<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Configurar cuenta',
    'active'                                          => 'Activo',
    'activity'                                        => 'Actividad',
    'activity_invoice_paid'                           => 'La factura <a href=":link">:number</a> ha sido pagada.',
    'activity_invoice_viewed'                         => 'Han visto la factura <a href=":link">:number</a>.',
    'activity_quote_approved'                         => 'El presupuesto <a href=":link">:number</a> ha sido aceptado.',
    'activity_quote_rejected'                         => 'El presupuesto <a href=":link">:number</a> ha sido rechazado.',
    'activity_quote_viewed'                           => 'Han visto el presupuesto <a href=":link">:number</a>.',
    'add_item'                                        => 'Nuevo',
    'add_line_item_to_invoice'                        => 'Añadir elemento de línea de la factura',
    'add_note'                                        => 'Añadir nota',
    'additional'                                      => 'Adicional',
    'addon'                                           => 'Add-on',
    'addons'                                          => 'Add-ons',
    'address'                                         => 'Dirección',
    'address_format'                                  => 'Formato de dirección',
    'after_amount'                                    => 'Después del importe',
    'all'                                             => 'Todo',
    'all_categories'                                  => 'Toda las categorías',
    'all_statuses'                                    => 'Todos los estados',
    'all_time'                                        => 'Todo el tiempo',
    'all_vendors'                                     => 'Todos los proveedores',
    'allow_login'                                     => 'Permitir login',
    'always_attach_pdf'                               => 'Siempre adjuntar PDF',
    'always_bcc'                                      => 'Siempre dirección CCO',
    'always_cc'                                       => 'Siempre dirección CC',
    'amount'                                          => 'Importe',
    'api_public_key'                                  => 'Clave API pública',
    'api_secret_key'                                  => 'Clave API secreta',
    'approve'                                         => 'Aceptar',
    'approved'                                        => 'Aceptado',
    'approved_quotes'                                 => 'Presupuestos aceptados',
    'attach_files'                                    => 'Adjuntar archivos',
    'attach_pdf'                                      => 'Adjuntar PDF',
    'attachment'                                      => 'Archivo adjunto',
    'attachments'                                     => 'Archivos adjuntos',
    'author'                                          => 'Autor',
    'automatic'                                       => 'Automático',
    'automatic_email_on_recur'                        => 'Enviar email automático de facturas recurrentes',
    'automatic_email_payment_receipts'                => 'Confirmar automáticamente por email las recepciones de pago',
    'available_fields'                                => 'Campos disponibles',
    'back'                                            => 'Atrás',
    'back_to_invoice'                                 => 'Volver a Presupuestos',
    'back_to_quote'                                   => 'Volver a Facturas',
    'balance'                                         => 'Saldo',
    'base_currency'                                   => 'Moneda base',
    'bcc'                                             => 'CCO',
    'before_amount'                                   => 'Antes del importe',
    'bill_this_expense'                               => 'Cobrar este gasto',
    'bill_to'                                         => 'Cliente',
    'billable'                                        => 'Cobrable',
    'billed'                                          => 'Cobrado',
    'billing_address'                                 => 'Dirección de facturación',
    'billing_city'                                    => 'Ciudad de facturación',
    'billing_name'                                    => 'Nombre de facturación',
    'billing_state'                                   => 'Estado de facturación',
    'billing_zip'                                     => 'Código postal de facturación',
    'binary_path'                                     => 'Ruta binaria',
    'body'                                            => 'Mensaje',
    'cancel'                                          => 'Cancelar',
    'canceled'                                        => 'Cancelado',
    'card_number'                                     => 'Numero Tarjeta',
    'cash'                                            => 'En efectivo',
    'category'                                        => 'Categoría',
    'cc'                                              => 'CC',
    'change'                                          => 'Cambiar',
    'change_client'                                   => 'Cambiar cliente',
    'check_for_update'                                => 'Comprobar actualización',
    'city'                                            => 'Ciudad',
    'clear_keys'                                      => 'Limpiar claves',
    'client'                                          => 'Cliente',
    'client_form'                                     => 'Cliente',
    'client_name'                                     => 'Razón social',
    'client_not_found'                                => 'Cliente no encontrado',
    'client_statement'                                => 'Estado del Cliente',
    'client_unique_name_option_1'                     => 'Solo cuando el nombre del cliente no es único',
    'client_unique_name_option_2'                     => 'Mostrar siempre',
    'client_visibility'                               => 'Visibilidad para el cliente',
    'clients'                                         => 'Clientes',
    'code'                                            => 'Código',
    'column_name'                                     => 'Nombre',
    'column_width'                                    => 'Ancho de columna',
    'company'                                         => 'Razón social',
    'complete'                                        => 'Completo',
    'complete_upgrade'                                => 'Actualización completa',
    'compound'                                        => 'Compuesto',
    'compound_tax_note'                               => 'Tasas de impuestos compuestos deberán de ser aplicadas a un artículo como impuesto 2 para conseguir el efecto deseado.',
    'confirm_approve_quote'                           => '¿Confirmas que deseas aceptar este presupuesto?',
    'confirm_reject_quote'                            => '¿Estás seguro de que deseas rechazar este presupuesto?',
    'continue'                                        => 'Continuar',
    'convert_quote_option1'                           => 'La factura deberá de retener los términos del presupuesto',
    'convert_quote_option2'                           => 'La factura deberá de utilizar los términos predeterminados de las facturas',
    'convert_quote_setting'                           => 'Cuando un presupuesto se convierte a factura',
    'convert_quote_when_approved'                     => 'Convertir automáticamente presupuesto en factura si es aceptado por el cliente.',
    'converted_from_quote'                            => 'Convertido desde Presupuesto',
    'converted_to_invoice'                            => 'Convertido a Factura',
    'country'                                         => 'País',
    'create_invoice'                                  => 'Nueva factura',
    'create_quote'                                    => 'Nuevo presupuesto',
    'created'                                         => 'Fecha',
    'credit_card'                                     => 'Tarjeta de crédito',
    'currencies'                                      => 'Monedas',
    'currency'                                        => 'Moneda',
    'currency_form'                                   => 'Moneda',
    'currency_symbol'                                 => 'Símbolo de moneda',
    'currency_symbol_placement'                       => 'Posición del símbolo de moneda',
    'custom_date_range'                               => 'Rango de fechas personalizadas',
    'custom_field_form'                               => 'Campos personalizados',
    'custom_fields'                                   => 'Campos personalizados',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Inicio',
    'dashboard_totals_option'                         => 'Los totales en el panel principal debe incluir',
    'database_not_configured'                         => 'Al parecer app/config/database.php no ha sido configurada.',
    'database_setup'                                  => 'Configurar base de datos',
    'date'                                            => 'Fecha',
    'date_format'                                     => 'Formato',
    'days'                                            => 'Días',
    'decimal_point'                                   => 'Signo decimal',
    'default_currency'                                => 'Moneda predeterminada',
    'default_footer'                                  => 'Pie de página predeterminado',
    'default_group'                                   => 'Serie predeterminada',
    'default_invoice_email_body'                      => 'Mensaje predeterminado de factura al cliente',
    'default_invoice_template'                        => 'Plantilla de factura',
    'default_item_tax_2_rate'                         => 'Default Item Tax 2 Rate',
    'default_item_tax_rate'                           => 'Impuesto predeterminado por artículo',
    'default_overdue_invoice_email_body'              => 'Mensaje predeterminado factura vencida al cliente',
    'default_payment_receipt_body'                    => 'Mensaje predeterminado de recepcíon de pago al cliente',
    'default_quote_email_body'                        => 'Mensaje predeterminado de presupuesto al cliente',
    'default_quote_template'                          => 'Plantilla de presupuesto',
    'default_terms'                                   => 'Términos y condiciones por defecto',
    'delete'                                          => 'Borrar',
    'delete_client_warning'                           => 'Si se borra este cliente también se eliminarán todas sus facturas, presupuestos y pagos relacionados. ¿Deseas continuar?',
    'delete_record_warning'                           => '¿Deseas eliminar este registro?',
    'description'                                     => 'Descripción',
    'details'                                         => 'Detalles',
    'disabled'                                        => 'Deshabilitado',
    'discount'                                        => 'Descuento',
    'display_client_unique_name'                      => 'Mostrar nombre único del cliente',
    'display_do_not_require'                          => 'Mostrar pero no requerir',
    'display_order'                                   => 'Mostrar orden',
    'display_profile_image'                           => 'Mostrar imagen de perfil',
    'do_not_add_line_item_to_invoice'                 => 'No añadir elemento de línea de la factura',
    'do_not_display'                                  => 'No mostrar',
    'documentation'                                   => 'Documentación',
    'download'                                        => 'Descargar',
    'draft'                                           => 'Borrador',
    'draft_invoices'                                  => 'Facturas borrador',
    'draft_quotes'                                    => 'Presupuestos borrador',
    'dropdown'                                        => 'Menú desplegable',
    'due'                                             => 'Debe',
    'due_date'                                        => 'Vencimiento',
    'edit'                                            => 'Editar',
    'edit_client'                                     => 'Editar Cliente',
    'email'                                           => 'Email',
    'email_address'                                   => 'Email',
    'email_invoice'                                   => 'Email de facturas',
    'email_payment_receipt'                           => 'Email de recepción de pago',
    'email_quote'                                     => 'Email de presupuestos',
    'email_send_method'                               => 'Método de envío por email',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'API SendGrid',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Habilitado',
    'enter_payment'                                   => 'Introducir pago',
    'error'                                           => 'Error',
    'every'                                           => 'Intervalo',
    'exchange_rate'                                   => 'Tasa de cambio',
    'exchange_rate_mode'                              => 'Modo de tasa de cambio',
    'expense_form'                                    => 'Formulario de Gastos',
    'expenses'                                        => 'Gastos',
    'expiration'                                      => 'Expiración',
    'expires'                                         => 'Vencimiento',
    'export_clients'                                  => 'Exportar Clientes',
    'export_data'                                     => 'Exportar Dato',
    'export_expenses'                                 => 'Exportar gastos',
    'export_invoice_items'                            => 'Exportar Productos de facturas',
    'export_invoices'                                 => 'Exportar Facturas',
    'export_payments'                                 => 'Exportar Pagos',
    'export_quote_items'                              => 'Exportar Productos de presupuestos',
    'export_quotes'                                   => 'Exportar Presupuestos',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Fax',
    'field_label'                                     => 'Nombre',
    'field_meta'                                      => 'Valores*',
    'field_meta_description'                          => '(*) Rellena este campo sólo si el tipo de campo es una lista desplegable. Escribe una lista de valores separados por comas.',
    'field_type'                                      => 'Tipo',
    'footer'                                          => 'Pie de página',
    'format'                                          => 'Formatear',
    'frequency'                                       => 'Frecuencia',
    'from'                                            => 'De',
    'from_date'                                       => 'Desde',
    'general'                                         => 'General',
    'generate_keys'                                   => 'Generar claves',
    'group'                                           => 'Serie',
    'group_form'                                      => 'Serie',
    'groups'                                          => 'Series',
    'header_title_text'                               => 'Encabezado (Texto o HTML)',
    'help'                                            => 'Ayuda',
    'help_currency_code'                              => 'Código moneda, e.j. "USD".',
    'help_currency_name'                              => 'Nombre moneda, e.j. "US Dollar".',
    'help_currency_symbol'                            => 'Símbolo moneda, e.j. "$".',
    'help_currency_symbol_placement'                  => 'Posición símbolo moneda.',
    'help_text_client_name'                           => 'Este valor puede ser el nombre de una empresa o de una persona y aparecerá en presupuestos y facturas. Este valor no tiene que ser único.',
    'help_text_client_password'                       => 'Deje este campo en blanco a menos que quiera crear o restablecer una contraseña.',
    'help_text_client_unique_name'                    => 'Cuando uno o más clientes en el sistema comparten el mismo nombre, un nombre único debe ser proporcionada a distinguir entre ellos. Este valor no aparecerá en presupuestos y facturas.',
    'i_accept'                                        => 'Acepto',
    'import_data'                                     => 'Importación de datos',
    'inactive'                                        => 'Inactivo',
    'income'                                          => 'Ingresos',
    'install'                                         => 'Instalar',
    'installation_complete'                           => 'Instalación finalizada',
    'installing_please_wait'                          => 'Instalando. Por favor, espera...',
    'invalid_credentials'                             => 'Credenciales inválidos',
    'invoice'                                         => 'Factura',
    'invoice_default'                                 => 'Factura predeterminada',
    'invoice_email_subject'                           => 'Asunto del email de la factura',
    'invoice_items'                                   => 'Artículos',
    'invoice_number'                                  => 'Nº',
    'invoice_summary'                                 => 'Resumen de facturación',
    'invoiced'                                        => 'Facturado',
    'invoices'                                        => 'Facturas',
    'invoices_due_after'                              => 'Plazo de pago (días)',
    'issued'                                          => 'Emitido',
    'item'                                            => 'Artículo',
    'item_lookup_form'                                => 'Artículo',
    'item_lookups'                                    => 'Artículos',
    'item_sales'                                      => 'Ventas por artículo',
    'items'                                           => 'Artículos',
    'label_invoice'                                   => 'Elija la factura a la que añadir este gasto',
    'label_item_description'                          => 'Añada una descripción de este gasto (opcional)',
    'label_item_name'                                 => 'Nombre del elemento de línea a añadir a esta factura',
    'landscape'                                       => 'Horizontal',
    'language'                                        => 'Idioma',
    'left_pad'                                        => 'Longitud (cifras)',
    'left_pad_description'                            => 'Número de ceros a la izquierda a dejar para el siguiente número.',
    'legal'                                           => 'Legal',
    'letter'                                          => 'Carta',
    'license_agreement'                               => 'Acuerdo de licencia',
    'license_agreement_accept'                        => 'Acepto los términos del acuerdo de licencia',
    'logo'                                            => 'Logotipo',
    'mail_hash_error'                                 => 'Parece que la clave secreta ha cambiado desde la última vez que se guardó la contraseña de correo electrónico. Para corregir este error, vaya a Configuración del sistema -> pestaña Correo electrónico, vuelva a introducir su contraseña de correo electrónico y pulse Guardar. Tenga en cuenta que el correo no se podrá enviar hasta que esto se haya hecho.',
    'manual'                                          => 'Manual',
    'map_fields_to_import'                            => 'Selección de campos para importación',
    'merchant_api_key'                                => 'Clave API',
    'merchant_api_password'                           => 'Contraseña API',
    'merchant_api_username'                           => 'Usuario API',
    'merchant_publishable_key'                        => 'Clave pública',
    'merchant_secret_key'                             => 'Clave Secreta',
    'merchant_signature'                              => 'Firma',
    'mobile'                                          => 'Móvil',
    'mobile_number'                                   => 'Teléfono móvil',
    'monthly'                                         => 'Mensual',
    'months'                                          => 'Mensual',
    'multiple_email_validation'                       => 'Multiples direcciones de email deberán de estar separas con una coma.',
    'name'                                            => 'Nombre',
    'net_income'                                      => 'Ingresos Netos',
    'never'                                           => 'Nunca',
    'new'                                             => 'Nuevo',
    'next_date'                                       => 'Siguiente fecha',
    'next_number'                                     => 'Siguiente número',
    'no'                                              => 'No',
    'no_open_invoices'                                => 'Este cliente no tiene ninguna factura pendiente. Para cobrar un gasto, el cliente debe tener al menos una factura que no haya sido pagada en su totalidad.',
    'no_records_found'                                => 'No se encontrarón entradas.',
    'none'                                            => 'Ninguno',
    'not_billable'                                    => 'No se puede cobrar',
    'not_billed'                                      => 'No cobrado',
    'not_viewed'                                      => 'No visto',
    'not_visible'                                     => 'No visible',
    'note'                                            => 'Notas',
    'note_notification'                               => 'Notificación: Nueva Nota',
    'notes'                                           => 'Notas',
    'online_payment'                                  => 'Pago online',
    'online_payment_method'                           => 'Sistema de pago online',
    'online_payments'                                 => 'Pagos Online',
    'options'                                         => 'Seleccionar',
    'other'                                           => 'Opciones',
    'output_type'                                     => 'Mostrar como',
    'overdue'                                         => 'Vencido',
    'overdue_email_subject'                           => 'Asunto del email de la factura vencida',
    'overdue_invoice_reminder'                        => 'Recordatorio para facturas atrasadas',
    'overdue_invoice_reminder_frequency'              => 'Frecuencia de recordatorio para facturas atrasadas',
    'overdue_invoice_reminder_frequency_help'         => 'Una coma separó la lista de días después de que una factura se debe enviar el recordatorio. Dejar en blanco para desactivar los recordatorios de facturas vencidas. Por ejemplo, un valor de 1,5,10 enviaría recordatorios 1, 5 y 10 días después de que la factura es debido.',
    'overdue_invoices'                                => 'Facturas vencidas',
    'paid'                                            => 'Pagado',
    'paper_orientation'                               => 'Orientación del papel',
    'paper_size'                                      => 'Tamaño del papel',
    'password'                                        => 'Contraseña',
    'password_confirmation'                           => 'Confirmar contraseña',
    'password_successfully_reset'                     => 'Contraseña restablecida correctamente',
    'pay'                                             => 'Pago',
    'pay_now'                                         => 'Pagar ahora',
    'payment_applied'                                 => 'Su pago ha sido hecho',
    'payment_button_text'                             => 'Texto del botón de pago',
    'payment_date'                                    => 'Fecha',
    'payment_form'                                    => 'Pago',
    'payment_method'                                  => 'Método',
    'payment_method_form'                             => 'Forma de pago',
    'payment_methods'                                 => 'Formas de pago',
    'payment_receipt'                                 => 'Recepción de pago',
    'payment_receipt_email_subject'                   => 'Asunto del email del recibo de pago',
    'payments'                                        => 'Pagos',
    'payments_collected'                              => 'Pagos recibidos',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF Driver',
    'pdf_driver_wkhtmltopdf'                          => 'El campo Camino binario debe contener una ruta de archivo válida cuando se utiliza el controlador wkhtmltopdf PDF.',
    'percent'                                         => 'Porcentaje',
    'phone'                                           => 'Tel.',
    'phone_number'                                    => 'Teléfono',
    'php_version_error'                               => 'La versión de PHP (%s) no es compatible',
    'placeholder_type_message'                        => 'Introducir mensaje...',
    'portrait'                                        => 'Vertical',
    'postal_code'                                     => 'Código Postal',
    'prefix'                                          => 'Prefijo',
    'prerequisites'                                   => 'Prerequisitos',
    'preview'                                         => 'Previsualización',
    'price'                                           => 'Precio',
    'private'                                         => 'Privado',
    'problem_with_email_template'                     => 'Parece existir un problema con la plantilla del email. Por favor revise las plantillas en la configuración del sistema en la pestaña de email.',
    'product'                                         => 'Artículo',
    'profit_and_loss'                                 => 'Beneficios y pérdidas',
    'public'                                          => 'Público',
    'qty'                                             => 'Cantidad',
    'quantity'                                        => 'Cantidad',
    'quantity_price_decimals'                         => 'Número de decimales para cantidades y precios',
    'quote'                                           => 'Presupuesto',
    'quote_approved'                                  => 'Presupuesto aceptado',
    'quote_approved_email_body'                       => 'Cuerpo del email para resupuesto aceptado',
    'quote_default'                                   => 'Presupuesto predeterminado',
    'quote_email_subject'                             => 'Asunto del email del presupuesto',
    'quote_items'                                     => 'Artículos',
    'quote_number'                                    => 'Código',
    'quote_rejected'                                  => 'Presupuesto rechazado',
    'quote_rejected_email_body'                       => 'Cuerpo del email para resupuesto rechazado',
    'quote_status_change_notification'                => 'Notificación: Estado del presupuesto cambiado',
    'quote_summary'                                   => 'Resumen de presupuestos',
    'quote_to_invoice'                                => 'Facturar presupuesto',
    'quotes'                                          => 'Presupuestos',
    'quotes_expire_after'                             => 'Validez del presupuesto (días)',
    'recalculate'                                     => 'Recalcular',
    'recalculate_help_text'                           => 'La recalculación puede tomar un tiempo. Se mostrará un mensaje una vez que el proceso haya finalizado.',
    'recalculate_invoices'                            => 'Recalcular facturas',
    'recalculate_quotes'                              => 'Recalcular presupuestos',
    'recalculating_wait'                              => 'Recalculando, espere por favor...',
    'recalculation_complete'                          => 'Recalculación Completada',
    'recent_invoices'                                 => 'Facturas Recientes',
    'recent_payments'                                 => 'Pagos Recientes',
    'recent_quotes'                                   => 'Presupuestos Recientes',
    'record_not_found'                                => 'Entrada no encontrada',
    'record_successfully_created'                     => 'Dato creado correctamente',
    'record_successfully_deleted'                     => 'Datos eliminados correctamente',
    'record_successfully_updated'                     => 'Datos modificados correctamente',
    'records_imported_successfully'                   => 'Datos importados correctamente',
    'recurring'                                       => 'Recurrente',
    'reject'                                          => 'Rechazar',
    'rejected'                                        => 'Rechazado',
    'rejected_quotes'                                 => 'Presupuestos rechazados',
    'remember_me'                                     => 'Recordarme',
    'remove_logo'                                     => 'Eliminar logotipo',
    'report_rev_client_notice'                        => 'Este informe estará disponible una vez que haya algún pago en el sistema.',
    'reports'                                         => 'Informes',
    'require'                                         => 'Requerir',
    'reset_number'                                    => 'Resetear número',
    'reset_password'                                  => 'Restablecer contraseña',
    'results_per_page'                                => 'Resultados Por Página',
    'revenue_by_client'                               => 'Ingresos por cliente',
    'round_tax_decimals'                              => 'Número de decimales para redondeo de impuestos',
    'run_report'                                      => 'Ver informe',
    'save'                                            => 'Guardar',
    'save_and_apply_exchange_rate'                    => 'Guardar y aplicar',
    'save_item_as_lookup'                             => 'Guardar artículo',
    'search'                                          => 'Buscar',
    'select_file_to_import'                           => 'Seleccionar archivo para importación',
    'send'                                            => 'Enviar',
    'sending'                                         => 'Enviando',
    'sendmail_path'                                   => 'Ruta de Sendmail',
    'sent'                                            => 'Enviado',
    'sent_invoices'                                   => 'Facturas enviadas',
    'sent_quotes'                                     => 'Presupuestos enviados',
    'settings'                                        => 'Configuración',
    'settings_successfully_saved'                     => 'Configuración guardada correctamente',
    'setup'                                           => 'Configuración',
    'sign_in'                                         => 'Logearse',
    'sign_out'                                        => 'Salir',
    'skin'                                            => 'Skin',
    'smtp_encryption'                                 => 'SMTP Encryption',
    'smtp_host_address'                               => 'Servidor SMTP',
    'smtp_host_port'                                  => 'Puerto SMTP',
    'smtp_password'                                   => 'Contraseña SMTP',
    'smtp_username'                                   => 'Usuario SMTP',
    'start_date'                                      => 'Fecha inicial',
    'state'                                           => 'Estado',
    'status'                                          => 'Estado',
    'step_database_setup'                             => 'Ahora se instalarán y actualizarán las tablas de la base de datos. Este proceso puede tardar unos minutos.',
    'step_prerequisites'                              => 'Problemas que se deben resolver para poder continuar con la instalación:',
    'subject'                                         => 'Asunto',
    'submit'                                          => 'Enviar',
    'subtotal'                                        => 'Subtotal',
    'summary'                                         => 'Resumen',
    'symbol'                                          => 'Símbolo',
    'symbol_placement'                                => 'Posición símbolo',
    'system'                                          => 'Sistema',
    'system_settings'                                 => 'Configuración',
    'table_name'                                      => 'Tabla',
    'tax'                                             => 'Impuestos',
    'tax_1'                                           => 'Impuesto 1',
    'tax_2'                                           => 'Impuesto 2',
    'tax_rate'                                        => 'Impuesto',
    'tax_rate_form'                                   => 'Impuesto',
    'tax_rate_name'                                   => 'Nombre',
    'tax_rate_percent'                                => 'Porcentaje',
    'tax_rates'                                       => 'Impuestos',
    'tax_summary'                                     => 'Totales de impuestos',
    'taxable_amount'                                  => 'Base imponible',
    'taxes'                                           => 'Total impuestos',
    'template'                                        => 'Plantilla',
    'terms_and_conditions'                            => 'Términos y condiciones',
    'test_mode'                                       => 'Modo de prueba',
    'text'                                            => 'Texto',
    'textarea'                                        => 'Area de texto',
    'this_quarter'                                    => 'Este cuatrimestre',
    'thousands_separator'                             => 'Separador de miles',
    'timezone'                                        => 'Zona horaria',
    'to'                                              => 'Para',
    'to_date'                                         => 'Hasta',
    'total'                                           => 'Total',
    'total_balance'                                   => 'Saldo',
    'total_invoiced'                                  => 'Total facturado',
    'total_expenses'                                  => 'Gastos totales',
    'total_paid_invoices'                             => 'Facturas pagadas totales',
    'try_again'                                       => 'Inténtalo de nuevo',
    'uninstall'                                       => 'Desinstalar',
    'uninstall_addon_warning'                         => 'La desinstalación de este complemento eliminará todos los datos que ha introducido asociado con el add-on. ¿Seguro que desea continuar?',
    'unique_name'                                     => 'Nombre Único',
    'unknown_error'                                   => 'Error desconocido',
    'upcoming_payment_notice_email_body'              => 'Cuerpo del email de aviso de pago próximo',
    'upcoming_payment_notice_email_subject'           => 'Asunto del email de aviso de pago próximo',
    'upcoming_payment_notice_frequency'               => 'Frecuencia de aviso de pago próximo',
    'upcoming_payment_notice_frequency_help'          => 'Una lista separada por comas con los días ANTERIORES a la fecha de vencimiento de la factura para enviar el aviso. Dejar el campo vacío para desactivar los próximos avisos. Por ejemplo: un valor de 1,5 enviaría avisos 1 y 5 días antes de la fecha de vencimiento de la factura.',
    'update_available'                                => 'La versión :version ya está disponible. Descárgala desde :url',
    'update_exchange_rate'                            => 'Actualizar',
    'update_not_available'                            => 'En estos momentos no hay actualizaciones disponibles.',
    'upload_progress'                                 => 'Progreso de carga',
    'user'                                            => 'Usuario',
    'user_accounts'                                   => 'Cuentas de usuario',
    'user_form'                                       => 'Usuario',
    'users'                                           => 'Usuarios',
    'validation_invoice_summary_from_date'            => 'La fecha de inicio en el Widget de tablero de resumen de facturas se requiere cuando el intervalo de fechas se establece en Rango de fechas personalizado.',
    'validation_invoice_summary_to_date'              => 'La fecha hasta la fecha en el Widget de tablero de resumen de facturas es necesaria cuando se utiliza un intervalo de fechas personalizado.',
    'validation_quote_summary_from_date'              => 'La fecha de inicio en el Widget de resumen de cotizaciones es necesaria cuando se utiliza un intervalo de fechas personalizado.',
    'validation_quote_summary_to_date'                => 'El hasta la fecha en el Widget de resumen de cotización es necesario cuando se utiliza un intervalo de fechas personalizado.',
    'vendor'                                          => 'Proveedor',
    'version'                                         => 'Versión',
    'view'                                            => 'Ver',
    'view_all'                                        => 'Ver todos',
    'view_all_invoices_for_client'                    => 'Ver todas las facturas de este cliente.',
    'view_all_payments_for_client'                    => 'Ver todos los pagos del cliente',
    'view_all_quotes_for_client'                      => 'Ver todas las notas de este cliente',
    'view_approved_quotes'                            => 'Ver presupuestos aceptados',
    'view_client'                                     => 'Cliente',
    'view_draft_invoices'                             => 'Ver facturas borrador',
    'view_draft_quotes'                               => 'Ver presupuestos borrador',
    'view_overdue_invoices'                           => 'Ver facturas vencidas',
    'view_payments'                                   => 'Listado',
    'view_rejected_quotes'                            => 'Ver presupuestos rechazados',
    'view_sent_invoices'                              => 'Ver facturas enviadas',
    'view_sent_quotes'                                => 'Ver presupuestos enviados',
    'view_unique_name'                                => 'Ver nombre único',
    'viewed'                                          => 'Visto',
    'visible'                                         => 'Visible',
    'visible_after_payment'                           => 'Visible después del pago',
    'web'                                             => 'Web',
    'web_address'                                     => 'Sitio web',
    'weekly'                                          => 'Semanalmente',
    'weeks'                                           => 'Semanal',
    'welcome'                                         => 'Bienvenido',
    'what_to_import'                                  => 'Importación de datos',
    'year'                                            => 'Año',
    'yearly'                                          => 'Anualmente',
    'years'                                           => 'Anual',
    'yes'                                             => 'Si',
    'you_may_now_sign_in'                             => '¡Ahora puedes logearte!',

    // 2017-1
    'all_company_profiles'                            => 'Todos los perfiles de la empresa',
    'cannot_delete_record_in_use'                     => 'Este registro est? en uso y no se puede eliminar.',
    'cannot_edit_record_in_use'                       => 'Este registro est? en uso y no se puede editar.',
    'change_company_profile'                          => 'Cambiar perfil de empresa',
    'company_profile'                                 => 'Perfil de la compa??a',
    'company_profiles'                                => 'Perfiles de empresa',
    'company_profile_form'                            => 'Formulario de perfil de empresa',
    'copy'                                            => 'Copiar',
    'create_recurring_invoice'                        => 'Crear factura peri?dica',
    'custom'                                          => 'Personalizado',
    'date_range'                                      => 'Rango de fechas',
    'day_short_sunday'                                => 'Su',
    'day_short_monday'                                => 'Mes',
    'day_short_tuesday'                               => 'Tu',
    'day_short_wednesday'                             => 'Nosotros',
    'day_short_thursday'                              => 'Th',
    'day_short_friday'                                => 'Fr',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Perfil de empresa predeterminado',
    'first_quarter'                                   => 'Primer cuarto',
    'fourth_quarter'                                  => 'Cuarto trimestre',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Los últimos 7 días',
    'last_30_days'                                    => 'Últimos 30 días',
    'last_month'                                      => 'El mes pasado',
    'last_quarter'                                    => 'Último cuarto',
    'last_year'                                       => 'El año pasado',
    'month_january'                                   => 'enero',
    'month_february'                                  => 'febrero',
    'month_march'                                     => 'marzo',
    'month_april'                                     => 'abril',
    'month_may'                                       => 'Mayo',
    'month_june'                                      => 'junio',
    'month_july'                                      => 'julio',
    'month_august'                                    => 'agosto',
    'month_september'                                 => 'septiembre',
    'month_october'                                   => 'octubre',
    'month_november'                                  => 'noviembre',
    'month_december'                                  => 'diciembre',
    'recurring_invoice'                               => 'Factura recurrente',
    'second_quarter'                                  => 'Segundo cuarto',
    'stop_date'                                       => 'Fecha de finalización',
    'third_quarter'                                   => 'Tercer cuarto',
    'this_month'                                      => 'Este mes',
    'this_year'                                       => 'Este año',
    'today'                                           => 'Hoy',
    'user_account'                                    => 'Cuenta de usuario',
    'yesterday'                                       => 'Ayer',

    // 2017-3
    'mail_log'                                        => 'Registro electrónico',
    'recent_client_activity'                          => 'Actividad reciente del cliente',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Excluir facturas impagas',

    // 2017-7
    'please_wait'                                     => 'Por favor espera...',
    'reply_to_address'                                => 'Dirección de respuesta',

    // 2017-8
    'admin'                                           => 'Administración',
    'admin_account'                                   => 'Cuenta de administrador',
    'admin_accounts'                                  => 'Cuentas de administrador',
    'all_accounts'                                    => 'Todas las cuentas',
    'api_key'                                         => 'Clave API',
    'client_account'                                  => 'Cuenta cliente',
    'client_accounts'                                 => 'Cuentas de clientes',
    'client_id'                                       => 'Identificación del cliente',
    'client_secret'                                   => 'Secreto del cliente',
    'enable_bitcoin_payments'                         => 'Habilitar pagos con Bitcoin',
    'live'                                            => 'En Vivo',
    'mode'                                            => 'Modo',
    'publishable_key'                                 => 'Clave publicable',
    'sandbox'                                         => 'Salvadera',
    'secret_key'                                      => 'Llave secreta',
    'type'                                            => 'Tipo',

    // 2017-10
    'deselect_all'                                    => 'Deseleccionar todo',
    'select_all'                                      => 'Seleccionar todo',
    'use_24_hour_time_format'                         => 'Usar formato de 24 horas',

    // 2017-11
    'bulk_delete_record_warning'                      => '¿Está seguro de que desea eliminar estos registros?',
    'bulk_invoice_change_status_warning'              => '¿Está seguro de que desea cambiar el estado de las facturas seleccionadas?',
    'bulk_quote_change_status_warning'                => '¿Está seguro de que desea cambiar el estado de las cotizaciones seleccionadas?',
    'calculate_as_vat_gst'                            => 'Calcular como IVA / GST',
    'change_status'                                   => 'Cambiar Estado',
    'default_status_filter'                           => 'Filtro de estado predeterminado',
    'error_applying_payment'                          => 'Hubo un error al aplicar este pago. Pruebe con otra tarjeta o método de pago.',
    'remaining'                                       => 'Restante',

    // 2017-12
    'invoice_date'                                    => 'Fecha de la factura',
    'include_profit_based_on'                         => 'Incluir ganancias basadas en',

    // 2018-1
    'add_contact'                                     => 'Agregar contacto',
    'allow_self_signed_cert'                          => 'Permitir certificado autofirmado',
    'backup'                                          => 'Apoyo',
    'close'                                           => 'Cerca',
    'change_invoice_date_to_todays_date'              => 'Cambiar la fecha de la factura a la fecha de hoy',
    'change_quote_date_to_todays_date'                => 'Cambiar la fecha de cotización a la fecha de hoy',
    'contacts'                                        => 'Contactos',
    'default_bcc'                                     => 'Cco predeterminado',
    'default_cc'                                      => 'CC predeterminado',
    'default_to'                                      => 'Por defecto a',
    'disable'                                         => 'Inhabilitar',
    'download_database_backup'                        => 'Descargar copia de seguridad de la base de datos',
    'edit_contact'                                    => 'Editar contacto',
    'expense_list'                                    => 'Lista de gastos',
    'keep_invoice_date_as_is'                         => 'Mantenga la fecha de la factura como está',
    'keep_quote_date_as_is'                           => 'Mantenga la fecha de cotización como está',
    'if_quote_is_emailed_while_draft'                 => 'Si la cotización se envía por correo electrónico mientras está en estado de borrador',

    // 2018-4
    'force_https'                                     => 'Forzar HTTPS',
    'force_https_help'                                => 'Antes de habilitar esta opción, asegúrese de que la instalación de FusionInvoice funcione a través de https. No hacerlo puede resultar en una instalación no funcional (pero reparable).',

    // 2019-1
    'attached_to'                                     => 'Adjunto a',
    'customer'                                        => 'Cliente',
    'expense'                                         => 'Gastos',
    'expense_categories'                              => 'Categorías de gastos',
    'expense_category_form'                           => 'Formulario de categoría de gastos',
    'expense_vendors'                                 => 'Proveedores de gastos',
    'expense_vendor_form'                             => 'Formulario de proveedor de gastos',
    'lead'                                            => 'Dirigir',
    'local_time'                                      => 'Hora local',
    'prospect'                                        => 'Perspectiva',
    'search_clients'                                  => 'Clientes de búsqueda',
    'search_expenses'                                 => 'Gastos de búsqueda',
    'search_invoices'                                 => 'Buscar facturas',
    'search_items'                                    => 'Artículos de búsqueda',
    'search_log'                                      => 'Registro de búsqueda',
    'search_quotes'                                   => 'Buscar cotizaciones',
    'search_payments'                                 => 'Pagos de búsqueda',
    'search_recurring_invoices'                       => 'Buscar facturas recurrentes',
    'show_all_statuses'                               => 'Mostrar todos los estados',
    'show_all_types'                                  => 'Mostrar todos los tipos',
    'unknown'                                         => 'Desconocido',
    'value'                                           => 'Valor',

    // 2019-2
    'default'                                         => 'Defecto',
    'no_data_available'                               => 'Datos no disponibles',
    'recurring_invoice_list'                          => 'Lista de facturas recurrentes',
    'report_total'                                    => 'Totales del informe',

    //2019-3
    'checkbox'                                        => 'Caja',
    'custom_dropdown_validate'                        => 'Seleccione una opción válida del campo :label',
    'custom_image_validate'                           => 'Seleccione una imagen válida.',
    'custom_tag_validate'                             => 'Seleccione una etiqueta válida de :label',
    'custom_text_validate'                            => 'Ingrese un :label válido en el campo :label.',
    'datetime'                                        => 'Fecha y hora',
    'decimal'                                         => 'Decimal',
    'delete-confirm'                                  => '¿Estás seguro?',
    'grand_total'                                     => 'Gran total',
    'image'                                           => 'Imagen',
    'integer'                                         => 'Entero',
    'mailed'                                          => 'Blindado',
    'mailed_invoices'                                 => 'Facturas enviadas por correo',
    'radio'                                           => 'Radio',
    'recurring_id'                                    => 'ID recurrente',
    'remove_image'                                    => 'Quita la imagen',
    'tags'                                            => 'Etiquetas',
    'tagselection'                                    => 'Selección de etiqueta',
    'unpaid'                                          => 'No pagado',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'Ver facturas enviadas por correo',
    'important'                                       => '¡Importante!',
    'created_recurring_invoice_id'                    => 'Creado a partir de ID de factura periódica',
    'mr'                                              => 'señor.',
    'miss'                                            => 'Pierda',
    'ms'                                              => 'Em.',
    'mrs'                                             => 'Señora.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Profe.',
    'select_title'                                    => 'Título del contacto',
    'title'                                           => 'Título',
    'test_email_subject'                              => 'Hola desde FusionInvoice',
    'test_email_body'                                 => 'Este es un correo electrónico de prueba de FusionInvoice.',
    'test_email_address'                              => 'Enviar prueba de correo electrónico a',
    'send_test_email'                                 => 'Enviar correo electrónico de prueba',
    'invalid_json'                                    => 'Ingrese una cadena JSON válida',
    'textarea_rows_limit'                             => 'Las filas no pueden exceder :limit',
    'custom_integer_validate'                         => ':label debe ser un valor entero válido',

    //2020-1
    'user_role'                                       => 'Rol del usuario',
    'standard_user'                                   => 'Usuario estándar',
    'permissions'                                     => 'Permisos',
    'modules'                                         => 'Módulos',
    'is_view'                                         => 'Ver',
    'is_create'                                       => 'Crear',
    'is_update'                                       => 'Actualizar',
    'is_delete'                                       => 'Eliminar',
    'dashboards'                                      => 'Cuadros de mando',
    'allow_time_period_change'                        => 'Permitir cambio de período de tiempo',
    'page_not_found'                                  => '¡Ups! Página no encontrada.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href =</a>.',
    'no_auth_to_create_client'                        => '¡No estás autorizado para crear clientes!',
    'check-all'                                       => 'Comprobar todo',
    'invoice_prefix'                                  => 'Prefijo de factura',
    'recently_viewed'                                 => 'visto recientemente',
    'copy_from'                                       => 'Copiado de',
    'select_user'                                     => 'Seleccionar usuario',
    'please_select_user'                              => 'Seleccione un usuario de la lista',
    'allow_client_center_login'                       => 'Permitir inicio de sesión en el centro de clientes',
    'online_payment_processing_fee'                   => 'Tarifa de procesamiento de pagos en línea',
    'client_password_required'                        => 'Ingrese la contraseña del cliente',
    'last_login_at'                                   => 'Último inicio de sesión en',
    'show_notes_panel_below_client'                   => 'Mostrar el panel de notas debajo de los detalles del cliente',
    'notepad'                                         => 'Bloc',
    'added'                                           => 'Adicional',
    'last_edited'                                     => 'Última edición',
    'loading'                                         => 'Procesando ....',
    'n_records_match'                                 => ':label Grabar :plural coincidencia',
    'initials'                                        => 'Iniciales',
    'initials_bg_color'                               => 'Color de fondo de las iniciales',
    'more'                                            => 'Más',
    'must_match_all'                                  => 'Debe coincidir con todos',
    'clear'                                           => 'Claro',
    'no_client_tags'                                  => 'No hay registros de clientes con etiquetas definidas.',
    'qr_code_on_invoice_quote'                        => 'Código QR en factura y cotización',
    'delete_tags'                                     => 'Limpieza de etiquetas',
    'orphan_tags_deleted'                             => 'Eliminó correctamente todas las etiquetas huérfanas del sistema.',
    'orphan_tags_delete_confirm'                      => 'Ejecutar Tag Cleanup eliminará todas las etiquetas no utilizadas. ¿Seguir?',
    'deleting_tags_wait'                              => 'Eliminando etiquetas, espere ...',
    'new-version-available'                           => '¡Nueva versión disponible!',
    'ignore-this-version'                             => 'Ignorar esta versión',
    'view-release-notes'                              => 'Ver notas de la versión',
    'task_list'                                       => 'Lista de tareas',
    'create_task'                                     => 'Crear tarea',
    'open'                                            => 'Abierto',
    'closed'                                          => 'Cerrado',
    'assignee'                                        => 'Cesionario',
    'task'                                            => 'Tarea',
    'task_successfully_created'                       => 'Tarea creada correctamente',
    'task_successfully_updated'                       => 'Tarea actualizada correctamente',
    'task_completed'                                  => 'Tarea completada con éxito',
    'task_marked_incomplete'                          => 'Tarea reabierta',
    'due_date_validation_date'                        => 'Seleccione una fecha de vencimiento válida',
    'assignee_validation_required'                    => 'Seleccione un cesionario válido de la lista',
    'assignee_validation_exists'                      => 'Seleccione un cesionario válido de la lista',
    'tomorrow'                                        => 'mañana',
    'task_not_authorized'                             => '¡No está autorizado para editar esta tarea!',
    'me'                                              => 'Yo',
    'task_from_note'                                  => 'Crear tarea al guardar',
    'done'                                            => 'Hecho',
    'refresh'                                         => 'Actualizar',
    'task_list_page_size'                             => 'Número de tareas por página',
    'select_client'                                   => 'Seleccionar cliente',
    'note-search-config'                              => 'Búsqueda de notas para incluir',
    'username'                                        => 'Nombre de usuario',
    'task-search-config'                              => 'Búsqueda de tareas para incluir',
    'task_section_invalid'                            => 'Sección de tarea no válida',
    'task_section'                                    => 'Sección de tareas',
    'select_section'                                  => 'Seleccionar sección',
    'email-test-failed'                               => 'Prueba de correo electrónico fallida',
    'smtp-setting-suggestion'                         => 'Sugerencias:<br>1. Verifique y vuelva a ingresar sus valores de usuario / contraseña<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Sugerencias:<br>1. Verifique que el servidor de correo PHP esté configurado correctamente<br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Sugerencias:<br>1. Verifique que su ruta de Sendmail esté configurada correctamente.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Sugerencias:<br>1. Verifique que su clave Sendgrid esté configurada correctamente.<br>2. Contact server admin',
    'later'                                           => 'Más tarde',
    'test-email-required'                             => 'Debe ingresar un correo electrónico válido para',
    'test_mail_sent_successfully'                     => 'Correo de prueba enviado con éxito',
    'test-mail-btn-title'                             => 'Debe guardar los cambios antes de realizar la prueba.',
    'agreement_expire'                                => 'Las actualizaciones y el soporte de sus productos vencerán el :date',
    'agreement_expired'                               => 'Las actualizaciones y el soporte de sus productos caducaron el :date',
    'piracy_message'                                  => 'Su clave de licencia de FusionInvoice no es válida. La piratería de software es un delito. Por favor, juegue limpio. Con una licencia válida recibirás soporte, actualizaciones y un buen karma.',
    'buy-now'                                         => 'Compra ahora',
    'piracy_alert'                                    => '¡Por favor sea justo!',
    'agreement-expire-alert'                          => 'Las actualizaciones de productos y el soporte caducarán pronto.',
    'agreement-expired-alert'                         => 'Las actualizaciones de productos y el soporte han expirado.',
    'dismiss-forever'                                 => 'Descartar para siempre',
    'renew-now'                                       => 'Renovar ahora',
    'select_all_permissions'                          => 'Seleccionar todos los permisos',
    'app-key-missing'                                 => 'Ingrese su clave de licencia en config / app.php.',
    'custom_fields_column_width'                      => 'Columnas de visualización de campos personalizados',
    'select-user-type'                                => 'Seleccione el tipo de usuario',
    'lead-or-prospect-with-invoices-error'            => 'Lo sentimos, el Tipo de un cliente no puede ser Cliente potencial o Cliente potencial cuando existen facturas o facturas recurrentes.',
    'sendgrid_key'                                    => 'Sendgrid clave',

    //2020-2.0
    'space'                                           => 'Espacio',
    'apostrophe'                                      => 'Apóstrofe',
    'comma'                                           => 'Coma',
    'fullstop'                                        => 'Punto (punto final)',
    'middledot'                                       => 'Punto medio',
    'thinspace'                                       => 'Espacio delgado',
    'narrow-no-break-space'                           => 'Espacio estrecho sin interrupciones',
    'dotabove'                                        => 'Punto arriba',
    'arabic-decimal'                                  => 'Separador decimal árabe',
    'arabic-thousand'                                 => 'Separador de mil árabes',
    'decimal-separator-key-symbol'                    => 'Símbolo de llave de separador decimal',
    'select-item'                                     => 'Seleccione un artículo',
    'item-lookup-overload'                            => 'Se permite un máximo de 100 elementos para la búsqueda de elementos',
    'select-expense-category'                         => 'Seleccionar categoría de gastos',
    'select-expense-vendor'                           => 'Seleccionar proveedor de gastos',
    'can-not-delete-all-users'                        => 'Lo sentimos, no puedes eliminar a todos los usuarios del sistema.',
    'can-not-change-default-user-role'                => 'Lo sentimos, no puede cambiar la función de usuario predeterminada',
    'can-not-change-default-user-status'              => 'Lo sentimos, no puede cambiar el estado de usuario predeterminado',
    'user_not_active'                                 => 'El usuario no está activo',
    'can-not-inactive-your-own-status'                => 'Lo siento, no puede permanecer inactivo.',
    'delete_user_warning'                             => '<p>¡DETENER! Eliminar a este usuario es una acción selectiva que puede eliminar los registros que crearon dentro del sistema. En su lugar, considere hacer que el usuario esté inactivo.</p><p>¿Está seguro de que desea eliminar este usuario?</p>',
    'include_time_in_due_date'                        => 'Incluir tiempo en la fecha de vencimiento',
    'cannot_delete_default_company'                   => 'No puede eliminar el perfil de empresa predeterminado',
    'make-user-inactive'                              => 'Hacer inactivo al usuario',
    'mail_from_address'                               => 'Dirección de correo electrónico',
    'mail_from_name'                                  => 'Correo desde Nombre',
    'item_categories'                                 => 'Categorías de artículos',
    'select-item-category'                            => 'Seleccionar categoría de artículo',
    'item_category_form'                              => 'Formulario de categoría de artículo',
    'sort_by_due'                                     => 'Ordenar por fecha de vencimiento',
    'affiliate'                                       => 'Afiliado',
    'parent_account'                                  => 'Cuenta para padres',
    'child_account'                                   => 'Cuentas de niños',
    'select_parent_client'                            => 'Seleccionar cuenta principal',
    'record_successfully_retrieved'                   => 'Registro recuperado con éxito',
    'custom-image-not-support'                        => 'El campo de imagen personalizado no es compatible',
    'custom-tag-not-support'                          => 'El campo de etiqueta personalizada no es compatible',
    'custom-checkbox-not-support'                     => 'El campo de casilla de verificación personalizado no es compatible',
    'custom-date-not-support'                         => 'El campo de fecha personalizado no es compatible',
    'custom-datetime-not-support'                     => 'El campo de fecha y hora personalizado no es compatible',
    'timeline'                                        => 'TimeLine',
    'client_invoice'                                  => 'Facturas por cliente',
    'select_client_blank_for_all'                     => 'Seleccionar cliente (en blanco para todos)',
    'invoice_email_success'                           => 'El correo electrónico de la factura se envió correctamente',
    'quote_email_success'                             => 'Correo electrónico de cotización enviado con éxito',
    'document_number_schemes'                         => 'Numeración de documentos',
    'document_number_scheme'                          => 'Esquema de número de documento',
    'document_number_scheme_form'                     => 'Formulario de esquema de número de documento',
    'default_document_number_scheme'                  => 'Esquema de número de documento predeterminado',
    'supporting_data'                                 => 'Datos de soporte',
    'customizations'                                  => 'Personalizaciones',
    'utilities_and_logs'                              => 'Utilidades y registros',
    'system_log'                                      => 'Registro del sistema',
    'paid_amount'                                     => 'Monto de pago',
    'payment_amount'                                  => 'Monto del pago',
    'payment_intent'                                  => 'Intención de pago',
    'apply_payment_to_one_or_more_invoice'            => 'Aplicar pago a una o más facturas',
    'pre_payment_for_future_invoices'                 => 'Pago anticipado de facturas futuras',
    'apply_to_invoices'                               => 'Aplicar a la (s) factura (s)',
    'payment_application'                             => 'Solicitud de pago',
    'remaining_payment_balance'                       => 'Saldo de pago restante',
    'remaining_balance'                               => 'Balance restante',
    'payment_warning'                                 => 'Por favor ingrese la cantidad',
    'apply_pre_payment_warning'                       => 'No ha aplicado el pago a ninguna factura. ¿Le gustaría registrarlo como un prepago?',
    'confirm_remaining_balance'                       => 'El saldo restante de :value estará disponible para aplicar a futuras facturas para este cliente.',
    'open_balance'                                    => 'Saldo abierto',
    'more_figure_then_total_payment'                  => 'Vuelva a ingresar el pago, el pago total de su factura es mayor que el saldo restante.',
    'remaining_payment_balance_apply_later_info'      => 'Los saldos de pago restantes se pueden aplicar a otras facturas más adelante.',
    'invoice_balance'                                 => 'Saldo de la factura',
    'enter_payment_for_invoice'                       => 'Ingrese el pago de la factura',
    'invoice_pdf'                                     => 'Factura PDF',
    'payment_applications'                            => 'Aplicaciones de pago',
    'multiple'                                        => 'Múltiple',
    'ok'                                              => 'OK',
    'credit_memo_default'                             => 'Nota de crédito predeterminada',
    'edit_payment'                                    => 'Editar pago',
    'credit_memo'                                     => 'Nota de crédito',
    'credit_memos'                                    => 'Notas de crédito',
    'create_credit_memo'                              => 'Crear nota de crédito',
    'credit_applications'                             => 'Aplicaciones de notas de crédito',
    'credit_applications_for_invoice'                 => 'Aplicaciones de notas de crédito para facturas',
    'prepayment_applications_for_invoice'             => 'Solicitudes de prepago para facturas',
    'apply_credit_memo'                               => 'Aplicar nota de crédito',
    'apply_pre_payment'                               => 'Aplicar prepago',
    'applied_amount'                                  => 'Cantidad aplicada',
    'remaining_credit_balance'                        => 'Saldo de crédito restante',
    'remaining_credit_balance_apply_later_info'       => 'Los saldos acreedores restantes se pueden aplicar a otras facturas más adelante.',
    'applied'                                         => 'Aplicado',
    'more_figure_then_invoice_amount'                 => 'Vuelva a ingresar el monto, el monto no puede ser mayor que el monto de la factura.',
    'more_figure_then_invoice_total'                  => 'Vuelva a ingresar el monto, el monto total aplicado no puede ser mayor que el monto de la factura.',
    'invoice_not_selected_warning'                    => 'Espere, no aplicó la nota de crédito a ninguna factura.',
    'select_type'                                     => 'Seleccione tipo',
    'email_credit_memo'                               => 'Nota de crédito por correo electrónico',
    'back_to_credit_memo'                             => 'Volver a nota de crédito',
    'invoice_amount'                                  => 'Monto de la factura',
    'remaining_invoice_amount'                        => 'Importe restante de la factura',
    'settlement_for_credit_memo'                      => 'Liquidación por nota de crédito',
    'credit_memo_amount'                              => 'Importe de la nota de crédito',
    'confirm_remaining_balance_invoice'               => 'El saldo restante de esta factura será :value después de la liquidación.',
    'payment_receipt_for_invoices'                    => 'Recibo de pago de facturas',
    'primary_phone'                                   => 'Número de teléfono primario',
    'alternate_phone'                                 => 'Número de teléfono alternativo',
    'currency_not_match'                              => 'La moneda no coincide',
    'tasks'                                           => 'Tareas',
    'full_and_final_payment'                          => 'lleno',
    'partial'                                         => 'parcial',
    'transition'                                      => [
        'created'          => 'Creado',
        'updated'          => 'Actualizado',
        'deleted'          => 'Eliminado',
        'received'         => 'Recibido',
        'opened'           => 'Abrió',
        'sent'             => 'Expedido',
        'mail'             => 'Blindado',
        'changed'          => 'Cambiado',
        'recurring'        => 'Creado',
        'completed'        => 'Terminado',
        'reversed'         => 'Invertido',
        'quote_to_invoice' => 'Cotizar para facturar',
        'download'         => 'Descargar',
        'added'            => 'Adicional',
        'email'            => 'Correo electrónico',
        'merge'            => 'Unir',
        'billed'           => 'facturado',
        'failed'           => 'Fallido',
        'invoice'          => [
            'created'                => 'Se creó la factura :invoice_number',
            'credit_memo_created'    => 'Se creó la nota de crédito :credit_memo_number',
            'credit_memo_updated'    => 'Se modificó la nota de crédito :credit_memo_number',
            'created_from_recurring' => 'Se creó la factura :invoice_number (a partir de la plantilla recurrente :recurring_invoice_id)',
            'updated'                => 'Se modificó la factura :invoice_number',
            'deleted'                => 'Se eliminó la factura :invoice_number',
            'credit_memo_deleted'    => 'Se eliminó la nota de crédito :credit_memo_number',
            'status_changed'         => 'Factura :invoice_number El estado cambió de :previous_value a :current_value',
            'email_sent'             => 'Factura :invoice_number correo electrónico enviado',
            'resend_email'           => 'Factura :invoice_number reenvío de correo electrónico',
            'email_opened'           => 'Factura :invoice_number correo electrónico abierto',
            'payment_updated'        => 'Factura :invoice_number actualizada :full_payment_text pago',
            'payment_received'       => 'Factura :invoice_number recibido :full_payment_text pago',
            'payment_reversed'       => 'La factura :invoice_number tenía un :full_payment_text',
            'invoice_tag_updated'    => 'La etiqueta de factura :tags se agregó en la factura :invoice_number',
            'invoice_tag_deleted'    => 'La etiqueta de factura :invoice_number fue eliminada :tags',
            'mark_mail'              => 'Factura :invoice_number marcar como enviada por correo',
            'unmark_mail'            => 'Factura :invoice_number máscara como no enviada',
            'paid_invoice_opened'    => 'La factura pagada se abrió para editar',
            'sent_invoice_opened'    => 'La factura enviada se abrió para editar',
            'sms_sent'               => 'Factura :invoice_number SMS enviado',
        ],
        'quote'            => [
            'created'           => 'Se creó la cita :quote_number',
            'updated'           => 'Se modificó la cita :quote_number',
            'deleted'           => 'Se eliminó la cita :quote_number',
            'status_changed'    => 'Quote :quote_number El estado cambió de :previous_value a :current_value',
            'email_sent'        => 'Cita :quote_number correo electrónico enviado',
            'resend_email'      => 'Cita :quote_number reenvío de correo electrónico',
            'email_opened'      => 'Cita :quote_number correo electrónico abierto',
            'quote_to_invoice'  => ':quote_number se ha convertido en una factura - :invoice_number',
            'quote_tag_updated' => 'La etiqueta de cotización :tags se agregó en la cita :quote_number',
            'quote_tag_deleted' => 'La etiqueta de cotización :quote_number fue eliminada :tags',
            'sms_sent'          => 'Cotización :quote_number SMS enviado',
        ],
        'payment'          => [
            'prepayment_created'           => 'Se creó el prepago',
            'payment_receipt_email_sent'   => 'Recibo de pago enviado por correo electrónico',
            'payment_receipt_resend_email' => 'Reenvío del correo electrónico del recibo de pago',
            'payment_updated'              => 'El pago fue modificado',
            'deleted'                      => 'El pago fue eliminado',
            'payment_receipt_pdf_download' => 'Descarga de PDF de comprobante de pago',
            'payment_note_deleted'         => 'Nota de pago eliminada:',
            'payment_note_added'           => 'Nota de pago añadida:',
            'payment_note_updated'         => 'Nota de pago actualizada de',
            'payment_failed'               => 'Pago fallido',
        ],
        'client'           => [
            'client_created'     => 'Se creó :client_type',
            'type_changed'       => ':previous_value se convirtió en :current_value',
            'updated'            => 'El cliente fue actualizado',
            'deleted'            => 'El cliente fue eliminado',
            'status_changed'     => 'Cliente configurado en :current_value',
            'client_tag_updated' => 'Etiqueta :tags añadida',
            'client_tag_deleted' => 'Etiqueta :tags eliminada',
            'merge'              => 'ID de cliente: :idTo - :nameTo se fusionó con ID de cliente: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Se creó el gasto',
            'updated' => 'Se modificó el gasto',
            'deleted' => 'Se eliminó el gasto',
            'billed'  => 'Se facturó el gasto',
            'vendor'  => [
                'created' => 'Se creó el proveedor de gastos',
                'updated' => 'Se modificó el proveedor de gastos',
                'deleted' => 'Se eliminó el proveedor de gastos',
            ],
        ],
        'note'             => [
            'created'          => 'Se creó la nota',
            'updated'          => 'La nota fue modificada',
            'deleted'          => 'La nota fue eliminada',
            'note_tag_updated' => 'Etiqueta :tags agregada en la nota',
            'note_tag_deleted' => 'Etiqueta :tags eliminada de la nota',
        ],
        'task'             => [
            'created'   => 'Se creó la tarea',
            'updated'   => 'La tarea fue modificada',
            'deleted'   => 'La tarea fue eliminada',
            'completed' => 'La tarea se completó',
        ],
        'subscription'     => [
            'created'                       => 'Se creó la suscripción :invoice_number',
            'updated'                       => 'Suscripción :invoice_number fue modificada',
            'deleted'                       => 'La suscripción :invoice_number fue eliminada',
            'recurring_invoice_tag_updated' => 'Etiqueta de suscripción :tags se agregó en Suscripción :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'La etiqueta de suscripción :recurringInvoice_number fue eliminada :tags',
        ],
        'attachment'       => [
            'created' => ':filename se cargó como un archivo adjunto.',
            'deleted' => ':filename se eliminó como un archivo adjunto',
        ],
        'tag'              => [
            'created' => 'Se agregó la etiqueta :tag a',
            'deleted' => 'La etiqueta :tag fue eliminada de',
        ],
    ],
    'reset'                                           => 'Reiniciar',
    'select_event'                                    => 'Seleccionar tipo de evento',
    'select_country'                                  => 'Seleccione un país',
    'type_captcha'                                    => 'Responde la pregunta anterior',
    'refresh_captcha'                                 => 'Actualizar pregunta',
    'answer'                                          => 'Responder',
    'use_captcha_in_login'                            => 'Usar captcha en Iniciar sesión',
    'allow_client_timeline'                           => 'Cronología',
    'client_timeline'                                 => 'Cronología',
    'no_invoice_tags'                                 => 'No hay etiquetas de factura.',
    'total_notifications'                             => 'Tienes notificaciones de :total',
    'no_notifications'                                => 'no hay notificaciones nuevas',
    'notifications'                                   => 'Notificaciones',
    'notification'                                    => [
        'task'  => [
            'created'           => 'Una nueva tarea que se te ha asignado',
            'due_date_breached' => 'La tarea',
            'completed'         => ':user tarea completada:',
        ],
        'quote' => [
            'approved'             => ':quote_number ha sido aprobado',
            'quote_to_invoice'     => ':quote_number se ha convertido en una factura -',
            'rejected'             => ':quote_number ha sido rechazado',
            'payment_successfully' => 'Se ha pagado la cotización :quote_number para el cliente :client_name . Se creó la factura :invoice_number y se aplicó el pago',
        ],
    ],
    'search_tasks'                                    => 'Tareas de búsqueda',
    'reopen_task'                                     => 'Reabrir tarea',
    'task_form'                                       => 'Agregar tarea',
    'view_task'                                       => 'Detalles de la tarea',
    'client_deleted'                                  => 'El cliente está eliminado',
    'payment_canceled'                                => 'Tu pago ha sido cancelado',
    'default_company_profile_set'                     => 'Hemos establecido su perfil de empresa predeterminado. Puede actualizarlo en cualquier momento desde la configuración del perfil de la empresa.',
    'file_uploaded_successfully'                      => 'El archivo ha subido correctamente',
    'attachment_notice'                               => 'Tamaño máximo del archivo adjunto menor o igual que :size',
    'attachment_error'                                => 'El tamaño del archivo adjunto no puede exceder :size',
    'attachment_warning'                              => 'El tamaño del archivo adjunto es :size.. La carga de muchos archivos adjuntos grandes puede degradar el rendimiento de la base de datos con el tiempo.',
    'generate_timeline_history'                       => 'Generar historial de cronología',
    'generating_timeline_wait'                        => 'Generando línea de tiempo, espere ...',
    'generating_timeline_confirm'                     => 'La función de línea de tiempo se agregó en FusionInvoice 2020. Esto generará entradas de línea de tiempo para todas las actividades que precedieron a la adición de esa función. ¿Seguir?',
    'generated_timeline_request_accepted'             => '',
    'transitions'                                     => '',
    'pending'                                         => 'Pendiente',
    'client_transition'                               => 'Cronogramas del cliente',
    'expense_transition'                              => 'Plazos de gastos',
    'invoice_transition'                              => 'Cronogramas de facturas',
    'payment_invoice_transition'                      => 'Plazos de pago de facturas',
    'payment_transition'                              => 'Plazos de pago',
    'quote_transition'                                => 'Cronogramas de cotización',
    'note_transition'                                 => 'Notas cronológicas',
    'task_transition'                                 => 'Cronogramas de tareas',
    'email_sent'                                      => 'Email enviado',
    'credit_applied'                                  => 'Crédito aplicado',
    'configuration'                                   => 'Configuración',
    'include_prepayments'                             => 'Incluir prepagos',
    'pre_payment'                                     => 'Prepagos',
    'pre_payments'                                    => 'Prepagos',
    'times'                                           => 'Veces',
    'include_prepayments_applied'                     => 'Incluir prepagos aplicados',
    'confirm_full_payment_applied'                    => 'El pago se aplicó por completo',
    'confirm_full_credit_memo_applied'                => 'La nota de crédito se aplicó por completo',
    'all_tasks'                                       => 'Todas las tareas',
    'my_tasks'                                        => 'Mis tareas',
    'assigned_from_others'                            => 'Asignado de otros',
    'full_payment_reversed'                           => 'pago completo invertido.',
    'partial_payment_reversed'                        => 'pago parcial revertido.',
    'invoice_delete_error'                            => 'Lo sentimos, no puede eliminar una factura que tenga pagos o aplicaciones de notas de crédito. Primero debe eliminar los pagos o las aplicaciones de notas de crédito.',
    'mail-from-required'                              => 'Debe ingresar un correo electrónico de correo válido',
    'contact_updated'                                 => 'Contacto actualizado correctamente',
    'contact_added'                                   => 'Contacto agregado exitosamente',
    'generate_passport_key_wait'                      => 'Generando su clave de pasaporte, espere ...',
    'generate_passport_key'                           => 'Generar clave de pasaporte',
    'default_greeting'                                => '¡Hola!<br>',
    'hi'                                              => 'Hola,',
    'deduct_tax_from_expenses'                        => 'Deducir impuestos de los gastos',
    'invalid_invoice_id'                              => 'ID de factura no válido',
    'client_related_record_exist'                     => 'Lo sentimos, el cliente tiene registros relacionados para:: módulos. Los clientes con historial de transacciones no se pueden eliminar.',
    'email_payment_receipt_notice'                    => 'El cliente no tiene una dirección de correo electrónico registrada',
    'show_more'                                       => 'Mostrar más ...',
    'show_less'                                       => 'Muestra menos ...',
    'invoice_already_paid'                            => '¡La factura ya está pagada!',
    'system_default'                                  => 'Sistema por defecto',
    'created_by'                                      => 'Creado por',
    'created_at'                                      => 'Creado en',
    'task_created_by_and_created_at'                  => 'Tarea creada por :created_by en :created_at',
    'dashboard_widgets_date_options'                  => 'Período de tiempo predeterminado del sistema para resumen de facturas y presupuestos',
    'dashboard-widget-from-date-required'             => 'Desde la fecha se requiere cuando se selecciona un rango de fechas personalizado en el período de tiempo predeterminado del sistema para el resumen de facturas y presupuestos',
    'dashboard-widget-to-date-required'               => 'Se requiere la fecha hasta cuando se selecciona un rango de fechas personalizado en el Período de tiempo predeterminado del sistema para el resumen de facturas y presupuestos',
    'invoice_currency'                                => 'Moneda de la factura',
    'currency_format'                                 => 'Formato de moneda',
    'create_missing_folder_success'                   => 'Se creó la carpeta requerida que falta',
    'create_missing_folder_failed'                    => 'Error al intentar crear carpeta (s) :path',
    'folder_is_not_writable'                          => 'La carpeta no se puede escribir :path',
    'update_item_as_lookup'                           => 'Actualizar la búsqueda de elementos',
    'number_of_tax_fields'                            => 'Número de campos de impuestos',
    'tax_1_entry'                                     => '1 entrada',
    'tax_2_entries'                                   => '2 entradas',
    'require_tags_on_client_notes'                    => 'Requerir etiqueta (s) en las notas del cliente',
    'entered_amount_less_than_invoice_amount'         => 'El monto ingresado debe ser menor o igual al monto de la factura',
    'send-to'                                         => 'Enviar a',
    'print'                                           => 'Impresión',
    'pdf_cleanup'                                     => 'Limpieza de PDF',
    'pdf_cleanup_confirm'                             => '¿Está seguro de que desea limpiar archivos PDF antiguos?',
    'pdf_cleanup_success'                             => 'Limpieza de PDF completada',
    'deleting_pdf_wait'                               => 'Eliminando archivos PDF antiguos, espere ...',
    'open_invoices'                                   => 'Facturas abiertas',
    'open_credits'                                    => 'Créditos abiertos',
    'unapplied_payments'                              => 'Pagos no aplicados',
    'attach_invoice_pdf'                              => 'Adjuntar factura PDF',
    'upcoming_payment_notice'                         => 'Próxima notificación de pago',
    'select_mapping'                                  => 'Seleccionar mapeo',
    'select_named_export'                             => 'Seleccionar exportación con nombre',
    'save_mapping'                                    => 'Guardar mapeo',
    'add_mapping'                                     => 'Crear un nuevo mapeo',
    'edit_mapping'                                    => 'Actualizar mapeo',
    'save_as_default_mapping'                         => 'Mapeo predeterminado',
    'save_as_default_export'                          => 'Exportación predeterminada',
    'export_item_lookups'                             => 'Exportar búsquedas de artículos',
    'import_file_selection'                           => 'Importar selección de archivo',
    'next'                                            => 'Próximo',
    'delete_import_mapping_warning'                   => '¿Está seguro de que desea eliminar esta asignación?',
    'export'                                          => 'Exportar',
    'named_exports'                                   => 'Exportaciones nombradas',
    'save_named_export'                               => 'Guardar exportación con nombre',
    'delete_named_export'                             => 'Eliminar exportación con nombre',
    'updated_at'                                      => 'Actualizado en',
    'zip'                                             => 'Cremallera',
    'fields_to_export'                                => 'Campos para exportar',
    'import-file-type-error'                          => 'El tipo de archivo de importación debe ser CSV',
    'recurring_invoice_items'                         => 'Elementos de factura recurrente',
    'important_details'                               => 'Detalles importantes',
    'important_information'                           => 'Información importante',
    'item_lookups_important_information'              => '<p>Si se encuentra un nombre de búsqueda de elemento coincidente en los datos existentes durante la importación de CSV, el lote de importación fallará y mostrará el elemento que causó la falla.</p>',
    'invoices_important_information'                  => '<p>El nombre del cliente (del CSV) se busca en la tabla Clientes y se resuelve como client_id, si hay un nombre coincidente. Si no se encuentra ninguna coincidencia de nombre, crea una entrada de cliente y utiliza el ID de la nueva entrada de cliente.</p><p>Número de factura,</p><p>Invoice_items busca el número de factura (del CSV) en la tabla de facturas y lo resuelve en el ID. No se realizan otras búsquedas / validaciones de campos clave</p>',
    'invoice_items_important_information'             => '<p>La importación invoice_items realiza una búsqueda en el número de factura (del CSV) en la tabla de facturas y lo resuelve en el ID de factura apropiado. La identificación del cliente también se deriva de la información de la factura correspondiente.</p>',
    'payments_important_information'                  => '<p>La importación de pagos requiere un número de factura coincidente válido para aplicar los pagos. Si no se encuentra una factura coincidente, la importación del lote completo fallará.</p><p>Los clientes apropiados-</p><p>Se realiza una búsqueda en el nombre del método de pago (desde el CSV a la tabla payment_methods) y se resolverá en el payment_method_id apropiado, si se encuentra. si no se encuentra un nombre que coincida, se creará un nuevo registro de método de pago y se utilizará el nuevo payment_method_id.</p>',
    'run_daily_tasks'                                 => 'Ejecutar tareas diarias',
    'daily_task_ran'                                  => 'Las tareas diarias se ejecutaron correctamente',
    'csv_row_number'                                  => 'Número de fila CSV :row',
    'max_item_lookup_records'                         => 'Max. Registros de búsqueda de artículos',
    'invoice_with_commission_delete_error'            => 'Lo sentimos, no puede eliminar una factura que tiene entradas de comisiones con un estado pagado. Primero debe eliminar la comisión pagada en esta factura.',
    'if_invoice_is_emailed_while_draft'               => 'Si la factura se envía por correo electrónico mientras está en estado de borrador',
    'custom_payment_receipt_body_not_exists'          => 'No se encontró la plantilla personalizada para Recibos de Pago.',
    'invoice_email_body_type'                         => 'Tipo de cuerpo del correo electrónico de la factura',
    'send_overdue_reminder'                           => 'Enviar recordatorio de vencimiento',
    'reminder_sent_successfully'                      => 'Recordatorio enviado con éxito',
    'error_sending_reminder'                          => 'Hubo un error al enviar el recordatorio, inténtalo de nuevo más tarde.',
    'expense_date'                                    => 'Fecha de gasto',
    'group_by'                                        => 'Agrupar por',
    'timeline_scope_all_user'                         => 'Alcance de la línea de tiempo: todos los usuarios',
    'copy_to_clipboard'                               => 'Copiar al portapapeles',
    'text_copied_clipboard'                           => '¡Texto copiado en el portapapeles!',
    'import_example_csv'                              => 'Puede encontrar un archivo CSV de ejemplo aquí',
    'import'                                          => 'Importar',
    'address2'                                        => 'Dirección 2',
    'use_parent_email'                                => 'Usar el correo electrónico de los padres',
    'max_import_records'                              => 'El límite máximo para importar registros es :total_records',
    'demo_file_attachment_disabled'                   => 'Los archivos adjuntos están deshabilitados en la demostración',
    'drag_drop_file'                                  => 'Arrastrar',
    'or'                                              => 'O',
    'browse_file'                                     => 'Buscar Archivo',
    'system_setting_and_ui'                           => 'Ajustes del sistema',
    'localization_and_timezone'                       => 'Localización',
    'security'                                        => 'Seguridad',
    'cleanup_and_backup'                              => 'Limpiar',
    'attach_quote_pdf'                                => 'Adjuntar Cotización PDF',
    'attach_payment_receipt'                          => 'Adjuntar recibo de pago',
    'choose-file'                                     => 'Elija el archivo',
    'important-note'                                  => 'Nota IMPORTANTE',
    'collapse'                                        => 'Colapso',
    'add_task'                                        => 'Agregar tarea',
    'recurring_invoice_commissions'                   => 'Comisiones de facturas recurrentes',
    'invoice_commissions'                             => 'Factura Comisiones',
    'percentage'                                      => 'Porcentaje',
    'flat_amount'                                     => 'Cantidad fija',
    'discount-amount'                                 => 'Descuento',
    'discount-type'                                   => 'Tipo de descuento',
    'saving'                                          => 'Ahorro...',
    'preparing'                                       => 'Preparando',
    'allow_line_item_discounts'                       => 'Permitir descuentos de artículos de línea',
    'invalid_price_amount'                            => '¡Cantidad de precio no válida! Debe ser mayor que 0.',
    'light-mode'                                      => 'Modo de luz',
    'dark-mode'                                       => 'Modo oscuro',
    'system_base_currency'                            => 'Moneda base del sistema',
    'is_recurring_task'                               => 'es una tarea recurrente',
    'contact_names'                                   => 'Nombres de contacto',
    'all_client'                                      => 'Todos los clientes',
    'invoice_grand_total'                             => 'Total general de la factura',
    'recurring_invoice_grand_total'                   => 'Total general de factura recurrente',
    'is_required'                                     => '¿Se requiere?',
    'add-new-client'                                  => 'Agregar nuevo cliente',
    'client_name_required'                            => 'El nombre del cliente es obligatorio',
    'custom_item_text_validate'                       => 'Ingrese un elemento válido :label en el campo :label.',
    'assigned_to_others'                              => 'Asignado a otros',
    'all_tasks_and_all_users'                         => 'Todas las tareas/Todos los usuarios',
    'statement'                                       => 'Declaración',
    'profile_code'                                    => 'Código de perfil',
    'login-url'                                       => 'URL de inicio de sesión',
    'url_copied_clipboard'                            => '¡URL copiada en el portapapeles!',
    'payment_receipt_email_sent'                      => 'Correo electrónico de recibo de pago enviado con éxito',
    'edit_payment_note_form'                          => 'Editar nota de pago',
    'payment_invoices_text'                           => '¡Gracias! Su pago de :amount se ha aplicado a las siguientes facturas.',
    'payment_text'                                    => 'Gracias por su pago de :amount.',
    'date_filter_by'                                  => 'Fecha Filtrar por',
    'filter_by_invoice_date'                          => 'Fecha de la factura',
    'filter_by_payment_date'                          => 'Fecha de pago',
    'date-range-required'                             => 'Seleccione rango de fechas',
    'save-and-complete'                               => 'Guardar y completar',
    'completion-note'                                 => 'Nota de finalización',
    'complete-with-note'                              => 'Completar con nota',
    'placeholder_type_note'                           => 'Escribe tus notas...',
    'credit_memo_email_subject'                       => 'Asunto del correo electrónico de la nota de crédito',
    'default_credit_memo_email_body'                  => 'Cuerpo de correo electrónico de nota de crédito predeterminado',
    'show_invoices_from'                              => 'Mostrar facturas de',
    'system_mail_from_address'                        => 'Dirección de remitente del correo del sistema',
    'user_who_created_invoice'                        => 'Usuario que creó la factura',
    'completed'                                       => 'Terminado',
    'no_auth_to_view_task'                            => 'Esta tarea ya no está en tu lista.',
    'credit-memo-and-prepayments'                     => 'Créditos y Pre-pagos',
    'all_selected'                                    => 'Todo seleccionado',
    'select_columns'                                  => 'Seleccionar columnas',
    'column_settings'                                 => 'Configuración de columna',
    'minimum_one_column_check_is_required'            => 'Seleccione al menos una columna',
    'date_of_entry'                                   => 'Fecha de entrada',
    'amount_applied'                                  => 'Cantidad aplicada',
    'date_applied'                                    => 'Fecha aplicada',
    'copy_to_recurring_invoice'                       => 'Copiar a factura recurrente',
    'top_bar_color'                                   => 'Color de la barra superior',
    'light_grey'                                      => 'gris claro',
    'bg-primary'                                      => 'Azul',
    'bg-warning'                                      => 'Amarillo',
    'bg-info'                                         => 'Libélula Azul',
    'bg-danger'                                       => 'Rojo',
    'bg-success'                                      => 'césped verde',
    'bg-indigo'                                       => 'Índigo',
    'bg-lightblue'                                    => 'Victoria Azul',
    'bg-navy'                                         => 'Azul marino',
    'bg-purple'                                       => 'Púrpura',
    'bg-fuchsia'                                      => 'Fucsia',
    'bg-pink'                                         => 'Rosa',
    'bg-maroon'                                       => 'Granate',
    'bg-orange'                                       => 'Naranja',
    'bg-lime'                                         => 'Verde lima',
    'bg-teal'                                         => 'verde azulado',
    'bg-olive'                                        => 'Aceituna',
    'fee_name'                                        => 'Nombre de la tarifa',
    'fee_percentage'                                  => 'Porcentaje de tarifa',
    'fee_explanation'                                 => 'Tarifa Explicación',
    'enable_online_payment_processing_fees'           => 'Habilitar tarifas de procesamiento de pagos en línea',
    'allow_online_payment_processing_fees'            => 'Permitir tarifas de procesamiento de pagos en línea',
    'allow_online_pay_fees'                           => 'Permitir tarifas de pago en línea',
    'convenience_charges'                             => 'Cargos de conveniencia',
    'opp-fee-percentage-required'                     => 'Se requiere el porcentaje de las tarifas de procesamiento de pagos en línea',
    'opp-fee-percentage-gt-zero'                      => 'El porcentaje de las tarifas de procesamiento de pagos en línea debe ser mayor que cero',
    'cron_error'                                      => 'falló en :datetime',
    'cron_start'                                      => 'El corredor de tareas diarias comenzó en :datetime',
    'notification_clear_all'                          => 'Borrar todas las notificaciones',
    'show'                                            => 'Show',
    'report'                                          => 'Informe',
    'profit_loss'                                     => 'Ganancia y perdida',
    'credit_and_pre_payments'                         => 'Créditos y Pre-pagos',
    'expenses_vendors'                                => 'Gastos Proveedores',
    'expenses_categories'                             => 'Categorías de gastos',
    'create'                                          => 'Crear',
    'import_map_clients'                              => 'Importar clientes de mapas',
    'payctr_users'                                    => 'Usuarios de PaymentCenter',
    'ctrl_plus_click'                                 => 'Ctrl-clic para agregar notas de finalización',
    'edit_note'                                       => 'Editar nota',
    'save-and-unComplete'                             => 'Guardar y Descompletar',
    'sales_chart'                                     => 'Gráfico de ventas',
    'accumulate_totals'                               => 'Acumular Totales',
    'do_not_accumulate_totals'                        => 'No acumular totales',
    'kpi_cards'                                       => 'Tarjetas KPI',
    'no_data_to_display'                              => 'No hay información para mostrar',
    'choose_period'                                   => 'Elija Periodo',
    'date_mailed'                                     => 'Fecha de envío',
    'date_emailed'                                    => 'Fecha de envío por correo electrónico',
    'action'                                          => 'Acción',
    'mail'                                            => 'Correo',
    'mark_as_mailed'                                  => 'Marcar como enviado',
    'invoice_mailed'                                  => 'La factura se ha marcado como enviada por correo',
    'emailed'                                         => 'Enviado por correo electrónico',
    'paid_invoice_canceled_error'                     => 'Para cancelar esta factura, elimine los pagos de la factura.',
    'allow_invoice_delete'                            => 'Permitir eliminación de factura',
    'allow_child_accounts'                            => 'Permitir cuentas infantiles',
    'third_party_bill_payer'                          => 'Pagador de facturas de terceros',
    'invoices_paid_by'                                => 'Facturas pagadas por',
    'use_third_party_bill_payer_email'                => 'Usar el correo electrónico del pagador de facturas de terceros',
    'email_default'                                   => 'Correo electrónico predeterminado',
    'client_default'                                  => 'Valor predeterminado del cliente',
    'clear-all'                                       => 'Limpiar todo',
    'system_log_is_missing_or_empty'                  => 'Falta el registro del sistema o está vacío',
    'change_to_draft'                                 => 'Cambiar a Borrador',
    'invoice_status_change_to_draft'                  => 'Cambio de estado de factura a borrador',
    'there_is_some_error'                             => 'Hay algunos errores',
    'filter_by_date'                                  => 'Filtrar por fecha',
    'quote_grand_total'                               => 'Total general de la cotización',
    'email_upcoming_payment_due_notice'               => 'Envíe por correo electrónico un aviso de próximo pago',
    'email_overdue_invoice_reminder'                  => 'Recordatorio de factura vencida por correo electrónico',
    'page_totals'                                     => 'Totales de página',
    'categories'                                      => 'Categorías',
    'conven_charges'                                  => 'conversión Cargos',
    'invoice_status_change_to_cancel'                 => 'Cambio de estado de factura para cancelar',
    'filter_by_invoice_number'                        => 'Número de factura',
    'filter_by_client_name'                           => 'nombre del cliente',
    'custom_mail_template'                            => 'Plantilla de correo personalizada',
    'invoice_use_custom_mail_template'                => 'Plantilla de correo personalizado de uso de factura',
    'client_or_company_name'                          => 'Cliente/Nombre de la empresa',
    'view_invoice'                                    => 'Mirar la factura',
    'tt_active'                                       => 'Cuando un registro de cliente no está activo, no aparecerá en la lista de clientes predeterminada y no se permitirán transacciones normales.',
    'tt_invoice_prefix'                               => 'Un código de prefijo de factura único se asigna automáticamente a un registro de cliente cuando se crea. Se puede cambiar manualmente más tarde. Se puede utilizar como parte de su esquema de numeración de documentos para la numeración de facturas, lo que permite un número de factura único por cliente.',
    'tt_automatic_email_payment_receipts'             => 'Envía un recibo de pago por correo electrónico al cliente al recibir un pago. Una configuración global está disponible dentro de la Configuración del sistema, pero se puede anular en función de un cliente individual.',
    'tt_automatic_email_on_recur'                     => 'Envía una factura por correo electrónico al cliente cuando se ejecuta una factura recurrente y crea una factura en vivo. Una configuración global está disponible dentro de la Configuración del sistema, pero se puede anular en función de un cliente individual.',
    'tt_default_currency'                             => 'La moneda asignada a esta cuenta de cliente, que se utilizará para sus transacciones de factura, cotización y pago. Este valor está predeterminado en la configuración del sistema para la divisa base.',
    'tt_language'                                     => 'El idioma que se mostrará al cliente cuando inicie sesión en el centro de clientes.',
    'tt_allow_client_center_login'                    => '¿Se debe permitir que el cliente inicie sesión en su centro de clientes de FusionInvoice? Su correo electrónico debe usarse para su nombre de usuario y debe asignar una contraseña. La URL del centro de clientes es',
    'tt_timezone'                                     => 'Zona horaria para el cliente. Si se ingresa, la hora local del cliente se mostrará en la parte superior de la vista de la página del Cliente.',
    'tt_allow_online_payment_processing_fees'         => 'Las tarifas de procesamiento de pagos en línea pueden aplicarse a los clientes que pagan con tarjeta de crédito, utilizando su enlace de factura pública (incluido en el correo electrónico de la factura). Esta opción tiene una configuración de sistema global, pero también se puede anular en función de un cliente individual.',
    'tt_allow_child_accounts'                         => 'Configurar Permitir cuentas secundarias en Sí permite que este cliente actúe como una cuenta principal y le permitirá seleccionarlo de la lista de cuentas principales.',
    'tt_third_party_bill_payer'                       => 'Un tercero pagador de facturas es una organización que paga las facturas de sus clientes, como una firma de contabilidad externa.',
    'tt_parent_account'                               => 'La empresa matriz con la que este cliente está relacionado o es una subsidiaria. Esta lista contiene los registros de clientes que tienen la configuración Permitir cuentas secundarias establecida en Sí. Deje en blanco si el cliente no tiene una cuenta principal.',
    'tt_invoices_paid_by'                             => 'El negocio de terceros que este cliente utiliza para pagar sus facturas. Esta lista contiene los registros de clientes que tienen la configuración Pagador de facturas de terceros establecida en Sí. Deje en blanco si el cliente paga sus propias facturas.',
    'tt_email_default'                                => 'Al enviar correos electrónicos a este cliente, seleccione el correo electrónico que debe usarse. Si este cliente tiene una cuenta principal asociada o una cuenta de facturas pagadas por, se puede seleccionar cualquiera de esas opciones. El valor predeterminado es el correo electrónico estándar del cliente.',
    'tt_default_to'                                   => 'Al enviar correos electrónicos, ¿debería agregarse automáticamente este contacto a la lista de destinatarios \'To:\'?',
    'tt_default_cc'                                   => 'Al enviar correos electrónicos, ¿debería agregarse automáticamente este contacto a la lista de destinatarios de \'CC:\'?',
    'tt_default_bcc'                                  => 'Al enviar correos electrónicos, ¿debe agregarse automáticamente este contacto a la lista de destinatarios \'BCC:\'?',
    'tt_client_type'                                  => 'Un Lead es un candidato de ventas no calificado. Un prospecto es un candidato calificado que pronto puede convertirse en cliente. Un Cliente es una empresa o persona a la que ha vendido (o pronto venderá) bienes o servicios. Un Afiliado es una empresa o individuo que revende sus productos o servicios. Otro se usa para negocios que no se ajustan a los otros tipos, como Pagadores de facturas de terceros o Cuentas de padres con las que no hace negocios directamente.',
    'tt_client_tags'                                  => 'Las etiquetas se pueden asignar a un cliente para ayudar a categorizar o filtrar su lista de clientes para ver o generar informes.',
    'tt_important_note'                               => 'Una nota ingresada aquí aparecerá automáticamente dentro de un ¡IMPORTANTE! ventana cuando se visualiza el registro del cliente.',
    'tt_gen_header_title_text'                        => 'El texto que se muestra en la esquina superior izquierda, junto a su logotipo, generalmente el nombre de su empresa.',
    'tt_gen_default_company_profile'                  => 'El perfil de la empresa que se utilizará de forma predeterminada al crear nuevas facturas, cotizaciones, etc. Los perfiles de la empresa le permiten presentar su negocio de manera diferente con cada perfil, lo que permite diferentes nombres de empresa, logotipos, formatos de factura, etc.',
    'tt_gen_address_format'                           => 'Le permite crear el formato de dirección que se muestra en las facturas y cotizaciones utilizando el campo de dirección única o una combinación de los campos de dirección individuales, como ciudad, estado, país, etc.',
    'tt_gen_custom_fields_columns'                    => 'Los campos personalizados pueden mostrarse de 1 a 3 campos por fila.',
    'tt_gen_require_tags_on_client_notes'             => 'Si se establece en Sí, requerirá que se seleccione o ingrese una etiqueta al agregar una nota de cliente, como \'Soporte\' o \'Ventas\'. Esto es útil para categorizar y buscar notas.',
    'tt_gen_skin'                                     => '¿Cómo le gustaría que se muestre su interfaz de usuario FI, modo claro u oscuro?',
    'tt_gen_top_bar_color'                            => 'El color de la barra de título superior. Si trabaja con varias instalaciones diferentes de FusionInvoice, esta puede ser una identificación visual útil.',
    'tt_gen_results_per_page'                         => 'La cantidad de registros que se muestran por página para todas las vistas de lista, como clientes, facturas, cotizaciones, gastos, etc.',
    'tt_gen_allow_line_item_discounts'                => 'Habilita o deshabilita la función de descuento de artículos de línea dentro de facturas y cotizaciones.',
    'tt_gen_language'                                 => 'El idioma que se utilizará para la instalación de FusionInvoice. Tenga en cuenta que puede asignar un idioma diferente para sus clientes, permitiéndoles interactuar con el Centro de clientes de FusionInvoice utilizando su idioma nativo.',
    'tt_gen_date_format'                              => 'Su formato de fecha preferido',
    'tt_gen_use_24_hour_time_format'                  => 'Permite la compatibilidad con formatos de hora de 24 o 12 horas.',
    'tt_gen_timezone'                                 => 'La revista de tiempo principal de su empresa.',
    'tt_gen_base_currency'                            => 'La moneda que su negocio usa con más frecuencia.',
    'tt_gen_exchange_rate_mode'                       => 'Manual le permite ingresar el valor del tipo de cambio mientras crea las facturas. Automatic intentará usar una API pública para obtener el tipo de cambio de la moneda. Esto solo se usa cuando está ingresando una transacción usando una moneda diferente a su moneda base.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice admite hasta 2 campos de impuestos por artículo de línea. El valor seleccionado con mostrar u ocultar el segundo campo de impuestos.',
    'tt_gen_quantity_price_decimals'                  => 'El número de decimales a mostrar para los valores de cantidad y cantidad. Seleccione de 0 a 4 según su nivel de precisión requerido.',
    'tt_gen_round_tax_decimals'                       => 'Seleccione el número requerido de decimales para los cálculos de redondeo de impuestos.',
    'tt_gen_use_captcha_in_login'                     => 'Si se establece en Sí, requerirá que sus usuarios respondan una pregunta de seguridad de CAPTCHA durante el inicio de sesión.',
    'tt_gen_force_https'                              => 'Rara vez recomendamos activar esta opción. Si su instalación no tiene instalado un certificado SSL que funcione correctamente en su servidor web, para su instalación de FusionInvoice, puede experimentar problemas. Puede lograr el mismo resultado configurando una regla de redirección del servidor.',
    'dashboard_settings'                              => 'Configuración del panel',
    'tt_dashboard_settings'                           => 'Su tablero se utiliza para mostrar métricas y eventos comerciales importantes, lo que le brinda información valiosa sobre el rendimiento de su empresa. El panel del sistema es el predeterminado para todos los usuarios, sin embargo, dentro de la configuración de cada usuario, puede anular el panel predeterminado del sistema, definiendo configuraciones específicas para cada usuario. La configuración a continuación le permite personalizar su tablero.',
    'tt_db_default_time_period'                       => 'Establece las fechas de inicio y finalización predeterminadas para los widgets del panel que las utilizan, como las tarjetas KPI y el gráfico de ventas.',
    'tt_db_recent_client_activity'                    => 'Un widget que muestra las interacciones de los clientes, como los pagos realizados y las facturas o cotizaciones vistas, desde sus enlaces de cotizaciones o facturas públicas.',
    'tt_db_display_order'                             => 'Esto cambia el orden de visualización de los widgets del tablero. 1 se mostrará en la parte superior, 2 se mostrará después de 1, etc.',
    'tt_db_column_width'                              => 'Los widgets del tablero usan el sistema de cuadrícula Bootstrap y tienen un ancho de columna máximo de 12. Establecer el ancho de columna en 12 hará que el widget use todo el ancho disponible. Establecerlo en 6 permitirá que dos widgets compartan la misma fila, 4 permitirá que 3 widgets compartan la misma fila, etc.',
    'tt_db_accumulate_totals'                         => 'Establecer este valor hará que su gráfico incluya los totales de los días anteriores para cada día. Por ejemplo, las ventas del día 1 fueron de $100, las del día 2 fueron de $50 y las del día 3 fueron de $125. El gráfico mostraría una línea ascendente con esta opción establecida en Sí. Establecer en No, mostraría una caída en la línea de ventas en el día 2 y aumentaría en el día 3.',
    'tt_db_kpi_cards'                                 => 'Estas tarjetas codificadas por colores muestran indicadores clave de rendimiento en la parte superior de su tablero.',
    'tt_db_sales_chart'                               => 'Un gráfico de líneas que muestra los totales de facturas y pagos.',
    'tt_db_task_list'                                 => 'Este widget le permite trabajar con el módulo Lista de tareas, directamente desde su tablero.',
    'tt_db_task_list_include_time'                    => 'Activar esta opción le permite especificar la fecha y la hora de las fechas de vencimiento cuando trabaja con tareas. Cuando se establece en No, solo se utiliza el valor de la fecha.',
    'tt_db_timeline'                                  => 'El widget de línea de tiempo muestra una lista cronológica y de búsqueda de eventos importantes del sistema, como cambios en el estado del cliente, facturas enviadas por correo electrónico, pagos realizados, notas tomadas, etc.',
    'tt_ss_invoices_default_invoice_template'         => 'Seleccione la plantilla que se utilizará, por defecto, al crear nuevas facturas. Las plantillas personalizadas deben colocarse en .\\custom\\templates\\invoice_templates\\ y deben nombrarse con la extensión .blade.php.',
    'tt_ss_invoices_default_doc_scheme'               => 'Seleccione el esquema de número de documento que se utilizará, por defecto, al crear nuevas facturas. Los esquemas de números de documentos se pueden crear dentro de los Ajustes de configuración y le permiten personalizar sus números de documentos (facturas, cotizaciones, notas de crédito).',
    'tt_ss_invoices_invoice_due_days'                 => 'El número predeterminado de días, después de la fecha de la factura (creación), que la factura vencerá y se espera que se pague.',
    'tt_ss_invoices_automatic_email_ri'               => 'Cuando se ejecuta una factura recurrente y genera una factura en vivo, ¿debe enviarse automáticamente esa factura en vivo al cliente por correo electrónico?',
    'tt_ss_invoices_qr_code'                          => 'En caso de que se coloque automáticamente un código QR en las facturas y cotizaciones predeterminadas. Si utiliza plantillas personalizadas de facturas o cotizaciones, consulte las plantillas predeterminadas para agregar el código QR a sus plantillas personalizadas.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'Si una factura está en estado Borrador y se envía por correo electrónico, ya sea de forma manual o automática, qué debe ocurrir con la fecha de la factura. Nota importante: cuando se envía una factura por correo electrónico, el estado cambiará automáticamente de Borrador a Enviado.',
    'tt_ss_invoices_recalculate'                      => 'Ejecuta todas las transacciones realizadas para cada factura, desde la fecha en que se creó hasta la fecha actual, y vuelve a calcular los totales, los totales de las partidas, los impuestos, los descuentos y los totales de las facturas. Esto puede tardar mucho tiempo en ejecutarse si tiene un conjunto de datos grande.',
    'tt_ss_invoices_due_after'                        => 'La fecha de vencimiento de la factura será la fecha de la factura más el número de días ingresados aquí.',
    'tt_ss_invoices_default_status_filter'            => 'El filtro de estado que se aplicará, por defecto, al visualizar la lista de facturas.',
    'tt_ss_invoices_default_terms'                    => 'El valor del texto de los términos que se muestra, en la plantilla de factura predeterminada, en el área inferior de la factura, dentro del área de Términos y condiciones.',
    'tt_ss_invoices_default_footer'                   => 'Valor de texto de pie de página que se muestra, en la plantilla de factura predeterminada, en la parte inferior de la factura. Por ejemplo:',
    'tt_ss_invoices_automatic_email_on_recur'         => 'Cuando el ejecutor de tareas diarias (trabajo CRON) ejecuta y genera una factura en vivo a partir de una plantilla de factura recurrente, ¿la factura recién creada debe enviarse automáticamente por correo electrónico al cliente? Esto se puede anular cliente por cliente.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'Cuando se toma un pago, ¿debe enviarse automáticamente esa información de pago al cliente por correo electrónico?',
    'tt_ss_invoices_online_payment_method'            => 'El método de pago que se asigna cuando un cliente paga mediante un enlace de factura pública. Los métodos de pago se pueden mantener a través de la configuración del sistema.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => '¿Debe mostrarse en el documento un código QR, que dirige a la URL pública de la factura o la cotización?',
    'tt_ss_invoices_allow_invoice_delete'             => '¿Debería permitirse a los usuarios, incluso a los administradores, eliminar facturas? Una alternativa más segura y rastreable a la eliminación de facturas es cambiar el estado de la factura a \'Cancelada\', lo que cambia el total de la factura a cero y la excluye de la mayoría de las listas e informes.',
    'tt_ss_invoices_show_invoices_from'               => 'Cuando las facturas se envían por correo electrónico, esto se mostrará como la dirección Enviado desde. Nota importante: El valor de Responder a siempre será el valor asignado en Configuración del sistema -',
    'tt_ss_invoices_if_emailed_while_draft'           => 'Desde la vista de factura, si la factura está en estado Borrador y se envió por correo electrónico, ¿la fecha de la factura debe permanecer sin cambios o cambiar a la fecha actual? Si cambia la fecha de la factura, también se actualiza la fecha de vencimiento.',
    'tt_ss_quotes_default_quote_template'             => 'Seleccione la plantilla que se utilizará, por defecto, al crear una nueva cotización. Las plantillas personalizadas deben colocarse en .\\custom\\templates\\quote_templates\\ y deben nombrarse con la extensión .blade.php.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Seleccione el esquema de número de documento que se utilizará, por defecto, al crear nuevas cotizaciones. Los esquemas de números de documentos se pueden crear dentro de los Ajustes de configuración y le permiten personalizar sus números de documentos (facturas, cotizaciones, notas de crédito).',
    'tt_ss_quotes_expire_days'                        => 'El número predeterminado de días, después de la fecha de cotización (creación), en que expirará la cotización. Cuando una cotización ha pasado su fecha de vencimiento, se entiende que el precio puede cambiar debido a las fluctuaciones del mercado, etc.',
    'tt_ss_quotes_default_status_filter'              => 'El filtro de estado que se aplicará, por defecto, al visualizar la lista de facturas.',
    'tt_ss_quotes_auto_convert'                       => 'Cuando se aprueba una cotización, en caso de que esto provoque que se cree automáticamente una factura a partir de la cotización.',
    'tt_ss_quotes_when_converted_action'              => 'Cuando una cotización se convierte en una factura, ¿deben usarse los términos de pago de la cotización o de la configuración predeterminada de los términos de la factura?',
    'tt_ss_quotes_default_terms'                      => 'El valor del texto de los términos que se muestra, en la plantilla de cotización predeterminada, en el área inferior de la cotización, dentro del área de Términos y condiciones.',
    'tt_ss_quotes_default_footer'                     => 'Valor de texto de pie de página que se muestra, en la plantilla de cotización predeterminada, en la parte inferior de la cotización. Por ejemplo:',
    'tt_ss_quotes_if_emailed_in_draft'                => 'Si una cotización está en estado Borrador y se envía por correo electrónico, ya sea de forma manual o automática, qué debe suceder con la fecha de la cotización. Nota importante: cuando se envía una cotización por correo electrónico, el estado cambiará automáticamente de Borrador a Enviado.',
    'tt_ss_quotes_recalculate'                        => 'Ejecuta cada transacción realizada para cada cotización, desde la fecha en que se creó hasta la fecha actual, y vuelve a calcular los totales, los totales de las partidas, los impuestos, los descuentos y los totales de la cotización. Esto puede tardar mucho tiempo en ejecutarse si tiene un conjunto de datos grande.',
    'tt_ss_taxes_default_rate1'                       => 'La tasa impositiva principal que debe aplicarse automáticamente a los nuevos elementos de línea agregados a las facturas o cotizaciones. Las tasas de impuestos se mantienen a través de Configuración -',
    'tt_ss_taxes_default_rate2'                       => 'La tasa impositiva secundaria que debe aplicarse automáticamente a los nuevos elementos de línea agregados a las facturas o cotizaciones. Las tasas de impuestos se mantienen a través de Configuración -',
    'tt_ss_email_send_method'                         => 'El método de envío de correo electrónico que debe utilizar FusionInvoice. Cambiar el método de envío también cambia la visualización de los campos de apoyo para el método de envío.',
    'tt_ss_email_allow_self_cert'                     => 'Al activar esta opción, se desactiva el requisito de verificar_peer de PHP. Para obtener más información, busque en Internet: PHP correo electrónico certificado autofirmado openssl.cafile',
    'tt_ss_email_reply_to'                            => 'Al enviar correos electrónicos, esta es la dirección Responder a predeterminada que verán sus destinatarios.',
    'tt_ss_email_always_cc'                           => 'Una dirección de correo electrónico que, de forma predeterminada, le gustaría copiar automáticamente con cada correo electrónico enviado.',
    'tt_ss_email_always_bcc'                          => 'Una dirección de correo electrónico que, de forma predeterminada, le gustaría incluir automáticamente en BCC con cada correo electrónico enviado.',
    'tt_ss_email_send_test_to'                        => 'La dirección de correo electrónico que se utilizará al hacer clic en el botón Enviar correo electrónico de prueba.',
    'tt_ss_email_mail_from_addr'                      => 'La dirección de remitente predeterminada que se utilizará cuando se envíen correos electrónicos desde FusionInvoice. Nota: dentro de Configuración del sistema -',
    'tt_ss_email_mail_from_name'                      => 'El nombre descriptivo Mail From que se mostrará en los correos electrónicos enviados.',
    'tt_ss_email_email_templates'                     => 'Las plantillas de correo electrónico están disponibles para muchos documentos y eventos, que incluyen: cotizaciones, aprobaciones de cotizaciones, rechazos de cotizaciones, facturas, facturas vencidas, notas de crédito, recibos de pago, avisos de próximos pagos. Se incluye una plantilla predeterminada, pero también puede crear plantillas personalizadas, que pueden ser simples (como las plantillas predeterminadas provistas) o HTML con formato completo.',
    'tt_ss_pdf_driver'                                => 'El controlador que se utilizará al crear documentos PDF. La selección del controlador \'wkhtmltopdf\' requiere la instalación de un servidor local de este programa y la configuración de la ruta binaria adecuada para él.',
    'tt_ss_pdf_binary_path'                           => 'La ruta del servidor local al archivo binario para wkhtmltopdf. Por ejemplo C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice es compatible con varios proveedores de pagos en línea. Habilita los proveedores con los que tienes cuentas establecidas. Los proveedores habilitados aquí se mostrarán como opciones de pago, cuando sus clientes vean sus facturas utilizando el enlace de factura pública (incluido en el correo electrónico de factura predeterminado).',
    'tt_ss_olp_api_key'                               => 'Su proveedor de pago le proporciona la clave API.',
    'tt_ss_olp_payment_button_text'                   => 'El texto que se muestra en el botón de método de pago para este proveedor de pago, en la parte superior de su factura pública, tal como lo ven sus clientes.',
    'tt_ss_olp_mode'                                  => 'Con el respaldo de algunos proveedores de pago, lo que permite Sandbox más (pruebas) y en vivo.',
    'tt_ss_olp_client_id'                             => 'Este proveedor de pago le proporciona el ID de cliente.',
    'tt_ss_olp_client_secret'                         => 'El secreto del cliente se lo proporciona este proveedor de pago.',
    'tt_ss_olp_publishable_key'                       => 'Este proveedor de pago le proporciona la clave publicable.',
    'tt_ss_olp_secret_key'                            => 'Este proveedor de pago le proporciona la clave secreta.',
    'tt_ss_olp_opp_fees_about'                        => 'Las tarifas de procesamiento de pagos en línea pueden aplicarse a los clientes que pagan con tarjeta de crédito, utilizando su enlace de factura pública (incluido en el correo electrónico de la factura).',
    'tt_ss_olp_enable_opp_fees'                       => 'Las tarifas de procesamiento de pagos en línea pueden aplicarse a los clientes que pagan con tarjeta de crédito, utilizando su enlace de factura pública (incluido en el correo electrónico de la factura). Esta opción tiene una configuración de sistema global, pero también se puede anular en función de un cliente individual.',
    'tt_ss_olp_opp_fee_pct'                           => 'El porcentaje del total de la factura que se cobrará como tarifa de procesamiento de pago en línea (conveniencia).',
    'tt_ss_olp_opp_fee_name'                          => 'El nombre de la tarifa que se mostrará en la factura. Es decir. \'Tarifa de conveniencia de tarjeta de crédito\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'Una explicación de la tarifa que se mostrará en la factura. Es decir. \'Se cobra una tarifa del 3% para todas las transacciones con tarjeta de crédito\'',
    'tt_company_profiles_about'                       => 'Los perfiles de empresa le permiten presentar su negocio de manera diferente con cada perfil, lo que permite diferentes nombres de empresa, logotipos, formatos de factura, etc. Proporciona una forma de tener varias empresas virtuales dentro de la misma instalación de FusionInvoice. Se debe seleccionar un perfil de empresa predeterminado en Configuración del sistema.',
    'tt_users_about'                                  => 'Puede crear usuarios de tipo Administrador (acceso completo) o Estándar (se deben otorgar permisos de sistema individuales). Al configurar \'Permitir inicio de sesión en el Centro de clientes\' en Sí para un registro de cliente, se agregará automáticamente un registro de usuario para el cliente; sin embargo, los usuarios del cliente solo se pueden agregar mediante la interfaz de configuración del cliente.',
    'tt_users_client_about'                           => 'Los usuarios del cliente solo pueden iniciar sesión en el Centro de Clientes, lo que les permite una vista limitada de sus facturas, cotizaciones y pagos. Al configurar \'Permitir inicio de sesión en el Centro de Clientes\' en Sí para un registro de cliente, se les otorgará acceso al Centro de Clientes.',
    'tt_user_types_about'                             => 'Los usuarios administradores tienen acceso completo al sistema. A los usuarios estándar se les pueden otorgar los permisos individuales que necesitan. Los usuarios del cliente solo tienen acceso a su información específica dentro del Centro de clientes y su capacidad para iniciar sesión se establece en la Configuración del cliente:',
    'tt_custom_fields_about'                          => 'Los campos personalizados le permiten agregar sus propios campos de datos a la mayoría de los módulos. Si necesita capturar la industria para los clientes, simplemente agregue un campo personalizado con la etiqueta \'Industria\' dentro de la página Clientes, convirtiéndolo en un tipo desplegable. Los campos personalizados se muestran automáticamente debajo de los campos normales.',
    'tt_recurring_invoices_about'                     => 'Las facturas periódicas no son facturas en realidad, sino plantillas para crear facturas futuras. Tienen una frecuencia de recurrencia y una próxima fecha que determinan cuándo generarán una factura en vivo. Se requiere un trabajo CRON diario o una tarea programada para que las facturas recurrentes funcionen correctamente.',
    'tt_addons_about'                                 => 'Los complementos son personalizaciones de FusionInvoice para necesidades comerciales únicas, como seguimiento de tiempo, fórmulas de precios o plantillas de facturas estilizadas. Se ofrecen a través del mercado de complementos FusionInvoice.',
    'client_center_user'                              => 'Usuario del Centro de Clientes',
    'user_type'                                       => 'Tipo de usuario',
    'custom_field'                                    => 'Campo personalizado',
    'placeholder_type_email_template'                 => 'Escriba o pegue su plantilla de correo electrónico. . .',
    'email_templates'                                 => 'Plantillas de correo electrónico',
    'payment_receipts'                                => 'Recibos de pago',
    'upcoming_payment_notices'                        => 'Próximos avisos de pago',
    'convenience_fee_for_credit_card_transactions'    => 'Tarifa de conveniencia para transacciones con tarjeta de crédito',
    'credit_card_processing_fee'                      => 'Tarifa de procesamiento de tarjeta de crédito',
    'delete_client_user_warning'                      => '<p>Eliminar un usuario cliente desactivará su capacidad para iniciar sesión en el centro de clientes.</p>',
    'use_default_mail_template'                       => 'Plantilla de correo predeterminada',
    'use_custom_mail_template'                        => 'Plantilla de correo personalizada',
    'quote_email_body'                                => 'Cuerpo del correo electrónico de la cotización',
    'overdue_invoice_email_body'                      => 'Cuerpo de correo electrónico de factura vencida',
    'credit_memo_email_body'                          => 'Cuerpo del correo electrónico de la nota de crédito',
    'payment_receipt_body'                            => 'Cuerpo del recibo de pago',
    'invoice_email_body'                              => 'Cuerpo del correo electrónico de la factura',
    'quote_custom_email_body_require'                 => 'Ingrese su plantilla de correo electrónico personalizada para el cuerpo del correo electrónico de cotización',
    'quote_custom_approve_email_body_require'         => 'Ingrese su plantilla de correo electrónico personalizada para el cuerpo del correo electrónico de aprobación de la cotización',
    'quote_reject_email_body_require'                 => 'Ingrese su plantilla de correo electrónico personalizada para el cuerpo del correo electrónico de rechazo de cotización',
    'overdue_invoice_email_body_require'              => 'Ingrese su plantilla de correo electrónico personalizada para el cuerpo del correo electrónico de la factura vencida',
    'invoice_email_body_require'                      => 'Ingrese su plantilla de correo electrónico personalizada para el cuerpo del correo electrónico de la factura',
    'credit_memo_email_body_require'                  => 'Ingrese su plantilla de correo electrónico personalizada para el cuerpo del correo electrónico de la nota de crédito',
    'payment_receipt_email_body_require'              => 'Ingrese su plantilla de correo electrónico personalizada para el cuerpo del correo electrónico del recibo de pago',
    'upcoming_payment_notice_email_body_require'      => 'Ingrese su plantilla de correo electrónico personalizada para el próximo cuerpo de correo electrónico de aviso de pago',
    'copy_text'                                       => 'Copiar texto',
    'tt_preview_template'                             => 'Plantilla de vista previa',
    'tt_view_template_code'                           => 'Ver código de plantilla',
    'dashboard_date_range'                            => 'Intervalo de fechas del panel',
    'tt_dashboard_date_range'                         => 'El rango de fechas del tablero filtra la vista para los siguientes widgets: tarjetas KPI, gráfico de ventas, actividad reciente del cliente.',
    'product_copy'                                    => 'Copia del producto',
    'open_selected_client'                            => 'Abrir cliente seleccionado',
    'save_this_client'                                => 'Guardar este cliente (no un duplicado)',
    'looks_like_duplicate'                            => 'Hmm... Esto parece un duplicado',
    'duplicate_instructions'                          => 'Si ve el cliente que deseaba en la lista, selecciónelo y ábralo. Si no, guarde el nuevo cliente.',
    'select_checkbox'                                 => 'Seleccione un cliente',
    'select_lead_source_tag'                          => 'Seleccione la fuente de clientes potenciales',
    'lead_source'                                     => 'Fuente de plomo',
    'tt_client_lead_source_tags'                      => 'Seleccione o ingrese la fuente del cliente potencial (cómo se adquirió el cliente)',
    'your_link_is_expired'                            => '¡Ups! Su enlace ha caducado.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Volver al tablero</a>.',
    'secure_link_and_expire_link_days'                => 'Enlaces de facturas públicas seguras y caducadas',
    'secure_link_expire_days'                         => 'Número de días',
    'tt_secure_link_and_expire_link_days'             => 'Al habilitar los enlaces seguros, también debe establecer la cantidad de días después de los cuales caducará el enlace de la factura. Al hacer esto, un cliente puede ver el enlace de su factura pública hasta que caduque.',
    'expire_time_period'                              => 'El campo Número de días de caducidad del enlace es obligatorio',
    'enter_days'                                      => 'Introducir días',
    'invalid_field_name'                              => 'Ingrese un nombre de campo válido',
    'lead_source_notes'                               => 'Notas de fuente de plomo',
    'important_note'                                  => 'Nota IMPORTANTE',
    'social_media_url'                                => 'URL de redes sociales',
    'general_notes'                                   => 'Notas generales',
    'payment_amount_mismatch'                         => 'Discrepancia en el monto del pago',
    'open_invoice_aging'                              => 'Antigüedad de la factura abierta',
    'tt_db_open_invoice_aging'                        => 'Antigüedad de la factura abierta',
    'current'                                         => 'Actual',
    'oneToThirty'                                     => '1-30 días',
    'thirtyOneToSixty'                                => '31-60 días',
    'sixtyOneToNinety'                                => '61-90 días',
    'ninetyOnePlus'                                   => '91 días',
    'sent_and_draft'                                  => 'Incluir facturas enviadas y borradores',
    'sent_only'                                       => 'Incluir solo facturas enviadas',
    'tt_open_ar_aging_settings'                       => 'Configuración para totales de antigüedad de factura abierta',
    'tt_client_field_settings'                        => 'Seleccione los campos que le gustaría mostrar en su vista de cliente',
    'position_change'                                 => 'Posición cambiada',
    'dynamic_width'                                   => 'Ancho dinámico',
    'full_width'                                      => 'Ancho completo',
    'save_configuration_default'                      => 'Guardar la configuración como predeterminada del sistema',
    'assign_configuration_other'                      => 'Asignar configuración a otros usuarios',
    'tt_user_tags'                                    => 'Etiquetas de usuario',
    'select_users'                                    => 'Seleccionar usuarios',
    'configuration_assigned'                          => 'Configuración asignada con éxito',
    'default_configuration_set'                       => 'Configuración predeterminada establecida con éxito',
    'current_user_id'                                 => 'ID de usuario actual',
    'tt_users_settings'                               => 'Configuración de usuarios',
    'invoice_link_expire'                             => 'El enlace público de su factura vencerá en',
    'quote_link_expire'                               => 'El enlace público de su cotización vencerá en',
    'dashboard_width'                                 => 'Se cambió la configuración de ancho de columna del tablero :widthName',
    'unmark_mailed'                                   => 'Desmarcar como enviado por correo',
    'invoice_unmark_mailed'                           => 'Desmarcar factura como enviada por correo',
    'print_mark_mailed'                               => 'Imprimir',
    'public_link'                                     => 'Enlace público',
    'tt_sales_chart_settings'                         => 'Configuración para gráfico de ventas factura/total',
    'verify_key'                                      => 'Verificación de clave de producto',
    'enter_key'                                       => 'Introduce tu clave',
    'verify'                                          => '¡Compruébalo!',
    'key_required'                                    => 'Se requiere clave de producto',
    'key_length_invalid'                              => 'Ingrese la clave de producto de 32 caracteres proporcionada en el momento de la compra.',
    'invalid_key'                                     => 'Lo sentimos, tu clave no es válida. La instalación no puede continuar.',
    'key_verified'                                    => 'Felicitaciones, su clave ha sido verificada.',
    'clear_cache'                                     => 'Limpiar cache',
    'clear_cache_confirm'                             => '¿Estás seguro de que quieres borrar la memoria caché de tu aplicación?',
    'cache_clear_success'                             => 'Caché borrado con éxito.',
    'cache_clear_error'                               => 'Verifique la configuración de su servidor para el comando PHP exec().',
    'add_new_client'                                  => 'Agregar nuevo cliente',
    'add'                                             => 'Agregar',
    'invalid_quantity_amount'                         => '¡Cantidad de cantidad no válida! Debe ser mayor que 0.',
    'api_version'                                     => 'Versión API',
    '2021_prior'                                      => '2021 y anteriores',
    '2022_later'                                      => '2022 y posteriores',
    'vendors'                                         => 'Vendedores',
    'file_not_found'                                  => ':file_name no se encuentra',
    'leave_empty_no_parent_account'                   => 'déjelo en blanco si el cliente no tiene una cuenta principal',
    'leave_empty_client_pays_invoices'                => 'dejar vacío si el cliente paga sus propias facturas',
    'modal_not_found'                                 => 'Modal no encontrado',
    'payment_delete_success'                          => 'Pago eliminado con éxito',
    'payment_delete_error'                            => 'Hubo un problema al eliminar el pago. Vuelva a intentarlo más tarde.',
    'status_change_error'                             => '¡Algo salió mal! No se modificó el estado.',
    'total_payments'                                  => 'Pagos totales',
    'licence_verification_error'                      => 'No se puede verificar su clave de licencia.',
    'line_item_discount_limit'                        => 'Las líneas de pedido no pueden tener un descuento superior al 99,99 %.',
    'date_range_report'                               => 'Intervalo de fechas (próxima fecha para ejecutar)',
    'no_client_found'                                 => 'Hmmm… no pudimos encontrar a ese cliente.',
    'tt_line_item_discount'                           => 'El descuento de un artículo de línea se puede calcular mediante un porcentaje del precio o una cantidad fija para el precio del artículo individual.',
    'functionality_not_available_on_demo'             => 'Lo sentimos, esa función no está permitida en la demostración.',
    'vat_tax_id'                                      => 'ID de IVA',
    'tt_vat_tax_id'                                   => 'Número de impuesto al valor agregado (IVA)',
    'enable_vat_tax_id'                               => '¿Habilitar ID de IVA',
    'no-attachment'                                   => 'No hay adjuntos',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Limpiar',
    'allow_edit_status_invoice'                       => 'Editar :status Factura',
    'tt_ss_allow_edit_invoices_status'                => 'Como medida de seguridad, solo se pueden editar las facturas en estado Borrador. Puede anular esto al permitir la edición de facturas Enviadas y/o Pagadas.',
    'allow_edit_invoices_status'                      => 'Permitir la edición de facturas en estado',
    'draft_and_sent'                                  => 'Borrador y enviado',
    'draft_or_sent_and_paid'                          => 'Borrador, enviado y pagado',
    'invoice_editable'                                => 'Factura Editable',
    'can_not_edit_paid_invoice'                       => 'No se puede editar una factura pagada',
    'item_category'                                   => 'Categoría de artículo',
    'itemLookups'                                     => 'Búsquedas de artículos',
    'quoteItems'                                      => 'Artículos de cotización',
    'invoiceItems'                                    => 'artículos de factura',
    'imports_disabled_in_demo.'                       => 'Las importaciones están deshabilitadas en la demostración.',
    'no_file_selected'                                => 'Ningún archivo seleccionado',
    'no_import_records'                               => 'No se encontraron registros para importar',
    'vendor_name'                                     => 'Nombre del vendedor',
    'license_key'                                     => 'Clave de licencia',
    'change_license_key'                              => 'Cambiar clave de licencia',
    'verify_and_save'                                 => 'Verificar',
    'same_key_error'                                  => 'No se detectó ningún cambio. Intente con una clave diferente',
    'trying_invalid_key'                              => 'Lo sentimos, esa clave no se pudo verificar. La clave de licencia no se cambió.',
    'key_updated'                                     => '¡Felicidades! Su clave de licencia se actualizó correctamente.',
    'invalid_date_format'                             => 'Formato de fecha no válido. Formato requerido: AAAA-MM-DD',
    'invalid_datetime_format'                         => 'Formato de fecha y hora no válido. Formato requerido: AAAA-MM-DD HH:MM:SS',
    'profile_setting'                                 => 'Configuración de perfil',
    'include_draft_invoices_unpaid_and_overdue'       => 'Incluir borradores de facturas en listas impagas y vencidas',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'Si se establece en Sí, las facturas con estado de Borrador se incluirán en listas y cálculos para facturas vencidas y no pagadas.',
    'tt_utilities_import'                             => 'Importe datos de archivos CSV a su base de datos FusionInvoice.',
    'tt_utilities_export'                             => 'Exporte datos de su base de datos FusionInvoice a varios formatos diferentes: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'Vea el archivo de registro que contiene todos los eventos de correo electrónico dentro de FusionInvoice.',
    'tt_utilities_system_log'                         => 'Vea el archivo de registro del sistema que contiene eventos del sistema de advertencia y error.',
    'tt_utilities_tag_cleanup'                        => 'Elimina etiquetas que fueron definidas, pero no utilizadas. También elimina las etiquetas duplicadas.',
    'tt_utilities_pdf_cleanup'                        => 'Elimina archivos PDF temporales.',
    'tt_utilities_recalc_invoices'                    => 'Escanea cada factura, asegurándose de que los totales coincidan con la suma de todas las partidas, teniendo en cuenta los descuentos y los impuestos. *Esto puede llevar mucho tiempo.',
    'tt_utilities_recalc_quotes'                      => 'Analiza cada cotización, asegurándose de que los totales coincidan con la suma de todas las partidas, teniendo en cuenta los descuentos y los impuestos. *Esto puede llevar mucho tiempo.',
    'tt_utilities_clear_cache'                        => 'Elimina archivos de caché temporales.',
    'tt_utilities_download_database'                  => 'Descargue un archivo de base de datos exportado a partir de sus datos activos de FusionInvoice. Cuanto más grande sea su base de datos, más tiempo llevará.',
    'tt_utilities_run_daily_tasks'                    => 'Un trabajo CRON o una tarea programada normalmente ejecuta sus tareas diarias. Esto le permite hacerlo manualmente. Genera facturas en vivo a partir de plantillas de facturas recurrentes, envía recordatorios de pago, etc.',
    'include_line_item_detail'                        => 'Incluir detalles de elementos de línea',
    'invoice_tags'                                    => 'Etiquetas de factura',
    'related_accounts'                                => 'Cuentas relacionadas',
    'not_found_related_clients'                       => 'No se han asignado cuentas de clientes relacionadas',
    'invoices_paid_for_list'                          => 'Esta cuenta de cliente paga las facturas de',
    'child_accounts_exist'                            => 'La configuración Permitir cuentas infantiles se revirtió a Sí. No se puede cambiar a No cuando existen cuentas secundarias.',
    'third_bp_accounts_exist'                         => 'La configuración de Pagador de facturas externo se revirtió a Sí. No se puede cambiar a No cuando existen cuentas relacionadas.',
    'tag_name'                                        => 'Nombre de etiqueta',
    'tag_new_name'                                    => 'Nuevo nombre de etiqueta',
    'tag_category'                                    => 'Etiqueta Categoría',
    'rename_tags'                                     => 'Renombrar etiquetas',
    'apply'                                           => 'Aplicar',
    'select_tag_category'                             => 'Seleccionar categoría de etiqueta',
    'tt_utilities_rename_tags'                        => 'Renombra etiquetas asignadas a clientes, notas, actividades de venta, etc.',
    'system_default_dashboard'                        => 'Panel predeterminado del sistema',
    'user_specific_dashboards'                        => 'Paneles de control específicos del usuario',
    'tt_default_client_type'                          => 'Tipo de cliente predeterminado',
    'default_client_type'                             => 'Tipo de cliente predeterminado',
    'invalid_user'                                    => 'Seleccione un usuario válido.',
    'create_live_invoice'                             => 'Crear factura en vivo',
    'create_live_invoice_successfully'                => 'Factura en vivo',
    'create_live_invoice_unsuccessfully'              => 'No se creó la factura en vivo',
    'live_invoice_not_generate'                       => 'No se puede generar una factura activa a partir de una Factura recurrente que tiene una Fecha de finalización de hoy o anterior, o una Fecha siguiente de más de 30 días en el futuro.',
    'data_seeder'                                     => 'Sembrador de datos',
    'select_module'                                   => 'Seleccionar módulo',
    'number_of_seed'                                  => 'Número de semillas',
    'seed_it'                                         => '¡Sembrarlo!',
    'seeds_success'                                   => 'Semillas añadidas con éxito',
    'tt_ri_generate_the_next_live_invoice'            => 'Genere la próxima factura en vivo para esta factura recurrente ahora mismo.',
    'system_log_clear_message'                        => '¿Está seguro de que desea borrar el registro del sistema? Esta acción no se puede deshacer y todos los registros anteriores se eliminarán de forma permanente.',
    'system_log_clear_successfully'                   => 'Registro del sistema borrado con éxito',
    'payment_problem'                                 => 'Ocurrió un problema durante el pago. Por favor, inténtelo de nuevo más tarde.',
    'log_detail'                                      => 'Haga clic aquí para ver el registro detallado.',
    'log_limit_message'                               => 'Archivo de registro',
    'log_download_file'                               => 'Descargar archivo',
    'log_delete_all'                                  => 'Borrar todos los archivos',
    'log_level'                                       => 'Nivel',
    'log_context'                                     => 'Contexto',
    'log_date'                                        => 'Fecha',
    'log_line_number'                                 => 'Número de línea',
    'log_content'                                     => 'Contenido',
    'addon_install_error'                             => 'Hay un problema con la instalación del complemento. Vuelva a intentarlo más tarde.',
    'addon_installed_success'                         => 'Complemento instalado con éxito.',
    'allow_edit_status_credit_memo'                   => 'Editar nota de crédito aplicada',
    'database_seeder'                                 => 'Sembradora',
    'tt_utilities_database_seeder'                    => 'Siembre su base de datos con datos de prueba utilizando clases de semillas',
    'vat_information'                                 => 'Información del IVA',
    'tt_vat_information'                              => 'Número de cuenta bancaria IBAN, BIC, correo electrónico, etc.',
    'explore_addons'                                  => 'Explorar complementos',
    'available_addons'                                => 'Complementos de FusionInvoice disponibles',
    'addon_success'                                   => 'El complemento se agregó correctamente.',
    'payment_cannot_enabled_in_demo'                  => 'Las pasarelas de pago no se pueden habilitar en la demostración',
    'confirm_approve_leave_page'                      => '¡Hay cambios no guardados en esta página! ¿Seguro que quieres salir sin guardar?',
    'leave'                                           => 'Dejar',
    'demo_date_refresh'                               => 'Los datos de la demostración se actualizarán en',
    'minutes'                                         => 'minutos',
    'minute'                                          => 'minuto',
    'seconds'                                         => 'segundos',
    'mautic-authentication-fail'                      => 'No está autorizado a acceder a este recurso. Utilice una clave secreta válida.',
    'something_went_wrong'                            => '¡Algo salió mal!',
    'month_to_date'                                   => 'Este mes hasta la fecha',
    'quarter_to_date'                                 => 'Este trimestre hasta la fecha',
    'year_to_date'                                    => 'Año hasta la fecha',
    'last_active'                                     => 'Último Activo',
    'database_seeder_stop'                            => ':name PARADA DE SEMBRADORA DE NEGOCIOS',
    'database_seeder_start'                           => ':name INICIO DE SEMBRADORA DE NEGOCIOS',
    'seeder_records_created'                          => ':total Registros creados con éxito para :modal',
    'seeder_credit_apply_invoice'                     => 'Nota de crédito Aplicar a factura',
    'seeder_quote_approve_reject'                     => 'Cotización Aprobar y Rechazar',
    'seeder_executed'                                 => '¡Seeder ejecutado exitosamente!',
    'seeder_not_executed'                             => '¡Seeder no fue ejecutado!',
    'db_to_file_system_attachments_migration'         => 'Migración de archivos adjuntos: base de datos al sistema de archivos',
    'attachment_content_count'                        => 'Estás a punto de migrar un total de',
    'attachment_repeat_content_count'                 => 'Estás a punto de migrar un total de',
    'attachment_key_invalid'                          => 'La clave del archivo adjunto no es válida',
    'stop'                                            => '¡Detener!',
    'attachment_migration_warning'                    => 'Este paso migrará los archivos adjuntos de su base de datos a su sistema de archivos. Realice una copia de seguridad completa de la base de datos antes de continuar y asegúrese de tener suficiente espacio en disco para realizar esta operación.',
    'attachment_agreement_accept'                     => 'He hecho una copia de seguridad de mi base de datos.',
    'microsoft365'                                    => 'microsoft 365',
    'office365_password'                              => 'Contraseña de Microsoft 365',
    'office365_username'                              => 'Nombre de usuario de Microsoft 365',
    'custom_date_formula_note1'                       => '<b><u>Marcadores de posición de valor predeterminado :</span></u></b> ~<br> Puede utilizar <b>hoy, mañana y ayer</b> cualquier valor predeterminado.<br>',
    'custom_date_formula_note2'                       => '<b>Para hoy + N días, use </b> \'default\': \'+7\' Esto agrega 7 días a la fecha de hoy <br><b>Para hoy - N días, use </b> \'default\': \'-7\' Esto restará 7 días a la fecha de hoy <br>',
    'mail_config_error'                               => 'No se puede enviar un correo electrónico de prueba sin el método de envío de correo electrónico definido.',
    'db_prefix_alert'                                 => 'Notamos que está utilizando un prefijo de base de datos de :prefix . FusionInvoice no admitirá prefijos de bases de datos en versiones futuras. Edite su base de datos y cambie el nombre de todas sus tablas, eliminando el prefijo, luego edite su archivo base de datos.php y establezca su valor de \'prefijo\' en vacío.',
    'db_prefix_alert_title'                           => 'El soporte para prefijos de base de datos finalizará pronto',
    'add_title_bar_shortcut'                          => 'Agregar acceso directo a la barra de título',
    'title_bar_shortcuts'                             => 'Atajos de la barra de título',
    'select_icon'                                     => 'Seleccionar icono',
    'all_payment_method'                              => 'Todos los métodos de pago',
    'about'                                           => 'Acerca de',
    'own_license'                                     => 'Licencia Propia',
    'tt_own_license'                                  => 'Licencia Propia',
    'git_branch'                                      => 'Rama actual de Git',
    'quote_email'                                     => 'Correo electrónico de cotización',
    'custom1'                                         => 'Personalizado 1',
    'custom2'                                         => 'personalizado 2',
    'custom3'                                         => 'personalizado 3',
    'default_document_template'                       => 'Plantilla de documento predeterminada',
    'default_email_template'                          => 'Plantilla de correo electrónico predeterminada',
    'sms'                                             => 'SMS',
    'pricing_formula'                                 => 'Fórmula de precios',
    'is_mobile'                                       => '¿Es móvil?',
    'default_sms_template'                            => 'Plantilla de SMS predeterminada',
    'sms_log'                                         => 'Registro de SMS',
    'two_factor_auth'                                 => 'Autenticación de dos factores',
    'enabled_mail_driver'                             => 'Por favor habilite el servicio de correo electrónico',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Código de verificación invalido',
    'otp-subject'                                     => 'Iniciar sesión OTP',
    'resend_otp_success'                              => 'Reenvío del código de verificación',
    'resend_otp_btn'                                  => 'Reenviar codigo',
    'expired_otp'                                     => 'Código de verificación expirado',
    'token_expired'                                   => 'Su token CSRF ha caducado',
    'verification_code'                               => 'Código de verificación',
    'migration'                                       => 'Migración',
    'invoice_status_change_draft_to_sent'             => 'El estado de la factura cambió de borrador a enviado',
    'default_sales_quantity'                          => 'Cantidad de ventas predeterminada',
    'lead_time'                                       => 'Promedio Plazo de entrega (días)',
    'primary_vendor_id'                               => 'Proveedor preferido',
    'all_items'                                       => 'Todos los artículos',
    'non_inventory_items'                             => 'Artículos que no están en el inventario',
    'back_ordered'                                    => 'Pedido atrás',
    'low_inventory'                                   => 'Bajo inventario',
    'high_inventory'                                  => 'Alto inventario',
    'merge_client_records'                            => 'Fusionar registros de clientes',
    'primary_merge_to_client'                         => 'Fusionarse en (mantener)',
    'surrogate_merge_from_client'                     => 'Fusionar desde (descartar)',
    'merge'                                           => 'Unir',
    'merge_action'                                    => 'Fusionar acción',
    'ignore'                                          => 'Ignorar',
    'overwrite'                                       => 'Sobrescribir',
    'add_to'                                          => 'Añadir',
    'select_merge_client'                             => 'Seleccionar para fusionar',
    'client_to_and_from_not_same'                     => 'El cliente hacia y el cliente desde deben ser diferentes.',
    'client_id_required'                              => 'El campo de selección de cliente debe ser obligatorio y único.',
    'is_merge'                                        => 'Unir',
    'record_successfully_merged'                      => 'Registro fusionado exitosamente',
    'service_ends'                                    => 'El servicio finaliza',
    'service_starts'                                  => 'Inicio del servicio',
    'explanation'                                     => 'Explicación',
    'subscription_details'                            => 'Detalles de suscripción',
    'generate_next_invoice'                           => 'Generar la próxima factura',
    'subscription'                                    => 'Suscripción',
    'of_the'                                          => 'Del',
    'on'                                              => 'En',
    'invoice_month'                                   => 'Mes de la factura',
    'invoice_year'                                    => 'Año de factura',
    'next_month'                                      => 'Próximo mes',
    'next_year'                                       => 'El próximo año',
    'day'                                             => 'Día',
    'last_date'                                       => 'Ultima cita',
    'merge_record_warning'                            => '¡Detener! La fusión de cuentas de clientes no se puede deshacer. Además de los campos que seleccionó para sobrescribir o agregar, todo el historial de transacciones del cliente de fusión se transferirá al cliente de fusión. ¿Está seguro de que desea fusionar estas cuentas de clientes?',
    'merge_child_account_warning'                     => 'El cliente Merge(From) tiene una cuenta principal con cuentas secundarias relacionadas que se reasignarán al cliente Merge(To). Asegúrese de que el cliente Merge(To) esté permitido como cuenta principal.',
    'merge_parent_account_warning'                    => 'La fusión eliminará su asociación con la cuenta principal.',
    'merge_invoices_paid_by_warning'                  => 'La fusión eliminará su asociación con la factura principal pagada por.',
    'merge_third_party_bill_payers_warning'           => '***ERR***',
    'merge_relationships_warning'                     => 'La cantidad de relaciones en el modelo Cliente ha cambiado.',
    'payment_terms'                                   => 'Términos de pago',
    'net_amount_due_in'                               => 'Monto neto adeudado en',
    'net_amount_due_by'                               => 'Monto neto adeudado por',
    'if_paid_within'                                  => 'si se paga dentro',
    'if_paid_by'                                      => 'si es pagado por',
    'th_of_next_month'                                => 'décimo del próximo mes',
    'of_next_month'                                   => 'del próximo mes',
    'down_payment'                                    => 'Depósito',
    'balance_amount_due_of'                           => 'monto del saldo adeudado en',
    'payment_split_over'                              => 'Pago dividido',
    'installments'                                    => 'cuotas',
    'days_from_invoice_date'                          => 'días desde la fecha de la factura',
    'payment'                                         => 'Pago',
    'one'                                             => 'Uno',
    'two'                                             => 'Dos',
    'three'                                           => 'Tres',
    'four'                                            => 'cuatro',
    'five'                                            => 'Cinco',
    'six'                                             => 'Seis',
    'discount_percent'                                => 'Porcentaje de descuento',
    'discount_days_simple'                            => 'Días de descuento simples',
    'discount_days_nth'                               => 'Días de descuento enésimo',
    'net_due_days'                                    => 'Días de vencimiento netos',
    'balance_due_days'                                => 'Días de vencimiento del saldo',
    'number_of_installments'                          => 'Número de plazos',
    'payment_term'                                    => 'Plazo de pago',
    'select_payment_term'                             => 'Seleccione el plazo de pago',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'El campo Porcentaje de cuotas :index es obligatorio y mayor que cero.',
        'installment_due_days_error'                  => 'Se requieren los días de vencimiento de las cuotas :index presentados',
        'discount_percent_gt_error'                   => 'El porcentaje de descuento presentado es obligatorio y mayor que cero.',
        'discount_percent_lt_error'                   => 'El porcentaje de descuento presentado es obligatorio y inferior al 100 %.',
        'down_payment_percent_lt_error'               => 'Se requiere el porcentaje del pago inicial presentado y menos del 100%.',
        'discount_percent_numeric_error'              => 'El campo Porcentaje de descuento debe ser un valor numérico y menos del 100%.',
        'down_payment_gt_error'                       => 'El pago inicial presentado es obligatorio y mayor que cero.',
        'discount_days_gt_net_days_error'             => 'El monto neto de los días de vencimiento debe ser mayor que los días de descuento.',
        'discount_days_nth_gt_net_days_error'         => 'El monto neto de los días de vencimiento debe ser mayor que el descuento de los enésimos días.',
        'installment_due_days_gt_error'               => 'Los días de vencimiento de las cuotas :index deben ser mayores que los días de vencimiento de las cuotas :preIndex.',
        'installment_percent_total_error'             => 'El porcentaje total de la cuota no es exacto. debería ser igual al 100%.',
        'installment_percent_numeric_error'           => 'El porcentaje total de la cuota no es exacto. Debería ser un valor numérico.',
        'term_discount'                               => 'Descuento por plazo',
        'installment_due_days_gt_zero_error'          => 'Los días de vencimiento de la cuota :index deben ser mayores o iguales a cero.',
        'net_due_days_error'                          => 'El monto neto de los días de vencimiento debe ser mayor que cero y debe presentarse.',
        'discount_days_simple_error'                  => 'Los días de descuento simples deben ser mayores que cero y deben presentarse.',
        'discount_days_nth_error'                     => 'El descuento enésimo día debe ser mayor que cero y debe presentarse.',
        'balance_due_days_error'                      => 'Los días de vencimiento del saldo deben ser mayores que cero y deben presentarse.',
        'status_error'                                => 'Lo sentimos, el estado no ha cambiado debido al término utilizado en la factura.',
        'down_payment_type_invoice_description_error' => 'El token de descripción de factura ingresado no coincide con su tipo de pago inicial.',
        'down_payment_type_quote_description_error'   => 'El token de descripción de cotización ingresado no coincide con su tipo de pago inicial.',
    ],
    'quotes_delete_error'                             => 'Error de eliminación de cotizaciones',
    'for'                                             => 'Para',
    'production'                                      => 'Producción',
    'access_token'                                    => 'Token de acceso',
    'application_id'                                  => 'ID de aplicación',
    'location_id'                                     => 'Identificación de ubicación',
    'fi_config_check'                                 => 'Verificación de requisitos previos',
    'requirement'                                     => 'Requisito',
    'required'                                        => 'Requerido',
    'actual'                                          => 'Actual',
    'result'                                          => 'Resultado',
    'db_prefix_setup_alert'                           => 'Su base de datos FusionInvoice utiliza prefijos DB. La compatibilidad con prefijos de base de datos finalizó con la versión 2023-3.0. Para continuar actualizando a esta y futuras versiones, es necesario eliminar los prefijos de base de datos. Puede hacer esto cambiando el nombre de todas las tablas en su base de datos y eliminando el prefijo y también configurando el valor \'prefijo\' => \'\', en su archivo base de datos.php.',
    'open_tasks'                                      => 'Tareas abiertas',
    'closed_tasks'                                    => 'Tareas cerradas',
    'select_status'                                   => 'Seleccionar estado',
    'net_amount_due_invoice'                          => 'Importe neto adeudado en :days días.',
    'days_add_in_current_date'                        => 'La fecha actual, a partir de <span class="text-blue">:date</span> , y la fecha de vencimiento, se considerarán como <span class="text-blue">:date</span>  <span class="text-danger">más</span> <span class="text-blue">el número de días</span>.',
    'terms'                                           => 'Términos',
    'quote_rejecting_error'                           => 'La factura # :invoice_number se creó el :invoice_date a partir de la aprobación de esta cotización. Debe eliminar o cancelar esta factura antes de rechazar esta cotización.',
    'resend_record_warning'                           => '¿Reenviar este correo electrónico ahora?',
    'resend_email'                                    => 'Reenviar email',
    'requirement_check_fail'                          => 'Antes de que la instalación pueda continuar, debe corregir las fallas que se muestran arriba.',
    'failed'                                          => 'Fallido',
    'subscriptions'                                   => 'Suscripciones',
    'tt_explanation'                                  => 'Ingrese una descripción para el servicio con marcadores de fecha opcionales. Puede utilizar los siguientes tokens para insertar dinámicamente fechas de inicio y finalización del servicio:{{service_starts_on}} y {{service_ends_on}}. Estas serán reemplazadas por las fechas reales de inicio y finalización cuando se muestre el contenido.',
    'tt_ss_invoices_default_payment_terms'            => 'Condiciones de pago predeterminadas de la factura',
    'invoices_default_terms'                          => 'Términos predeterminados de facturas',
    'net_amount_due_in_n_days'                        => 'Importe neto adeudado en N días',
    'last_day'                                        => 'Último día',
    'down_payment_payment_term1'                      => 'pago inicial de',
    'down_payment_payment_term2'                      => 'se requiere.  El saldo se debe pagar en',
    '1_type'                                          => 'Una factura creada hoy vencerá en <span class="text-primary">#N</span> días',
    '2_type'                                          => 'Una factura creada hoy permitirá un descuento si se paga antes del <span class="text-primary">#date</span> ; de lo contrario, el monto total deberá pagarse dentro de <span class="text-primary">#N</span>  días.',
    '3_type'                                          => 'Una factura creada hoy permitirá un descuento si se paga antes del <span class="text-primary">#date</span>  . El monto neto vence dentro de <span class="text-primary">#N</span>  días',
    '4_type'                                          => 'Una factura creada hoy requerirá un pago inicial de <span class="text-primary">#amount</span>  . El saldo restante deberá pagarse dentro de <span class="text-primary">#N</span>  días',
    '5_type'                                          => '<p><span class="text-danger">*</span> <strong>Una factura creada hoy y dividida en <span class="text-primary">#months</span> #installment</span></strong></p> ~',
    '5_1_type'                                        => '<p>Pago <span class="text-primary text-bold">#installmentnumber .</span> <span class="text-primary">#percent%</span> Vencimiento <span class="text-primary">#date</span></p>',
    'installment'                                     => 'entrega',
    'apply_payment_terms'                             => 'Aplicar términos de pago monto de descuento',
    'payable_amount'                                  => 'Monto final a pagar',
    'payable_amount_lt_error'                         => 'El monto final a pagar debe ser menor que el saldo de la factura.',
    'payment_term_type_4_amount'                      => 'Pago parcial de :amount aceptada',
    'net_terms'                                       => 'términos netos',
    'proforma_invoice_default'                        => 'Predeterminado de factura proforma',
    'expense_vendor'                                  => 'Proveedor de gastos',
    'expense_vendor_deleted'                          => 'Se eliminó el proveedor de gastos',
    'expense_vendor_already_used'                     => 'No puede eliminar un proveedor que tenga entradas de gastos relacionados.',
    'total_must_be_gt_zero'                           => 'El total de :modal_name debe ser mayor que cero.',
    'payment_failed'                                  => 'El pago falló con: error',
    'xss_validation'                                  => 'El campo :attribute contiene etiquetas que podrían exponer una vulnerabilidad XSS',
    'support_desk'                                    => 'Mesa de apoyo',
    'choose_file'                                     => 'Elija el archivo',
    'supportTicket'                                   => 'Mesa de apoyo',
    'create_support_ticket'                           => 'Crear ticket de soporte',
    'supportTicket_inbox_view'                        => 'Mesa de apoyo',
    'support_ticket'                                  => 'Boleto de soporte',
    'ticket_number'                                   => 'Numero de ticket',
    'revision'                                        => 'Revisión',
    'revisions'                                       => 'Revisiones',
    'recurring_invoices'                              => 'Facturas recurrentes',
    'message'                                         => 'Mensaje',
    'custom_img'                                      => 'Imagen personalizada',
    'please_fill_some_data'                           => 'Por favor complete los datos requeridos en el nuevo artículo.',
    'assigned'                                        => 'Asignado',
    'add_ons_will_be_disabled'                        => 'LOS SIGUIENTES COMPLEMENTOS ESTARÁN DESHABILITADOS:',
    'add_ons_will_be_disabled_msg'                    => 'Todos los complementos se desactivan automáticamente durante una actualización principal de FusionInvoice. Una vez finalizada esta actualización, asegúrese de descargar los archivos zip complementarios adecuados e instalarlos. Una vez que haya hecho eso, puede volver a habilitarlos desde el menú Configuración del sistema, Personalizaciones, Complementos y seleccionando [Instalar].',
    'price_not_valid'                                 => 'El precio debe ser mayor que cero.',
    'free_space'                                      => 'Espacio libre',
    'expense_type'                                    => 'Tipo de gasto',
    'standard_expense'                                => 'Gasto estándar',
    'expense_with_deductible_tax'                     => 'Gasto Con Impuesto Deducible',
    'remittance_to_tax_authority'                     => 'Remesa a la autoridad tributaria',
    'tax_paid'                                        => 'Impuesto pagado',
    'tax_detail'                                      => 'Detalle de impuestos',
    'select_expense_type'                             => 'Seleccionar tipo de gasto',
    'taxes_paid_on_expenses_or_remitted'              => 'Impuestos pagados sobre gastos o remitidos',
    'tax_name'                                        => 'Nombre del impuesto',
    'last_activity'                                   => 'Última actividad',
    'select_default_company_profile'                  => 'Seleccione su perfil de empresa predeterminado',
    'mn_sales_tax'                                    => 'Impuesto sobre las ventas de Minnesota',
    'taxes_collected_on_sales'                        => 'Impuestos recaudados sobre las ventas',
    'vatgst_tax_note'                                 => 'Sí calcula el impuesto como incluido en el total del artículo. No se agregará el impuesto al total del artículo.',
    'tt_vatgst_tax'                                   => 'Para este ejemplo, asumiremos una tasa impositiva del 5% y un precio de artículo de $100. Configurar Habilitar IVA/GST en Sí generará una factura total de $100, con el monto del artículo ajustado a $95,24 y un monto de impuestos de $4,76. Configurar el IVA/GST en No generará una factura total de $105, con un precio de artículo de $100 y un impuesto de $5.',
    'level_of_detail'                                 => 'Nivel de detalle',
    'tax_report'                                      => 'Informe de impuestos',
    'detail'                                          => 'Detalle',
    'totals'                                          => 'Totales',
    'totals_with_dots'                                => 'Totales. . .',
    'yes_all'                                         => 'Si todo)',
    'invoices_only'                                   => 'Solo facturas',
    'payment_receipts_only'                           => 'Solo recibos de pago',
    'role'                                            => 'Role',
    'previous_email'                                  => 'Email anterior',
    'web_store_user_id'                               => 'ID de usuario de la tienda web: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Monto neto adeudado antes del <span class="text-info">#LASTDATE</span>',
        '2_type'       => 'Se puede obtener un descuento del #DISCOUNTPERCENT % si se paga antes del <span class="text-info">#DISCOUNTDATE</span> ;</span> de lo contrario, el monto neto vence antes del <span class="text-info">#LASTDATE</span> .',
        '3_type'       => 'Se puede obtener un descuento del #DISCOUNTPERCENT % si se paga antes del <span class="text-info">#DISCOUNTDATE</span> ;</span> de lo contrario, el monto neto vence antes del <span class="text-info">#LASTDATE</span> .',
        '4_type'       => 'Un pago inicial de <span class="text-info">#DOWNPAYMENT</span>  está en #INVOICEDATE . El saldo vence antes del <span class="text-info">#LASTDATE</span> .',
        '5_type'       => '<p class="mt-2 mb-1">Los pagos se pueden dividir en <span class="text-info">#NUMBEROFINSTALLMENTS</span> cuotas</p>',
        '5_1_type'     => '<li>Pago <span class="text-info">#PERCENT %</span> adeudado <span class="text-info">#LASTDATE</span></li>',
        '3_type_error' => '<span class="text-danger">El próximo mes tiene un total de #N días, así que ingrese un valor entre 1 y #N para el descuento de los días del próximo mes.</span>',
    ],
    'payment_term_not_selected'                       => 'Plazo de pago no seleccionado',
    'confirm'                                         => 'Confirmar',
    'create_live_invoice_now'                         => '¿Crear factura en vivo ahora?',
    'create_live_invoice_warn_message'                => '<p class="m-0">Una suscripción es como una plantilla de factura que se utiliza para crear facturas activas con una frecuencia determinada.</p><p class="m-0"> Normalmente, un trabajo CRON o una tarea programada está configurado para ejecutarse una vez al día y es responsable de verificar las facturas activas que deben crearse, según el campo de fecha Generar próxima factura de la suscripción.  Si ese valor de fecha es hoy o antes de hoy, se crea automáticamente una factura activa.</p><p class="m-0"> Esta opción le permite crear manualmente la factura activa desde la suscripción, sin pasar por el método automatizado. . ¿Le gustaría crear la factura en vivo ahora?</p>',
    'contact'                                         => 'Contacto',
    'invoice_month_plus_one'                          => 'Mes de factura +1',
    'invoice_month_plus_two'                          => 'Mes de factura +2',
    'invoice_month_plus_three'                        => 'Mes de factura +3',
    'inbound_email'                                   => 'Correo electrónico entrante',
    'outbound_email'                                  => 'Correo electrónico saliente',
    'email_signature'                                 => 'Firma de email',
    'mail_credential_error'                           => 'Configuración de correo electrónico no válida. Por favor verifique su configuración e inténtelo nuevamente. <strong>( Configuración <i class="fa fa-arrow-alt-circle-right"> </i> Configuración del sistema <i class="fa fa-arrow-alt-circle-right"> </i> Correo electrónico )</strong>',
    'tt_generate_next_invoice'                        => 'La fecha en la que se creará automáticamente la próxima factura activa a partir de esta suscripción.',
    'tt_stop_date'                                    => 'El umbral de fecha después del cual no se generarán automáticamente más facturas activas para esta suscripción. Deje este campo vacío para una suscripción que debería continuar para siempre.',
    'description_template'                            => 'Plantilla de descripción',
    't_1_description'                                 => 'El pago total vence antes del #LASTDATE.',
    't_2_description'                                 => 'Obtenga un #DISCOUNTPERCENT % de descuento si paga antes del #DISCOUNTDATE, de lo contrario, pague el monto total de la factura antes del #LASTDATE.',
    't_3_description'                                 => 'Obtenga un #DISCOUNTPERCENT % de descuento si paga antes del #DISCOUNTDATE, de lo contrario, pague el monto total de la factura antes del #LASTDATE.',
    't_4_description'                                 => 'Un pago inicial de #DOWNPAYMENT vence el #INVOICEDATE, el saldo de la factura vence antes del #LASTDATE',
    't_4_1_description'                               => 'Un pago inicial de #DOWNPAYMENTPERCENT vence el #INVOICEDATE, el saldo de la factura vence antes del #LASTDATE',
    't_5_description'                                 => 'Los pagos deben realizarse en #NUMBEROFINSTALLMENTS cuotas iguales',
    't_5_type_description'                            => 'El pago #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT vence el #LASTDATE',
    'tokens_allowed'                                  => 'Fichas permitidas',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'El texto evaluado de la plantilla es la descripción de los términos que se muestra en documentos como facturas, cotizaciones, etc.',
    'cc_mail'                                         => 'Correo electrónico',
    'assigned_inv_sent_or_paid'                       => '*Hay facturas pagadas o enviadas que tienen asignado este plazo de pago. No se permite cambiar los detalles del \'Tipo\'.',
    'exclude_paid_invoices'                           => 'Excluir facturas pagadas',
    'phone_number_numeric_error'                      => 'El número de teléfono debe ser un número.',
    'phone_num_same_country_code_error'               => 'Asegúrese de que su número de teléfono tenga el formato adecuado. Parece que se ha introducido empezando por el código de país, lo cual no está permitido.',
    'tt_expense_amount'                               => 'Ingrese el monto total del gasto, incluidos los impuestos. Este campo no está disponible al enviar un pago de impuestos a una autoridad fiscal.',
    'tt_expense_tax_paid_deductible'                  => 'Ingrese el monto del impuesto que se pagó con este gasto. Este valor se deducirá de su obligación tributaria general en los informes Resumen de impuestos y Detalles de impuestos.',
    'tt_expense_tax_paid_remittance'                  => 'Ingrese el monto del impuesto que se remitió a la autoridad fiscal. Esto se utiliza para registrar los pagos realizados por los impuestos recaudados en sus facturas pagadas.',
    'tt_expense_client'                               => 'Si este gasto se realizó únicamente en nombre de un cliente y desea facturarlo, seleccione aquí el cliente relacionado.',
    'base_currency_not_deleted'                       => 'La moneda base no se puede eliminar',
    'used_currency_modal_error'                       => 'Moneda ya utilizada en el módulo :modal_names.',
    'addon_uninstall_success'                         => 'Complemento desinstalado exitosamente',
    'original'                                        => 'Original',
    'revision_current'                                => 'Revisión (actual)',
    'number'                                          => 'Número',
    'copy_process_error'                              => '¡Ups! Parece que hubo un problema durante el proceso de copia. Por favor, inténtelo de nuevo más tarde.',
    'tt_captcha_image'                                => 'Imagen CAPTCHA',
    'reload_page'                                     => 'Por favor recarga la página',
    'discount_limit'                                  => 'El descuento debe ser inferior al 99,99%.',
    'tooltip'                                         => 'Información sobre herramientas',
    'authorization_error'                             => 'No está autorizado a realizar esta operación.',
    'reset_to_default'                                => 'Restablecen a los predeterminados',
    'reset_to_default_warning'                        => '<p>Esto restablecerá el Asunto y el Cuerpo al valor predeterminado para :model . ¿Continuar?</p>',
    'reset_default_mail_template'                     => 'La plantilla de correo predeterminada para :model se ha restablecido correctamente.',
    'overdue_invoice'                                 => 'Factura vencida',
    'total_cannot_be_lt_zero'                         => 'El total :modal_name no puede ser menor que cero.',
    'addons_disabled_during_setup'                    => 'Durante el proceso de actualización se deshabilitaron los siguientes complementos: :addons . No olvide habilitarlos ahora que se completó la actualización.',
    'allow_payments_on_quotes'                        => 'Permitir pagos sobre cotizaciones S/N',
    'allow_payments_on_quote'                         => 'Permitir pago S/N',
    'tt_ss_quotes_is_payable'                         => 'Si está habilitado, tras la aprobación de la cotización, aparecerá un botón Pagar ahora en la vista del enlace público de la cotización. Se creará una factura automáticamente y el pago se aplicará a la factura.',
    'pay_with_square'                                 => 'Pague con Square',
    'validation_mess_for_is_payable_quote'            => 'La configuración para Convertir automáticamente cotización en factura cuando el cliente lo apruebe es obligatoria cuando Permitir pagos de cotizaciones está configurado en "Sí".',
    'client_requirement_msg'                          => 'Cree un cliente antes de agregar :seed_name',
    'quote_add_items'                                 => 'Artículos de cotización requeridos y estado no cancelado',
    'invalid_quote_id'                                => 'ID de cotización no válido',
    'information_header'                              => '¡Felicitaciones, está a punto de ahorrar algo de dinero!',
    'convenience_charge'                              => 'Cargo de conveniencia',
    'credit_card_fee_message'                         => 'Se aplicará un cargo por conveniencia de tarjeta de crédito de :charge en esta transacción.',
    'info_payment_term_type_2'                        => 'Aunque el saldo de su factura es :ORIGINAL_AMOUNT, es elegible para un descuento en las condiciones de pago del :DISCOUNT_PERCENT %, lo que reducirá el monto de su pago a :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Aunque el saldo de su factura es :ORIGINAL_AMOUNT, es elegible para un descuento en las condiciones de pago del :DISCOUNT_PERCENT %, lo que reducirá el monto de su pago a :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Aunque el saldo de su factura es :ORIGINAL_AMOUNT, usted es elegible para las condiciones de pago para realizar un pago inicial :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Aunque el saldo de su factura es :ORIGINAL_AMOUNT, usted es elegible para las condiciones de pago para realizar un pago a plazos :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Las condiciones de pago deben eliminarse del :modal antes de eliminarlas.',
    'default_payment_term_warn'                       => '*Solo puedes cambiar el Nombre y los Días de Vencimiento Neto, para las <strong>Términos de Pago Predeterminados del Sistema</strong>.',
    'quote_rejected_not_payable'                      => 'La cotización # :number ha sido rechazada y no es pagadera debido a su estado.',
    'could_not_delete'                                => 'No se pudo eliminar',
    'convenience_charges_calculation_fail'            => 'Error: el cálculo de los cargos por conveniencia falló durante la migración. Por favor, inténtelo de nuevo más tarde.',
    'sign_in_welcome_message'                         => 'ðŸš€ ¡Felicitaciones! ¡Su FusionInvoice se instaló exitosamente! ðŸš€',
    'sign_in_welcome_message_1'                       => '<p>Su FusionInvoice se actualizó exitosamente de la versión :old_version a la versión :new_version .</p><p> Para obtener una descripción detallada de todas las nuevas funciones y mejoras, consulte nuestras <a href="https://www~ .fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Notas de la versión</a> .</p>',
    'sign_in_welcome_message_2'                       => '<p>Gracias por elegir FusionInvoice. Su confianza, apoyo y comentarios impulsan nuestra innovación.</p><p class="m-0 text-bold">¡Facturación feliz!</p><p class="text-bold">El equipo de FusionInvoice</p >',
    'tt_gen_skin_user_profile'                        => 'Cambiar este valor establece el valor predeterminado del sistema SÓLO para nuevos usuarios. Los usuarios pueden anular esta configuración a través de la configuración de su perfil de usuario.',
    'description_template_invoice'                    => 'Plantilla de descripción: factura',
    'description_template_quote'                      => 'Plantilla de descripción: cotización',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'El pago total vence dentro de #NETDAYS a partir de la fecha de la factura.',
    't_2_description_for_quote'                       => 'Obtenga un #DISCOUNTPERCENT % de descuento si paga dentro de #DISCOUNTDAYS, de lo contrario, pague el monto total de la cotización antes de #NETDAYS.',
    't_3_description_for_quote'                       => 'Obtenga un #DISCOUNTPERCENT % de descuento si paga antes del #NTHDAY del mes siguiente; de lo contrario, pague el monto total de la factura dentro de #NETDAYS días.',
    't_4_description_for_quote'                       => 'Un pago inicial de #DOWNPAYMENT vence en la fecha de la factura, el saldo restante vence dentro de #NETDAYS días',
    't_4_1_description_for_quote'                     => 'Un pago inicial de #DOWNPAYMENTPERCENT vence en la fecha de la factura, el saldo restante vence dentro de #NETDAYS días',
    't_5_description_for_quote'                       => 'Los pagos deben realizarse en #NUMBEROFINSTALLMENTS cuotas iguales',
    't_5_type_description_for_quote'                  => 'El pago #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT vence #INSTALLMENTDUEDAYS días a partir de la fecha de la factura',
    'default_term'                                    => 'Término predeterminado',
    'proceed_to_payment'                              => 'Proceder al pago',
    'version_upgraded'                                => 'Su solicitud está actualizada.',
    'term_amount_gt_payment_amount'                   => 'El monto debe ser mayor que el monto del descuento de las condiciones de pago',
    'payment_term_not_eligible_warning'               => 'El descuento por plazo de pago está disponible solo para pagos completos. Desafortunadamente, no calificas para ello.',
    'processed_by_user'                               => '<strong>Procesado por:</strong> :user_initial ( :paid_at)',
    'payment_method_application'                      => '<strong>Método de pago:</strong> :method',
    'all_methods'                                     => 'Todos los métodos',
    'this_payment'                                    => 'Este pago',
    'previous_balance'                                => 'Balance anterior',
    'payment_applied_with_remaining_balance'          => '<p><strong>Su pago de :amount se ha aplicado parcialmente. :remaining_balance sigue pendiente.</strong></p>',
    'pre_payment_received'                            => '<p><strong>Se recibió un prepago de :amount para facturas futuras el :date .</strong></p>',
    'payment_full_applied'                            => '<p><strong>Su pago :amount se ha aplicado en su totalidad.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Pago <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;"> :formatted_number</span> ~ Detalles:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>El pago de :paid se ha aplicado a la factura :invoice_number el :date</span> ~',
    'payment_full_applied_on_inv_with_ptd'            => '<p>El pago de :paid, menos :payment_terms_discount descuento por plazo de pago, se aplicó a la factura :invoice_number el :date</span> ~',
    'payment_full_applied_on_inv_with_cc'             => '<p>El pago de :paid, más :convenience_charges cargos de conveniencia, se aplicó a la factura :invoice_number el :date</span> ~',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>El pago de :paid, más :convenience_charges cargos de conveniencia y menos :payment_terms_discount descuento por plazo de pago, se aplicó a la factura :invoice_number el :date</span> ~',
    'payment_remaining_balance_mail_message'          => '<p>El saldo restante de Factura :invoice_number es :remaining_balance</span> ~',
    'unpaid_invoices'                                 => 'Facturas impagas',
    'include'                                         => 'Incluir',
    'exclude'                                         => 'Excluir',
    'invoice_with_no_tax'                             => 'Facturas sin impuestos',
    'tax_total'                                       => 'Total de impuestos',
];

return TranslationOverride::override(__FILE__, $translations);
