<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * -mw- For automated language conversions, all tokens and phrases must be delimited with single quotes, not double quotes.
 *      Ie.  'example_text'   => 'Example Text'
 */

use FI\Support\TranslationOverride;

$translations = [
    'a4'                                              => 'A4',
    'account_setup'                                   => 'Account Setup',
    'active'                                          => 'Active',
    'activity'                                        => 'Activity',
    'activity_invoice_paid'                           => 'Invoice <a href=":link">#:number</a> was paid.',
    'activity_invoice_viewed'                         => 'Invoice <a href=":link">#:number</a> was viewed.',
    'activity_quote_approved'                         => 'Quote <a href=":link">#:number</a> was approved.',
    'activity_quote_rejected'                         => 'Quote <a href=":link">#:number</a> was rejected.',
    'activity_quote_viewed'                           => 'Quote <a href=":link">#:number</a> was viewed.',
    'add_item'                                        => 'Add Item',
    'add_line_item_to_invoice'                        => 'Add line item to invoice',
    'add_note'                                        => 'Add Note',
    'additional'                                      => 'Additional',
    'addon'                                           => 'Add-on',
    'addons'                                          => 'Add-ons',
    'address'                                         => 'Address',
    'address_format'                                  => 'Address Format',
    'after_amount'                                    => 'After Amount',
    'all'                                             => 'All',
    'all_categories'                                  => 'All Categories',
    'all_statuses'                                    => 'All Statuses',
    'all_time'                                        => 'All Time',
    'all_vendors'                                     => 'All Vendors',
    'allow_login'                                     => 'Allow Login',
    'always_attach_pdf'                               => 'Always Attach PDF',
    'always_bcc'                                      => 'Always BCC Address',
    'always_cc'                                       => 'Always CC Address',
    'amount'                                          => 'Amount',
    'api_public_key'                                  => 'API Public Key',
    'api_secret_key'                                  => 'API Secret Key',
    'approve'                                         => 'Approve',
    'approved'                                        => 'Approved',
    'approved_quotes'                                 => 'Approved Quotes',
    'attach_files'                                    => 'Attach Files',
    'attach_pdf'                                      => 'Attach PDF',
    'attachment'                                      => 'Attachment',
    'attachments'                                     => 'Attachments',
    'author'                                          => 'Author',
    'automatic'                                       => 'Automatic',
    'automatic_email_on_recur'                        => 'Automatically Email Subscriptions',
    'automatic_email_payment_receipts'                => 'Automatically Email Payment Receipts',
    'available_fields'                                => 'Available Fields',
    'back'                                            => 'Back',
    'back_to_invoice'                                 => 'Back to Invoice',
    'back_to_quote'                                   => 'Back to Quote',
    'balance'                                         => 'Balance',
    'base_currency'                                   => 'Base Currency',
    'bcc'                                             => 'BCC',
    'before_amount'                                   => 'Before Amount',
    'bill_this_expense'                               => 'Bill This Expense',
    'bill_to'                                         => 'Bill To',
    'billable'                                        => 'Billable',
    'billed'                                          => 'Billed',
    'billing_address'                                 => 'Billing Address',
    'billing_city'                                    => 'Billing City',
    'billing_name'                                    => 'Billing Name',
    'billing_state'                                   => 'Billing State',
    'billing_zip'                                     => 'Billing Zip',
    'binary_path'                                     => 'Binary Path',
    'body'                                            => 'Body',
    'cancel'                                          => 'Cancel',
    'canceled'                                        => 'Canceled',
    'card_number'                                     => 'Card Number',
    'cash'                                            => 'Cash',
    'category'                                        => 'Category',
    'cc'                                              => 'CC',
    'change'                                          => 'Change',
    'change_client'                                   => 'Change Client',
    'check_for_update'                                => 'Check for Update',
    'city'                                            => 'City',
    'clear_keys'                                      => 'Clear Keys',
    'client'                                          => 'Client',
    'client_form'                                     => 'Client Form',
    'client_name'                                     => 'Client Name',
    'client_not_found'                                => 'Client not found',
    'client_statement'                                => 'Client Statement',
    'client_unique_name_option_1'                     => 'Only When the Client Name is Not Unique',
    'client_unique_name_option_2'                     => 'Always Display',
    'client_visibility'                               => 'Client Visibility',
    'clients'                                         => 'Clients',
    'code'                                            => 'Code',
    'column_name'                                     => 'Column Name',
    'column_width'                                    => 'Column Width',
    'company'                                         => 'Company',
    'complete'                                        => 'Complete',
    'complete_upgrade'                                => 'Complete Upgrade',
    'compound'                                        => 'Compound',
    'compound_tax_note'                               => 'Compound tax rates must be applied to an item as tax 2 to have the desired effect.',
    'confirm_approve_quote'                           => 'Are you sure you wish to approve this quote?',
    'confirm_reject_quote'                            => 'Are you sure you wish to reject this quote?',
    'continue'                                        => 'Continue',
    'convert_quote_option1'                           => 'The invoice should retain the terms from the quote',
    'convert_quote_option2'                           => 'The invoice should use the default invoice terms',
    'convert_quote_setting'                           => 'When a Quote Is Converted to An Invoice',
    'convert_quote_when_approved'                     => 'Automatically Convert Quote to Invoice When Client Approves',
    'converted_from_quote'                            => 'Converted from Quote',
    'converted_to_invoice'                            => 'Converted to Invoice',
    'country'                                         => 'Country',
    'create_invoice'                                  => 'Create Invoice',
    'create_quote'                                    => 'Create Quote',
    'created'                                         => 'Created',
    'credit_card'                                     => 'Credit Card',
    'currencies'                                      => 'Currencies',
    'currency'                                        => 'Currency',
    'currency_form'                                   => 'Currency Form',
    'currency_symbol'                                 => 'Currency Symbol',
    'currency_symbol_placement'                       => 'Currency Symbol Placement',
    'custom_date_range'                               => 'Custom Date Range',
    'custom_field_form'                               => 'Custom Field Form',
    'custom_fields'                                   => 'Custom Fields',
    'cvc'                                             => 'CVC',
    'dashboard'                                       => 'Dashboard',
    'dashboard_totals_option'                         => 'Totals on the Dashboard Should Include',
    'database_not_configured'                         => 'It appears app/config/database.php has not yet been configured.',
    'database_setup'                                  => 'Database Setup',
    'date'                                            => 'Date',
    'date_format'                                     => 'Date Format',
    'days'                                            => 'Days',
    'decimal_point'                                   => 'Decimal Point',
    'default_currency'                                => 'Default Currency',
    'default_footer'                                  => 'Default Footer',
    'default_group'                                   => 'Default Group',
    'default_invoice_email_body'                      => 'Default Invoice Email Body',
    'default_invoice_template'                        => 'Default Invoice Template',
    'default_item_tax_2_rate'                         => 'Default Item Tax 2 Rate',
    'default_item_tax_rate'                           => 'Default Item Tax Rate',
    'default_overdue_invoice_email_body'              => 'Default Overdue Invoice Email Body',
    'default_payment_receipt_body'                    => 'Default Payment Receipt Body',
    'default_quote_email_body'                        => 'Default Quote Email Body',
    'default_quote_template'                          => 'Default Quote Template',
    'default_terms'                                   => 'Default Terms',
    'delete'                                          => 'Delete',
    'delete_client_warning'                           => '<p>STOP! If you delete this client you will also delete ALL of their transaction history, including invoices, quotes and payments.</p><p>Are you sure you want to permanently delete this client?</p>',
    'delete_record_warning'                           => 'Are you sure you wish to delete this record?',
    'description'                                     => 'Description',
    'details'                                         => 'Details',
    'disabled'                                        => 'Disabled',
    'discount'                                        => 'Discount',
    'display_client_unique_name'                      => 'Display Client Unique Name',
    'display_do_not_require'                          => 'Display but do not require',
    'display_order'                                   => 'Display Order',
    'display_profile_image'                           => 'Display Profile Image',
    'do_not_add_line_item_to_invoice'                 => 'Do not add line item to invoice',
    'do_not_display'                                  => 'Do not display',
    'documentation'                                   => 'Documentation',
    'download'                                        => 'Download',
    'draft'                                           => 'Draft',
    'draft_invoices'                                  => 'Draft Invoices',
    'draft_quotes'                                    => 'Draft Quotes',
    'dropdown'                                        => 'Dropdown',
    'due'                                             => 'Due',
    'due_date'                                        => 'Due Date',
    'edit'                                            => 'Edit',
    'edit_client'                                     => 'Edit Client',
    'email'                                           => 'Email',
    'email_address'                                   => 'Email Address',
    'email_invoice'                                   => 'Email Invoice',
    'email_payment_receipt'                           => 'Email Payment Receipt',
    'email_quote'                                     => 'Email Quote',
    'email_send_method'                               => 'Email Sending Method',
    'email_send_method_phpmail'                       => 'PHP Mail',
    'email_send_method_sendmail'                      => 'Sendmail',
    'email_send_method_sendgrid'                      => 'SendGrid API',
    'email_send_method_smtp'                          => 'SMTP',
    'enabled'                                         => 'Enabled',
    'enter_payment'                                   => 'Enter Payment',
    'error'                                           => 'Error',
    'every'                                           => 'Every',
    'exchange_rate'                                   => 'Exchange Rate',
    'exchange_rate_mode'                              => 'Exchange Rate Mode',
    'expense_form'                                    => 'Expense Form',
    'expenses'                                        => 'Expenses',
    'expiration'                                      => 'Expiration',
    'expires'                                         => 'Expires',
    'export_clients'                                  => 'Export Clients',
    'export_data'                                     => 'Export Data',
    'export_expenses'                                 => 'Export Expenses',
    'export_invoice_items'                            => 'Export Invoice Items',
    'export_invoices'                                 => 'Export Invoices',
    'export_payments'                                 => 'Export Payments',
    'export_quote_items'                              => 'Export Quote Items',
    'export_quotes'                                   => 'Export Quotes',
    'fax'                                             => 'Fax',
    'fax_number'                                      => 'Fax Number',
    'field_label'                                     => 'Field Label',
    'field_meta'                                      => 'Field Meta',
    'field_meta_description'                          => 'Use the Field Meta field only if the Field Type is a dropdown. To specify dropdown values, enter a list of dropdown values separated by commas.',
    'field_type'                                      => 'Field Type',
    'footer'                                          => 'Footer',
    'format'                                          => 'Format',
    'frequency'                                       => 'Frequency',
    'from'                                            => 'From',
    'from_date'                                       => 'From Date',
    'general'                                         => 'General',
    'generate_keys'                                   => 'Generate Keys',
    'group'                                           => 'Group',
    'group_form'                                      => 'Group Form',
    'groups'                                          => 'Groups',
    'header_title_text'                               => 'Header Title Text',
    'help'                                            => 'Help',
    'help_currency_code'                              => 'The currency code, e.g. "USD".',
    'help_currency_name'                              => 'The currency name, e.g. "US Dollar".',
    'help_currency_symbol'                            => 'The currency symbol, e.g. "$".',
    'help_currency_symbol_placement'                  => 'Where to place the currency symbol.',
    'help_text_client_name'                           => 'This value may be the name of a company or a person and will appear on quotes and invoices. This value does not need to be unique.',
    'help_text_client_password'                       => 'Leave this field blank unless creating or resetting a password.',
    'help_text_client_unique_name'                    => 'When one or more clients in the system share the same name, a unique name must be provided to distinguish between them. This value will not appear on quotes or invoices.',
    'i_accept'                                        => 'I Accept',
    'import_data'                                     => 'Import Data',
    'inactive'                                        => 'Inactive',
    'income'                                          => 'Income',
    'install'                                         => 'Install',
    'installation_complete'                           => 'Installation Complete',
    'installing_please_wait'                          => 'Installing, please wait...',
    'invalid_credentials'                             => 'Invalid Credentials',
    'invoice'                                         => 'Invoice',
    'invoice_default'                                 => 'Invoice Default',
    'invoice_email_subject'                           => 'Invoice Email Subject',
    'invoice_items'                                   => 'Invoice Items',
    'invoice_number'                                  => 'Invoice Number',
    'invoice_summary'                                 => 'Invoice Summary',
    'invoiced'                                        => 'Invoiced',
    'invoices'                                        => 'Invoices',
    'invoices_due_after'                              => 'Invoices Due After (Days)',
    'issued'                                          => 'Issued',
    'item'                                            => 'Item',
    'item_lookup_form'                                => 'Item Lookup Form',
    'item_lookups'                                    => 'Item Lookups',
    'item_sales'                                      => 'Item Sales',
    'items'                                           => 'Items',
    'label_invoice'                                   => 'Choose the invoice to add this expense to',
    'label_item_description'                          => 'Enter a description for this expense (optional)',
    'label_item_name'                                 => 'Enter the name of the line item to add to the invoice',
    'landscape'                                       => 'Landscape',
    'language'                                        => 'Language',
    'left_pad'                                        => 'Left Pad',
    'left_pad_description'                            => 'The number of zeroes to optionally left pad the next number with.',
    'legal'                                           => 'Legal',
    'letter'                                          => 'Letter',
    'license_agreement'                               => 'License Agreement',
    'license_agreement_accept'                        => 'I accept the terms of the license agreement',
    'logo'                                            => 'Logo',
    'mail_hash_error'                                 => 'It appears your secret key has been changed since the last time you saved your email password. To fix this error, go to System Settings -> Email tab, re-enter your email password and press Save. Note that no mail will be delivered until this has been done.',
    'manual'                                          => 'Manual',
    'map_fields_to_import'                            => 'Map Fields to Import',
    'merchant_api_key'                                => 'API Key',
    'merchant_api_password'                           => 'API Password',
    'merchant_api_username'                           => 'API Username',
    'merchant_publishable_key'                        => 'Publishable Key',
    'merchant_secret_key'                             => 'Secret Key',
    'merchant_signature'                              => 'Signature',
    'mobile'                                          => 'Mobile',
    'mobile_number'                                   => 'Mobile Number',
    'monthly'                                         => 'Monthly',
    'months'                                          => 'Months',
    'multiple_email_validation'                       => 'Multiple email addresses should be valid and separated by commas.',
    'name'                                            => 'Name',
    'net_income'                                      => 'Net Income',
    'never'                                           => 'Never',
    'new'                                             => 'New',
    'next_date'                                       => 'Next Date',
    'next_number'                                     => 'Next Number',
    'no'                                              => 'No',
    'no_open_invoices'                                => 'This client has no open invoices. To bill an expense, the client must have at least one invoice which has not been paid in full.',
    'no_records_found'                                => 'No records found',
    'none'                                            => 'None',
    'not_billable'                                    => 'Not Billable',
    'not_billed'                                      => 'Not Billed',
    'not_viewed'                                      => 'Not Viewed',
    'not_visible'                                     => 'Not Visible',
    'note'                                            => 'Note',
    'note_notification'                               => 'Notification: New Note',
    'notes'                                           => 'Notes',
    'online_payment'                                  => 'Online Payment',
    'online_payment_method'                           => 'Online Payment Method',
    'online_payments'                                 => 'Online Payments',
    'options'                                         => 'Options',
    'other'                                           => 'Other',
    'output_type'                                     => 'Output Type',
    'overdue'                                         => 'Overdue',
    'overdue_email_subject'                           => 'Overdue Email Subject',
    'overdue_invoice_reminder'                        => 'Overdue Invoice Reminder',
    'overdue_invoice_reminder_frequency'              => 'Overdue Invoice Reminder Frequency',
    'overdue_invoice_reminder_frequency_help'         => 'A comma separated list of days AFTER an invoice is due to send the reminder. Leave empty to disable overdue invoice reminders. For example, a value of 1,5,10 would send reminders 1, 5 and 10 days after the invoice is due.',
    'overdue_invoices'                                => 'Overdue Invoices',
    'paid'                                            => 'Paid',
    'paper_orientation'                               => 'Paper Orientation',
    'paper_size'                                      => 'Paper Size',
    'password'                                        => 'Password',
    'password_confirmation'                           => 'Password Confirmation',
    'password_successfully_reset'                     => 'Password successfully reset',
    'pay'                                             => 'Pay',
    'pay_now'                                         => 'Pay Now',
    'payment_applied'                                 => 'Your payment has been applied',
    'payment_button_text'                             => 'Payment Button Text',
    'payment_date'                                    => 'Payment Date',
    'payment_form'                                    => 'Payment Form',
    'payment_method'                                  => 'Payment Method',
    'payment_method_form'                             => 'Payment Method Form',
    'payment_methods'                                 => 'Payment Methods',
    'payment_receipt'                                 => 'Payment Receipt',
    'payment_receipt_email_subject'                   => 'Payment Receipt Email Subject',
    'payments'                                        => 'Payments',
    'payments_collected'                              => 'Payments Collected',
    'pdf'                                             => 'PDF',
    'pdf_driver'                                      => 'PDF Driver',
    'pdf_driver_wkhtmltopdf'                          => 'The Binary Path field must contain a valid file path when using the wkhtmltopdf PDF driver.',
    'percent'                                         => 'Percent',
    'phone'                                           => 'Phone',
    'phone_number'                                    => 'Phone Number',
    'php_version_error'                               => 'PHP does not meet the version requirement (%s)',
    'placeholder_type_message'                        => 'Type Message...',
    'portrait'                                        => 'Portrait',
    'postal_code'                                     => 'Postal Code',
    'prefix'                                          => 'Prefix',
    'prerequisites'                                   => 'Prerequisites',
    'preview'                                         => 'Preview',
    'price'                                           => 'Price',
    'private'                                         => 'Private',
    'problem_with_email_template'                     => 'There appears to be a problem with the email template. Please check the templates in System Settings on the Email tab.',
    'product'                                         => 'Product',
    'profit_and_loss'                                 => 'Profit and Loss',
    'public'                                          => 'Public',
    'qty'                                             => 'Qty',
    'quantity'                                        => 'Quantity',
    'quantity_price_decimals'                         => 'Number of Decimals for Quantities and Amounts',
    'quote'                                           => 'Quote',
    'quote_approved'                                  => 'Quote Approved',
    'quote_approved_email_body'                       => 'Quote Approved Email Body',
    'quote_default'                                   => 'Quote Default',
    'quote_email_subject'                             => 'Quote Email Subject',
    'quote_items'                                     => 'Quote Items',
    'quote_number'                                    => 'Quote Number',
    'quote_rejected'                                  => 'Quote Rejected',
    'quote_rejected_email_body'                       => 'Quote Rejected Email Body',
    'quote_status_change_notification'                => 'Notification: Quote Status Change',
    'quote_summary'                                   => 'Quote Summary',
    'quote_to_invoice'                                => 'Quote to Invoice',
    'quotes'                                          => 'Quotes',
    'quotes_expire_after'                             => 'Quotes Expire After (Days)',
    'recalculate'                                     => 'Recalculate',
    'recalculate_help_text'                           => 'Recalculating may take a few moments to complete. A message will be displayed once the process is complete.',
    'recalculate_invoices'                            => 'Recalculate Invoices',
    'recalculate_quotes'                              => 'Recalculate Quotes',
    'recalculating_wait'                              => 'Recalculating, please wait...',
    'recalculation_complete'                          => 'Recalculation Complete',
    'recent_invoices'                                 => 'Recent Invoices',
    'recent_payments'                                 => 'Recent Payments',
    'recent_quotes'                                   => 'Recent Quotes',
    'record_not_found'                                => 'Record not found',
    'record_successfully_created'                     => 'Record successfully created',
    'record_successfully_deleted'                     => 'Record successfully deleted',
    'record_successfully_updated'                     => 'Record successfully updated',
    'records_imported_successfully'                   => 'Records Successfully Imported: :total_records',
    'recurring'                                       => 'Recurring',
    'reject'                                          => 'Reject',
    'rejected'                                        => 'Rejected',
    'rejected_quotes'                                 => 'Rejected Quotes',
    'remember_me'                                     => 'Remember Me',
    'remove_logo'                                     => 'Remove Logo',
    'report_rev_client_notice'                        => 'This report will be available once you have some payments entered in the system.',
    'reports'                                         => 'Reports',
    'require'                                         => 'Require',
    'reset_number'                                    => 'Reset Number',
    'reset_password'                                  => 'Reset Password',
    'results_per_page'                                => 'Results Per Page',
    'revenue_by_client'                               => 'Revenue by Client',
    'round_tax_decimals'                              => 'Number of Decimals for Tax Rounding',
    'run_report'                                      => 'Run Report',
    'save'                                            => 'Save',
    'save_and_apply_exchange_rate'                    => 'Save and Apply Exchange Rate',
    'save_item_as_lookup'                             => 'Save item as lookup',
    'search'                                          => 'Search',
    'select_file_to_import'                           => 'Select the file to import',
    'send'                                            => 'Send',
    'sending'                                         => 'Sending',
    'sendmail_path'                                   => 'Sendmail Path',
    'sent'                                            => 'Sent',
    'sent_invoices'                                   => 'Sent Invoices',
    'sent_quotes'                                     => 'Sent/Pending Quotes',
    'settings'                                        => 'Settings',
    'settings_successfully_saved'                     => 'Settings successfully saved',
    'setup'                                           => 'Setup',
    'sign_in'                                         => 'Sign In',
    'sign_out'                                        => 'Sign Out',
    'skin'                                            => 'Skin',
    'smtp_encryption'                                 => 'SMTP Encryption',
    'smtp_host_address'                               => 'SMTP Host Address',
    'smtp_host_port'                                  => 'SMTP Host Port',
    'smtp_password'                                   => 'SMTP Password',
    'smtp_username'                                   => 'SMTP Username',
    'start_date'                                      => 'Start Date',
    'state'                                           => 'State',
    'status'                                          => 'Status',
    'step_database_setup'                             => 'This step will install and upgrade your database tables. This step may take a few moments to complete.',
    'step_prerequisites'                              => 'The following prerequisites need to be resolved before installation can continue:',
    'subject'                                         => 'Subject',
    'submit'                                          => 'Submit',
    'subtotal'                                        => 'Subtotal',
    'summary'                                         => 'Summary',
    'symbol'                                          => 'Symbol',
    'symbol_placement'                                => 'Symbol Placement',
    'system'                                          => 'System',
    'system_settings'                                 => 'System Settings',
    'table_name'                                      => 'Table Name',
    'tax'                                             => 'Tax',
    'tax_1'                                           => 'Tax 1',
    'tax_2'                                           => 'Tax 2',
    'tax_rate'                                        => 'Tax Rate',
    'tax_rate_form'                                   => 'Tax Rate Form',
    'tax_rate_name'                                   => 'Tax Rate Name',
    'tax_rate_percent'                                => 'Tax Rate Percent',
    'tax_rates'                                       => 'Tax Rates',
    'tax_summary'                                     => 'Tax Summary',
    'taxable_amount'                                  => 'Taxable Amount',
    'taxes'                                           => 'Taxes',
    'template'                                        => 'Template',
    'terms_and_conditions'                            => 'Terms and Conditions',
    'test_mode'                                       => 'Test Mode',
    'text'                                            => 'Text',
    'textarea'                                        => 'Textarea',
    'this_quarter'                                    => 'This Quarter',
    'thousands_separator'                             => 'Thousands Separator',
    'timezone'                                        => 'Timezone',
    'to'                                              => 'To',
    'to_date'                                         => 'To Date',
    'total'                                           => 'Total',
    'total_balance'                                   => 'Total Balance',
    'total_invoiced'                                  => 'Total Invoiced',
    'total_expenses'                                  => 'Total Expenses',
    'total_paid_invoices'                             => 'Total Paid Invoices',
    'try_again'                                       => 'Try Again',
    'uninstall'                                       => 'Uninstall',
    'uninstall_addon_warning'                         => 'Are you sure you wish to disable this add-on?',
    'unique_name'                                     => 'Unique Name',
    'unknown_error'                                   => 'Unknown Error',
    'upcoming_payment_notice_email_body'              => 'Upcoming Payment Notice Email Body',
    'upcoming_payment_notice_email_subject'           => 'Upcoming Payment Notice Email Subject',
    'upcoming_payment_notice_frequency'               => 'Upcoming Payment Notice Frequency',
    'upcoming_payment_notice_frequency_help'          => 'A comma separated list of days BEFORE an invoice is due to send the reminder. Leave empty to disable upcoming payment notices. For example, a value of 1,5 would send notices 1 and 5 days before the invoice is due.',
    'update_available'                                => 'FusionInvoice :version is available to download!',
    'update_exchange_rate'                            => 'Update Exchange Rate',
    'update_not_available'                            => 'There are currently no updates available.',
    'upload_progress'                                 => 'Upload Progress',
    'user'                                            => 'User',
    'user_accounts'                                   => 'User Accounts',
    'user_form'                                       => 'User Form',
    'users'                                           => 'Users',
    'validation_invoice_summary_from_date'            => 'The from date on the Invoice Summary Dashboard Widget is required when the date range is set to Custom Date Range.',
    'validation_invoice_summary_to_date'              => 'The to date on the Invoice Summary Dashboard Widget is required when using a custom date range.',
    'validation_quote_summary_from_date'              => 'The from date on the Quote Summary Dashboard Widget is required when using a custom date range.',
    'validation_quote_summary_to_date'                => 'The to date on the Quote Summary Dashboard Widget is required when using a custom date range.',
    'vendor'                                          => 'Vendor',
    'version'                                         => 'Version',
    'view'                                            => 'View',
    'view_all'                                        => 'View All',
    'view_all_invoices_for_client'                    => 'View all invoices for this client',
    'view_all_payments_for_client'                    => 'View all payments for this client',
    'view_all_quotes_for_client'                      => 'View all quotes for this client',
    'view_approved_quotes'                            => 'View Approved Quotes',
    'view_client'                                     => 'View Client',
    'view_draft_invoices'                             => 'View Draft Invoices',
    'view_draft_quotes'                               => 'View Draft Quotes',
    'view_overdue_invoices'                           => 'View Overdue Invoices',
    'view_payments'                                   => 'View Payments',
    'view_rejected_quotes'                            => 'View Rejected Quotes',
    'view_sent_invoices'                              => 'View Sent Invoices',
    'view_sent_quotes'                                => 'View Sent Quotes',
    'view_unique_name'                                => 'View Unique Name',
    'viewed'                                          => 'Viewed',
    'visible'                                         => 'Visible',
    'visible_after_payment'                           => 'Visible After Payment',
    'web'                                             => 'Web',
    'web_address'                                     => 'Web Address',
    'weekly'                                          => 'Weekly',
    'weeks'                                           => 'Weeks',
    'welcome'                                         => 'Welcome',
    'what_to_import'                                  => 'What would you like to import?',
    'year'                                            => 'Year',
    'yearly'                                          => 'Yearly',
    'years'                                           => 'Years',
    'yes'                                             => 'Yes',
    'you_may_now_sign_in'                             => 'You may now sign in!',

    // 2017-1
    'all_company_profiles'                            => 'All Company Profiles',
    'cannot_delete_record_in_use'                     => 'This record is in use and cannot be deleted.',
    'cannot_edit_record_in_use'                       => 'This record is in use and cannot not be edited.',
    'change_company_profile'                          => 'Change Company Profile',
    'company_profile'                                 => 'Company Profile',
    'company_profiles'                                => 'Company Profiles',
    'company_profile_form'                            => 'Company Profile Form',
    'copy'                                            => 'Copy',
    'create_recurring_invoice'                        => 'Create Subscription',
    'custom'                                          => 'Custom',
    'date_range'                                      => 'Date Range',
    'day_short_sunday'                                => 'Su',
    'day_short_monday'                                => 'Mo',
    'day_short_tuesday'                               => 'Tu',
    'day_short_wednesday'                             => 'We',
    'day_short_thursday'                              => 'Th',
    'day_short_friday'                                => 'Fr',
    'day_short_saturday'                              => 'Sa',
    'default_company_profile'                         => 'Default Company Profile',
    'first_quarter'                                   => 'First Quarter',
    'fourth_quarter'                                  => 'Fourth Quarter',
    'id'                                              => 'ID',
    'last_7_days'                                     => 'Last 7 Days',
    'last_30_days'                                    => 'Last 30 Days',
    'last_month'                                      => 'Last Month',
    'last_quarter'                                    => 'Last Quarter',
    'last_year'                                       => 'Last Year',
    'month_january'                                   => 'January',
    'month_february'                                  => 'February',
    'month_march'                                     => 'March',
    'month_april'                                     => 'April',
    'month_may'                                       => 'May',
    'month_june'                                      => 'June',
    'month_july'                                      => 'July',
    'month_august'                                    => 'August',
    'month_september'                                 => 'September',
    'month_october'                                   => 'October',
    'month_november'                                  => 'November',
    'month_december'                                  => 'December',
    'recurring_invoice'                               => 'Subscription',
    'second_quarter'                                  => 'Second Quarter',
    'stop_date'                                       => 'Stop Date',
    'third_quarter'                                   => 'Third Quarter',
    'this_month'                                      => 'This Month',
    'this_year'                                       => 'This Year',
    'today'                                           => 'Today',
    'user_account'                                    => 'User Account',
    'yesterday'                                       => 'Yesterday',

    // 2017-3
    'mail_log'                                        => 'Mail Log',
    'recent_client_activity'                          => 'Recent Client Activity',

    // 2017-5
    'exclude_unpaid_invoices'                         => 'Exclude Unpaid Invoices',

    // 2017-7
    'please_wait'                                     => 'Please wait...',
    'reply_to_address'                                => 'Reply To Address',

    // 2017-8
    'admin'                                           => 'Admin',
    'admin_account'                                   => 'Admin Account',
    'admin_accounts'                                  => 'Admin Accounts',
    'all_accounts'                                    => 'All Accounts',
    'api_key'                                         => 'API Key',
    'client_account'                                  => 'Client Account',
    'client_accounts'                                 => 'Client Accounts',
    'client_id'                                       => 'Client ID',
    'client_secret'                                   => 'Client Secret',
    'enable_bitcoin_payments'                         => 'Enable Bitcoin Payments',
    'live'                                            => 'Live',
    'mode'                                            => 'Mode',
    'publishable_key'                                 => 'Publishable Key',
    'sandbox'                                         => 'Sandbox',
    'secret_key'                                      => 'Secret Key',
    'type'                                            => 'Type',

    // 2017-10
    'deselect_all'                                    => 'Deselect All',
    'select_all'                                      => 'Select All',
    'use_24_hour_time_format'                         => 'Use 24 Hour Time Format',

    // 2017-11
    'bulk_delete_record_warning'                      => 'Are you sure you wish to delete these records?',
    'bulk_invoice_change_status_warning'              => 'Are you sure you wish to change the status of the selected invoice(s)?',
    'bulk_quote_change_status_warning'                => 'Are you sure you wish to change the status of the selected quote(s)?',
    'calculate_as_vat_gst'                            => 'Calculate as VAT/GST',
    'change_status'                                   => 'Change Status',
    'default_status_filter'                           => 'Default Status Filter',
    'error_applying_payment'                          => 'There was an error applying this payment. Please try a different card or payment method.',
    'remaining'                                       => 'Remaining',

    // 2017-12
    'invoice_date'                                    => 'Invoice Date',
    'include_profit_based_on'                         => 'Include Profit Based On',

    // 2018-1
    'add_contact'                                     => 'Add Contact',
    'allow_self_signed_cert'                          => 'Allow Self-Signed Certificate',
    'backup'                                          => 'Backup',
    'close'                                           => 'Close',
    'change_invoice_date_to_todays_date'              => 'Change Invoice Date to Today\'s Date',
    'change_quote_date_to_todays_date'                => 'Change Quote Date to Today\'s Date',
    'contacts'                                        => 'Contacts',
    'default_bcc'                                     => 'Default BCC',
    'default_cc'                                      => 'Default CC',
    'default_to'                                      => 'Default To',
    'disable'                                         => 'Disable',
    'download_database_backup'                        => 'Download Database Backup',
    'edit_contact'                                    => 'Edit Contact',
    'expense_list'                                    => 'Expense List',
    'keep_invoice_date_as_is'                         => 'Keep Invoice Date As Is',
    'keep_quote_date_as_is'                           => 'Keep Quote Date As Is',
    'if_quote_is_emailed_while_draft'                 => 'If Quote Is Emailed While in Draft Status',

    // 2018-4
    'force_https'                                     => 'Force HTTPS',
    'force_https_help'                                => 'Prior to enabling this option, be sure your FusionInvoice installation is functional via https. Failure to do so may result in a non-functional (but fixable) installation.',

    // 2019-1
    'attached_to'                                     => 'Attached To',
    'customer'                                        => 'Customer',
    'expense'                                         => 'Expense',
    'expense_categories'                              => 'Expense Categories',
    'expense_category_form'                           => 'Expense Category Form',
    'expense_vendors'                                 => 'Expense Vendors',
    'expense_vendor_form'                             => 'Expense Vendor Form',
    'lead'                                            => 'Lead',
    'local_time'                                      => 'Local Time',
    'prospect'                                        => 'Prospect',
    'search_clients'                                  => 'Search Clients',
    'search_expenses'                                 => 'Search Expenses',
    'search_invoices'                                 => 'Search Invoices',
    'search_items'                                    => 'Search Items',
    'search_log'                                      => 'Search Log',
    'search_quotes'                                   => 'Search Quotes',
    'search_payments'                                 => 'Search Payments',
    'search_recurring_invoices'                       => 'Search Subscriptions',
    'show_all_statuses'                               => 'Show All Statuses',
    'show_all_types'                                  => 'Show All Types',
    'unknown'                                         => 'Unknown',
    'value'                                           => 'Value',

    // 2019-2
    'default'                                         => 'Default',
    'no_data_available'                               => 'No data available',
    'recurring_invoice_list'                          => 'Subscription List',
    'report_total'                                    => 'Report Totals',

    //2019-3
    'checkbox'                                        => 'Checkbox',
    'custom_dropdown_validate'                        => 'Please select a valid option from the :label field',
    'custom_image_validate'                           => 'Please select a valid image.',
    'custom_tag_validate'                             => 'Please select a valid tag from :label',
    'custom_text_validate'                            => 'Please enter a valid :label in the :label field.',
    'datetime'                                        => 'DateTime',
    'decimal'                                         => 'Decimal',
    'delete-confirm'                                  => 'Are you sure?',
    'grand_total'                                     => 'Grand Total',
    'image'                                           => 'Image',
    'integer'                                         => 'Integer',
    'mailed'                                          => 'Mailed',
    'mailed_invoices'                                 => 'Mailed Invoices',
    'radio'                                           => 'Radio',
    'recurring_id'                                    => 'Recurring ID',
    'remove_image'                                    => 'Remove Image',
    'tags'                                            => 'Tags',
    'tagselection'                                    => 'Tag Selection',
    'unpaid'                                          => 'Unpaid',
    'url'                                             => 'URL',
    'view_mailed_invoices'                            => 'View Mailed Invoices',
    'important'                                       => 'Important!',
    'created_recurring_invoice_id'                    => 'Created from Subscription ID',
    'mr'                                              => 'Mr.',
    'miss'                                            => 'Miss',
    'ms'                                              => 'Ms.',
    'mrs'                                             => 'Mrs.',
    'dr'                                              => 'Dr.',
    'prof'                                            => 'Prof.',
    'select_title'                                    => 'Contact Title',
    'title'                                           => 'Title',
    'test_email_subject'                              => 'Hello from FusionInvoice',
    'test_email_body'                                 => 'This is a test email from FusionInvoice.',
    'test_email_address'                              => 'Send Email Test to',
    'send_test_email'                                 => 'Send Test Email',
    'invalid_json'                                    => 'Please enter a valid JSON string',
    'textarea_rows_limit'                             => 'Rows cannot exceed :limit',
    'custom_integer_validate'                         => ':label must be a valid integer value',

    //2020-1
    'user_role'                                       => 'User role',
    'standard_user'                                   => 'Standard user',
    'permissions'                                     => 'Permissions',
    'modules'                                         => 'Modules',
    'is_view'                                         => 'View',
    'is_create'                                       => 'Create',
    'is_update'                                       => 'Update',
    'is_delete'                                       => 'Delete',
    'dashboards'                                      => 'Dashboards',
    'allow_time_period_change'                        => 'Allow Time Period Change',
    'page_not_found'                                  => 'Oops! Page not found.',
    'return_to_dashboard'                             => 'We could not find the page you were looking for. <a href=":dashboard_link">Return to dashboard</a>.',
    'no_auth_to_create_client'                        => 'You are not authorized to create clients!',
    'check-all'                                       => 'Check All',
    'invoice_prefix'                                  => 'Invoice Prefix',
    'recently_viewed'                                 => 'Recently Viewed',
    'copy_from'                                       => 'Copy from',
    'select_user'                                     => 'Select User',
    'please_select_user'                              => 'Please select a user from the list',
    'allow_client_center_login'                       => 'Allow Client Center Login',
    'online_payment_processing_fee'                   => 'Online Payment Processing Fee',
    'client_password_required'                        => 'Please enter client password',
    'last_login_at'                                   => 'Last Login At',
    'show_notes_panel_below_client'                   => 'Show Notes Panel below Client Details',
    'notepad'                                         => 'Notepad',
    'added'                                           => 'Added',
    'last_edited'                                     => 'Last Edited',
    'loading'                                         => 'Processing ....',
    'n_records_match'                                 => ':label Record:plural match',
    'initials'                                        => 'Initials',
    'initials_bg_color'                               => 'Initials Background Color',
    'more'                                            => 'More',
    'must_match_all'                                  => 'Must match all',
    'clear'                                           => 'Clear',
    'no_client_tags'                                  => 'There are no client records with tags defined.',
    'qr_code_on_invoice_quote'                        => 'QR-Code on Invoice and Quote',
    'delete_tags'                                     => 'Tag Cleanup',
    'orphan_tags_deleted'                             => 'Successfully deleted all the orphaned tags from the system.',
    'orphan_tags_delete_confirm'                      => 'Running Tag Cleanup will remove all unused tags. Continue?',
    'deleting_tags_wait'                              => 'Deleting tags, please wait...',
    'new-version-available'                           => 'New Version Available!',
    'ignore-this-version'                             => 'Ignore this version',
    'view-release-notes'                              => 'View Release Notes',
    'task_list'                                       => 'Task List',
    'create_task'                                     => 'Create Task',
    'open'                                            => 'Open',
    'closed'                                          => 'Closed',
    'assignee'                                        => 'Assignee',
    'task'                                            => 'Tasks',
    'task_successfully_created'                       => 'Task successfully created',
    'task_successfully_updated'                       => 'Task successfully updated',
    'task_completed'                                  => 'Task successfully completed',
    'task_marked_incomplete'                          => 'Task reopened',
    'due_date_validation_date'                        => 'Please select a valid due date',
    'assignee_validation_required'                    => 'Please select a valid assignee from the list',
    'assignee_validation_exists'                      => 'Please select a valid assignee from the list',
    'tomorrow'                                        => 'Tomorrow',
    'task_not_authorized'                             => 'You are not authorized to edit this task!',
    'me'                                              => 'Me',
    'task_from_note'                                  => 'Create Task on Save',
    'done'                                            => 'Done',
    'refresh'                                         => 'Refresh',
    'task_list_page_size'                             => 'Number of tasks per page',
    'select_client'                                   => 'Select Client',
    'note-search-config'                              => 'Notes Search to Include',
    'username'                                        => 'User Name',
    'task-search-config'                              => 'Task Search to Include',
    'task_section_invalid'                            => 'Invalid task section',
    'task_section'                                    => 'Task section',
    'select_section'                                  => 'Select section',
    'email-test-failed'                               => 'Email Test Failed',
    'smtp-setting-suggestion'                         => 'Suggestions: <br> 1. Verify and reenter your user/password values<br>2. Verify that your SMTP settings are entered correctly',
    'mail-setting-suggestion'                         => 'Suggestions: <br> 1. Verify that PHP Mail server configured properly <br>2. Contact server admin',
    'sendmail-setting-suggestion'                     => 'Suggestions: <br> 1. Verify that your Sendmail path is correctly configured.<br>2. Contact server admin',
    'sendgrid-setting-suggestion'                     => 'Suggestions: <br> 1. Verify that your Sendgrid key is correctly configured.<br>2. Contact server admin',
    'later'                                           => 'Later',
    'test-email-required'                             => 'You must enter a valid To email',
    'test_mail_sent_successfully'                     => 'Test mail sent successfully',
    'test-mail-btn-title'                             => 'Must save changes before testing.',
    'agreement_expire'                                => 'Your Product Updates and Support will expire on :date',
    'agreement_expired'                               => 'Your Product Updates and Support expired on :date',
    'piracy_message'                                  => 'Your FusionInvoice License Key is not valid. Software piracy is a crime. Please play fair. With a valid license you will receive support, updates and a good karma.',
    'buy-now'                                         => 'Buy Now',
    'piracy_alert'                                    => 'Please be fair!',
    'agreement-expire-alert'                          => 'Product Updates and Support Expiring Soon.',
    'agreement-expired-alert'                         => 'Product Updates and Support Has Expired.',
    'dismiss-forever'                                 => 'Dismiss Forever',
    'renew-now'                                       => 'Renew Now',
    'select_all_permissions'                          => 'Select All Permissions',
    'app-key-missing'                                 => 'Please enter a valid license key',
    'custom_fields_column_width'                      => 'Custom Fields Display Columns',
    'select-user-type'                                => 'Select User Type',
    'lead-or-prospect-with-invoices-error'            => 'Sorry, a client\'s Type cannot be Lead or Prospect when invoices or Subscriptions exist.',
    'sendgrid_key'                                    => 'Sendgrid key',

    //2020-2.0
    'space'                                           => 'Space',
    'apostrophe'                                      => 'Apostrophe',
    'comma'                                           => 'Comma',
    'fullstop'                                        => 'Dot (Full Stop)',
    'middledot'                                       => 'Middle Dot',
    'thinspace'                                       => 'Thin Space',
    'narrow-no-break-space'                           => 'Narrow No-Break Space',
    'dotabove'                                        => 'Dot Above',
    'arabic-decimal'                                  => 'Arabic Decimal Separator',
    'arabic-thousand'                                 => 'Arabic Thousand Separator',
    'decimal-separator-key-symbol'                    => 'Decimal Separator Key Symbol',
    'select-item'                                     => 'Select Item',
    'item-lookup-overload'                            => 'Max of :max_import items allowed for item lookup',
    'select-expense-category'                         => 'Select Expense Category',
    'select-expense-vendor'                           => 'Select Expense Vendor',
    'can-not-delete-all-users'                        => 'Sorry, you can\'t delete all users from the system',
    'can-not-change-default-user-role'                => 'Sorry, you can\'t change the default user role',
    'can-not-change-default-user-status'              => 'Sorry, you can\'t change the default user status',
    'user_not_active'                                 => 'User is not active',
    'can-not-inactive-your-own-status'                => 'Sorry, you can\'t make yourself inactive.',
    'delete_user_warning'                             => '<p>STOP! Deleting this user is a destructive action that may remove records that they created within the system. Please consider making the user inactive instead.</p><p>Are you sure you want to delete this user?</p>',
    'include_time_in_due_date'                        => 'Include Time In Due Date',
    'cannot_delete_default_company'                   => 'You can\'t delete the default company profile',
    'make-user-inactive'                              => 'Make User Inactive',
    'mail_from_address'                               => 'Mail From Address',
    'mail_from_name'                                  => 'Mail From Name',
    'item_categories'                                 => 'Item Categories',
    'select-item-category'                            => 'Select Item Category',
    'item_category_form'                              => 'Item Category Form',
    'sort_by_due'                                     => 'Sort By Due Date',
    'affiliate'                                       => 'Affiliate',
    'parent_account'                                  => 'Parent Account',
    'child_account'                                   => 'Child Accounts',
    'select_parent_client'                            => 'Select Parent Account',
    'record_successfully_retrieved'                   => 'Record retrieved successfully',
    'custom-image-not-support'                        => 'Custom image field not supported',
    'custom-tag-not-support'                          => 'Custom tag field not supported',
    'custom-checkbox-not-support'                     => 'Custom checkbox field not supported',
    'custom-date-not-support'                         => 'Custom date field not supported',
    'custom-datetime-not-support'                     => 'Custom datetime field not supported',
    'timeline'                                        => 'TimeLine',
    'client_invoice'                                  => 'Invoices By Client',
    'select_client_blank_for_all'                     => 'Select Client (blank for all)',
    'invoice_email_success'                           => 'Invoice email sent successfully',
    'quote_email_success'                             => 'Quote email sent successfully',
    'document_number_schemes'                         => 'Document Numbering',
    'document_number_scheme'                          => 'Document Number Scheme',
    'document_number_scheme_form'                     => 'Document Number Scheme Form',
    'default_document_number_scheme'                  => 'Default Document Number Scheme',
    'supporting_data'                                 => 'Supporting Data',
    'customizations'                                  => 'Customizations',
    'utilities_and_logs'                              => 'Utilities and Logs',
    'system_log'                                      => 'System Log',
    'paid_amount'                                     => 'Paid Amount',
    'payment_amount'                                  => 'Payment Amount',
    'payment_intent'                                  => 'Payment Intent',
    'apply_payment_to_one_or_more_invoice'            => 'Apply Payment to one or more invoices',
    'pre_payment_for_future_invoices'                 => 'Pre-payment for future invoices',
    'apply_to_invoices'                               => 'Apply to Invoice(s)',
    'payment_application'                             => 'Payment Application',
    'remaining_payment_balance'                       => 'Remaining Payment Balance',
    'remaining_balance'                               => 'Remaining Balance',
    'payment_warning'                                 => 'Please enter amount',
    'apply_pre_payment_warning'                       => 'You haven’t applied the payment to any invoices. Would you like to record it as a pre-payment?',
    'confirm_remaining_balance'                       => 'The remaining balance of :value will be available to apply to future invoices for this client.',
    'open_balance'                                    => 'Open Balance',
    'more_figure_then_total_payment'                  => 'Please re-enter the payment, your total invoice payment is greater then remaining balance.',
    'remaining_payment_balance_apply_later_info'      => 'Remaining payment balances can be applied to other invoices later.',
    'invoice_balance'                                 => 'Invoice Balance',
    'enter_payment_for_invoice'                       => 'Enter payment for Invoice',
    'invoice_pdf'                                     => 'Invoice PDF',
    'payment_applications'                            => 'Payment Applications',
    'multiple'                                        => 'Multiple',
    'ok'                                              => 'Ok',
    'credit_memo_default'                             => 'Credit Memo Default',
    'edit_payment'                                    => 'Edit Payment',
    'credit_memo'                                     => 'Credit Memo',
    'credit_memos'                                    => 'Credit Memos',
    'create_credit_memo'                              => 'Create Credit Memo',
    'credit_applications'                             => 'Credit Memo Applications',
    'credit_applications_for_invoice'                 => 'Credit Memo Applications For Invoice',
    'prepayment_applications_for_invoice'             => 'Pre-payment Applications For Invoice',
    'apply_credit_memo'                               => 'Apply Credit Memo',
    'apply_pre_payment'                               => 'Apply Pre-payment',
    'applied_amount'                                  => 'Applied Amount',
    'remaining_credit_balance'                        => 'Remaining Credit Balance',
    'remaining_credit_balance_apply_later_info'       => 'Remaining credit balances can be applied to other invoices later.',
    'applied'                                         => 'Applied',
    'more_figure_then_invoice_amount'                 => 'Please re-enter the amount, the amount cannot be greater then invoice amount.',
    'more_figure_then_invoice_total'                  => 'Please re-enter the amount, the total applied amount cannot be greater then invoice amount.',
    'invoice_not_selected_warning'                    => 'Wait, you didn’t apply the Credit Memo to any invoices.',
    'select_type'                                     => 'Select Type',
    'email_credit_memo'                               => 'Email Credit Memo',
    'back_to_credit_memo'                             => 'Back to Credit Memo',
    'invoice_amount'                                  => 'Invoice Amount',
    'remaining_invoice_amount'                        => 'Remaining Invoice Amount',
    'settlement_for_credit_memo'                      => 'Settlement for Credit Memo',
    'credit_memo_amount'                              => 'Credit Memo Amount',
    'confirm_remaining_balance_invoice'               => 'The remaining balance for this invoice will be :value after settlement.',
    'payment_receipt_for_invoices'                    => 'Payment Receipt for Invoices',
    'primary_phone'                                   => 'Primary Phone number',
    'alternate_phone'                                 => 'Alternate Phone number',
    'currency_not_match'                              => 'Currency does not match',
    'tasks'                                           => 'Tasks',
    'full_and_final_payment'                          => 'full',
    'partial'                                         => 'partial',
    'transition'                                      => [
        'created'          => 'Created',
        'updated'          => 'Updated',
        'deleted'          => 'Deleted',
        'received'         => 'Received',
        'opened'           => 'Opened',
        'sent'             => 'Sent',
        'mail'             => 'Mailed',
        'changed'          => 'Changed',
        'recurring'        => 'Created',
        'completed'        => 'Completed',
        'reversed'         => 'Reversed',
        'quote_to_invoice' => 'Quote To Invoice',
        'download'         => 'Download',
        'added'            => 'Added',
        'email'            => 'Email',
        'merge'            => 'Merge',
        'billed'           => 'Billed',
        'failed'           => 'Failed',
        'invoice'          => [
            'created'                => 'Invoice :invoice_number was created',
            'credit_memo_created'    => 'Credit Memo :credit_memo_number was created',
            'credit_memo_updated'    => 'Credit Memo :credit_memo_number was modified',
            'created_from_recurring' => 'Invoice :invoice_number was created(from Recurring template <strong>:recurring_invoice_id</strong>)',
            'updated'                => 'Invoice :invoice_number was modified',
            'deleted'                => 'Invoice :invoice_number was deleted',
            'credit_memo_deleted'    => 'Credit Memo :credit_memo_number was deleted',
            'status_changed'         => 'Invoice :invoice_number Status changed from <strong><del>:previous_value</del></strong> to <strong>:current_value</strong>',
            'email_sent'             => 'Invoice :invoice_number email sent',
            'resend_email'           => 'Invoice :invoice_number email resend',
            'email_opened'           => 'Invoice :invoice_number email opened',
            'payment_updated'        => 'Invoice :invoice_number updated :full_payment_text payment',
            'payment_received'       => 'Invoice :invoice_number received :full_payment_text payment',
            'payment_reversed'       => 'Invoice :invoice_number had a :full_payment_text',
            'invoice_tag_updated'    => 'Invoice Tag :tags was added on invoice :invoice_number',
            'invoice_tag_deleted'    => 'Invoice Tag :invoice_number was deleted :tags',
            'mark_mail'              => 'Invoice  :invoice_number mark as mailed',
            'unmark_mail'            => 'Invoice  :invoice_number mask as unmailed',
            'paid_invoice_opened'    => 'Paid invoice was opened for editing <strong>:invoice_number</strong>',
            'sent_invoice_opened'    => 'Sent Invoice was opened for editing <strong>:invoice_number</strong>',
            'sms_sent'               => 'Invoice :invoice_number SMS sent',
        ],
        'quote'            => [
            'created'           => 'Quote :quote_number was created',
            'updated'           => 'Quote :quote_number was modified',
            'deleted'           => 'Quote :quote_number was deleted',
            'status_changed'    => 'Quote :quote_number Status changed from <strong><del>:previous_value</del></strong> to <strong>:current_value</strong>',
            'email_sent'        => 'Quote :quote_number email sent',
            'resend_email'      => 'Quote :quote_number email resend',
            'email_opened'      => 'Quote :quote_number email opened',
            'quote_to_invoice'  => ':quote_number has been converted to an invoice - <strong>:invoice_number</strong>',
            'quote_tag_updated' => 'Quote Tag :tags was added on quote :quote_number',
            'quote_tag_deleted' => 'Quote Tag :quote_number was deleted :tags',
            'sms_sent'          => 'Quote :quote_number SMS sent',
        ],
        'payment'          => [
            'prepayment_created'           => 'Prepayment was created',
            'payment_receipt_email_sent'   => 'Payment receipt email sent',
            'payment_receipt_resend_email' => 'Payment receipt email resend',
            'payment_updated'              => 'Payment was modified',
            'deleted'                      => 'Payment was deleted',
            'payment_receipt_pdf_download' => 'Payment receipt PDF download',
            'payment_note_deleted'         => 'Payment note deleted: <span><strong><del>:previous_value</del></strong></span>',
            'payment_note_added'           => 'Payment note added: <strong>:current_value</strong>',
            'payment_note_updated'         => 'Payment note updated from <strong><del>:previous_value</del></strong> to <strong>:current_value</strong>',
            'payment_failed'               => 'Payment failed',
        ],
        'client'           => [
            'client_created'     => ':client_type was created',
            'type_changed'       => '<strong><del>:previous_value</del></strong> became a <strong>:current_value</strong>',
            'updated'            => 'Client was updated',
            'deleted'            => '<strong><del>“:client_name”</del></strong> was deleted',
            'status_changed'     => 'Client set to <strong>:current_value</strong>',
            'client_tag_updated' => 'Tag :tags added',
            'client_tag_deleted' => 'Tag :tags deleted',
            'merge'              => 'Client ID: :idTo - :nameTo  was merged into Client ID: :idFrom - :nameFrom',
        ],
        'expense'          => [
            'created' => 'Expense was created',
            'updated' => 'Expense was modified',
            'deleted' => 'Expense was deleted',
            'billed'  => 'Expense was billed',
            'vendor'  => [
                'created' => 'Expense Vendor was created',
                'updated' => 'Expense Vendor was modified',
                'deleted' => 'Expense Vendor was deleted',
            ],
        ],
        'note'             => [
            'created'          => 'Note was created',
            'updated'          => 'Note was modified',
            'deleted'          => 'Note was deleted',
            'note_tag_updated' => 'Tag :tags added on note',
            'note_tag_deleted' => 'Tag :tags deleted from note',
        ],
        'task'             => [
            'created'   => 'Task was created',
            'updated'   => 'Task was modified',
            'deleted'   => 'Task was deleted',
            'completed' => 'Task was completed',
        ],
        'subscription'     => [
            'created'                       => 'Subscription :invoice_number was created',
            'updated'                       => 'Subscription :invoice_number was modified',
            'deleted'                       => 'Subscription :invoice_number was deleted',
            'recurring_invoice_tag_updated' => 'Subscription Tag :tags was added on Subscription :recurringInvoice_number',
            'recurring_invoice_tag_deleted' => 'Subscription tag :recurringInvoice_number was deleted :tags',
        ],
        'attachment'       => [
            'created' => ':filename was uploaded as an attachment',
            'deleted' => ':filename was removed as an attachment',
        ],
        'tag'              => [
            'created' => 'The tag :tag was added to <strong>:module</strong>.',
            'deleted' => 'The tag :tag was removed from <strong>:module</strong>.',
        ],
    ],
    'reset'                                           => 'Reset',
    'select_event'                                    => 'Select Event Type',
    'select_country'                                  => 'Select a country',
    'type_captcha'                                    => 'Please enter the security string.',
    'refresh_captcha'                                 => 'Refresh security string',
    'answer'                                          => 'Security string',
    'use_captcha_in_login'                            => 'Use captcha in Login',
    'allow_client_timeline'                           => 'Timeline',
    'client_timeline'                                 => 'Timeline',
    'no_invoice_tags'                                 => 'There are no invoice tags.',
    'total_notifications'                             => 'You have :total notifications',
    'no_notifications'                                => 'No new notifications',
    'notifications'                                   => 'Notifications',
    'notification'                                    => [
        'task'  => [
            'created'           => 'A new task assigned to you',
            'due_date_breached' => 'The task <strong>":task_title"</strong> is past its due date.',
            'completed'         => ':user completed task: <strong>:task_title</strong>',
        ],
        'quote' => [
            'approved'             => ':quote_number has been approved',
            'quote_to_invoice'     => ':quote_number has been converted to an invoice - <strong>:invoice_number</strong>',
            'rejected'             => ':quote_number has been rejected',
            'payment_successfully' => 'Quote :quote_number for client :client_name has been paid. Invoice :invoice_number was created and the payment was applied',
        ],
    ],
    'search_tasks'                                    => 'Search Tasks',
    'reopen_task'                                     => 'Reopen Task',
    'task_form'                                       => 'Add Task',
    'view_task'                                       => 'Task Details',
    'client_deleted'                                  => 'Client is deleted',
    'payment_canceled'                                => 'Your payment has been canceled',
    'default_company_profile_set'                     => 'We have set your default company profile. You can update it any time from the Company Profile settings.',
    'file_uploaded_successfully'                      => 'File uploaded successfully',
    'attachment_notice'                               => 'Maximum Attachment file size less than or equal to :size',
    'attachment_error'                                => 'Attachment size may not exceed :size',
    'attachment_warning'                              => 'Attachment size is :size. Uploading many large attachments may degrade your database performance over time.',
    'generate_timeline_history'                       => 'Generate Timeline History',
    'generating_timeline_wait'                        => 'Generating Timeline, please wait...',
    'generating_timeline_confirm'                     => 'The timeline feature was added in FusionInvoice 2020. This will generate timeline entries for all activities that preceded that feature addition. Continue?',
    'generated_timeline_request_accepted'             => 'Generation of timeline history is complete.',
    'transitions'                                     => 'Timeline History',
    'pending'                                         => 'Pending',
    'client_transition'                               => 'Client Timelines',
    'expense_transition'                              => 'Expense Timelines',
    'invoice_transition'                              => 'Invoice Timelines',
    'payment_invoice_transition'                      => 'Payment Invoice Timelines',
    'payment_transition'                              => 'Payment Timelines',
    'quote_transition'                                => 'Quote Timelines',
    'note_transition'                                 => 'Note Timelines',
    'task_transition'                                 => 'Task Timelines',
    'email_sent'                                      => 'Email sent',
    'credit_applied'                                  => 'Credit Applied',
    'configuration'                                   => 'Configuration',
    'include_prepayments'                             => 'Include Prepayments',
    'pre_payment'                                     => 'Pre-Payment',
    'pre_payments'                                    => 'Pre-Payments',
    'times'                                           => 'Times',
    'include_prepayments_applied'                     => 'Include Prepayments Applied',
    'confirm_full_payment_applied'                    => 'Payment was fully applied',
    'confirm_full_credit_memo_applied'                => 'Credit memo was fully applied',
    'all_tasks'                                       => 'All Tasks',
    'my_tasks'                                        => 'My Tasks',
    'assigned_from_others'                            => 'Assigned fom Others',
    'full_payment_reversed'                           => 'full payment reversed.',
    'partial_payment_reversed'                        => 'partial payment reversed.',
    'invoice_delete_error'                            => 'Sorry, you cannot delete an invoice that has payments or credit memo applications. You must first delete the payments or credit memo applications.',
    'mail-from-required'                              => 'You must enter a valid Mail-From email address',
    'contact_updated'                                 => 'Contact updated successfully',
    'contact_added'                                   => 'Contact added successfully',
    'generate_passport_key_wait'                      => 'Generating your passport key, please wait...',
    'generate_passport_key'                           => 'Generate Passport Key',
    'default_greeting'                                => 'Hi, There! <br>',
    'hi'                                              => 'Hi, ',
    'deduct_tax_from_expenses'                        => 'Deduct Tax from Expenses',
    'invalid_invoice_id'                              => 'Invalid Invoice Id',
    'client_related_record_exist'                     => 'Sorry, the client has related records for: :modules. Clients with transaction history cannot be deleted.',
    'email_payment_receipt_notice'                    => 'Client has no email address on file',
    'show_more'                                       => 'Show more ...',
    'show_less'                                       => 'Show less ...',
    'invoice_already_paid'                            => 'Invoice is already paid!',
    'system_default'                                  => 'System Default',
    'created_by'                                      => 'Created By',
    'created_at'                                      => 'Created At',
    'task_created_by_and_created_at'                  => 'Task created by :created_by on :created_at',
    'dashboard_widgets_date_options'                  => 'System Default Time Period for Widgets',
    'dashboard-widget-from-date-required'             => 'From date is required when custom date range is selected on System Default Time Period for Invoice and Quote Summary',
    'dashboard-widget-to-date-required'               => 'To date is required when custom date range is selected on System Default Time Period for Invoice and Quote Summary',
    'invoice_currency'                                => 'Invoice Currency',
    'currency_format'                                 => 'Currency Format',
    'create_missing_folder_success'                   => 'Created missing required folder',
    'create_missing_folder_failed'                    => 'Attempt to create folder(s) failed :path',
    'folder_is_not_writable'                          => 'Folder is not writable :path',
    'update_item_as_lookup'                           => 'Update item lookup',
    'number_of_tax_fields'                            => 'Number of tax fields',
    'tax_1_entry'                                     => '1 Entry',
    'tax_2_entries'                                   => '2 Entries',
    'require_tags_on_client_notes'                    => 'Require Tag(s) on Client Notes',
    'entered_amount_less_than_invoice_amount'         => 'Entered Amount must be less than or equal to Invoice amount',
    'send-to'                                         => 'Send To',
    'print'                                           => 'Print',
    'pdf_cleanup'                                     => 'PDF Cleanup',
    'pdf_cleanup_confirm'                             => 'Are you sure you want to clean up old PDF files',
    'pdf_cleanup_success'                             => 'PDF Cleanup completed',
    'deleting_pdf_wait'                               => 'Deleting old PDF files, please wait...',
    'open_invoices'                                   => 'Open Invoices',
    'open_credits'                                    => 'Open Credits',
    'unapplied_payments'                              => 'Unapplied Payments',
    'attach_invoice_pdf'                              => 'Attach Invoice PDF',
    'upcoming_payment_notice'                         => 'Upcoming Payment Notice',
    'select_mapping'                                  => 'Select Mapping',
    'select_named_export'                             => 'Select Named Export',
    'save_mapping'                                    => 'Save Mapping',
    'add_mapping'                                     => 'Create new mapping',
    'edit_mapping'                                    => 'Update mapping',
    'save_as_default_mapping'                         => 'Default mapping',
    'save_as_default_export'                          => 'Default export',
    'export_item_lookups'                             => 'Export Item Lookups',
    'import_file_selection'                           => 'Import File Selection',
    'next'                                            => 'Next',
    'delete_import_mapping_warning'                   => 'Are you sure you want to delete this mapping?',
    'export'                                          => 'Export',
    'named_exports'                                   => 'Named Exports',
    'save_named_export'                               => 'Save Named Export',
    'delete_named_export'                             => 'Delete Named Export',
    'updated_at'                                      => 'Updated At',
    'zip'                                             => 'Zip',
    'fields_to_export'                                => 'Fields to Export',
    'import-file-type-error'                          => 'Import file type must be CSV',
    'recurring_invoice_items'                         => 'Subscription Items',
    'important_details'                               => 'Important Details',
    'important_information'                           => 'Important Information',
    'item_lookups_important_information'              => '<p>If a matching item lookup name is found in the existing data during the CSV import, the import batch will fail, showing the item that caused the failure.</p>',
    'invoices_important_information'                  => '<p>Client name (from the CSV) is looked up in the Clients table and resolved to client_id, If there is a matching name. If no name match is found, then it creates a client entry and uses the ID of the new client entry</p><p>Invoice number, "number" in the invoice table is persisted from the CSV as a invoice number. If the invoice number already exists when attempting the import, The batch import will fail.</p><p>Invoice_items does a lookup on the invoice number (from the CSV) in the invoice table and resolves it to the ID. No other key field lookups/validations are done</p>',
    'invoice_items_important_information'             => '<p>The invoice_items import performs a lookup on the invoice number (from the CSV) in the invoices table and resolves it to the appropriate invoice ID. The client ID is also derived from the matching invoice information.</p>',
    'payments_important_information'                  => '<p>Importing payments requires a valid matching invoice number to apply the payments to. If a matching invoice is not found, the entire batch import will fail.</p><p>The appropriate clients->id is resolved using the invoice number in the CSV, from a lookup in the invoice table.</p><p>A lookup is performed on the payment method name (from the CSV into the payment_methods table) and will resolve to the appropriate payment_method_id, if found. if not matching name is found, a new payment method record will be created, and the new payment_method_id will be used.</p>',
    'run_daily_tasks'                                 => 'Run Daily Tasks',
    'daily_task_ran'                                  => 'Daily Tasks ran successfully',
    'csv_row_number'                                  => 'CSV Row number :row',
    'max_item_lookup_records'                         => 'Max. Item Lookup Records',
    'invoice_with_commission_delete_error'            => 'Sorry, you cannot delete an invoice that has commission entries with a paid status. You must first delete paid commission on this invoice.',
    'if_invoice_is_emailed_while_draft'               => 'If Invoice Is Emailed While in Draft Status',
    'custom_payment_receipt_body_not_exists'          => 'The custom template for Payment Receipts was not found. "custom/email_templates/ payment/ paymentReceiptBody.blade.php"',
    'invoice_email_body_type'                         => 'Invoice Email Body Type',
    'send_overdue_reminder'                           => 'Send overdue reminder',
    'reminder_sent_successfully'                      => 'Reminder sent successfully',
    'error_sending_reminder'                          => 'There was an error sending reminder, please try again later.',
    'expense_date'                                    => 'Expense Date',
    'group_by'                                        => 'Group By',
    'timeline_scope_all_user'                         => 'Timeline Scope - All Users',
    'copy_to_clipboard'                               => 'Copy to clipboard',
    'text_copied_clipboard'                           => 'Text copied on clipboard!',
    'import_example_csv'                              => 'An example CSV file can be found here',
    'import'                                          => 'Import',
    'address2'                                        => 'Address 2',
    'use_parent_email'                                => 'Use Parent Email',
    'max_import_records'                              => 'Maximum limit to import records are :total_records',
    'demo_file_attachment_disabled'                   => 'File attachments are disabled in the demo',
    'drag_drop_file'                                  => 'Drag & Drop to Upload File',
    'or'                                              => 'OR',
    'browse_file'                                     => 'Browse File',
    'system_setting_and_ui'                           => 'System Settings & UI',
    'localization_and_timezone'                       => 'Localization & Timezone',
    'security'                                        => 'Security',
    'cleanup_and_backup'                              => 'Cleanup & Backup',
    'attach_quote_pdf'                                => 'Attach Quote PDF',
    'attach_payment_receipt'                          => 'Attach Payment Receipt',
    'choose-file'                                     => 'Choose File',
    'important-note'                                  => 'Important Note',
    'collapse'                                        => 'Collapse',
    'add_task'                                        => 'Add Task',
    'recurring_invoice_commissions'                   => 'Subscription Commissions',
    'invoice_commissions'                             => 'Invoice Commissions',
    'percentage'                                      => 'Percentage',
    'flat_amount'                                     => 'Flat Amount',
    'discount-amount'                                 => 'Discount',
    'discount-type'                                   => 'Discount Type',
    'saving'                                          => 'Saving...',
    'preparing'                                       => 'Preparing',
    'allow_line_item_discounts'                       => 'Allow Line Item Discounts',
    'invalid_price_amount'                            => 'Price cannot be zero/empty',
    'light-mode'                                      => 'Light Mode',
    'dark-mode'                                       => 'Dark Mode',
    'system_base_currency'                            => 'System Base Currency',
    'is_recurring_task'                               => 'Is Recurring Task',
    'contact_names'                                   => 'Contact Names',
    'all_client'                                      => 'All Clients',
    'invoice_grand_total'                             => 'Invoice Grand Total',
    'recurring_invoice_grand_total'                   => 'Subscription Grand Total',
    'is_required'                                     => 'Is Required?',
    'add-new-client'                                  => 'Add New Client',
    'client_name_required'                            => 'Client name is required',
    'custom_item_text_validate'                       => 'Please enter a valid item :label in the :label field.',
    'assigned_to_others'                              => 'Assigned to Others',
    'all_tasks_and_all_users'                         => 'All tasks/All users',
    'statement'                                       => 'Statement',
    'profile_code'                                    => 'Profile Code',
    'login-url'                                       => 'Login URL',
    'url_copied_clipboard'                            => 'URL copied on clipboard!',
    'payment_receipt_email_sent'                      => 'Payment receipt email sent successfully',
    'edit_payment_note_form'                          => 'Edit Payment Note',
    'payment_invoices_text'                           => 'Thank you! Your payment of :amount has been applied to following invoices.',
    'payment_text'                                    => 'Thank you for your payment of :amount .',
    'date_filter_by'                                  => 'Date Filter by',
    'filter_by_invoice_date'                          => 'Invoice Date',
    'filter_by_payment_date'                          => 'Payment Date',
    'date-range-required'                             => 'Please select Date Range',
    'save-and-complete'                               => 'Save And Complete',
    'completion-note'                                 => 'Completion Note',
    'complete-with-note'                              => 'Complete with Note',
    'placeholder_type_note'                           => 'Type your notes...',
    'credit_memo_email_subject'                       => 'Credit Memo Email Subject',
    'default_credit_memo_email_body'                  => 'Default Credit Memo Email Body',
    'show_invoices_from'                              => 'Show Invoices From',
    'system_mail_from_address'                        => 'System Mail From Address',
    'user_who_created_invoice'                        => 'User Who Created Invoice',
    'completed'                                       => 'Completed',
    'no_auth_to_view_task'                            => 'This task is no longer in your list.',
    'credit-memo-and-prepayments'                     => 'Credits and Pre-payments',
    'all_selected'                                    => 'All Selected',
    'select_columns'                                  => 'Select Columns',
    'column_settings'                                 => 'Column Settings',
    'minimum_one_column_check_is_required'            => 'Please select at-least one column',
    'date_of_entry'                                   => 'Date of Entry',
    'amount_applied'                                  => 'Amount Applied',
    'date_applied'                                    => 'Date Applied',
    'copy_to_recurring_invoice'                       => 'Copy to Subscription',
    'top_bar_color'                                   => 'Top Bar Color',
    'light_grey'                                      => 'Light Grey',
    'bg-primary'                                      => 'Blue',
    'bg-warning'                                      => 'Yellow',
    'bg-info'                                         => 'Dragonfly Blue',
    'bg-danger'                                       => 'Red',
    'bg-success'                                      => 'Turf Green',
    'bg-indigo'                                       => 'Indigo',
    'bg-lightblue'                                    => 'Victoria Blue',
    'bg-navy'                                         => 'Navy Blue',
    'bg-purple'                                       => 'Purple',
    'bg-fuchsia'                                      => 'Fuchsia',
    'bg-pink'                                         => 'Pink',
    'bg-maroon'                                       => 'Maroon',
    'bg-orange'                                       => 'Orange',
    'bg-lime'                                         => 'Lime Green',
    'bg-teal'                                         => 'Teal',
    'bg-olive'                                        => 'Olive',
    'fee_name'                                        => 'Fee Name',
    'fee_percentage'                                  => 'Fee Percentage',
    'fee_explanation'                                 => 'Fee Explanation',
    'enable_online_payment_processing_fees'           => 'Enable Online Payment Processing Fees',
    'allow_online_payment_processing_fees'            => 'Allow Online Payment Processing fees',
    'allow_online_pay_fees'                           => 'Allow Online Pay Fees',
    'convenience_charges'                             => 'Convenience Charges',
    'opp-fee-percentage-required'                     => 'Online Payment Processing Fees Percentage is Required',
    'opp-fee-percentage-gt-zero'                      => 'Online Payment Processing Fees Percentage must be Greater than Zero',
    'cron_error'                                      => 'failed at :datetime',
    'cron_start'                                      => 'Daily task runner started at :datetime',
    'notification_clear_all'                          => 'Clear all notifications',
    'show'                                            => 'Show',
    'report'                                          => 'Report',
    'profit_loss'                                     => 'Profit and Loss',
    'credit_and_pre_payments'                         => 'Credits and Pre-payments',
    'expenses_vendors'                                => 'Expenses Vendors',
    'expenses_categories'                             => 'Expenses Categories',
    'create'                                          => 'Create',
    'import_map_clients'                              => 'Import Map Clients',
    'payctr_users'                                    => 'PaymentCenter Users',
    'ctrl_plus_click'                                 => 'Ctrl-Click to Add Completion Notes',
    'edit_note'                                       => 'Edit Note',
    'save-and-unComplete'                             => 'Save And UnComplete',
    'sales_chart'                                     => 'Sales Chart',
    'accumulate_totals'                               => 'Accumulate Totals',
    'do_not_accumulate_totals'                        => 'Do Not Accumulate Totals',
    'kpi_cards'                                       => 'KPI Cards',
    'no_data_to_display'                              => 'No Data To Display',
    'choose_period'                                   => 'Choose Period',
    'date_mailed'                                     => 'Date Mailed',
    'date_emailed'                                    => 'Date Emailed',
    'action'                                          => 'Action',
    'mail'                                            => 'Mail',
    'mark_as_mailed'                                  => 'Mark as Mailed',
    'invoice_mailed'                                  => 'Invoice has been marked as Mailed',
    'emailed'                                         => 'Emailed',
    'paid_invoice_canceled_error'                     => 'To Cancel this invoice, Please delete payments from invoice.',
    'allow_invoice_delete'                            => 'Allow Invoice Delete',
    'allow_child_accounts'                            => 'Allow Child Accounts',
    'third_party_bill_payer'                          => '3rd Party Bill Payer',
    'invoices_paid_by'                                => 'Invoices Paid By',
    'use_third_party_bill_payer_email'                => 'Use Third Party Bill Payer Email',
    'email_default'                                   => 'Email Default',
    'client_default'                                  => 'Client Default',
    'clear-all'                                       => 'Clear All',
    'system_log_is_missing_or_empty'                  => 'System Log is missing or empty',
    'change_to_draft'                                 => 'Change to Draft',
    'invoice_status_change_to_draft'                  => 'Invoice Status Change to Draft',
    'there_is_some_error'                             => 'There Are Some Errors',
    'filter_by_date'                                  => 'Filter By Date',
    'quote_grand_total'                               => 'Quote Grand Total',
    'email_upcoming_payment_due_notice'               => 'Email Upcoming Payment Notice',
    'email_overdue_invoice_reminder'                  => 'Email Overdue Invoice Reminder',
    'page_totals'                                     => 'Page Totals',
    'categories'                                      => 'Categories',
    'conven_charges'                                  => 'Conv. Charges',
    'invoice_status_change_to_cancel'                 => 'Invoice Status Change to Cancel',
    'filter_by_invoice_number'                        => 'Invoice Number',
    'filter_by_client_name'                           => 'Client Name',
    'custom_mail_template'                            => 'Custom Mail Template',
    'invoice_use_custom_mail_template'                => 'Invoice Use Custom Mail Template',
    'client_or_company_name'                          => 'Client/Company Name',
    'view_invoice'                                    => 'View Invoice',
    'tt_active'                                       => 'When a client record is not active, they will not appear in the default client list and normal transactions will not be allowed.',
    'tt_invoice_prefix'                               => 'A unique invoice prefix code is automatically assigned to a client record when it is created. It can be manually changed later. It can be used as part of your document numbering scheme for invoice numbering, allowing for a unique invoice number per client.',
    'tt_automatic_email_payment_receipts'             => 'Sends an emailed payment receipt to the client upon taking a payment. A global setting is available within System Settings, but may be overridden on an individual client basis.',
    'tt_automatic_email_on_recur'                     => 'Sends an emailed invoice to the client when a Subscription is run and creates a live invoice. A global setting is available within System Settings, but may be overridden on an individual client basis.',
    'tt_default_currency'                             => 'The currency assigned to this client account, which  will be used for their invoice, quote and payment transactions. This value is defaulted from the System Setting for Base Currency.',
    'tt_language'                                     => 'The language which will be displayed for the client when they login to the client center.',
    'tt_allow_client_center_login'                    => 'Should the client be allowed to login to your FusionInvoice client center? Their email must be used for their user name and you must assign a password. The client center URL is <your_fusioninvoice_url>/client_center',
    'tt_timezone'                                     => 'Timezone for the client. If entered, the client\'s local time will be displayed at the top of the Client page view.',
    'tt_allow_online_payment_processing_fees'         => 'Online payment processing fees may be assessed for customers paying by credit card, using their public invoice link (included in the invoice email). This option has a global system setting, but may also be overridden on an individual client basis.',
    'tt_allow_child_accounts'                         => 'Setting Allow Child Accounts to Yes enables this client to act as a Parent Account and will allow you to select it from the Parent Accounts list.',
    'tt_third_party_bill_payer'                       => 'A third party bill payer is an organization that pays bills for their clients, such as an external accounting firm.',
    'tt_parent_account'                               => 'The parent business that this client is related to or a subsidiary of. This list contains the client records which have the setting Allow Child Accounts set to Yes. Leave empty if the client has no parent account.',
    'tt_invoices_paid_by'                             => 'The third party business that this client uses to pay their invoices. This list contains the client records which have the setting 3rd Party Bill Payer set to Yes. Leave empty if the client pays their own invoices.',
    'tt_email_default'                                => 'When sending emails to this client, select the email that should be used. If this client has an associated Parent Account or Invoices Paid By account, either of those options may be selected. Default is the standard client email.',
    'tt_default_to'                                   => 'When sending emails, should this contact automatically get added to the \'To:\' recipients list?',
    'tt_default_cc'                                   => 'When sending emails, should this contact automatically get added to the \'CC:\' recipients list?',
    'tt_default_bcc'                                  => 'When sending emails, should this contact automatically get added to the \'BCC:\' recipients list?',
    'tt_client_type'                                  => 'A Lead is an unqualified sales candidate. A Prospect is a qualified candidate who may soon become a customer. A Customer is a business or individual with whom you have sold (or soon will sell) goods or services to. An Affiliate is a business or individual who resells your goods or serices. Other is used for business which do not fit the other types, such as Third Party Bill Payers or Parent Accounts with which you do not do business with directly.',
    'tt_client_tags'                                  => 'Tags can be assigned to a client to help categorize or filter your clients list for viewing or reporting.',
    'tt_important_note'                               => 'A note entered here will automatically pop up within an IMPORTANT! window when the client record is viewed.',
    'tt_gen_header_title_text'                        => 'The text that displays in the upper left corner, next to your logo, usually your company name.',
    'tt_gen_default_company_profile'                  => 'The company profile to use by default when creating new invoices, quotes, etc. Company profiles allow you to present your business differently with each profile, allowing for different company names, logos, invoice formats, etc. ',
    'tt_gen_address_format'                           => 'Allows you to build the address format shown on invoices and quotes by using the single address field or a combination of the individual address fields, such as city, state, country, etc.',
    'tt_gen_custom_fields_columns'                    => 'Custom fields may be displayed from 1 to 3 fields per row.',
    'tt_gen_require_tags_on_client_notes'             => 'If set to Yes, will require that a tag is selected or entered when adding a client note, such as \'Support\' or \'Sales\', This is helpful for categorizing and searching notes.',
    'tt_gen_skin'                                     => 'How would you like your FI UI shown, Light or Dark mode',
    'tt_gen_top_bar_color'                            => 'The color of the top title bar. If you work with several different FusionInvoice installations, this can be a helpful visual identification.',
    'tt_gen_results_per_page'                         => 'The number of records shown per page for all list views, such as clients, invoices, quotes, expenses, etc.',
    'tt_gen_allow_line_item_discounts'                => 'Enables or disables the line item discounting feature within invoices and quotes.',
    'tt_gen_language'                                 => 'The language to be used for your FusionInvoice installation. Note that you can assign a different language for your clients, allowing them to interact with the FusionInvoice Client Center using their native language.',
    'tt_gen_date_format'                              => 'Your preferred date format',
    'tt_gen_use_24_hour_time_format'                  => 'Allows for support of 24 or 12 hour hour time formats.',
    'tt_gen_timezone'                                 => 'Your business\' primary timezine.',
    'tt_gen_base_currency'                            => 'The currency that your business uses most often.',
    'tt_gen_exchange_rate_mode'                       => 'Manual allow you to enter the exchange rate value as you are creating invoices. Automatic will attempt to use a public API to fetch the curreny exchange rate. This is only used when you are entering a transaction using a currency different from your base currency.',
    'tt_gen_number_of_tax_fields'                     => 'FusionInvoice supports up to 2 tax fields per line item. The value selected with show or hide the second tax field.',
    'tt_gen_quantity_price_decimals'                  => 'The number of decimals to show for quantity and amount values. Select 0 to 4 based on your required accuracy level.',
    'tt_gen_round_tax_decimals'                       => 'Select your required number of decimals for tax rounding calculations.',
    'tt_gen_use_captcha_in_login'                     => 'If set to Yes, will requires your users to answer a CAPTCHA challenge question during login.',
    'tt_gen_force_https'                              => 'We rarely recommend turning this option on. If your installation does not have a properly functioning SSL certificate installed on your webserver, for your FusionInvoice installation, you may experience problems. You can accomplish the same result by setting up a server redirect rule.',
    'dashboard_settings'                              => 'Dashboard Settings',
    'tt_dashboard_settings'                           => 'The dashboard is used to display important business metrics and events, providing valuable insight into your company\'s performance. The System Default dashboard is the starting point for all users, however each use can have their own User Specific dashboard. User Specific dashboards, if defined, will display in place of the system default.',
    'tt_db_default_time_period'                       => 'Sets the default begining and ending dates for dashboard widgets that use them, such as KPI Cards and the Sales Graph.',
    'tt_db_recent_client_activity'                    => 'A widget that shows client interactions, such as payments made and invoices or quotes viewed, from your public invoice or quote links.',
    'tt_db_display_order'                             => 'This changes the order of display for dashboard widgets. 1 will display at the top, 2 will display after 1, etc.',
    'tt_db_column_width'                              => 'Dashboard widgets use the Bootstrap grid system, and have a maximum column width of 12. Setting the column width to 12 will cause the widget use the entire width available. Setting it to 6 will allow two widgets to share the same row, 4 will allow 3 widgets to share the same row, etc.',
    'tt_db_accumulate_totals'                         => 'Setting this value on will cause your graph to include the prior days totals for each day. For example, sales for day 1 were $100, day 2 were $50, day 3 were $125. The graph would show a rising line with this option set to Yes. Set to No, would show a dip in the sales line on day 2 and increase to day 3.',
    'tt_db_kpi_cards'                                 => 'These color coded cards display key performance indicators at the top of your dashboard.',
    'tt_db_sales_chart'                               => 'A line graph chart, displaying invoice and payment totals.',
    'tt_db_task_list'                                 => 'This widget allow you to work with the Task List module, directly from your dashboard.',
    'tt_db_task_list_include_time'                    => 'Setting this option on allows you to specify date and time for due dates when working with tasks. When set to No only the date value is used.',
    'tt_db_timeline'                                  => 'The timeline widget displays a chronological and searchable list of important sysytem events, such as client status changes, invoices emailed, payments taken, notes taken, etc.',
    'tt_ss_invoices_default_invoice_template'         => 'Select the template that will be used, by default, when creating new invoices. Custom templates should be placed in .\custom\templates\invoice_templates\ and must be named with a .blade.php extension.',
    'tt_ss_invoices_default_doc_scheme'               => 'Select the document number scheme to be used, by default, when creating new invoices. Document number schemes can be created within Configuration Settings, and allow you to personalize your document numbers (invoices, quotes, credit memos).',
    'tt_ss_invoices_invoice_due_days'                 => 'The default number of days, past the invoice (creation) date, that the invoice will come due and is expected to be paid.',
    'tt_ss_invoices_automatic_email_ri'               => 'When a Subscription is run and generates a live invoice, should that live invoice automatically be emailed to the client?',
    'tt_ss_invoices_qr_code'                          => 'Should a QR code be automatically placed on the default invoices and quotes. If you are using custom invoice or quote templates, refer to the default templates to add the QR code to your custom templates.',
    'tt_ss_invoices_if_emailed_in_draft'              => 'If an invoice is in Draft status and is emailed, either manually or automatically, what should happen to the invoice date. Important note: When an invoice is emailed, the status will automatically be changed from Draft to Sent.',
    'tt_ss_invoices_recalculate'                      => 'Runs every transaction made for each invoice, from the date it was created to the current date, and recalculates the totals, line item totals, taxes, discounts and invoice totals. This can take a long time to run if you have a large dataset.',
    'tt_ss_invoices_due_after'                        => 'The due date of the invoice will be the invoice date plus the number of days entered here.',
    'tt_ss_invoices_default_status_filter'            => 'This controls the filter setting of the invoices listed, by default, in the Invoice module\'s invoices list.',
    'tt_ss_invoices_default_terms'                    => 'The default text value for invoice terms when a new invoice is created.',
    'tt_ss_invoices_default_footer'                   => 'The default text value for invoice footer when a new invoice is created.',
    'tt_ss_invoices_automatic_email_on_recur'         => 'When the daily task runner (CRON job) executes and generates a live invoice from a Subscription template, should that newly created invoice be automatically emailed to the client? This can be overridden on a client by client basis.',
    'tt_ss_invoices_automatic_email_payment_receipts' => 'When a payment is made, by a client using a public invoice link, or by a FusionInvoice user within the application, should a payment receipt email be automatically sent? This can be overridden on a client by client basis.',
    'tt_ss_invoices_online_payment_method'            => 'When a client pays, using a public invoice link, this is the Payment Method that will be recorded on the payment entry.',
    'tt_ss_invoices_qr_code_on_invoice_quote'         => 'Should a QR Code, which routes to the Invoice\'s or Quote\'s public URL, be displayed on the document?',
    'tt_ss_invoices_allow_invoice_delete'             => 'Allowing users to delete invoices can cause accountability and traceability problems. A better option is to change an invoice status to \'Cancelled\' which zeros the invoice balance, but maintains a record of the invoice having been created.',
    'tt_ss_invoices_show_invoices_from'               => 'When an invoice is emailed, this will determine the \'mail from\' address. Either the user who created the invoice or the System Settings -> Email value.',
    'tt_ss_invoices_if_emailed_while_draft'           => 'From the invoice view, if the invoice is in Draft status and emailed, should the invoice date remain unchanged or change to the current date? If the invoice date changes, the due date is also updated.',
    'tt_ss_quotes_default_quote_template'             => 'Select the template that will be used, by default, when creating new quote. Custom templates should be placed in .\custom\templates\quote_templates\ and must be named with a .blade.php extension.',
    'tt_ss_quotes_default_doc_scheme'                 => 'Select the document number scheme to be used, by default, when creating new quotes. Document number schemes can be created within Configuration Settings, and allow you to personalize your document numbers (invoices, quotes, credit memos).',
    'tt_ss_quotes_expire_days'                        => 'The default number of days, past the quote (creation) date, that the quote will expire. When a quote has passed its expiration date, it is understood that pricing may change due to market fluctuations, etc.',
    'tt_ss_quotes_default_status_filter'              => 'The status filter to be applied, by default, when viewing the invoices list.',
    'tt_ss_quotes_auto_convert'                       => 'When a quote is approved, should this cause an invoice to be automatically created from the quote.',
    'tt_ss_quotes_when_converted_action'              => 'When a quote is converted to an invoice, should the payment terms be used from the quote or from the default invoice terms setting?',
    'tt_ss_quotes_default_terms'                      => 'The terms text value which is displayed, on the default quote template, at the bottom area of the quote, within the Terms and Conditions area.',
    'tt_ss_quotes_default_footer'                     => 'Footer text value which is displayed, on the default quote template, at the bottom of the quote. For example: "We look forward to working with you!"',
    'tt_ss_quotes_if_emailed_in_draft'                => 'If a quote is in Draft status and is emailed, either manually or automatically, what should happen to the quote date. Important note: When an quote is emailed, the status will automatically be changed from Draft to Sent.',
    'tt_ss_quotes_recalculate'                        => 'Runs every transaction made for each quote, from the date it was created to the current date, and recalculates the totals, line item totals, taxes, discounts and quote totals. This can take a long time to run if you have a large dataset.',
    'tt_ss_taxes_default_rate1'                       => 'The primary tax rate that should be automatically applied to new line items added to invoices or quotes. Tax rates are maintained through Configuration -> Tax Rates.',
    'tt_ss_taxes_default_rate2'                       => 'The secondary tax rate that should be automatically applied to new line items added to invoices or quotes. Tax rates are maintained through Configuration -> Tax Rates. Note: within System Settings -> General, you may select to display 1 or 2 tax fields on invoices and quotes.',
    'tt_ss_email_send_method'                         => 'The email sending method that FusionInvoice should use. Changing the sending method also changes the display of the supporting fields for the sending method.',
    'tt_ss_email_allow_self_cert'                     => 'Turning this option on sets the PHP verify_peer requirement off. For more information search the internet for: PHP email self-signed certificate openssl.cafile',
    'tt_ss_email_reply_to'                            => 'When sending emails, this is the default Reply To address that your recipients will see.',
    'tt_ss_email_always_cc'                           => 'An email address which, by default, you would like to automatically CC with each email sent.',
    'tt_ss_email_always_bcc'                          => 'An email address which, by default, you would like to automatically BCC with each email sent.',
    'tt_ss_email_send_test_to'                        => 'The email address to be used when clicking the Send Test Email button.',
    'tt_ss_email_mail_from_addr'                      => 'The default Mail From address to be used when emails are sent from FusionInvoice. Note: within System Settings -> Invoices, you may select to have invoices emails sent from this (system) address or the user that created the invoice.',
    'tt_ss_email_mail_from_name'                      => 'The Mail From friendly name to be shown on emails sent.',
    'tt_ss_email_email_templates'                     => 'Email templates are available for many documents and events, these include: quotes, quote approvals, quote rejections, invoices, invoices becoming overdue, credit memos, payment receipts, upcoming payment notices. A default template is included, but you may also create custom templates, which can be simple (like the provided default templates) or fully formatted HTML.',
    'tt_ss_pdf_driver'                                => 'The driver to use when creating PDF documents. Selecting the \'wkhtmltopdf\' driver requires a local server installation of this program and setting the appropriate binary path for it.',
    'tt_ss_pdf_binary_path'                           => 'The local server path to the binary file for wkhtmltopdf. For example C:\\wkhtmltopdf\\bin\\wkhtmltopdf.exe',
    'tt_ss_olp_about'                                 => 'FusionInvoice supports several online payment providers. Enable the providers with whom you have established accounts. The providers enabled here will be displayed as payment options, when your clients view their invoices using the public invoice link (included in the default invoice email).',
    'tt_ss_olp_api_key'                               => 'The API key is provided to you by your payment provider.',
    'tt_ss_olp_payment_button_text'                   => 'The text that is displayed on the payment method button for this payment provider, at the top of your public invoice, as viewed by your clients.',
    'tt_ss_olp_mode'                                  => 'Supported by some payment providers, allowing for Sandbox more (testing) and live.',
    'tt_ss_olp_client_id'                             => 'The Client ID is provided to you by this payment provider.',
    'tt_ss_olp_client_secret'                         => 'The Client Secret is provided to you by this payment provider.',
    'tt_ss_olp_publishable_key'                       => 'The Publishable Key is provided to you by this payment provider.',
    'tt_ss_olp_secret_key'                            => 'The Secret Key is provided to you by this payment provider.',
    'tt_ss_olp_opp_fees_about'                        => 'Online payment processing fees may be assessed for customers paying by credit card, using their public invoice link (included in the invoice email).',
    'tt_ss_olp_enable_opp_fees'                       => 'Online payment processing fees may be assessed for customers paying by credit card, using their public invoice link (included in the invoice email). This option has a global system setting, but may also be overridden on an individual client basis.',
    'tt_ss_olp_opp_fee_pct'                           => 'The percentage of the invoice total to be charged as the online payment processing (convenience) fee.',
    'tt_ss_olp_opp_fee_name'                          => 'The fee name to be shown on the invoice. Ie. \'Credit Card Convenience Fee\'.',
    'tt_ss_olp_opp_fee_explanation'                   => 'An explanation of the fee to be displayed on the invoice. Ie. \'A 3% fee is assessed for all credit card transactions\'',
    'tt_company_profiles_about'                       => 'Company profiles allow you to present your business differently with each profile, allowing for different company names, logos, invoice formats, etc.  It provides a way to have multiple virtual companies within the same FusionInvoice installation. A default company profile must be selected within System Settings.',
    'tt_users_about'                                  => 'You can create users of type Admin (full access) or Standard (individual system permissions must be granted).  Setting the \'Allow Client Center Login\' to Yes for a client record will automatically add a User record for the client, however, Client users may only be added using the Client settings interface.',
    'tt_users_client_about'                           => 'Client users may only login to the Client Center, which allows them a limited view of their invoices, quotes and payments. Setting the \'Allow Client Center Login\' to Yes for a client record, will grant them access to the Client Center.',
    'tt_user_types_about'                             => 'Admin users have full system access.  Standard users may be granted the individual permissions that they require. Client users only have access to their specific information within the Client Center and their ability to login is set within Client Settings -> \'Allow Client Center Login\'',
    'tt_custom_fields_about'                          => 'Custom fields allow you to add your own data fields to most modules. If you needed to capture the industry for clients, simply add a custom field labeled \'Industry\' within the Clients page, making it a Dropdown type. Custom fields display automatically below the normal fields.',
    'tt_recurring_invoices_about'                     => 'Subscriptions are not actually invoices, but rather templates for creating future invoices. They have a recurrence frequency and Next Date which determine when they will generate a live invoice. A daily CRON job or scheduled task is required for Subscriptions to work properly.',
    'tt_addons_about'                                 => 'Addons are customizations to FusionInvoice for a unique business needs, such as time-tracking, pricing furmulas or sylized invoice templates. They are offered through the FusionInvoice add-on marketplace.',
    'client_center_user'                              => 'Client Center User',
    'user_type'                                       => 'User Type',
    'custom_field'                                    => 'Custom Field',
    'placeholder_type_email_template'                 => 'Type or paste your email template . . . ',
    'email_templates'                                 => 'Email Templates',
    'payment_receipts'                                => 'Payment Receipts',
    'upcoming_payment_notices'                        => 'Upcoming Payment Notices',
    'convenience_fee_for_credit_card_transactions'    => 'Convenience Fee for Credit Card Transactions',
    'credit_card_processing_fee'                      => 'Credit Card Processing Fee',
    'delete_client_user_warning'                      => '<p>Deleting a client user will disable their ability to login to the client center.</p>',
    'use_default_mail_template'                       => 'Default Mail Template',
    'use_custom_mail_template'                        => 'Custom Mail Template',
    'quote_email_body'                                => 'Quote Email Body',
    'overdue_invoice_email_body'                      => 'Overdue Invoice Email Body',
    'credit_memo_email_body'                          => 'Credit Memo Email Body',
    'payment_receipt_body'                            => 'Payment Receipt Body',
    'invoice_email_body'                              => 'Invoice Email Body',
    'quote_custom_email_body_require'                 => 'Please enter your custom email template for quote email body',
    'quote_custom_approve_email_body_require'         => 'Please enter your custom email template for quote approve email body',
    'quote_reject_email_body_require'                 => 'Please enter your custom email template for quote reject email body',
    'overdue_invoice_email_body_require'              => 'Please enter your custom email template for overdue invoice email body',
    'invoice_email_body_require'                      => 'Please enter your custom email template for invoice email body',
    'credit_memo_email_body_require'                  => 'Please enter your custom email template for credit memo email body',
    'payment_receipt_email_body_require'              => 'Please enter your custom email template for payment receipt email body',
    'upcoming_payment_notice_email_body_require'      => 'Please enter your custom email template for upcoming payment notice email body',
    'copy_text'                                       => 'Copy Text',
    'tt_preview_template'                             => 'Preview Template',
    'tt_view_template_code'                           => 'View Template Code',
    'dashboard_date_range'                            => 'Dashboard Date Range',
    'tt_dashboard_date_range'                         => 'Dashboard Date Range filters the view for the following widgets: KPI Cards, Sales Chart, Recent Client Activity.',
    'product_copy'                                    => 'Product Copy',
    'open_selected_client'                            => 'Open Selected Client',
    'save_this_client'                                => 'Save This Client (not a duplicate)',
    'looks_like_duplicate'                            => 'Hmm... This looks like a duplicate',
    'duplicate_instructions'                          => 'If you see the client you wanted in the list, select and open it. If not, save the new client.',
    'select_checkbox'                                 => 'Select a client',
    'select_lead_source_tag'                          => 'Select Client Lead Source',
    'lead_source'                                     => 'Lead Source',
    'tt_client_lead_source_tags'                      => 'Select or enter client lead source (how the client was acquired)',
    'your_link_is_expired'                            => 'Oops! Your link has expired.',
    'page_expire_return_to_dashboard'                 => 'We could not find the page you were looking for. <a href=":dashboard_link">Return to dashboard</a>.',
    'secure_link_and_expire_link_days'                => 'Secure and Expire Public Invoice Links',
    'secure_link_expire_days'                         => 'Number of days',
    'tt_secure_link_and_expire_link_days'             => 'When enabling secure links you must also set the number of days after which the invoice link will expire. By doing this, a client may view their public invoice link until it expires.',
    'expire_time_period'                              => 'Link Expire Number of Days field is required',
    'enter_days'                                      => 'Enter Days',
    'invalid_field_name'                              => 'Please enter a valid field name',
    'lead_source_notes'                               => 'Lead Source Notes',
    'important_note'                                  => 'Important Note',
    'social_media_url'                                => 'Social Media URL',
    'general_notes'                                   => 'General Notes',
    'payment_amount_mismatch'                         => 'Payment Amount Mismatch',
    'open_invoice_aging'                              => 'Open Invoice Aging',
    'tt_db_open_invoice_aging'                        => 'Open Invoice Aging',
    'current'                                         => 'Current',
    'oneToThirty'                                     => '1-30 Days',
    'thirtyOneToSixty'                                => '31-60 Days',
    'sixtyOneToNinety'                                => '61-90 Days',
    'ninetyOnePlus'                                   => '91+ Days',
    'sent_and_draft'                                  => 'Include both Sent And Draft Invoices',
    'sent_only'                                       => 'Include only Sent Invoices',
    'tt_open_ar_aging_settings'                       => 'Settings for Open Invoice Aging Totals',
    'tt_client_field_settings'                        => 'Select the fields you would like displayed on your client view',
    'position_change'                                 => 'Position changed',
    'dynamic_width'                                   => 'Dynamic width',
    'full_width'                                      => 'Full width',
    'save_configuration_default'                      => 'Save configuration as system default',
    'assign_configuration_other'                      => 'Assign configuration to other users',
    'tt_user_tags'                                    => 'User Tags',
    'select_users'                                    => 'Select Users',
    'configuration_assigned'                          => 'Configuration assigned successfully',
    'default_configuration_set'                       => 'Default configuration set successfully',
    'current_user_id'                                 => 'Current user id',
    'tt_users_settings'                               => 'Users settings',
    'invoice_link_expire'                             => 'Your invoice public link will expire in <strong> :days </strong> days',
    'quote_link_expire'                               => 'Your quote public link will expire in <strong> :days </strong> days',
    'dashboard_width'                                 => 'Dashboard :widthName column width setting changed',
    'unmark_mailed'                                   => 'Un-mark as mailed',
    'invoice_unmark_mailed'                           => 'Invoice un-mark as mailed',
    'print_mark_mailed'                               => 'Print & Mark as Mailed',
    'public_link'                                     => 'Public Link',
    'tt_sales_chart_settings'                         => 'Setting for sales chart invoice/total',
    'verify_key'                                      => 'Product Key Verification',
    'enter_key'                                       => 'Enter your key',
    'verify'                                          => 'Verify it!',
    'key_required'                                    => 'Product key is required',
    'key_length_invalid'                              => 'Please enter the 32 character product key provided at the time of purchase.',
    'invalid_key'                                     => 'Sorry, your key is invalid. The installation cannot proceed.',
    'key_verified'                                    => 'Congratulations, your key has been verified.',
    'clear_cache'                                     => 'Clear Cache',
    'clear_cache_confirm'                             => 'Are you sure you want to clear your application cache?',
    'cache_clear_success'                             => 'Cache successfully cleared. ',
    'cache_clear_error'                               => 'Please check your server configuration for PHP exec() command.',
    'add_new_client'                                  => 'Add new client',
    'add'                                             => 'Add',
    'invalid_quantity_amount'                         => 'Invalid Quantity Amount! Must be greater than 0.',
    'api_version'                                     => 'API Version',
    '2021_prior'                                      => '2021 and Prior',
    '2022_later'                                      => '2022 and Later',
    'vendors'                                         => 'Vendors',
    'file_not_found'                                  => ':file_name is not found',
    'leave_empty_no_parent_account'                   => 'leave empty if client has no parent account',
    'leave_empty_client_pays_invoices'                => 'leave empty if client pays their own invoices',
    'modal_not_found'                                 => 'Modal not found',
    'payment_delete_success'                          => 'Payment deleted successfully',
    'payment_delete_error'                            => 'There was problem deleting the payment, Please try again later.',
    'status_change_error'                             => 'Something went wrong! Status was not changed.',
    'total_payments'                                  => 'Total Payments',
    'licence_verification_error'                      => 'Unable to verify your license key.',
    'line_item_discount_limit'                        => 'Line items may not have a discount more than 99.99%.',
    'date_range_report'                               => 'Date Range (next date to run)',
    'no_client_found'                                 => 'Hmmm… we couldn’t find that client.',
    'tt_line_item_discount'                           => 'A line item discount may be calculated by a percentage of the price or a flat amount for the individual item price.',
    'functionality_not_available_on_demo'             => 'Sorry, that function isn’t allowed in the demo.',
    'vat_tax_id'                                      => 'VAT ID',
    'tt_vat_tax_id'                                   => 'Value added tax (VAT) number',
    'enable_vat_tax_id'                               => 'Enable VAT ID',
    'no-attachment'                                   => 'There is no attachment',
    'csv'                                             => 'CSV',
    'clean_up'                                        => 'Clean Up',
    'allow_edit_status_invoice'                       => 'Edit :status Invoice',
    'tt_ss_allow_edit_invoices_status'                => 'As a security precaution, only invoices in Draft status may be edited. You may override this by allowing editing of Sent and/or Paid invoices.',
    'allow_edit_invoices_status'                      => 'Allow editing of invoices in status',
    'draft_and_sent'                                  => 'Draft And Sent',
    'draft_or_sent_and_paid'                          => 'Draft, Sent And Paid',
    'invoice_editable'                                => 'Invoice Editable',
    'can_not_edit_paid_invoice'                       => 'You can not edit a paid invoice',
    'item_category'                                   => 'Item Category',
    'itemLookups'                                     => 'Item Lookups',
    'quoteItems'                                      => 'Quote Items',
    'invoiceItems'                                    => 'Invoice Items',
    'imports_disabled_in_demo.'                       => 'Imports are disabled in the demo.',
    'no_file_selected'                                => 'No file selected',
    'no_import_records'                               => 'No records were found to import',
    'vendor_name'                                     => 'Vendor Name',
    'license_key'                                     => 'License Key',
    'change_license_key'                              => 'Change License Key',
    'verify_and_save'                                 => 'Verify & Save',
    'same_key_error'                                  => 'No change detected. Please try a different key',
    'trying_invalid_key'                              => 'Sorry, that key could not be verified. License key was not changed.',
    'key_updated'                                     => 'Congratulations! Your license key was successfully updated.',
    'invalid_date_format'                             => 'Invalid Date Format. Required format: YYYY-MM-DD',
    'invalid_datetime_format'                         => 'Invalid DateTime Format. Required format: YYYY-MM-DD HH:MM:SS',
    'profile_setting'                                 => 'Profile Settings',
    'include_draft_invoices_unpaid_and_overdue'       => 'Include Draft Invoices in Unpaid and Overdue Lists',
    'tt_ss_include_draft_invoices_unpaid_and_overdue' => 'If set to Yes, invoices with a status of Draft will be included in lists and calculations for Overdue and Unpaid invoices.',
    'tt_utilities_import'                             => 'Import data from CSV files into your FusionInvoice database.',
    'tt_utilities_export'                             => 'Export data from your FusionInvoice database into a number of different formats: CSV, XLS, XML, JSON',
    'tt_utilities_mail_log'                           => 'View the log file that holds all email events within FusionInvoice.',
    'tt_utilities_system_log'                         => 'View the system log file containing error and warning system events.',
    'tt_utilities_tag_cleanup'                        => 'Removes tags which were defined, but not used. Also removes any duplicated tags.',
    'tt_utilities_pdf_cleanup'                        => 'Removes temporary PDF files.',
    'tt_utilities_recalc_invoices'                    => 'Scans through each invoice, ensuring the totals match the sum of all line items, taking discounts and tax into account. *This can take a long time.',
    'tt_utilities_recalc_quotes'                      => 'Scans through each quote, ensuring the totals match the sum of all line items, taking discounts and tax into account. *This can take a long time.',
    'tt_utilities_clear_cache'                        => 'Removes temporary cache files.',
    'tt_utilities_download_database'                  => 'Download an exported database file from your live FusionInvoice data. The larger your database, the longer this will take.',
    'tt_utilities_run_daily_tasks'                    => 'A CRON job or scheduled task normally runs your daily tasks. This allows you to do it manually. It generates live invoices from Subscription templates, sends payment reminders, etc.',
    'include_line_item_detail'                        => 'Include Line Item Details',
    'invoice_tags'                                    => 'Invoice Tags',
    'related_accounts'                                => 'Related Accounts',
    'not_found_related_clients'                       => 'No related client accounts have been assigned',
    'invoices_paid_for_list'                          => 'This client account pays invoices for',
    'child_accounts_exist'                            => 'Allow Child Accounts setting reverted to Yes. Unable to change to No when child accounts exist.',
    'third_bp_accounts_exist'                         => '3rd Party Bill Payer setting reverted to Yes. Unable to change to No when related accounts exist.',
    'tag_name'                                        => 'Tag Name',
    'tag_new_name'                                    => 'New Tag Name',
    'tag_category'                                    => 'Tag Category',
    'rename_tags'                                     => 'Rename Tags',
    'apply'                                           => 'Apply',
    'select_tag_category'                             => 'Select Tag Category',
    'tt_utilities_rename_tags'                        => 'Rename tags assigned to clients, notes, sales activities, etc.',
    'system_default_dashboard'                        => 'System Default Dashboard',
    'user_specific_dashboards'                        => 'User Specific Dashboards',
    'tt_default_client_type'                          => 'Default Client Type',
    'default_client_type'                             => 'Default Client Type',
    'invalid_user'                                    => 'Please select a valid user.',
    'create_live_invoice'                             => 'Create Live Invoice',
    'create_live_invoice_successfully'                => 'Live invoice <strong> :number </strong> was created',
    'create_live_invoice_unsuccessfully'              => 'Live invoice was not created',
    'live_invoice_not_generate'                       => 'Cannot generate a live invoice from a Subscription that has a Stop Date of today or prior, or a Next Date more than 30 days in the future.',
    'data_seeder'                                     => 'Data Seeder',
    'select_module'                                   => 'Select Module',
    'number_of_seed'                                  => 'Number of Seeds',
    'seed_it'                                         => 'Seed It!',
    'seeds_success'                                   => 'Seeds added successfully',
    'tt_ri_generate_the_next_live_invoice'            => 'Generate the next live invoice for this Subscription right now.',
    'system_log_clear_message'                        => 'Are you sure you want to clear the system log? This action cannot be undone and all previous logs will be permanently deleted.',
    'system_log_clear_successfully'                   => 'System Log cleared Successfully',
    'payment_problem'                                 => 'A problem occurred during the payment. Please try again later.',
    'log_detail'                                      => 'Click here to view detail log.',
    'log_limit_message'                               => 'Log file >:size M, please download it.',
    'log_download_file'                               => 'Download file',
    'log_delete_all'                                  => 'Delete all files',
    'log_level'                                       => 'Level',
    'log_context'                                     => 'Context',
    'log_date'                                        => 'Date',
    'log_line_number'                                 => 'Line number',
    'log_content'                                     => 'Content',
    'addon_install_error'                             => 'There was a problem with addon installation, Please try again later.',
    'addon_installed_success'                         => 'Addon successfully installed.',
    'allow_edit_status_credit_memo'                   => 'Edit Applied Credit Memo',
    'database_seeder'                                 => 'Seeder',
    'tt_utilities_database_seeder'                    => 'Seed your database with test data using seed classes',
    'vat_information'                                 => 'VAT Information',
    'tt_vat_information'                              => 'IBAN Bank Account Number, BIC, Email etc ...',
    'explore_addons'                                  => 'Explore Addons',
    'available_addons'                                => 'Available FusionInvoice Addons',
    'addon_success'                                   => 'Addon was successfully added.',
    'payment_cannot_enabled_in_demo'                  => 'Payment gateways cannot be enabled in the demo',
    'confirm_approve_leave_page'                      => 'There are unsaved changes on this page! Are you sure you want to leave without saving?',
    'leave'                                           => 'Leave',
    'demo_date_refresh'                               => 'Demo data will be refreshed in',
    'minutes'                                         => 'minutes',
    'minute'                                          => 'minute',
    'seconds'                                         => 'seconds',
    'mautic-authentication-fail'                      => 'You are not authorized to access this resource, Please use valid secret key.',
    'something_went_wrong'                            => 'Something went wrong!',
    'month_to_date'                                   => 'This Month To Date ',
    'quarter_to_date'                                 => 'This Quarter To Date',
    'year_to_date'                                    => 'This Year To Date',
    'last_active'                                     => 'Last Active',
    'database_seeder_stop'                            => ':name BUSINESS SEEDER STOP',
    'database_seeder_start'                           => ':name BUSINESS SEEDER START',
    'seeder_records_created'                          => ':total Records Created Successfully For :modal',
    'seeder_credit_apply_invoice'                     => 'Credit Memo Apply To Invoice',
    'seeder_quote_approve_reject'                     => 'Quote Approve And Reject',
    'seeder_executed'                                 => 'Seeder executed successfully!',
    'seeder_not_executed'                             => 'Seeder was not executed!',
    'db_to_file_system_attachments_migration'         => 'Attachments Migration - Database to File System',
    'attachment_content_count'                        => 'You are about to migrate a total of  <strong style="color: #b22222 !important;"> :number </strong> attachments from your database to disk',
    'attachment_repeat_content_count'                 => 'You are about to migrate a total of  <strong style="color: #b22222 !important;"> :number1 </strong> attachments from your database to disk and <strong style="color: #42b602 !important;"> :number2 </strong> were already migrated successfully.',
    'attachment_key_invalid'                          => 'Attachment key is invalid',
    'stop'                                            => 'Stop!',
    'attachment_migration_warning'                    => 'This step will migrate the attachments from your database to your file system, please perform a full database backup before proceeding and ensure that you have sufficient disk space to perform this operation.',
    'attachment_agreement_accept'                     => 'I have backed up my database.',
    'microsoft365'                                    => 'Microsoft 365',
    'office365_password'                              => 'Microsoft 365 Password',
    'office365_username'                              => 'Microsoft 365 Username',
    'custom_date_formula_note1'                       => '<b><u>Default Value Placeholders:</u></b> <br>You can use <b>today, tomorrow and, yesterday</b> any one value as default. <br>',
    'custom_date_formula_note2'                       => '<b>For today + N days, use </b> \'default\': \'+7\' This adds 7 days to today\'s date <br><b>For today - N days, use </b> \'default\': \'-7\' This will subtract 7 days from today\'s date <br>',
    'mail_config_error'                               => 'Cannot send a test email without the Email Sending Method defined.',
    'db_prefix_alert'                                 => 'We noticed that you are using a database prefix of :prefix.  FusionInvoice will not support database prefixes in future versions. Please edit your database and rename all of your tables, by removing the prefix, then edit your database.php file and set your \'prefix\' value to empty',
    'db_prefix_alert_title'                           => 'Support for DB Prefixes Ending Soon',
    'add_title_bar_shortcut'                          => 'Add Title Bar Shortcut',
    'title_bar_shortcuts'                             => 'Title Bar Shortcuts',
    'select_icon'                                     => 'Select Icon',
    'all_payment_method'                              => 'All payment method',
    'about'                                           => 'About',
    'own_license'                                     => 'Own License',
    'tt_own_license'                                  => 'Own License',
    'git_branch'                                      => 'Git Current Branch',
    'quote_email'                                     => 'Quote Email',
    'custom1'                                         => 'Custom 1',
    'custom2'                                         => 'Custom 2',
    'custom3'                                         => 'Custom 3',
    'default_document_template'                       => 'Default Document Template',
    'default_email_template'                          => 'Default Email Template',
    'sms'                                             => 'Sms',
    'pricing_formula'                                 => 'Pricing Formula',
    'is_mobile'                                       => 'Is Mobile?',
    'default_sms_template'                            => 'Default SMS Template',
    'sms_log'                                         => 'SMS Log',
    'two_factor_auth'                                 => 'Two-Factor Authentication',
    'enabled_mail_driver'                             => 'Please enable email service',
    'otp'                                             => 'OTP',
    'invalid_otp'                                     => 'Invalid Verification Code',
    'otp-subject'                                     => 'Login OTP',
    'resend_otp_success'                              => 'Verification Code Resent',
    'resend_otp_btn'                                  => 'Resend Code',
    'expired_otp'                                     => 'Verification Code Expired',
    'token_expired'                                   => 'Your CSRF token is expired',
    'verification_code'                               => 'Verification Code',
    'migration'                                       => 'Migration',
    'invoice_status_change_draft_to_sent'             => 'Invoice status changed from draft to sent',
    'default_sales_quantity'                          => 'Default Sales Quantity',
    'lead_time'                                       => 'Avg. Lead Time (days)',
    'primary_vendor_id'                               => 'Preferred Vendor',
    'all_items'                                       => 'All Items',
    'non_inventory_items'                             => 'Non-inventory Items',
    'back_ordered'                                    => 'Back Ordered',
    'low_inventory'                                   => 'Low Inventory',
    'high_inventory'                                  => 'High Inventory',
    'merge_client_records'                            => 'Merge Client Records',
    'primary_merge_to_client'                         => 'Merge Into (keep)',
    'surrogate_merge_from_client'                     => 'Merge From (discard)',
    'merge'                                           => 'Merge',
    'merge_action'                                    => 'Merge Action',
    'ignore'                                          => 'Ignore',
    'overwrite'                                       => 'Overwrite',
    'add_to'                                          => 'Add To',
    'select_merge_client'                             => 'Select For Merge',
    'client_to_and_from_not_same'                     => 'The client to and client from must be different.',
    'client_id_required'                              => 'The client select field must be both required and unique.',
    'is_merge'                                        => 'Merge',
    'record_successfully_merged'                      => 'Record successfully merged',
    'service_ends'                                    => 'Service Ends',
    'service_starts'                                  => 'Service Starts',
    'explanation'                                     => 'Explanation',
    'subscription_details'                            => 'Subscription Details',
    'generate_next_invoice'                           => 'Generate Next Invoice',
    'subscription'                                    => 'Subscription',
    'of_the'                                          => 'Of The',
    'on'                                              => 'On',
    'invoice_month'                                   => 'Invoice Month',
    'invoice_year'                                    => 'Invoice Year',
    'next_month'                                      => 'Next Month',
    'next_year'                                       => 'Next Year',
    'day'                                             => 'Day',
    'last_date'                                       => 'Last Date',
    'merge_record_warning'                            => 'Stop! Merging client accounts cannot be undone. In addition to the fields that you selected to overwrite or add-to, all transaction history for the merge-from client will be transferred to the merge-to client. Are you sure you want to merge these client accounts?',
    'merge_child_account_warning'                     => 'The Merge(From) client has a parent account with related child accounts that will be reassigned to the Merge(To) client, Please ensure Merge(To) client is allowed as a parent account.',
    'merge_parent_account_warning'                    => 'Merging will remove your association with the parent account.',
    'merge_invoices_paid_by_warning'                  => 'Merging will remove your association with the parent invoice paid by.',
    'merge_third_party_bill_payers_warning'           => '',
    'merge_relationships_warning'                     => 'The number of relationships in the Client model has changed.',
    'payment_terms'                                   => 'Payment Terms',
    'net_amount_due_in'                               => 'Net amount due in',
    'net_amount_due_by'                               => 'Net amount due by',
    'if_paid_within'                                  => 'if paid within',
    'if_paid_by'                                      => 'if paid by',
    'th_of_next_month'                                => 'th of next month',
    'of_next_month'                                   => 'of next month',
    'down_payment'                                    => 'Down payment',
    'balance_amount_due_of'                           => 'balance amount due in',
    'payment_split_over'                              => 'Payment split over',
    'installments'                                    => 'installments',
    'days_from_invoice_date'                          => 'days from invoice date',
    'payment'                                         => 'Payment',
    'one'                                             => 'One',
    'two'                                             => 'Two',
    'three'                                           => 'Three',
    'four'                                            => 'Four',
    'five'                                            => 'Five',
    'six'                                             => 'Six',
    'discount_percent'                                => 'Discount Percent',
    'discount_days_simple'                            => 'Discount Days Simple',
    'discount_days_nth'                               => 'Discount Days Nth',
    'net_due_days'                                    => 'Net Due Days',
    'balance_due_days'                                => 'Balance Due Days',
    'number_of_installments'                          => 'Number Of Installments',
    'payment_term'                                    => 'Payment Term',
    'select_payment_term'                             => 'Select Payment Term',
    'payment_terms_error'                             => [
        'installment_percent_error'                   => 'The Installment percent :index field is required and greater then zero.',
        'installment_due_days_error'                  => 'The Installment due days :index filed is required',
        'discount_percent_gt_error'                   => 'The Discount percent filed is required and greater then zero.',
        'discount_percent_lt_error'                   => 'The Discount percent filed is required and less then 100%.',
        'down_payment_percent_lt_error'               => 'The Down Payment percent filed is required and less then 100%.',
        'discount_percent_numeric_error'              => 'The Discount percent field must be a numeric value and less than 100%.',
        'down_payment_gt_error'                       => 'The Down payment filed is required and greater then zero.',
        'discount_days_gt_net_days_error'             => 'The Net amount due days should be greater then Discount days.',
        'discount_days_nth_gt_net_days_error'         => 'The Net amount due days should be greater then Discount Nth days.',
        'installment_due_days_gt_error'               => 'The Installment due days :index should be greater then :preIndex installment due days.',
        'installment_percent_total_error'             => 'The Installment percent total is not accurate. it should be equal to 100%.',
        'installment_percent_numeric_error'           => 'The Installment percent total is not accurate. It should be a numeric value.',
        'term_discount'                               => 'Term Discount',
        'installment_due_days_gt_zero_error'          => 'The Installment due days :index should be greater then or equal to Zero.',
        'net_due_days_error'                          => 'The Net amount due days should be greater then Zero and required filed.',
        'discount_days_simple_error'                  => 'The Discount days simple should be greater then Zero and required filed.',
        'discount_days_nth_error'                     => 'The Discount Nth days should be greater then Zero and required filed.',
        'balance_due_days_error'                      => 'The Balance due days should be greater then Zero and required filed.',
        'status_error'                                => 'Sorry, the status hasn\'t changed due to the term used in the invoice.',
        'down_payment_type_invoice_description_error' => 'Your entered Invoice Description token is mismatched with your down payment type.',
        'down_payment_type_quote_description_error'   => 'Your entered Quote Description token is mismatched with your down payment type.',
    ],
    'quotes_delete_error'                             => 'Quotes delete error',
    'for'                                             => 'For',
    'production'                                      => 'Production',
    'access_token'                                    => 'Access Token',
    'application_id'                                  => 'Application Id',
    'location_id'                                     => 'Location Id',
    'fi_config_check'                                 => 'Prerequisites Check',
    'requirement'                                     => 'Requirement',
    'required'                                        => 'Required',
    'actual'                                          => 'Actual',
    'result'                                          => 'Result',
    'db_prefix_setup_alert'                           => 'Your FusionInvoice database is using DB prefixes. Support for DB prefixes ended with version 2023-3.0. In order to continue upgrading to this and future versions, it is required that you remove DB Prefixes. You can do this by renaming all tables in your DB and removing the prefix and also setting the value \'prefix\'    => \'\', in your database.php file.',
    'open_tasks'                                      => 'Open Tasks',
    'closed_tasks'                                    => 'Closed Tasks',
    'select_status'                                   => 'Select Status',
    'net_amount_due_invoice'                          => 'Net amount due in :days days.',
    'days_add_in_current_date'                        => 'The current date, as of <span class="text-blue"> :date</span>, and the due date, are to be considered as <span class="text-blue">:date</span> <span class="text-danger"> plus </span> <span class="text-blue">number of days</span>.',
    'terms'                                           => 'Terms',
    'quote_rejecting_error'                           => 'Invoice #:invoice_number was created on :invoice_date from the approval of this quote. You must delete or cancel this invoice before rejecting this quote.',
    'resend_record_warning'                           => 'Resend this email now?',
    'resend_email'                                    => 'Resend Email',
    'requirement_check_fail'                          => 'Before the installation can continue, you must correct the failures shown above.',
    'failed'                                          => 'Failed',
    'subscriptions'                                   => 'Subscriptions',
    'tt_explanation'                                  => 'Enter a description for the service with optional date placeholders. You can use the following tokens to dynamically insert service start and end dates: {{service_starts_on}} and {{service_ends_on}}. These will be replaced with the actual start and end dates when the content is displayed.',
    'tt_ss_invoices_default_payment_terms'            => 'Invoice Default Payment Terms',
    'invoices_default_terms'                          => 'Invoices Default Terms',
    'net_amount_due_in_n_days'                        => 'Net amount due in N days',
    'last_day'                                        => 'Last day',
    'down_payment_payment_term1'                      => 'Down payment of',
    'down_payment_payment_term2'                      => 'is required.  The balance is due in ',
    '1_type'                                          => 'An invoice created today will be due in <span class="text-primary"> #N </span>days',
    '2_type'                                          => 'An invoice created today will allow a discount if paid by <span class="text-primary">#date</span>, if not, the full amount is due within <span class="text-primary">#N</span> days',
    '3_type'                                          => 'An invoice created today will allow a discount if paid by <span class="text-primary">#date</span>. Net amount is due within <span class="text-primary">#N</span> days',
    '4_type'                                          => 'An invoice created today will require a down payment of <span class="text-primary">#amount</span>. The remaining balance will be due within <span class="text-primary">#N</span> days',
    '5_type'                                          => '<p><span class="text-danger">*</span><strong>An invoice created today and split over <span class="text-primary"> #months </span> #installment</strong></p>',
    '5_1_type'                                        => '<p>Payment <span class="text-primary text-bold"> #installmentnumber. </span> <span class="text-primary"> #percent% </span> Due <span class="text-primary"> #date </span></p>',
    'installment'                                     => 'installment',
    'apply_payment_terms'                             => 'Apply payment terms discount amount',
    'payable_amount'                                  => 'Final Payable Amount',
    'payable_amount_lt_error'                         => 'Final payable amount should be less then Invoice Balance.',
    'payment_term_type_4_amount'                      => 'Partial payment of :amount accepted',
    'net_terms'                                       => 'Net terms',
    'proforma_invoice_default'                        => 'Proforma Invoice Default',
    'expense_vendor'                                  => 'Expense Vendor',
    'expense_vendor_deleted'                          => 'Expense vendor was deleted',
    'expense_vendor_already_used'                     => 'You can\'t delete a vendor that has related expense entries.',
    'total_must_be_gt_zero'                           => 'The :modal_name total must be greater than zero.',
    'payment_failed'                                  => 'Payment failed with :error',
    'xss_validation'                                  => 'The :attribute field contains tags that could expose an XSS vulnerability',
    'support_desk'                                    => 'Support Desk',
    'choose_file'                                     => 'Choose File',
    'supportTicket'                                   => 'Support Desk',
    'create_support_ticket'                           => 'Create Support Ticket',
    'supportTicket_inbox_view'                        => 'Support Desk',
    'support_ticket'                                  => 'Support Ticket',
    'ticket_number'                                   => 'Ticket Number',
    'revision'                                        => 'Revision',
    'revisions'                                       => 'Revisions',
    'recurring_invoices'                              => 'Subscriptions',
    'message'                                         => 'Message',
    'custom_img'                                      => 'Custom Image',
    'please_fill_some_data'                           => 'Please fill in the required data on the new item.',
    'assigned'                                        => 'Assigned',
    'add_ons_will_be_disabled'                        => 'THE FOLLOWING ADD-ONS WILL BE DISABLED:',
    'add_ons_will_be_disabled_msg'                    => 'All add-ons are automatically disabled during a core FusionInvoice upgrade. After this upgrade is finished, make sure to download the appropriate add-on zip files and install them. Once you\'ve done that, you can re-enable them from the System Settings menu, Customizations, Add-ons and selecting [Install]. ',
    'price_not_valid'                                 => 'The price must be greater than zero',
    'free_space'                                      => 'Free Space',
    'expense_type'                                    => 'Expense Type',
    'standard_expense'                                => 'Standard Expense',
    'expense_with_deductible_tax'                     => 'Expense With Deductible Tax',
    'remittance_to_tax_authority'                     => 'Remittance To Tax Authority',
    'tax_paid'                                        => 'Tax Paid',
    'tax_detail'                                      => 'Tax Detail',
    'select_expense_type'                             => 'Select Expense Type',
    'taxes_paid_on_expenses_or_remitted'              => 'Taxes Paid On Expenses Or Remitted',
    'tax_name'                                        => 'Tax Name',
    'last_activity'                                   => 'Last Activity',
    'select_default_company_profile'                  => 'Please select your default company profile',
    'mn_sales_tax'                                    => 'MN Sales Tax',
    'taxes_collected_on_sales'                        => 'Taxes Collected On Sales',
    'vatgst_tax_note'                                 => 'Yes calculates the tax as being included in the item total. No will add the tax to the item total.',
    'tt_vatgst_tax'                                   => 'For this example, we will assume a tax rate of 5% and an item price of $100. Setting Enable VAT/GST to Yes will yield an invoice total of $100, with the item amount adjusting to $95.24 and a tax amount of $4.76. Setting the VAT/GST to No will yeild an invoice total of $105, with an item price of $100 and a tax of $5.',
    'level_of_detail'                                 => 'Level of Detail',
    'tax_report'                                      => 'Tax Report',
    'detail'                                          => 'Detail',
    'totals'                                          => 'Totals',
    'totals_with_dots'                                => 'Totals . . .',
    'yes_all'                                         => 'Yes (all)',
    'invoices_only'                                   => 'Invoices only',
    'payment_receipts_only'                           => 'Payment Receipts only',
    'role'                                            => 'Role',
    'previous_email'                                  => 'Previous Email',
    'web_store_user_id'                               => 'Web Store User ID: :user_id',
    'payment_term_messages'                           => [
        '1_type'       => 'Net amount due by <span class="text-info"> #LASTDATE </span>',
        '2_type'       => 'A discount of #DISCOUNTPERCENT % can be taken if paid by <span class="text-info">#DISCOUNTDATE</span>, otherwise the net amount is due by <span class="text-info">#LASTDATE</span>.',
        '3_type'       => 'A discount of #DISCOUNTPERCENT % can be taken if paid by <span class="text-info">#DISCOUNTDATE</span>, otherwise the net amount is due by <span class="text-info">#LASTDATE</span>.',
        '4_type'       => 'A down payment of <span class="text-info">#DOWNPAYMENT</span> is on #INVOICEDATE. The balance is due by <span class="text-info">#LASTDATE</span>.',
        '5_type'       => '<p class="mt-2 mb-1">Payments may be split over <span class="text-info"> #NUMBEROFINSTALLMENTS </span> installments</p>',
        '5_1_type'     => '<li>Payment <span class="text-info"> #PERCENT % </span> Due <span class="text-info"> #LASTDATE </span> </li>',
        '3_type_error' => '<span class="text-danger">Next month has a total of #N days, so please input a value between 1 and #N for the discount next month days.</span>',
    ],
    'payment_term_not_selected'                       => 'Payment Term Not Selected',
    'confirm'                                         => 'Confirm',
    'create_live_invoice_now'                         => 'Create Live Invoice Now?',
    'create_live_invoice_warn_message'                => '<p class="m-0">A Subscription is like an invoice template that gets used for creating live invoices at a given frequency.</p><p class="m-0"> Normally a CRON job or scheduled task is set up to run once per day, and is responsible for checking for live invoices that should be created, based on the subscription’s Generate Next Invoice date field.  If that date value is today or earlier than today, a live invoice is automatically created.</p><p class="m-0"> This option allows you to manually create the live invoice from the subscription, bypassing the automated method. Would you like to create the live invoice now?</p>',
    'contact'                                         => 'Contact',
    'invoice_month_plus_one'                          => 'Invoice Month +1',
    'invoice_month_plus_two'                          => 'Invoice Month +2',
    'invoice_month_plus_three'                        => 'Invoice Month +3',
    'inbound_email'                                   => 'Inbound email',
    'outbound_email'                                  => 'Outbound email',
    'email_signature'                                 => 'Email signature',
    'mail_credential_error'                           => 'Invalid email configuration. Please check your settings and try again. <strong>( Configuration <i class="fa fa-arrow-alt-circle-right"> </i> System Settings <i class="fa fa-arrow-alt-circle-right"> </i> Email )</strong>',
    'tt_generate_next_invoice'                        => 'The date when the next live invoice will be automatically created from this subscription.',
    'tt_stop_date'                                    => 'The date threshold after which no more live invoices will be automatically generated for this subscription. Leave this field empty for a subscription that should continue forever.',
    'description_template'                            => 'Description Template',
    't_1_description'                                 => 'Full Payment is due by #LASTDATE.',
    't_2_description'                                 => 'Take a #DISCOUNTPERCENT % discount if paid by #DISCOUNTDATE, otherwise pay the full invoice amount by #LASTDATE.',
    't_3_description'                                 => 'Take a #DISCOUNTPERCENT % discount if paid by #DISCOUNTDATE, otherwise pay the full invoice amount by #LASTDATE.',
    't_4_description'                                 => 'A down payment of #DOWNPAYMENT is due on #INVOICEDATE, the balance of the invoice is due by #LASTDATE',
    't_4_1_description'                               => 'A down payment of #DOWNPAYMENTPERCENT is due on #INVOICEDATE, the balance of the invoice is due by #LASTDATE',
    't_5_description'                                 => 'The payments are to be made in #NUMBEROFINSTALLMENTS equal installments',
    't_5_type_description'                            => 'Payment #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT is due on #LASTDATE',
    'tokens_allowed'                                  => 'Tokens allowed',
    'description_tokens'                              => '<span class="notranslate">#INVOICEDATE, #LASTDATE, #DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #DISCOUNTDATE, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER</span>',
    'description_template_tooltip'                    => 'The evaluated text from the template is the terms description that is shown on documents like invoice, quotes, etc.',
    'cc_mail'                                         => 'CC Mail',
    'assigned_inv_sent_or_paid'                       => '*There are invoices that have been paid or sent which have this payment term assigned. Changing the ‘Type’ details is not allowed.',
    'exclude_paid_invoices'                           => 'Exclude Paid Invoices',
    'phone_number_numeric_error'                      => 'The Phone Number must be a number.',
    'phone_num_same_country_code_error'               => 'Please ensure your phone number is properly fomatted. It seems to have been entered starting with the country code, which is not allowed.',
    'tt_expense_amount'                               => 'Enter the total amount of the expense, including tax. This field is not available when remitting a tax payment to a tax authority.',
    'tt_expense_tax_paid_deductible'                  => 'Enter the amount of tax that was paid with this expense. This value will be deducted from your overall tax liability on the Tax Summary and Tax Detail reports.',
    'tt_expense_tax_paid_remittance'                  => 'Enter the amount of tax that was remitted to the tax authority. This is used to record payments made for taxes collected on your paid invoices.',
    'tt_expense_client'                               => 'If this expense was incurred solely on behalf of a client, and you wish to invoice them for it, select the related client here.',
    'base_currency_not_deleted'                       => 'Base currency cannot be deleted',
    'used_currency_modal_error'                       => 'Currency already used in :modal_names module.',
    'addon_uninstall_success'                         => 'Addon successfully uninstalled',
    'original'                                        => 'Original',
    'revision_current'                                => 'Revision(current)',
    'number'                                          => 'Number',
    'copy_process_error'                              => 'Oops! It seems there was a hiccup during the copying process. Please try again later.',
    'tt_captcha_image'                                => 'CAPTCHA Image',
    'reload_page'                                     => 'Please reload the page',
    'discount_limit'                                  => 'Discount must be less than 99.99%.',
    'tooltip'                                         => 'Tooltip',
    'authorization_error'                             => 'You are not authorized to perform this operation.',
    'reset_to_default'                                => 'Reset To Default',
    'reset_to_default_warning'                        => '<p>This will reset the Subject and Body to the default value for :model. Continue?</p>',
    'reset_default_mail_template'                     => 'The default mail template for :model has been reset successfully.',
    'overdue_invoice'                                 => 'Overdue Invoice',
    'total_cannot_be_lt_zero'                         => 'The :modal_name total cannot be less than zero.',
    'addons_disabled_during_setup'                    => 'During the upgrade process the following addons were disabled: :addons . Don\'t forget to enable them now that the upgrade is complete.',
    'allow_payments_on_quotes'                        => 'Allow Payments on Quotes Y/N',
    'allow_payments_on_quote'                         => 'Allow Payment Y/N',
    'tt_ss_quotes_is_payable'                         => 'If enabled, upon quote approval, a Pay Now button will appear on the quote\'s public link view. An invoice will be automatically created and the payment will be applied to the invoice.',
    'pay_with_square'                                 => 'Pay With Square',
    'validation_mess_for_is_payable_quote'            => 'The setting to Automatically Convert Quote to Invoice When Client Approves is required when Allow Payments on Quotes is set to \'Yes\'.',
    'client_requirement_msg'                          => 'Please create a client before adding :seed_name',
    'quote_add_items'                                 => 'Quote items required and status not canceled',
    'invalid_quote_id'                                => 'Invalid Quote Id',
    'information_header'                              => 'Congratulations, you’re about to save some money!',
    'convenience_charge'                              => 'Convenience Charge',
    'credit_card_fee_message'                         => 'There will be a Credit Card Convenience Fee of :charge on this transaction.',
    'info_payment_term_type_2'                        => 'Although your invoice balance is :ORIGINAL_AMOUNT, you’re eligible for a payment terms discount of :DISCOUNT_PERCENT %, which will reduce your payment amount to :DISCOUNT_AMOUNT.',
    'info_payment_term_type_3'                        => 'Although your invoice balance is :ORIGINAL_AMOUNT, you’re eligible for a payment terms discount of :DISCOUNT_PERCENT %, which will reduce your payment amount to :DISCOUNT_AMOUNT.',
    'info_payment_term_type_4'                        => 'Although your invoice balance is :ORIGINAL_AMOUNT, you’re eligible for payment terms to pay a down payment :DISCOUNT_AMOUNT.',
    'info_payment_term_type_5'                        => 'Although your invoice balance is :ORIGINAL_AMOUNT, you’re eligible for payment terms to pay a installment payment :DISCOUNT_AMOUNT.',
    'payment_terms_applied'                           => 'Payment Terms must be removed from the :modal before deletion.',
    'default_payment_term_warn'                       => '*You can only change Name and Net Due Days, for the <strong>System Default Payment Terms</strong>.',
    'quote_rejected_not_payable'                      => 'Quote #:number has been rejected and is not payable due to its status.',
    'could_not_delete'                                => 'Could not delete',
    'convenience_charges_calculation_fail'            => 'Error: Convenience charges calculation failed during migration. Please try again later.',
    'sign_in_welcome_message'                         => '🚀 Congratulations! Your FusionInvoice Was Successfully Installed! 🚀',
    'sign_in_welcome_message_1'                       => '<p>Your FusionInvoice has been successfully upgraded from version :old_version to version :new_version.</p> <p>For a detailed overview of all the new features and improvements, please check out our <a href="https://www.fusioninvoice.com/docs/2024/About-FusionInvoice/Release-Notes">Release Notes</a>.</p>',
    'sign_in_welcome_message_2'                       => '<p>Thank you for choosing FusionInvoice. Your trust, support and feedback drive our innovation.</p><p class="m-0 text-bold">Happy Invoicing!</p><p class="text-bold">The FusionInvoice Team</p>',
    'tt_gen_skin_user_profile'                        => 'Changing this value sets the system default ONLY for new users. Users may override this setting through their user profile settings.',
    'description_template_invoice'                    => 'Description Template - Invoice',
    'description_template_quote'                      => 'Description Template - Quote',
    'description_tokens_for_quote'                    => '<span class="notranslate">#DISCOUNTPERCENT, #DISCOUNTAMOUNT, #DISCOUNTDAYS, #DISCOUNTEDTOTAL, #NODISCOUNTTOTAL, #NETDAYS, #NTHDAY, #DOWNPAYMENT, #DOWNPAYMENTPERCENT, #PERCENT, #NUMBEROFINSTALLMENTS, #INSTALLMENTAMOUNT, #INSTALLMENTNUMBER, #INSTALLMENTDUEDAYS<span>',
    't_1_description_for_quote'                       => 'Full payment is due within #NETDAYS of the invoice date.',
    't_2_description_for_quote'                       => 'Take a #DISCOUNTPERCENT % discount if paid within #DISCOUNTDAYS, otherwise pay the full quote amount by #NETDAYS.',
    't_3_description_for_quote'                       => 'Take a #DISCOUNTPERCENT % discount if paid by the #NTHDAY of the next month, otherwise pay the full invoice amount within #NETDAYS days.',
    't_4_description_for_quote'                       => 'A down payment of #DOWNPAYMENT is due on the invoice date, the remaining balance is due within #NETDAYS days',
    't_4_1_description_for_quote'                     => 'A down payment of #DOWNPAYMENTPERCENT is due on the invoice date, the remaining balance is due within #NETDAYS days',
    't_5_description_for_quote'                       => 'The payments are to be made in #NUMBEROFINSTALLMENTS equal installments',
    't_5_type_description_for_quote'                  => 'Payment #INSTALLMENTNUMBER, #INSTALLMENTAMOUNT is due #INSTALLMENTDUEDAYS days from the invoice date',
    'default_term'                                    => 'Default Term',
    'proceed_to_payment'                              => 'Proceed To Payment',
    'version_upgraded'                                => 'Your application is up to date.',
    'term_amount_gt_payment_amount'                   => 'The Amount should be greater than the payment terms discount amount',
    'payment_term_not_eligible_warning'               => 'The payment term discount is available only for full payments. Unfortunately, you do not qualify for it.',
    'processed_by_user'                               => '<strong>Processed By:</strong> :user_initial (:paid_at)',
    'payment_method_application'                      => '<strong>Payment Method:</strong> :method',
    'all_methods'                                     => 'All Methods',
    'this_payment'                                    => 'This Payment',
    'previous_balance'                                => 'Previous Balance',
    'payment_applied_with_remaining_balance'          => '<p>Your Payment of :amount has been partially applied. :remaining_balance remains outstanding.</p>',
    'pre_payment_received'                            => '<p>A Pre-Payment of :amount  has been received for future Invoices on :date.</p>',
    'payment_full_applied'                            => '<p><strong>Your Payment <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;">:formatted_number</span> of :amount has been applied.</strong></p>',
    'payment_detail_label'                            => '<p><strong>Payment <span style="background: #d2d6de;border-radius: 2px;padding: 0 8px;">:formatted_number</span> Details:</strong></p>',
    'payment_full_applied_on_inv'                     => '<p>Your Payment of :paid has been applied to Invoice :invoice_number on :date</p>',
    'payment_full_applied_on_inv_with_ptd'            => '<p>Your Payment of :paid, combined with payment terms discount of :payment_terms_discount, has been applied to Invoice :invoice_number on :date</p>',
    'payment_full_applied_on_inv_with_cc'             => '<p>Your Payment of :paid, combined with convenience charges of :convenience_charges, has been applied to Invoice :invoice_number on :date</p>',
    'payment_full_applied_on_inv_with_cc_and_ptd'     => '<p>Your Payment of :paid, combined with payment terms discount of :payment_terms_discount and convenience charges of :convenience_charges, has been applied to Invoice :invoice_number on :date</p>',
    'payment_remaining_balance_mail_message'          => '<p>The remaining balance of Invoice :invoice_number is :remaining_balance</p>',
    'unpaid_invoices'                                 => 'Unpaid Invoices',
    'include'                                         => 'Include',
    'exclude'                                         => 'Exclude',
    'invoice_with_no_tax'                             => 'Invoices With No Tax',
    'tax_total'                                       => 'Tax Total',
    'proforma_invoices'                               => 'Proforma Invoices'
];

return TranslationOverride::override(__FILE__, $translations);
