<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => 'Das :attribute muss akzeptiert werden.',
    'active_url'                      => 'Das :attribute ist keine gültige URL.',
    'after'                           => 'Das :attribute muss ein Datum nach :date sein.',
    'after_or_equal'                  => 'Das :attribute muss ein Datum nach oder gleich :date sein.',
    'alpha'                           => 'Das :attribute darf nur Buchstaben enthalten.',
    'alpha_dash'                      => 'Das :attribute darf nur Buchstaben, Zahlen und Bindestriche enthalten.',
    'alpha_num'                       => 'Das :attribute darf nur Buchstaben und Zahlen enthalten.',
    'array'                           => 'Das :attribute muss ein Array sein.',
    'before'                          => 'Das :attribute muss ein Datum vor :date sein.',
    'before_or_equal'                 => 'Das :attribute muss ein Datum vor oder gleich :date sein.',
    'between'                         => [
        'numeric' => 'Das :attribute muss zwischen :min und :max liegen.',
        'file'    => 'Das :attribute muss zwischen :min und :max Kilobyte liegen.',
        'string'  => 'Das :attribute muss zwischen den Zeichen :min und :max liegen.',
        'array'   => 'Das :attribute muss zwischen :min und :max Elementen enthalten.',
    ],
    'boolean'                         => 'Das Feld :attribute muss wahr oder falsch sein.',
    'confirmed'                       => 'Die :attribute -Bestätigung stimmt nicht überein.',
    'date'                            => 'Das :attribute ist kein gültiges Datum.',
    'date_format'                     => 'Das :attribute stimmt nicht mit dem Format :format überein.',
    'different'                       => 'Das :attribute und :other müssen unterschiedlich sein.',
    'digits'                          => 'Das :attribute muss aus :digits Ziffern bestehen.',
    'digits_between'                  => 'Das :attribute muss zwischen :min und :max Ziffern liegen.',
    'dimensions'                      => 'Das :attribute hat ungültige Bildabmessungen.',
    'distinct'                        => 'Das Feld :attribute hat einen doppelten Wert.',
    'email'                           => 'Das :attribute muss eine gültige E-Mail-Adresse sein.',
    'exists'                          => 'Das ausgewählte :attribute ist ungültig.',
    'file'                            => 'Das :attribute muss eine Datei sein.',
    'filled'                          => 'Das Feld :attribute muss einen Wert haben.',
    'image'                           => 'Das :attribute muss ein Bild sein.',
    'in'                              => 'Das ausgewählte :attribute ist ungültig.',
    'in_array'                        => 'Das Feld :attribute existiert nicht in :other.',
    'integer'                         => 'Das :attribute muss eine Ganzzahl sein.',
    'ip'                              => 'Das :attribute muss eine gültige IP-Adresse sein.',
    'ipv4'                            => 'Das :attribute muss eine gültige IPv4-Adresse sein.',
    'ipv6'                            => 'Das :attribute muss eine gültige IPv6-Adresse sein.',
    'json'                            => 'Das :attribute muss eine gültige JSON-Zeichenfolge sein.',
    'max'                             => [
        'numeric' => 'Das :attribute darf nicht größer als :max sein.',
        'file'    => 'Das :attribute darf nicht größer als :max Kilobyte sein.',
        'string'  => 'Das :attribute darf nicht länger als :max Zeichen sein.',
        'array'   => 'Das :attribute darf nicht mehr als :max Elemente enthalten.',
    ],
    'mimes'                           => 'Das :attribute muss eine Datei vom Typ :values sein.',
    'mimetypes'                       => 'Das :attribute muss eine Datei vom Typ :values sein.',
    'min'                             => [
        'numeric' => 'Das :attribute muss mindestens :min sein.',
        'file'    => 'Das :attribute muss mindestens :min Kilobyte groß sein.',
        'string'  => 'Das :attribute muss mindestens :min Zeichen lang sein.',
        'array'   => 'Das :attribute muss mindestens :min Elemente enthalten.',
    ],
    'not_in'                          => 'Das ausgewählte :attribute ist ungültig.',
    'numeric'                         => 'Das :attribute muss eine Zahl sein.',
    'present'                         => 'Das Feld :attribute muss vorhanden sein.',
    'regex'                           => 'Das :attribute -Format ist ungültig.',
    'required'                        => 'Das Feld :attribute ist erforderlich.',
    'required_if'                     => 'Das Feld :attribute ist erforderlich, wenn :other den :value hat.',
    'required_unless'                 => 'Das Feld :attribute ist erforderlich, es sei denn, :other ist in :values enthalten.',
    'required_with'                   => 'Das Feld :attribute ist erforderlich, wenn :values vorhanden ist.',
    'required_with_all'               => 'Das Feld :attribute ist erforderlich, wenn :values vorhanden ist.',
    'required_without'                => 'Das Feld :attribute ist erforderlich, wenn :values nicht vorhanden ist.',
    'required_without_all'            => 'Das Feld :attribute ist erforderlich, wenn keiner der :values vorhanden ist.',
    'same'                            => ':attribute und :other müssen übereinstimmen.',
    'size'                            => [
        'numeric' => 'Das :attribute muss :size sein.',
        'file'    => 'Das :attribute muss :size Kilobyte sein.',
        'string'  => 'Das :attribute muss aus :size -Zeichen bestehen.',
        'array'   => 'Das :attribute muss :size -Elemente enthalten.',
    ],
    'string'                          => 'Das :attribute muss eine Zeichenfolge sein.',
    'timezone'                        => 'Das :attribute muss eine gültige Zone sein.',
    'unique'                          => 'Das :attribute wurde bereits vergeben.',
    'uploaded'                        => 'Das :attribute konnte nicht hochgeladen werden.',
    'url'                             => 'Das :attribute -Format ist ungültig.',
    'captcha'                         => 'Das :attribute ist nicht korrekt',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'benutzerdefinierte Nachricht',
        ],
        'field_label'    => [
            'regex' => 'Die Feldbezeichnung enthält ein ungültiges Zeichen. Erlaubte Zeichen: A-Z, a-z, 0-9, Leerzeichen, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
