<?php

$translations = [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'                        => 'Cal acceptar el :attribute.',
    'active_url'                      => 'El :attribute no és un URL vàlid.',
    'after'                           => 'El :attribute ha de ser una data posterior a :date.',
    'after_or_equal'                  => 'El :attribute ha de ser una data posterior o igual a :date.',
    'alpha'                           => 'El :attribute només pot contenir lletres.',
    'alpha_dash'                      => 'El :attribute només pot contenir lletres, números i guions.',
    'alpha_num'                       => 'El :attribute només pot contenir lletres i números.',
    'array'                           => 'El :attribute ha de ser una matriu.',
    'before'                          => 'El :attribute ha de ser una data anterior :date.',
    'before_or_equal'                 => 'El :attribute ha de ser una data anterior o igual a :date.',
    'between'                         => [
        'numeric' => 'El :attribute ha d\'estar entre :min i :max.',
        'file'    => 'El :attribute ha d\'estar entre :min i :max kilobytes.',
        'string'  => 'El :attribute ha d\'estar entre els caràcters :min i :max.',
        'array'   => 'El :attribute ha de tenir entre :min i :max elements.',
    ],
    'boolean'                         => 'El camp :attribute ha de ser vertader o fals.',
    'confirmed'                       => 'La confirmació :attribute no coincideix.',
    'date'                            => 'El :attribute no és una data vàlida.',
    'date_format'                     => 'El :attribute no coincideix amb el format :format.',
    'different'                       => 'El :attribute i :other han de ser diferents.',
    'digits'                          => 'El :attribute ha de ser :digits dígits.',
    'digits_between'                  => 'El :attribute ha d\'estar entre els dígits :min i :max.',
    'dimensions'                      => 'El :attribute té dimensions d\'imatge no vàlides.',
    'distinct'                        => 'El camp :attribute té un valor duplicat.',
    'email'                           => 'El :attribute ha de ser una adreça de correu electrònic vàlida.',
    'exists'                          => 'El :attribute seleccionat no és vàlid.',
    'file'                            => 'El :attribute ha de ser un fitxer.',
    'filled'                          => 'El camp :attribute ha de tenir un valor.',
    'image'                           => 'El :attribute ha de ser una imatge.',
    'in'                              => 'El :attribute seleccionat no és vàlid.',
    'in_array'                        => 'El camp :attribute no existeix a :other.',
    'integer'                         => 'El :attribute ha de ser un nombre enter.',
    'ip'                              => 'El :attribute ha de ser una adreça IP vàlida.',
    'ipv4'                            => 'El :attribute ha de ser una adreça IPv4 vàlida.',
    'ipv6'                            => 'El :attribute ha de ser una adreça IPv6 vàlida.',
    'json'                            => 'El :attribute ha de ser una cadena JSON vàlida.',
    'max'                             => [
        'numeric' => 'El :attribute no pot ser més gran que :max.',
        'file'    => 'El :attribute no pot ser superior a :max kilobytes.',
        'string'  => 'El :attribute no pot ser més gran que :max caràcters.',
        'array'   => 'El :attribute pot no tenir més de :max elements.',
    ],
    'mimes'                           => 'El :attribute ha de ser un fitxer del tipus: :values.',
    'mimetypes'                       => 'El :attribute ha de ser un fitxer del tipus: :values.',
    'min'                             => [
        'numeric' => 'El :attribute ha de ser almenys :min.',
        'file'    => 'El :attribute ha de ser almenys :min kilobytes.',
        'string'  => 'El :attribute ha de tenir com a mínim :min caràcters.',
        'array'   => 'El :attribute ha de tenir almenys :min elements.',
    ],
    'not_in'                          => 'El :attribute seleccionat no és vàlid.',
    'numeric'                         => 'El :attribute ha de ser un número.',
    'present'                         => 'El camp :attribute ha d\'estar present.',
    'regex'                           => 'El format :attribute no és vàlid.',
    'required'                        => 'El :attribute és obligatori.',
    'required_if'                     => 'El camp :attribute és obligatori quan :other és :value.',
    'required_unless'                 => 'El camp :attribute és obligatori tret que :other estigui a :values.',
    'required_with'                   => 'El camp :attribute és obligatori quan :values està present.',
    'required_with_all'               => 'El camp :attribute és obligatori quan :values està present.',
    'required_without'                => 'El camp :attribute és obligatori quan :values no està present.',
    'required_without_all'            => 'El camp :attribute és obligatori quan no hi ha cap dels :values.',
    'same'                            => 'Els :attribute i :other han de coincidir.',
    'size'                            => [
        'numeric' => 'El :attribute ha de ser :size.',
        'file'    => 'El :attribute ha de ser :size kilobytes.',
        'string'  => 'El :attribute ha de ser :size caràcters.',
        'array'   => 'El :attribute ha de contenir elements :size.',
    ],
    'string'                          => 'El :attribute ha de ser una cadena.',
    'timezone'                        => 'El :attribute ha de ser una zona vàlida.',
    'unique'                          => 'El :attribute ja s\'ha pres.',
    'uploaded'                        => 'El :attribute no s\'ha pogut carregar.',
    'url'                             => 'El format :attribute no és vàlid.',
    'captcha'                         => 'El :attribute no és correcte',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom'                          => [
        'attribute-name' => [
            'rule-name' => 'missatge personalitzat',
        ],
        'field_label'    => [
            'regex' => 'L\'etiqueta del camp conté un caràcter no vàlid. Caràcters permesos: A-Z, a-z, 0-9, espai, -, _',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes'                      => [],
    'unique_of_decimal_and_thousands' => 'Decimal point and thousand separator already selected for another currency'

];

return \FI\Support\TranslationOverride::override(__FILE__, $translations);
