<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\PaymentTerms\Models\PaymentTerm;
use FI\Modules\Quotes\Models\Quote;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasColumn('quotes', 'payment_term_id'))
        {
            Schema::table('quotes', function (Blueprint $table)
            {
                $table->integer('payment_term_id')->nullable()->after('is_payable_quote');
            });
        }

        $paymentTerm = PaymentTerm::where('is_default', 1)->first();
        if(isset($paymentTerm->id))
        {
            Quote::whereNull('payment_term_id')->update(['payment_term_id' => $paymentTerm->id]);
        }
    }
};