<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Payments\Models\PaymentInvoice;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return new class extends Migration
{
    public function up(): void
    {
        try
        {
            DB::beginTransaction();
            $paymentInvoices = PaymentInvoice::where('convenience_charges', '<>', 0)
                ->whereHas('invoice', function ($query)
                {
                    $query->where('invoices.total_convenience_charges', 0)
                        ->where('invoices.online_payment_processing_fee', 'no')
                        ->whereHas('amount', function ($query)
                        {
                            $query->where('balance', 0)
                                ->where(DB::raw('ROUND(total, 2)'), DB::raw('ROUND(paid, 2)'));
                        });
                })->get();

            if (count($paymentInvoices) > 0)
            {
                $paymentInvoiceIds = $paymentInvoices->pluck('id');
                PaymentInvoice::whereIn('id', $paymentInvoiceIds)->update(['convenience_charges' => 0]);
            }

            DB::commit();
        }
        catch (\Exception $e)
        {
            DB::rollBack();
            Log::error(trans('fi.convenience_charges_calculation_fail'));
            Log::error(trans('fi.convenience_charges: ') . $e->getMessage() . ' - ' . $e->getFile());
        }
    }

};
