<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Emails\Models\DefaultEmailTemplate;
use FI\Modules\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        if (!Schema::hasTable('default_email_templates'))
        {
            Schema::create('default_email_templates', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->string('language')->default('en');
                $table->string('module');
                $table->string('type');
                $table->string('value');
            });
        }

        if (Schema::hasTable('default_email_templates'))
        {
            foreach (DefaultEmailTemplate::defaultMailTemplateValues() as $module => $modelDefaultKeyValue)
            {
                foreach ($modelDefaultKeyValue as $key => $value)
                {
                    Setting::saveByKey($key, $value);

                    DefaultEmailTemplate::create([
                        'module' => $module,
                        'type'   => $key,
                        'value'  => $value,
                    ]);
                }
            }
        }
    }
};
