<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    public function up(): void
    {

        if (!Schema::hasColumn('payment_terms', 'description_template'))
        {
            Schema::table('payment_terms', function (Blueprint $table)
            {
                $table->renameColumn('description', 'name');
                $table->text('description_template')->nullable()->after('number_of_installments');
            });
        }
    }
};
