<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('document_revisions'))
        {
            Schema::create('document_revisions', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->integer('revision_number');
                $table->morphs('revisable');
                $table->json('text')->nullable();
                $table->integer('updated_by')->nullable();
            });
        }
    }
};