<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Invoices\Models\Invoice;
use FI\Modules\PaymentTerms\Models\PaymentTerm;
use FI\Modules\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasColumn('invoices', 'terms'))
        {
            Schema::table('invoices', function (Blueprint $table)
            {
                $table->text('terms')->nullable();
            });
        }

        if (!Schema::hasColumn('payment_terms', 'is_default'))
        {
            Schema::table('payment_terms', function (Blueprint $table)
            {
                $table->boolean('is_default')->default(0);
            });
        }

        $paymentTerm = PaymentTerm::where('is_default', 1)->first();

        if (empty($paymentTerm))
        {
            $paymentTerm = PaymentTerm::create(
                [
                    "type"         => 0,
                    "description"  => trans('fi.net_terms'),
                    "net_due_days" => 0,
                    "is_default"   => 1,
                ]
            );
        }
        if (config('fi.defaultPaymentTerms') == '')
        {
            Setting::saveByKey('defaultPaymentTerms', $paymentTerm->id);
        }

        Invoice::where('payment_terms_id', 0)->orWhere('payment_terms_id', null)->update(['payment_terms_id' => $paymentTerm->id]);
    }
};