<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasColumn('invoice_amounts', 'payment_terms_discount'))
        {
            Schema::table('invoice_amounts', function (Blueprint $table)
            {
                $table->decimal('payment_terms_discount', 20, 4)->default(0.00)->after('discount');
            });
        }
    }

};