<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {
        Schema::table('countries', function (Blueprint $table)
        {
            $table->string('local_name');
        });

        $local_name = [
            "AF" => "افغانستان",
            "AL" => "Shqipëri",
            "DZ" => "الجزائر",
            "AM" => "Հայաստան",
            "AT" => "Österreich",
            "AZ" => "Azərbaycan",
            "BH" => "‫البحرين‬‎",
            "BD" => "বাংলাদেশ",
            "BY" => "Беларусь",
            "BE" => "België",
            "BJ" => "Bénin",
            "BT" => "འབྲུག་ཡུལ",
            "BA" => "Bosna i Hercegovina",
            "BV" => "Bouvetøya",
            "BR" => "Brasil",
            "BN" => "Negara Brunei Darussalam",
            "BG" => "България",
            "KH" => "កម្ពុជា",
            "CV" => "Cabo Verde",
            "CF" => "République centrafricaine",
            "TD" => "Tchad",
            "CN" => "中国",
            "KM" => "Komori",
            "CD" => "Jamhuri ya Kidemokrasia ya Kongo",
            "CG" => "Congo",
            "CY" => "Κύπρος",
            "CZ" => "Česká republika",
            "DO" => "República Dominicana",
            "TP" => "Timor-Leste",
            "EG" => "مصر",
            "GQ" => "Guinea Ecuatorial",
            "ER" => "ኤርትራ",
            "EE" => "Eesti",
            "ET" => "ኢትዮጵያ",
            "FK" => "Islas Malvinas",
            "FO" => "Føroyar",
            "FI" => "Suomi",
            "GF" => "Guyane française",
            "PF" => "Polynésie française",
            "TF" => "Terres australes françaises",
            "GE" => "საქართველო",
            "DE" => "Deutschland",
            "GR" => "Ελλάδα",
            "GL" => "Kalaallit Nunaat",
            "GN" => "Guinée",
            "GW" => "Guiné-Bissau",
            "HT" => "Haïti",
            "HM" => "Heard et les îles McDonald",
            "HK" => "香港",
            "HU" => "Magyarország",
            "IS" => "Ísland",
            "IN" => "भारत",
            "IM" => "Isle of Man",
            "IR" => "ایران",
            "IQ" => "العراق",
            "IE" => "Éire",
            "IL" => "ישראל",
            "IT" => "Italia",
            "CI" => "Côte d'Ivoire",
            "JP" => "日本",
            "JO" => "الأردن",
            "KZ" => "Қазақстан",
            "KP" => "조선민주주의인민공화국",
            "KR" => "대한민국",
            "XK" => "Republika e Kosovës",
            "KW" => "الكويت",
            "KG" => "Кыргызстан",
            "LA" => "ສປປລາວ",
            "LV" => "Latvija",
            "LB" => "لبنان",
            "LY" => "ليبيا",
            "LT" => "Lietuva",
            "LU" => "Lëtzebuerg",
            "MO" => "澳門",
            "MK" => "Северна Македонија",
            "MG" => "Madagasikara",
            "MV" => "ދިވެހިރާއްޖޭގެ ޖުމްހޫރިއްޔާ",
            "MH" => "Majōl",
            "MR" => "موريتانيا",
            "MX" => "México",
            "MN" => "Монгол улс",
            "ME" => "Црна Гора",
            "MA" => "المغرب",
            "MZ" => "Moçambique",
            "NA" => "Namibië",
            "NP" => "नेपाल",
            "NL" => "Nederland",
            "AN" => "Nederlandse Antillen",
            "NC" => "Nouvelle-Calédonie",
            "NO" => "Norge",
            "OM" => "عمان",
            "PK" => "پاکستان",
            "PW" => "Belau",
            "PS" => "فلسطين",
            "PA" => "Panamá",
            "PE" => "Perú",
            "PH" => "Pilipinas",
            "PN" => "Pitcairn Islands",
            "QA" => "قطر",
            "RE" => "La Réunion",
            "RO" => "România",
            "RU" => "Россия",
            "RW" => "Rwanda",
            "KN" => "Saint Kitts and Nevis",
            "ST" => "São Tomé e Príncipe",
            "SA" => "المملكة العربية السعودية",
            "SN" => "Sénégal",
            "RS" => "Србија",
            "SK" => "Slovenská republika",
            "SI" => "Slovenija",
            "SO" => "Soomaaliya",
            "ES" => "España",
            "LK" => "ශ්‍රී ලංකාව",
            "SH" => "Saint Helena",
            "SD" => "السودان",
            "SZ" => "eSwatini",
            "SE" => "Sverige",
            "CH" => "Schweiz",
            "SY" => "سوريا",
            "TW" => "台灣",
            "TJ" => "Тоҷикистон",
            "TZ" => "Tanzania",
            "TH" => "ประเทศไทย",
            "TN" => "تونس",
            "TR" => "Türkiye",
            "TM" => "Türkmenistan",
            "UA" => "Україна",
            "AE" => "الإمارات العربية المتحدة",
            "UZ" => "O‘zbekiston",
            "VA" => "Vaticano",
            "VN" => "Việt Nam",
            "WF" => "Wallis et Futuna",
            "EH" => "الصحراء الغربية",
            "YE" => "اليمن",
        ];

        foreach ($local_name as $key => $value)
        {
            DB::table('countries')->where('code', $key)->update(['local_name' => $value]);
        }
    }
};
