<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasColumn('invoices', 'service_explanation'))
        {
            Schema::table('invoices', function (Blueprint $table)
            {
                $table->text('service_explanation')->nullable();
                $table->date('service_starts_on')->nullable();
                $table->date('service_ends_off')->nullable();
            });
        }
    }
};