<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('company_profiles', function (Blueprint $table)
        {
            $table->string('quote_email_body')->default('default.blade.php')->nullable()->change();
            $table->string('quote_approved_email_body')->default('default.blade.php')->nullable()->change();
            $table->string('quote_rejected_email_body')->default('default.blade.php')->nullable()->change();
            $table->string('invoice_email_body')->default('default.blade.php')->nullable()->change();
            $table->string('credit_memos_email_body')->default('default.blade.php')->nullable()->change();
            $table->string('overdue_invoice_email_body')->default('default.blade.php')->nullable()->change();
            $table->string('payment_receipt_email_body')->default('default.blade.php')->nullable()->change();
            $table->string('upcoming_payment_email_body')->default('default.blade.php')->nullable()->change();
        });
    }
};
