<?php
/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('users', 'two_factor_enabled'))
        {
            Schema::table('users', function (Blueprint $table)
            {
                $table->boolean('two_factor_enabled')
                    ->after('name')
                    ->default(false);
            });
        }

        if (!Schema::hasTable('users_two_factor_otp'))
        {
            Schema::create('users_two_factor_otp', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->integer('user_id');
                $table->string('otp', 6)->nullable();

            });
        }
    }


};
