<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('contacts', 'primary_isd_code'))
        {
            Schema::table('contacts', function (Blueprint $table)
            {
                $table->text('primary_isd_code')->nullable();
                $table->boolean('primary_is_mobile')->default(0);
                $table->text('alternate_isd_code')->nullable();
                $table->boolean('alternate_is_mobile')->default(0);
            });
        }
    }

};
