<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Settings\Models\Setting;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $files = File::files(storage_path('app/email_templates'));

        foreach ($files as $key => $file)
        {

            if ($file->getFilename() == 'creditMemoEmailBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('creditMemosMailTemplateDefault', $contents);
                Storage::put('email_templates/creditMemos/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'creditMemoEmailSubject.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('creditMemosSubjectDefault', $contents);
                Storage::put('email_templates/creditMemos/Subject/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'invoiceCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('invoiceMailTemplateCustom1', $contents);
                Storage::put('email_templates/invoice/MailTemplate/custom1.blade.php', $contents);
            }
            if ($file->getFilename() == 'invoiceEmailBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('invoiceMailTemplateDefault', $contents);
                Storage::put('email_templates/invoice/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'overdueInvoiceEmailBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('overdueInvoiceMailTemplateDefault', $contents);
                Storage::put('email_templates/overdueInvoice/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'overdueInvoiceEmailSubject.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('overdueInvoicesSubjectDefault', $contents);
                Storage::put('email_templates/overdueInvoice/Subject/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'paymentReceiptBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('paymentReceiptMailTemplateDefault', $contents);
                Storage::put('email_templates/paymentReceipt/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'paymentReceiptEmailSubject.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('paymentReceiptSubjectDefault', $contents);
                Storage::put('email_templates/paymentReceipt/Subject/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'quoteApprovedEmailBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('quoteApprovedMailTemplateDefault', $contents);
                Storage::put('email_templates/quoteApproved/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'quoteCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('quoteMailTemplateCustom1', $contents);
                Storage::put('email_templates/quote/MailTemplate/custom1.blade.php', $contents);
            }
            if ($file->getFilename() == 'quoteEmailBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('quoteMailTemplateDefault', $contents);
                Storage::put('email_templates/quote/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'quoteRejectedEmailBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('quoteRejectedMailTemplateDefault', $contents);
                Storage::put('email_templates/quoteRejected/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'upcomingPaymentNoticeEmailBody.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('upcomingPaymentMailTemplateDefault', $contents);
                Storage::put('email_templates/upcomingPayment/MailTemplate/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'upcomingPaymentNoticeEmailSubject.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('upcomingPaymentSubjectDefault', $contents);
                Storage::put('email_templates/upcomingPayment/Subject/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'creditMemoCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('creditMemosMailTemplateCustom1', $contents);
                Storage::put('email_templates/creditMemos/MailTemplate/custom1.blade.php', $contents);
            }
            if ($file->getFilename() == 'invoiceEmailSubject.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('invoiceSubjectDefault', $contents);
                Storage::put('email_templates/invoice/Subject/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'overdueInvoiceCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('overdueInvoiceMailTemplateCustom1', $contents);
                Storage::put('email_templates/overdueInvoice/MailTemplate/custom1.blade.php', $contents);
            }
            if ($file->getFilename() == 'paymentReceiptCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('paymentReceiptMailTemplateCustom1', $contents);
                Storage::put('email_templates/paymentReceipt/MailTemplate/custom1.blade.php', $contents);
            }
            if ($file->getFilename() == 'quoteApprovedCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('quoteApprovedMailTemplateCustom1', $contents);
                Storage::put('email_templates/quoteApproved/MailTemplate/custom1.blade.php', $contents);
            }
            if ($file->getFilename() == 'quoteEmailSubject.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('quoteSubjectDefault', $contents);
                Storage::put('email_templates/quote/Subject/default.blade.php', $contents);
            }
            if ($file->getFilename() == 'quoteRejectedCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('quoteRejectedMailTemplateCustom1', $contents);
                Storage::put('email_templates/quoteRejected/MailTemplate/custom1.blade.php', $contents);
            }
            if ($file->getFilename() == 'upcomingPaymentNoticeCustomMailTemplate.blade.php')
            {
                $filename = 'app/email_templates/' . $file->getFilename();
                $contents = file_get_contents(storage_path($filename), true);
                Setting::saveByKey('upcomingPaymentMailTemplateCustom1', $contents);
                Storage::put('email_templates/upcomingPayment/MailTemplate/custom1.blade.php', $contents);
            }

        }
    }

};
