<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\CompanyProfiles\Models\CompanyProfile;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('company_profiles', 'quote_email_body'))
        {
            Schema::table('company_profiles', function (Blueprint $table)
            {
                $table->text('quote_email_body')->nullable();
                $table->text('quote_approved_email_body')->nullable();
                $table->text('quote_rejected_email_body')->nullable();
                $table->text('invoice_email_body')->nullable();
                $table->text('credit_memos_email_body')->nullable();
                $table->text('overdue_invoice_email_body')->nullable();
                $table->text('payment_receipt_email_body')->nullable();
                $table->text('upcoming_payment_email_body')->nullable();
            });

            $companyProfiles = CompanyProfile::all();

            foreach ($companyProfiles as $company_profile)
            {
                $company_profile->quote_email_body            = 'default.blade.php';
                $company_profile->quote_approved_email_body   = 'default.blade.php';
                $company_profile->quote_rejected_email_body   = 'default.blade.php';
                $company_profile->invoice_email_body          = 'default.blade.php';
                $company_profile->credit_memos_email_body     = 'default.blade.php';
                $company_profile->overdue_invoice_email_body  = 'default.blade.php';
                $company_profile->payment_receipt_email_body  = 'default.blade.php';
                $company_profile->upcoming_payment_email_body = 'default.blade.php';
                $company_profile->save();
            }
        }
    }

};
