<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddSystemUserCustomField extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $user                   = DB::table('users')->where('user_type', 'system')->first();
        $systemUserCustomExists = DB::table('users_custom')->whereUserId($user->id)->exists();
        if ($systemUserCustomExists == false)
        {
            DB::table('users_custom')->insert([
                'user_id'    => $user->id,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
    }

}
