<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRecurringInvoiceTagsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('recurring_invoice_tags'))
        {
            Schema::create('recurring_invoice_tags', function (Blueprint $table)
            {
                $table->increments('id');
                $table->integer('recurring_invoice_id')->unsigned();
                $table->integer('tag_id')->unsigned();
                $table->timestamps();
            });
        }
    }
}
