<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use FI\Modules\Countries\Models\Country;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('countries'))
        {
            Schema::create('countries', function (Blueprint $table)
            {
                $table->increments('id');
                $table->string('code');
                $table->string('name');
            });
        }

        Country::truncate();

        $countries = [
            ['id' => '1', 'code' => 'AF', 'name' => 'Afghanistan'],
            ['id' => '2', 'code' => 'AL', 'name' => 'Albania'],
            ['id' => '3', 'code' => 'DZ', 'name' => 'Algeria'],
            ['id' => '4', 'code' => 'DS', 'name' => 'American Samoa'],
            ['id' => '5', 'code' => 'AD', 'name' => 'Andorra'],
            ['id' => '6', 'code' => 'AO', 'name' => 'Angola'],
            ['id' => '7', 'code' => 'AI', 'name' => 'Anguilla'],
            ['id' => '8', 'code' => 'AQ', 'name' => 'Antarctica'],
            ['id' => '9', 'code' => 'AG', 'name' => 'Antigua and Barbuda'],
            ['id' => '10', 'code' => 'AR', 'name' => 'Argentina'],
            ['id' => '11', 'code' => 'AM', 'name' => 'Armenia'],
            ['id' => '12', 'code' => 'AW', 'name' => 'Aruba'],
            ['id' => '13', 'code' => 'AU', 'name' => 'Australia'],
            ['id' => '14', 'code' => 'AT', 'name' => 'Austria'],
            ['id' => '15', 'code' => 'AZ', 'name' => 'Azerbaijan'],
            ['id' => '16', 'code' => 'BS', 'name' => 'Bahamas'],
            ['id' => '17', 'code' => 'BH', 'name' => 'Bahrain'],
            ['id' => '18', 'code' => 'BD', 'name' => 'Bangladesh'],
            ['id' => '19', 'code' => 'BB', 'name' => 'Barbados'],
            ['id' => '20', 'code' => 'BY', 'name' => 'Belarus'],
            ['id' => '21', 'code' => 'BE', 'name' => 'Belgium'],
            ['id' => '22', 'code' => 'BZ', 'name' => 'Belize'],
            ['id' => '23', 'code' => 'BJ', 'name' => 'Benin'],
            ['id' => '24', 'code' => 'BM', 'name' => 'Bermuda'],
            ['id' => '25', 'code' => 'BT', 'name' => 'Bhutan'],
            ['id' => '26', 'code' => 'BO', 'name' => 'Bolivia'],
            ['id' => '27', 'code' => 'BA', 'name' => 'Bosnia and Herzegovina'],
            ['id' => '28', 'code' => 'BW', 'name' => 'Botswana'],
            ['id' => '29', 'code' => 'BV', 'name' => 'Bouvet Island'],
            ['id' => '30', 'code' => 'BR', 'name' => 'Brazil'],
            ['id' => '31', 'code' => 'IO', 'name' => 'British Indian Ocean Territory'],
            ['id' => '32', 'code' => 'BN', 'name' => 'Brunei Darussalam'],
            ['id' => '33', 'code' => 'BG', 'name' => 'Bulgaria'],
            ['id' => '34', 'code' => 'BF', 'name' => 'Burkina Faso'],
            ['id' => '35', 'code' => 'BI', 'name' => 'Burundi'],
            ['id' => '36', 'code' => 'KH', 'name' => 'Cambodia'],
            ['id' => '37', 'code' => 'CM', 'name' => 'Cameroon'],
            ['id' => '38', 'code' => 'CA', 'name' => 'Canada'],
            ['id' => '39', 'code' => 'CV', 'name' => 'Cape Verde'],
            ['id' => '40', 'code' => 'KY', 'name' => 'Cayman Islands'],
            ['id' => '41', 'code' => 'CF', 'name' => 'Central African Republic'],
            ['id' => '42', 'code' => 'TD', 'name' => 'Chad'],
            ['id' => '43', 'code' => 'CL', 'name' => 'Chile'],
            ['id' => '44', 'code' => 'CN', 'name' => 'China'],
            ['id' => '45', 'code' => 'CX', 'name' => 'Christmas Island'],
            ['id' => '46', 'code' => 'CC', 'name' => 'Cocos (Keeling) Islands'],
            ['id' => '47', 'code' => 'CO', 'name' => 'Colombia'],
            ['id' => '48', 'code' => 'KM', 'name' => 'Comoros'],
            ['id' => '49', 'code' => 'CD', 'name' => 'Democratic Republic of the Congo'],
            ['id' => '50', 'code' => 'CG', 'name' => 'Republic of Congo'],
            ['id' => '51', 'code' => 'CK', 'name' => 'Cook Islands'],
            ['id' => '52', 'code' => 'CR', 'name' => 'Costa Rica'],
            ['id' => '53', 'code' => 'HR', 'name' => 'Croatia (Hrvatska)'],
            ['id' => '54', 'code' => 'CU', 'name' => 'Cuba'],
            ['id' => '55', 'code' => 'CY', 'name' => 'Cyprus'],
            ['id' => '56', 'code' => 'CZ', 'name' => 'Czech Republic'],
            ['id' => '57', 'code' => 'DK', 'name' => 'Denmark'],
            ['id' => '58', 'code' => 'DJ', 'name' => 'Djibouti'],
            ['id' => '59', 'code' => 'DM', 'name' => 'Dominica'],
            ['id' => '60', 'code' => 'DO', 'name' => 'Dominican Republic'],
            ['id' => '61', 'code' => 'TP', 'name' => 'East Timor'],
            ['id' => '62', 'code' => 'EC', 'name' => 'Ecuador'],
            ['id' => '63', 'code' => 'EG', 'name' => 'Egypt'],
            ['id' => '64', 'code' => 'SV', 'name' => 'El Salvador'],
            ['id' => '65', 'code' => 'GQ', 'name' => 'Equatorial Guinea'],
            ['id' => '66', 'code' => 'ER', 'name' => 'Eritrea'],
            ['id' => '67', 'code' => 'EE', 'name' => 'Estonia'],
            ['id' => '68', 'code' => 'ET', 'name' => 'Ethiopia'],
            ['id' => '69', 'code' => 'FK', 'name' => 'Falkland Islands (Malvinas)'],
            ['id' => '70', 'code' => 'FO', 'name' => 'Faroe Islands'],
            ['id' => '71', 'code' => 'FJ', 'name' => 'Fiji'],
            ['id' => '72', 'code' => 'FI', 'name' => 'Finland'],
            ['id' => '73', 'code' => 'FR', 'name' => 'France'],
            ['id' => '74', 'code' => 'FX', 'name' => 'France, Metropolitan'],
            ['id' => '75', 'code' => 'GF', 'name' => 'French Guiana'],
            ['id' => '76', 'code' => 'PF', 'name' => 'French Polynesia'],
            ['id' => '77', 'code' => 'TF', 'name' => 'French Southern Territories'],
            ['id' => '78', 'code' => 'GA', 'name' => 'Gabon'],
            ['id' => '79', 'code' => 'GM', 'name' => 'Gambia'],
            ['id' => '80', 'code' => 'GE', 'name' => 'Georgia'],
            ['id' => '81', 'code' => 'DE', 'name' => 'Germany'],
            ['id' => '82', 'code' => 'GH', 'name' => 'Ghana'],
            ['id' => '83', 'code' => 'GI', 'name' => 'Gibraltar'],
            ['id' => '84', 'code' => 'GK', 'name' => 'Guernsey'],
            ['id' => '85', 'code' => 'GR', 'name' => 'Greece'],
            ['id' => '86', 'code' => 'GL', 'name' => 'Greenland'],
            ['id' => '87', 'code' => 'GD', 'name' => 'Grenada'],
            ['id' => '88', 'code' => 'GP', 'name' => 'Guadeloupe'],
            ['id' => '89', 'code' => 'GU', 'name' => 'Guam'],
            ['id' => '90', 'code' => 'GT', 'name' => 'Guatemala'],
            ['id' => '91', 'code' => 'GN', 'name' => 'Guinea'],
            ['id' => '92', 'code' => 'GW', 'name' => 'Guinea-Bissau'],
            ['id' => '93', 'code' => 'GY', 'name' => 'Guyana'],
            ['id' => '94', 'code' => 'HT', 'name' => 'Haiti'],
            ['id' => '95', 'code' => 'HM', 'name' => 'Heard and Mc Donald Islands'],
            ['id' => '96', 'code' => 'HN', 'name' => 'Honduras'],
            ['id' => '97', 'code' => 'HK', 'name' => 'Hong Kong'],
            ['id' => '98', 'code' => 'HU', 'name' => 'Hungary'],
            ['id' => '99', 'code' => 'IS', 'name' => 'Iceland'],
            ['id' => '100', 'code' => 'IN', 'name' => 'India'],
            ['id' => '101', 'code' => 'IM', 'name' => 'Isle of Man'],
            ['id' => '102', 'code' => 'ID', 'name' => 'Indonesia'],
            ['id' => '103', 'code' => 'IR', 'name' => 'Iran (Islamic Republic of)'],
            ['id' => '104', 'code' => 'IQ', 'name' => 'Iraq'],
            ['id' => '105', 'code' => 'IE', 'name' => 'Ireland'],
            ['id' => '106', 'code' => 'IL', 'name' => 'Israel'],
            ['id' => '107', 'code' => 'IT', 'name' => 'Italy'],
            ['id' => '108', 'code' => 'CI', 'name' => 'Ivory Coast'],
            ['id' => '109', 'code' => 'JE', 'name' => 'Jersey'],
            ['id' => '110', 'code' => 'JM', 'name' => 'Jamaica'],
            ['id' => '111', 'code' => 'JP', 'name' => 'Japan'],
            ['id' => '112', 'code' => 'JO', 'name' => 'Jordan'],
            ['id' => '113', 'code' => 'KZ', 'name' => 'Kazakhstan'],
            ['id' => '114', 'code' => 'KE', 'name' => 'Kenya'],
            ['id' => '115', 'code' => 'KI', 'name' => 'Kiribati'],
            ['id' => '116', 'code' => 'KP', 'name' => 'Korea, Democratic People\'s Republic of'],
            ['id' => '117', 'code' => 'KR', 'name' => 'Korea, Republic of'],
            ['id' => '118', 'code' => 'XK', 'name' => 'Kosovo'],
            ['id' => '119', 'code' => 'KW', 'name' => 'Kuwait'],
            ['id' => '120', 'code' => 'KG', 'name' => 'Kyrgyzstan'],
            ['id' => '121', 'code' => 'LA', 'name' => 'Lao People\'s Democratic Republic'],
            ['id' => '122', 'code' => 'LV', 'name' => 'Latvia'],
            ['id' => '123', 'code' => 'LB', 'name' => 'Lebanon'],
            ['id' => '124', 'code' => 'LS', 'name' => 'Lesotho'],
            ['id' => '125', 'code' => 'LR', 'name' => 'Liberia'],
            ['id' => '126', 'code' => 'LY', 'name' => 'Libyan Arab Jamahiriya'],
            ['id' => '127', 'code' => 'LI', 'name' => 'Liechtenstein'],
            ['id' => '128', 'code' => 'LT', 'name' => 'Lithuania'],
            ['id' => '129', 'code' => 'LU', 'name' => 'Luxembourg'],
            ['id' => '130', 'code' => 'MO', 'name' => 'Macau'],
            ['id' => '131', 'code' => 'MK', 'name' => 'North Macedonia'],
            ['id' => '132', 'code' => 'MG', 'name' => 'Madagascar'],
            ['id' => '133', 'code' => 'MW', 'name' => 'Malawi'],
            ['id' => '134', 'code' => 'MY', 'name' => 'Malaysia'],
            ['id' => '135', 'code' => 'MV', 'name' => 'Maldives'],
            ['id' => '136', 'code' => 'ML', 'name' => 'Mali'],
            ['id' => '137', 'code' => 'MT', 'name' => 'Malta'],
            ['id' => '138', 'code' => 'MH', 'name' => 'Marshall Islands'],
            ['id' => '139', 'code' => 'MQ', 'name' => 'Martinique'],
            ['id' => '140', 'code' => 'MR', 'name' => 'Mauritania'],
            ['id' => '141', 'code' => 'MU', 'name' => 'Mauritius'],
            ['id' => '142', 'code' => 'TY', 'name' => 'Mayotte'],
            ['id' => '143', 'code' => 'MX', 'name' => 'Mexico'],
            ['id' => '144', 'code' => 'FM', 'name' => 'Micronesia, Federated States of'],
            ['id' => '145', 'code' => 'MD', 'name' => 'Moldova, Republic of'],
            ['id' => '146', 'code' => 'MC', 'name' => 'Monaco'],
            ['id' => '147', 'code' => 'MN', 'name' => 'Mongolia'],
            ['id' => '148', 'code' => 'ME', 'name' => 'Montenegro'],
            ['id' => '149', 'code' => 'MS', 'name' => 'Montserrat'],
            ['id' => '150', 'code' => 'MA', 'name' => 'Morocco'],
            ['id' => '151', 'code' => 'MZ', 'name' => 'Mozambique'],
            ['id' => '152', 'code' => 'MM', 'name' => 'Myanmar'],
            ['id' => '153', 'code' => 'NA', 'name' => 'Namibia'],
            ['id' => '154', 'code' => 'NR', 'name' => 'Nauru'],
            ['id' => '155', 'code' => 'NP', 'name' => 'Nepal'],
            ['id' => '156', 'code' => 'NL', 'name' => 'Netherlands'],
            ['id' => '157', 'code' => 'AN', 'name' => 'Netherlands Antilles'],
            ['id' => '158', 'code' => 'NC', 'name' => 'New Caledonia'],
            ['id' => '159', 'code' => 'NZ', 'name' => 'New Zealand'],
            ['id' => '160', 'code' => 'NI', 'name' => 'Nicaragua'],
            ['id' => '161', 'code' => 'NE', 'name' => 'Niger'],
            ['id' => '162', 'code' => 'NG', 'name' => 'Nigeria'],
            ['id' => '163', 'code' => 'NU', 'name' => 'Niue'],
            ['id' => '164', 'code' => 'NF', 'name' => 'Norfolk Island'],
            ['id' => '165', 'code' => 'MP', 'name' => 'Northern Mariana Islands'],
            ['id' => '166', 'code' => 'NO', 'name' => 'Norway'],
            ['id' => '167', 'code' => 'OM', 'name' => 'Oman'],
            ['id' => '168', 'code' => 'PK', 'name' => 'Pakistan'],
            ['id' => '169', 'code' => 'PW', 'name' => 'Palau'],
            ['id' => '170', 'code' => 'PS', 'name' => 'Palestine'],
            ['id' => '171', 'code' => 'PA', 'name' => 'Panama'],
            ['id' => '172', 'code' => 'PG', 'name' => 'Papua New Guinea'],
            ['id' => '173', 'code' => 'PY', 'name' => 'Paraguay'],
            ['id' => '174', 'code' => 'PE', 'name' => 'Peru'],
            ['id' => '175', 'code' => 'PH', 'name' => 'Philippines'],
            ['id' => '176', 'code' => 'PN', 'name' => 'Pitcairn'],
            ['id' => '177', 'code' => 'PL', 'name' => 'Poland'],
            ['id' => '178', 'code' => 'PT', 'name' => 'Portugal'],
            ['id' => '179', 'code' => 'PR', 'name' => 'Puerto Rico'],
            ['id' => '180', 'code' => 'QA', 'name' => 'Qatar'],
            ['id' => '181', 'code' => 'RE', 'name' => 'Reunion'],
            ['id' => '182', 'code' => 'RO', 'name' => 'Romania'],
            ['id' => '183', 'code' => 'RU', 'name' => 'Russian Federation'],
            ['id' => '184', 'code' => 'RW', 'name' => 'Rwanda'],
            ['id' => '185', 'code' => 'KN', 'name' => 'Saint Kitts and Nevis'],
            ['id' => '186', 'code' => 'LC', 'name' => 'Saint Lucia'],
            ['id' => '187', 'code' => 'VC', 'name' => 'Saint Vincent and the Grenadines'],
            ['id' => '188', 'code' => 'WS', 'name' => 'Samoa'],
            ['id' => '189', 'code' => 'SM', 'name' => 'San Marino'],
            ['id' => '190', 'code' => 'ST', 'name' => 'Sao Tome and Principe'],
            ['id' => '191', 'code' => 'SA', 'name' => 'Saudi Arabia'],
            ['id' => '192', 'code' => 'SN', 'name' => 'Senegal'],
            ['id' => '193', 'code' => 'RS', 'name' => 'Serbia'],
            ['id' => '194', 'code' => 'SC', 'name' => 'Seychelles'],
            ['id' => '195', 'code' => 'SL', 'name' => 'Sierra Leone'],
            ['id' => '196', 'code' => 'SG', 'name' => 'Singapore'],
            ['id' => '197', 'code' => 'SK', 'name' => 'Slovakia'],
            ['id' => '198', 'code' => 'SI', 'name' => 'Slovenia'],
            ['id' => '199', 'code' => 'SB', 'name' => 'Solomon Islands'],
            ['id' => '200', 'code' => 'SO', 'name' => 'Somalia'],
            ['id' => '201', 'code' => 'ZA', 'name' => 'South Africa'],
            ['id' => '202', 'code' => 'GS', 'name' => 'South Georgia South Sandwich Islands'],
            ['id' => '203', 'code' => 'SS', 'name' => 'South Sudan'],
            ['id' => '204', 'code' => 'ES', 'name' => 'Spain'],
            ['id' => '205', 'code' => 'LK', 'name' => 'Sri Lanka'],
            ['id' => '206', 'code' => 'SH', 'name' => 'St. Helena'],
            ['id' => '207', 'code' => 'PM', 'name' => 'St. Pierre and Miquelon'],
            ['id' => '208', 'code' => 'SD', 'name' => 'Sudan'],
            ['id' => '209', 'code' => 'SR', 'name' => 'Suriname'],
            ['id' => '210', 'code' => 'SJ', 'name' => 'Svalbard and Jan Mayen Islands'],
            ['id' => '211', 'code' => 'SZ', 'name' => 'Swaziland'],
            ['id' => '212', 'code' => 'SE', 'name' => 'Sweden'],
            ['id' => '213', 'code' => 'CH', 'name' => 'Switzerland'],
            ['id' => '214', 'code' => 'SY', 'name' => 'Syrian Arab Republic'],
            ['id' => '215', 'code' => 'TW', 'name' => 'Taiwan'],
            ['id' => '216', 'code' => 'TJ', 'name' => 'Tajikistan'],
            ['id' => '217', 'code' => 'TZ', 'name' => 'Tanzania, United Republic of'],
            ['id' => '218', 'code' => 'TH', 'name' => 'Thailand'],
            ['id' => '219', 'code' => 'TG', 'name' => 'Togo'],
            ['id' => '220', 'code' => 'TK', 'name' => 'Tokelau'],
            ['id' => '221', 'code' => 'TO', 'name' => 'Tonga'],
            ['id' => '222', 'code' => 'TT', 'name' => 'Trinidad and Tobago'],
            ['id' => '223', 'code' => 'TN', 'name' => 'Tunisia'],
            ['id' => '224', 'code' => 'TR', 'name' => 'Turkey'],
            ['id' => '225', 'code' => 'TM', 'name' => 'Turkmenistan'],
            ['id' => '226', 'code' => 'TC', 'name' => 'Turks and Caicos Islands'],
            ['id' => '227', 'code' => 'TV', 'name' => 'Tuvalu'],
            ['id' => '228', 'code' => 'UG', 'name' => 'Uganda'],
            ['id' => '229', 'code' => 'UA', 'name' => 'Ukraine'],
            ['id' => '230', 'code' => 'AE', 'name' => 'United Arab Emirates'],
            ['id' => '231', 'code' => 'GB', 'name' => 'United Kingdom'],
            ['id' => '232', 'code' => 'US', 'name' => 'United States'],
            ['id' => '233', 'code' => 'UM', 'name' => 'United States minor outlying islands'],
            ['id' => '234', 'code' => 'UY', 'name' => 'Uruguay'],
            ['id' => '235', 'code' => 'UZ', 'name' => 'Uzbekistan'],
            ['id' => '236', 'code' => 'VU', 'name' => 'Vanuatu'],
            ['id' => '237', 'code' => 'VA', 'name' => 'Vatican City State'],
            ['id' => '238', 'code' => 'VE', 'name' => 'Venezuela'],
            ['id' => '239', 'code' => 'VN', 'name' => 'Vietnam'],
            ['id' => '240', 'code' => 'VG', 'name' => 'Virgin Islands (British)'],
            ['id' => '241', 'code' => 'VI', 'name' => 'Virgin Islands (U.S.)'],
            ['id' => '242', 'code' => 'WF', 'name' => 'Wallis and Futuna Islands'],
            ['id' => '243', 'code' => 'EH', 'name' => 'Western Sahara'],
            ['id' => '244', 'code' => 'YE', 'name' => 'Yemen'],
            ['id' => '245', 'code' => 'ZM', 'name' => 'Zambia'],
            ['id' => '246', 'code' => 'ZW', 'name' => 'Zimbabwe'],
        ];

        if (count(Country::all()) == 0)
        {
            Country::insert($countries);
        }
    }
}
