<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('user_settings'))
        {
            Schema::create('user_settings', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->integer('user_id');
                $table->string('setting_key', 255);
                $table->text('setting_value');
            });
        }
    }
}
