<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterClientsForOnlinePaymentProcessingFee extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('clients', 'online_payment_processing_fee'))
        {
            Schema::table('clients', function (Blueprint $table)
            {
                $table->enum('online_payment_processing_fee', ['default', 'yes', 'no'])->default('default');
            });
        }
    }
}
