<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMruTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mru'))
        {
            Schema::create('mru', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->integer('user_id');
                $table->string('module', 50);
                $table->string('title');
                $table->string('url');
            });
        }
    }
}
