<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('user_permissions'))
        {
            Schema::create('user_permissions', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->integer('user_id');
                $table->string('module', 255);
                $table->boolean('is_view')->default(0);
                $table->boolean('is_create')->default(0);
                $table->boolean('is_update')->default(0);
                $table->boolean('is_delete')->default(0);
                $table->unique(['user_id', 'module']);
            });
        }
    }
}
