<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTagsTable extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('tags'))
        {
            Schema::create('tags', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->string('tag_entity');
                $table->string('name');
                $table->string('forecolor')->nullable();
                $table->string('backcolor')->nullable();
                $table->boolean('bold')->nullable();
                $table->boolean('italic')->nullable();
            });
        }
    }
}