<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CompanyProfilesTable extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('company_profiles'))
        {
            Schema::create('company_profiles', function (Blueprint $table)
            {
                $table->increments('id');
                $table->timestamps();
                $table->string('company')->nullable();
                $table->text('address')->nullable();
                $table->string('city')->nullable();
                $table->string('state')->nullable();
                $table->string('zip')->nullable();
                $table->string('country')->nullable();
                $table->string('phone')->nullable();
                $table->string('fax')->nullable();
                $table->string('mobile')->nullable();
                $table->string('web')->nullable();
            });
        }
    }
}
