<!doctype html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{ trans('fi.quote') }} #{{ $quote->number }}</title>

    <style>
        @page {
            margin: 25px;
        }

        body {
            color: #001028;
            background: #FFFFFF;
            font-family: DejaVu Sans, Helvetica, sans-serif;
            font-size: 12px;
            margin-left: 0px;
            margin-right: 0px;
        }

        a {
            color: #5D6975;
            border-bottom: 1px solid currentColor;
            text-decoration: none;
        }

        h1 {
            color: #5D6975;
            font-size: 2.8em;
            line-height: 1.4em;
            font-weight: bold;
            margin: 0;
        }

        table {
            width: 100%;
            border-spacing: 0;
            margin-bottom: 20px;
            padding: 0 2px;
        }

        th, .section-header {
            padding: 16px 10px;
            color: #5D6975;
            border-bottom: 1px solid #C1CED9;
            white-space: nowrap;
            font-weight: normal;
            text-align: center;
        }

        @media only screen and (max-width: 600px) {
            th, .section-header {
                padding: 5px 4px;
            }
        }

        @media only screen and (max-width: 320px) {
            table {
                width: 100%;
                border-spacing: 0;
                margin-bottom: 20px;
                font-size: 10px;
                margin-left: 0px;
            }
        }

        td {
            padding: 10px 5px;
        }

        table.alternate tr:nth-child(odd) td {
            background: #F5F5F5;
        }

        th.amount, td.amount {
            text-align: right;
        }

        .info {
            color: #5D6975;
            font-weight: bold;
        }

        .terms {
            padding: 10px;
            text-align: center;
        }

        .footer {
            text-align: center;
            padding: 10px;
        }

        #cp-logo {
            max-width: 114px;
        }

        .name_des_p {
            margin: 5px 0;
        }
    </style>
</head>
<body class="body-light">

<table class="body-light">
    <tr>
        <td style="width: {{ config('fi.qrCodeOnInvoiceQuote') == 1 ? 33 : 50 }}%;" valign="top">
            <h1>{{ mb_strtoupper(trans('fi.quote')) }}</h1>
            <span class="info">{{ mb_strtoupper(trans('fi.quote')) }} #</span>{{ $quote->number }}<br>
            <span class="info">{{ mb_strtoupper(trans('fi.issued')) }}</span> {{ $quote->formatted_created_at }}<br>
            <span class="info">{{ mb_strtoupper(trans('fi.expires')) }}</span> {{ $quote->formatted_expires_at }}
            <br><br>
            <span class="info">{{ mb_strtoupper(trans('fi.bill_to')) }}</span><br>
            {{ $quote->client->title != '' ? $quote->client->title.' '.$quote->client->name : $quote->client->name }}
            <br><br>
            @if ($quote->client->address)
                {!! $quote->client->formatted_address !!}<br>
            @endif
            @if(config('fi.clientColumnSettingsVatTaxId') == 1)
                @if($quote->client->vat_tax_id)
                    <span class="info">{{ trans('fi.vat_tax_id') }}
                    :</span> {{ $quote->client->vat_tax_id }}<br>
                @endif
            @endif
        </td>
        @if(config('fi.qrCodeOnInvoiceQuote') == 1)
            <td style="width: 33%;" valign="top" align="center">
                <img alt="QR-Code" width=""
                     src="data:image/png;base64,{!! DNS2D::getBarcodePNG(route('clientCenter.public.quote.show', [$quote->url_key]),"QRCODE") !!}"
                     class="img-responsive">
            </td>
        @endif
        <td style="width: {{ config('fi.qrCodeOnInvoiceQuote') == 1 ? 33 : 50 }}%; text-align: right;" valign="top">
            {!! $quote->companyProfile->logo() !!}<br>
            {{ $quote->companyProfile->company }}<br>
            {!! $quote->companyProfile->formatted_address !!}<br>
            @if ($quote->companyProfile->phone)
                {{ $quote->companyProfile->phone }}<br>
            @endif
            @if ($quote->user->fromEmail)
                <a href="mailto:{{ $quote->user->fromEmail }}">{{ $quote->user->fromEmail }}</a><br>
            @endif
            @if(config('fi.clientColumnSettingsVatTaxId') == 1)
                <br>{!! nl2br($quote->companyProfile->vat_detail) !!}
            @endif
        </td>
    </tr>
</table>

<table class="alternate table-light">
    <thead>
    <tr>
        <th style="text-align: left;" width="45%"><strong>{{ mb_strtoupper(trans('fi.product')) }}
                / {{ mb_strtoupper(trans('fi.description')) }}</strong></th>
        <th class="amount" width="10%"><strong>{{ mb_strtoupper(trans('fi.quantity')) }}</strong></th>
        <th class="amount" width="15%"><strong>{{ mb_strtoupper(trans('fi.price')) }}</strong></th>
        @if ($hasLineItemDiscount)
            <th class="amount" width="10%"><strong>{{ mb_strtoupper(trans('fi.discount')) }}</strong></th>
        @else
            <th class="amount" width="10%"></th>
        @endif
        <th class="amount" width="20%"><strong>{{ mb_strtoupper(trans('fi.total')) }}</strong></th>
    </tr>
    </thead>
    <tbody>
    @foreach ($quote->items as $item)
        <tr>
            <td>
                <p class="name_des_p" ><strong>{!! $item->name !!}</strong></p>
                <p class="name_des_p" style="font-size: 11px;"> {!! $item->formatted_description !!}</p>
                @if(count($quoteItemCustomFields))
                    <table class="customfield-table" style="padding: 5px 0 0 0; margin-bottom: 0;">
                        @foreach(array_chunk($quoteItemCustomFields, 3) as $chunkQuoteItemCustomField)
                            @foreach($chunkQuoteItemCustomField as $quoteItemCustomField)
                                @if(!empty($item->custom->{$quoteItemCustomField->column_name}))
                                    <tr>
                                        <td>
                                            <div class="custom_img">{!! $item->custom->imageView($quoteItemCustomField->column_name,75) !!}</div>
                                            <strong>{{ ucfirst($quoteItemCustomField->field_label) }} :</strong>
                                            <span style="margin-left: 4px;">{!! ($item->custom->{$quoteItemCustomField->column_name}) ?? "-" !!}</span>
                                        </td>
                                    </tr>
                                @endif
                            @endforeach
                        @endforeach
                    </table>
                @endif
            </td>
            <td nowrap class="amount">{{ $item->formatted_quantity }}</td>
            <td nowrap class="amount">{{ $item->formatted_price }}</td>
            @if ($hasLineItemDiscount)
                <td class="amount">{{ $item->formatted_discount }}</td>
            @else
                <td class="amount"></td>
            @endif
            <td nowrap class="amount">{{ $item->amount->formatted_subtotal }}</td>
        </tr>
    @endforeach

    <tr>
        <td colspan="4" class="amount"><strong>{{ mb_strtoupper(trans('fi.subtotal')) }}</strong></td>
        <td class="amount">{{ $quote->amount->formatted_subtotal }}</td>
    </tr>

    @if ($quote->discount > 0)
        <tr>
            <td colspan="4" class="amount"><strong>{{ mb_strtoupper(trans('fi.discount')) }}</strong></td>
            <td class="amount">{{ $quote->amount->formatted_discount }}</td>
        </tr>
    @endif

    @foreach ($quote->summarized_taxes as $tax)
        <tr>
            <td colspan="4" class="amount">{{ mb_strtoupper($tax->name) }} ({{ $tax->percent }})</td>
            <td class="amount">{{ $tax->total }}</td>
        </tr>
    @endforeach

    <tr>
        <td colspan="4" class="amount"><strong>{{ mb_strtoupper(trans('fi.total')) }}</strong></td>
        <td class="amount">{{ $quote->amount->formatted_total }}</td>
    </tr>
    </tbody>
</table>

<table class="body-light">
    @if ($quote->terms != null)
        <tr>
            <td colspan="2">
                <div class="section-header">{{ mb_strtoupper(trans('fi.terms_and_conditions')) }}</div>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <div class="terms">{!! $quote->formatted_terms !!}</div>

                @if($quote->online_payment_processing_fee == 'yes')
                    <div class="terms text-justify" style="text-align: center;">
                        <span style="color: #d82525">* </span> {!! config('fi.feeExplanation') !!}<span style="color: #d82525"> *</span>
                    </div>
                @endif
            </td>
        </tr>
    @endif
    @if ($quote->footer != null)
        <tr>
            <td colspan="2">
                <div class="section-header">{{ mb_strtoupper(trans('fi.footer')) }}</div>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <div class="footer">{!! $quote->formatted_footer !!}</div>
            </td>
        </tr>
    @endif

</table>

</body>
</html>