<?php 

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Support;

class Languages
{
    /**
     * Provide a list of the available language translations.
     *
     * @return array
     */
    static function listLanguages()
    {
        $directories       = Directory::listContents(base_path('resources/lang'));
        $fullNameLanguages = [
            'ca'    => 'Catalan',
            'cs'    => 'Čech',
            'da'    => 'Dansk',
            'de'    => 'Deutsch',
            'en'    => 'English',
            'es'    => 'Española',
            'fr'    => 'Français',
            'fr_ca' => 'Français Canadien',
            'it'    => 'Italian',
            'lt'    => 'Lietuvių',
            'nl'    => 'Nederlands',
            'sv'    => 'Svenska',
            'tr'    => 'Türkçe',
        ];
        $languages         = [];

        foreach ($directories as $directory)
        {
            foreach ($fullNameLanguages as $key => $value)
            {

                if ($key == $directory)
                {
                    $languages[$directory] = ($value) ? strtoupper($directory) . ' - ' . ucfirst($value) : $directory;
                    break;
                }
                else
                {
                    $languages[$directory] = $directory;
                }
            }
        }

        return $languages;
    }
}