<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Support;

use Collective\Html\FormFacade;
use FI\Modules\Clients\Models\Client;

class Contacts
{
    private $client;
    private $user;

    public function __construct(Client $client)
    {
        $this->client = $client;
        $this->user   = auth()->user();
    }

    public function contactDropdownTo($defaultUser = true, $type = null)
    {
        $allContacts      = $this->getAllContacts($defaultUser);
        $selectedContacts = $this->getSelectedContactsTo($type);

        return FormFacade::select('to', $allContacts, $selectedContacts, ['id' => 'to', 'multiple' => 'multiple', 'class' => 'form-control form-control-sm']);
    }

    public function contactMobileDropdownTo()
    {
        $allContacts      = $this->getAllContactsMobile();
        $selectedContacts = $this->getSelectedContactsTo();

        return FormFacade::select('to', $allContacts, $selectedContacts, ['id' => 'to', 'multiple' => 'multiple', 'class' => 'form-control form-control-sm']);
    }

    public function contactDropdownCc($type = null)
    {
        $allContacts      = $this->getAllContacts();
        $selectedContacts = $this->getSelectedContactsCc($type);

        return FormFacade::select('cc', $allContacts, $selectedContacts, ['id' => 'cc', 'multiple' => 'multiple', 'class' => 'form-control form-control-sm']);
    }

    public function contactDropdownBcc($type = null)
    {
        $allContacts      = $this->getAllContacts();
        $selectedContacts = $this->getSelectedContactsBcc($type);

        return FormFacade::select('bcc', $allContacts, $selectedContacts, ['id' => 'bcc', 'multiple' => 'multiple', 'class' => 'form-control form-control-sm']);
    }

    public function getSelectedContactsTo($type = null)
    {
        if ($this->client->email_default == 'use_parent_email' && $this->client->parent_client_id)
        {
            return collect([$this->client->parent->email]);
        }
        elseif ($this->client->email_default == 'use_third_party_bill_payer_email' && $this->client->invoices_paid_by && $this->client->invoices_paid_by_email)
        {
            return collect([$this->client->invoices_paid_by_email]);
        }
        else
        {
            $contacts_array = ($type != null) ? $this->client->contacts->whereIn('default_to', [1, $type])->pluck('email')->toArray() : $this->client->contacts->where('default_to', 1)->pluck('email')->toArray();
            return collect(array_filter(array_merge($contacts_array, [$this->client->email])));
        }
    }

    public function getContactsTo()
    {
        return $this->client->contacts->pluck('name', 'email');
    }

    public function getSelectedContactsCc($type = null)
    {
        $contacts = ($type != null) ? $this->client->contacts->whereIn('default_cc', [1, $type])->pluck('email')->toArray() : $this->client->contacts->where('default_cc', 1)->pluck('email')->toArray();;

        if (config('fi.mailDefaultCc'))
        {
            $contacts = array_merge($contacts, [config('fi.mailDefaultCc')]);
        }

        return $contacts;
    }

    public function getSelectedContactsBcc($type = null)
    {
        $contacts = ($type != null) ? $this->client->contacts->whereIn('default_bcc', [1, $type])->pluck('email')->toArray() : $this->client->contacts->where('default_bcc', 1)->pluck('email')->toArray();;

        if (config('fi.mailDefaultBcc'))
        {
            $contacts = array_merge($contacts, [config('fi.mailDefaultBcc')]);
        }

        return $contacts;
    }

    public function getAllContacts($defaultUser = true)
    {
        $contacts = [];
        if ($this->client->email)
        {
            $contacts[$this->client->email] = $this->getFormattedContact($this->client->name, $this->client->email);
        }
        if ($this->client->email_default == 'use_parent_email' && $this->client->parent_client_id)
        {
            $parentClient                   = $this->client->parent;
            $contacts[$parentClient->email] = $this->getFormattedContact($parentClient->name, $parentClient->email);
        }
        if ($this->client->email_default == 'use_third_party_bill_payer_email' && $this->client->invoices_paid_by && $this->client->invoices_paid_by_email)
        {
            $contacts[$this->client->invoices_paid_by_email] = $this->getFormattedContact($this->client->invoices_paid_by_name, $this->client->invoices_paid_by_email);
        }

        foreach ($this->client->contacts->where('status', 1)->pluck('name', 'email') as $email => $name)
        {
            $contacts[$email] = $this->getFormattedContact($name, $email);
        }

        if ($defaultUser == true)
        {
            $contacts[$this->user->email] = $this->getFormattedContact($this->user->name, $this->user->email);
        }

        if (config('fi.mailDefaultCc'))
        {
            $contacts[config('fi.mailDefaultCc')] = config('fi.mailDefaultCc');
        }

        if (config('fi.mailDefaultBcc'))
        {
            $contacts[config('fi.mailDefaultBcc')] = config('fi.mailDefaultBcc');
        }

        return $contacts;
    }

    public function getAllContactsMobile()
    {
        $contacts = [];

        foreach ($this->client->contacts as $contact)
        {
            if ($contact->primary_is_mobile == 1 && $contact->primary_isd_code && $contact->primary_phone)
            {
                $mobile            = $contact->primary_isd_code . $contact->primary_phone;
                $contacts[$mobile] = $this->getFormattedContact($contact->name, $mobile);
            }
            if ($contact->alternate_is_mobile == 1 && $contact->alternate_isd_code && $contact->alternate_phone)
            {
                $mobile            = $contact->alternate_isd_code . $contact->alternate_phone;
                $contacts[$mobile] = $this->getFormattedContact($contact->name, $mobile);
            }

        }

        return $contacts;
    }

    private function getFormattedContact($name, $email)
    {
        return $name . ' <' . $email . '>';
    }
}
