@if(count($userSettingShortcuts)>0)
    <div class="row">
        <div class="col-12">
            <div class="form-group m-0">
                <label>{{trans('fi.title_bar_shortcuts')}}</label>
            </div>
        </div>
        <div class="col-12 table-responsive">
            <table class="table table-hover table-striped table-sm text-nowrap">
                <tbody>
                @foreach($userSettingShortcuts as $key => $value)
                    <tr>
                        <td data-toggle="tooltip" data-placement="auto" title="{{$value->formatted_setting_description}}">{{$value->formatted_setting_value_url}}</td>
                        <td title="{{$value->formatted_setting_description}}">
                            <span class="badge badge-info">
                                <i class="{{$value->formatted_setting_value_icon}} fa-2x"></i></span>
                        </td>
                        <td class="text-right">
                            <button type="button" class="btn btn-xs btn-outline-primary  shortcut-edit"
                                    data-id="{{$value->id}}" data-user="{{$user->id}}"><i class="fa fa-edit"></i>
                            </button>
                            <button type="button" class="btn btn-xs btn-outline-danger shortcut-delete" data-id="{{$value->id}}" data-user="{{$user->id}}">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endif

@if(count($userSettingShortcuts)< 5)
    <div class="row">
        <div class="col-md-6">
            <button type="button" class="btn btn-sm btn-primary" id="add-url-shortcut"
                    data-user="{{$user->id}}">
                <i class="fa fa-plus"></i>
                {{trans('fi.add_title_bar_shortcut')}}
            </button>
        </div>
    </div>
@endif