@include('layouts._bootstrap_icon_picker')
<script type="text/javascript">
    $(function () {

        $('body #modal-{{$modalName}}-add').modal();

        $('.btn-{{$modalName}}-cancel').click(function () {
            $('#add-url-shortcut').attr('disabled', false);
            $('.shortcut-edit').attr('disabled', false);
            $('.shortcut-delete').attr('disabled', false);
            $('.delete-{{$modalName}}-active').removeClass('delete-{{$modalName}}-active');
        });

        $(document).off('click', '#btn-{{$modalName}}-save').on('click', '#btn-{{$modalName}}-save', function () {

            var $this = $(this)

            $this.attr('disabled', true)
            $.post($(this).data('action'), {
                user_id: {{$user_id}},
                url: $('#url-shortcut').val(),
                description: $('#url-description').val(),
                fa_icon: $('.url-fa-action').children('input').val(),
            }).done(function (response) {
                $('#modal-{{$modalName}}-add').modal('hide');
                $('#title-bar-table').html(response.view)
                alertify.success(response.message, 5);
                setTimeout(function () {
                    $this.attr('disabled', false)
                }, 5000);
            }).fail(function (response) {
                $this.attr('disabled', false)
                showAlertifyErrors($.parseJSON(response.responseText).errors);
            });

        });


        @if($editMode)
        $('.url-fa-action').iconpicker('setIcon', '{{$userSettingTitleBar->formatted_setting_value_icon}}');
        @else
        $('.url-fa-action').iconpicker('setIcon',);
        @endif

    });
</script>

<div class="modal fade" id="modal-{{$modalName}}-add" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog text-break">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> {{trans('fi.title_bar_shortcuts')}} </h5>
                <button type="button" class="close btn-{{$modalName}}-cancel" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>{{ trans('fi.url') }}: </label>

                                <div class="input-group input-group-sm">
                                    {!! Form::text('url', $editMode ? $userSettingTitleBar->formatted_setting_value_url:null, ['id' => 'url-shortcut', 'class' => 'form-control form-control-sm']) !!}
                                    @if(!$editMode)
                                        <div class="input-group-append">
                                            <span class="input-group-text" title="{{ trans('fi.select_icon') }}"><i
                                                        class="fa fa-info"></i></span>
                                        </div>
                                    @endif
                                    <div class="input-group-append">
                                        <button name="url-fa-action"
                                                class="btn btn-sm btn-default url-fa-action"
                                                role="iconpicker" data-placement="top" data-iconset="fontawesome"
                                                value="123">
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>{{ trans('fi.tooltip') }}: </label>
                                <div class="input-group input-group-sm">
                                    {!! Form::text('description', $editMode ? $userSettingTitleBar->formatted_setting_description :null, ['id' => 'url-description', 'class' => 'form-control form-control-sm']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer pb-1 pt-1">
                <div class="col-sm-12">
                    @if($editMode)
                        <button type="button" id="btn-{{$modalName}}-save"
                                class="btn btn-sm btn-outline-primary float-right ml-2"
                                data-action="{{ route('dashboard.user.edit.title.bar',[$userSettingTitleBar->id]) }}">
                            {{ trans('fi.save') }}
                        </button>
                    @else
                        <button type="button" id="btn-{{$modalName}}-save"
                                data-action="{{ route('dashboard.user.add.store.url') }}"
                                class="btn btn-sm btn-outline-primary float-right ml-2">
                            {{ trans('fi.add') }}
                        </button>
                    @endif
                    <button type="button" class="btn btn-sm btn-outline-secondary float-right btn-{{$modalName}}-cancel"
                            data-dismiss="modal" id="btn-{{$modalName}}-cancel">
                        {{ trans('fi.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>