<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Users\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserTitleBarStoreUpdate extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function attributes()
    {
        return [
            'user_id' => trans('fi.users'),
            'url'     => trans('fi.url'),
            'fa_icon' => trans('fi.icon'),
        ];
    }

    public function prepareForValidation()
    {
        $request = $this->all();

        if (isset($request['url']))
        {
            $url = $request['url'];

            if(!preg_match("/^https?:\/\//", $url) && !preg_match("/^http?:\/\//", $url) )
            {
                $request['url'] = ($this->isSecure() ? 'https' : 'http') . '://' . $url;
            }

            $this->replace($request);
        }
    }

    public function rules()
    {
        $regex = "/^https?:\\/\\/(?:www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.[a-zA-Z0-9()]{2,6}\\b(?:[-a-zA-Z0-9()@:%_\\+.~#?&\\/=]*)$/";

        return [
            'user_id' => 'required',
            'url'     => 'required|regex:' . $regex,
            'fa_icon' => ['required', 'not_in:empty'],
        ];
    }
}