<!doctype html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{ mb_strtoupper(trans('fi.payment_receipt')) }}</title>

    <style>
        @page {
            margin: 25px;
        }

        body {
            color: #001028;
            background: #FFFFFF;
            font-family: DejaVu Sans, Helvetica, sans-serif;
            font-size: 12px;
            margin-left: 0px;
            margin-right: 0px;
        }

        a {
            color: #5D6975;
            border-bottom: 1px solid currentColor;
            text-decoration: none;
        }

        h1 {
            color: #5D6975;
            font-size: 2.8em;
            line-height: 1.4em;
            font-weight: bold;
            margin: 0;
        }

        table {
            width: 100%;
            border-spacing: 0;
            margin-bottom: 20px;
            padding: 0 2px;
        }

        th, .section-header {
            padding: 5px 10px;
            color: #5D6975;
            border-bottom: 1px solid #C1CED9;
            white-space: nowrap;
            font-weight: normal;
            text-align: center;
        }

        @media only screen and (max-width: 600px) {
            th, .section-header {
                padding: 5px 4px;
            }
        }

        @media only screen and (max-width: 320px) {
            table {
                width: 100%;
                border-spacing: 0;
                margin-bottom: 20px;
                font-size: 10px;
                margin-left: 0px;
            }
        }

        td {
            padding: 10px 5px;
        }

        table.alternate tr:nth-child(odd) td {
            background: #F5F5F5;
        }

        table.customfield-table tr td {
            background: inherit !important;
        }

        th.amount, td.amount {
            text-align: right;
        }

        .info {
            color: #5D6975;
            font-weight: bold;
        }

        .terms {
            padding: 10px;
        }

        .footer {
            text-align: center;
            padding: 10px;
        }

        #cp-logo {
            max-width: 114px;
        }

    </style>
</head>
<body>

<table>
    <tr>
        <td style="width: 50%;" valign="top">
            <h1>{{ mb_strtoupper(trans('fi.payment_receipt')) }}</h1>
            <span class="info"> {{ mb_strtoupper(trans('fi.payment')) }} </span> <span style='background: #d2d6de;border-radius: 2px;padding: 0 8px;'>{!! $payment->formatted_number !!}</span><br>
            <span class="info">{{ mb_strtoupper(trans('fi.payment_date')) }}: </span> {{ $payment->formatted_paid_at }}
            <br>
            <span class="info">{{ mb_strtoupper(trans('fi.payment_method')) }}: </span>{!! $payment->paymentMethod->name !!}
            <br>
            <span class="info">{{ mb_strtoupper(trans('fi.customer')) }}: </span>
            #{{ $payment->client->title != '' ? $payment->client->title.' '.$payment->client->name : $payment->client->name }}
            <br>
            @if ($payment->client->address)
                {!! $payment->client->formatted_address !!}
            @endif
            <br>
            <span class="info">{{ mb_strtoupper(trans('fi.email')) }} -</span> {{ $payment->client->email }} <br>
            <span class="info">{{ mb_strtoupper(trans('fi.phone')) }} -</span> {{ $payment->client->phone }} <br>
        </td>
        <td style="width: 50%; text-align: right;" valign="top">
            {!! $companyProfile->logo() !!}<br>
            <span class="info">{{ $companyProfile->company }}</span><br>
            {!! $companyProfile->formatted_address !!}
        </td>
    </tr>
</table>
<p style="margin-top: 50px; margin-bottom: 15px;">{{ $paymentText }}</p>
<table class="alternate">
    <thead>
    <tr>
        <th style="text-align: left;"><strong>{{ mb_strtoupper(trans('fi.invoice')) }}</strong></th>
        <th style="text-align: left;"><strong>{{ mb_strtoupper(trans('fi.date')) }}</strong></th>
        <th style="text-align: left;"><strong>{{ mb_strtoupper(trans('fi.due')) }}</strong></th>
        <th style="text-align: center;"><strong>{{ mb_strtoupper(trans('fi.invoice_amount')) }}</strong></th>
        <th style="text-align: center;"><strong>{{ mb_strtoupper(trans('fi.previous_balance')) }}</strong></th>
        <th style="text-align: center;"><strong>{{ mb_strtoupper(trans('fi.this_payment')) }}</strong></th>
        <th style="text-align: center;"><strong>{{ mb_strtoupper(trans('fi.discount')) }}</strong></th>
        <th style="text-align: center;"><strong>{{ mb_strtoupper(trans('fi.balance')) }}</strong></th>
    </tr>
    </thead>
    <tbody>
    @foreach ($payment->paymentInvoice as $paymentInvoice)
        <tr>
            <td style="text-align: left;">
                <a href="{{$paymentInvoice->invoice->public_url}}" style="color: #3c3cff;">
                    {{ $paymentInvoice->invoice->number }}
                </a>
            </td>
            <td style="text-align: left;">{{ $paymentInvoice->invoice->formatted_invoice_date }}</td>
            <td style="text-align: left; @if ($paymentInvoice->invoice->isOverdue) color: #ff0000; font-weight: bold; @endif">
                {{ $paymentInvoice->invoice->formatted_due_at }}
            </td>
            <td style="text-align: center;">{{ $paymentInvoice->formatted_invoice_total_for_pdf }}</td>
            <td style="text-align: center;">{{ $paymentInvoice->formatted_previous_balance_with_currency }}</td>
            <td style="text-align: center;">{{ $paymentInvoice->formatted_invoice_amount_paid }}</td>
            <td style="text-align: center;">{{ $paymentInvoice->formatted_payment_terms_discount }}</td>
            <td style="text-align: center;">{{ $paymentInvoice->formatted_previous_remaining_balance }}</td>
        </tr>
    @endforeach
    </tbody>
</table>

<p class="info"
   style="bottom: 10px; position: absolute;right: 0px;"><span>{!! mb_strtoupper(trans('fi.processed_by_user',['user_initial'=>$payment->user->initials, 'paid_at'=>$payment->formatted_paid_at])) !!}</span></p>
<br>

</body>
</html>