<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

Route::group(['middleware' => ['web', 'auth.admin'], 'prefix' => 'task', 'namespace' => 'FI\Modules\TaskList\Controllers'], function ()
{
    Route::group(['prefix' => 'widget'], function ()
    {
        Route::get('create', ['uses' => 'TaskController@createWidget', 'as' => 'task.widget.create']);
        Route::post('create', ['uses' => 'TaskController@storeWidget', 'as' => 'task.widget.store']);
        Route::post('tasks-list', ['uses' => 'TaskController@taskList', 'as' => 'task.widget.list']);
        Route::get('edit/{id}', ['uses' => 'TaskController@editWidget', 'as' => 'task.widget.edit']);
        Route::post('edit/{id}', ['uses' => 'TaskController@updateWidget', 'as' => 'task.widget.update']);
        Route::post('reorder', ['uses' => 'TaskController@reorder', 'as' => 'task.widget.reorder']);
        Route::post('refresh', ['uses' => 'TaskController@refresh', 'as' => 'task.widget.refresh']);
        Route::post('sort', ['uses' => 'TaskController@orderBy', 'as' => 'task.widget.sort']);
    });
    Route::get('{id}/delete', ['uses' => 'TaskController@delete', 'as' => 'task.delete']);
    Route::post('complete/{id}/{complete}', ['uses' => 'TaskController@completeToggle', 'as' => 'task.complete']);
    Route::get('/', ['uses' => 'TaskController@index', 'as' => 'task.index']);
    Route::get('create', ['uses' => 'TaskController@create', 'as' => 'task.create']);
    Route::post('create', ['uses' => 'TaskController@store', 'as' => 'task.store']);
    Route::get('{id}/edit', ['uses' => 'TaskController@edit', 'as' => 'task.edit']);
    Route::post('edit/{id}', ['uses' => 'TaskController@update', 'as' => 'task.update']);
    Route::get('{id}/show', ['uses' => 'TaskController@show', 'as' => 'task.show']);
    Route::post('complete-with-note/{id}', ['uses' => 'TaskController@taskCompleteModal', 'as' => 'task.complete-with-note.modal']);
    Route::post('complete-with-note', ['uses' => 'TaskController@completeWithNote', 'as' => 'task.complete-with-note']);

    Route::post('delete/confirmation/modal', ['uses' => 'TaskController@deleteModal', 'as' => 'task.delete.modal']);

    Route::post('status/filter', ['uses' => 'TaskController@statusFilter', 'as' => 'task.status.filter']);
    Route::get('shorting', ['uses' => 'TaskController@ajaxShorting', 'as' => 'task.get.ajax.shorting']);

});