<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

Route::group(['middleware' => ['setup'], 'namespace' => 'FI\Modules\Setup\Controllers'], function ()
{
    Route::get('setup', ['uses' => 'SetupController@index', 'as' => 'setup.index']);
    Route::post('setup', ['uses' => 'SetupController@postIndex', 'as' => 'setup.postIndex']);

    Route::get('setup/pre/requirement', ['uses' => 'SetupController@preRequirement', 'as' => 'setup.preRequirement']);

    Route::get('setup/migration', ['uses' => 'SetupController@migration', 'as' => 'setup.migration']);
    Route::post('setup/migration', ['uses' => 'SetupController@postMigration', 'as' => 'setup.postMigration']);

    Route::get('setup/attachment', ['uses' => 'SetupController@attachment', 'as' => 'setup.attachment']);
    Route::post('setup/attachment', ['uses' => 'SetupController@postAttachment', 'as' => 'setup.postAttachment']);

    Route::get('setup/account', ['uses' => 'SetupController@account', 'as' => 'setup.account']);
    Route::post('setup/account', ['uses' => 'SetupController@postAccount', 'as' => 'setup.postAccount']);

    Route::get('setup/companyProfile', ['uses' => 'SetupController@companyProfile', 'as' => 'setup.companyProfile']);
    Route::post('setup/companyProfile', ['uses' => 'SetupController@postCompanyProfile', 'as' => 'setup.postCompanyProfile']);

    Route::get('verify/key', ['uses' => 'SetupController@verifyKey', 'as' => 'setup.verify.key']);
    Route::post('verify/key', ['uses' => 'SetupController@postVerifyKey', 'as' => 'setup.postVerify.key']);

    Route::get('setup/complete', ['uses' => 'SetupController@complete', 'as' => 'setup.complete']);
});