@extends('setup.master')
@section('head')
    @if( config('fi.headerTitleText') == '')
        <title>{{ trans('fi.setup') }}</title>
    @endif
@stop
@section('content')
    @include('layouts._alertifyjs')
    @include('layouts._alerts')
    <script type="text/javascript">
        $(function () {
            $('#accept').click(function () {

                if ($(this).is(":checked") && '{{ count($addons) > 0 }}')
                {
                    $('body #modal-addon-disabled-notice').modal();
                }

            });
        });
    </script>

    <section class="content-header">
        <h1>{{ trans('fi.license_agreement') }}</h1>
    </section>

    <section class="content">

        {!! Form::open() !!}

        <div class="row">

            <div class="col-md-12">

                <div class="card card-primary card-outline">

                    <div class="card-body">

                        <div class="form-group">
                            {!! Form::textarea('', $license, ['id' => 'license', 'class' => 'form-control form-control-sm', 'readonly' => 'readonly']) !!}
                        </div>

                        <div class="form-group">
                            {!! Form::checkbox('accept', 1,false,['id' => 'accept']) !!}
                            <label for="accept"> {{ trans('fi.license_agreement_accept') }} </label>
                        </div>

                        {!! Form::hidden('addon_enabled', (count($addons) > 0) ? true : false) !!}
                        {!! Form::submit(trans('fi.i_accept'), ['class' => 'btn btn-sm btn-outline-primary','style'=>'box-shadow: 0px 0px 6px lightblue;']) !!}

                    </div>

                </div>

            </div>

        </div>

        {!! Form::close() !!}

        @if(count($addons) > 0)
            <div class="modal fade" id="modal-addon-disabled-notice" data-keyboard="false" data-backdrop="static">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header bg-danger">
                            <h5 class="modal-title">{!! trans('fi.add_ons_will_be_disabled')!!}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <div class="modal-body text-break">
                            <ul class="nav nav-header mb-3">
                                @foreach($addons as $addon)
                                    <li class="col-12 p-0"><i class="fa-solid fa-caret-right"></i> <span
                                                class="font-weight-bold">{!! $addon !!}</span></li>
                                @endforeach
                            </ul>
                            <p class="m-0">
                                <small class="font-weight-bold text-info">
                                    {!! nl2br(trans('fi.add_ons_will_be_disabled_msg')) !!}
                                </small>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">
                                {{trans('fi.confirm')}}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

        @endif

    </section>

@stop