@extends('setup.master')
@section('javascript')
	@include('layouts._alertifyjs')
@stop
@section('content')

	<section class="content">

        <div class="container-fluid">

            <div class="row">

                <div class="col-lg-12">

                    <div class="card card-primary card-outline">

                        <div class="card-header">
                            <h3 class="card-title">{{ trans('fi.company_profile') }}</h3>
                        </div>

                        <div class="card-body">
                            {!! Form::open(['route' => 'setup.postCompanyProfile', 'class' => 'form-install']) !!}
							@include('layouts._alerts')


							{!! Form::hidden('is_create', ($companyProfileCount == 0)? 'create':'edit') !!}
							{!! Form::hidden('create_only_profile', true) !!}

							@if($companyProfileCount == 0)
								<div class="row">
                                    <div class="col-md-12 form-group">
                                        {!! Form::text('company_profile[company]', null, ['class' => 'form-control form-control-sm', 'placeholder' => trans('fi.company')]) !!}
                                    </div>
                                </div>

								<div class="row">
                                    <div class="col-md-12 form-group">
                                        {!! Form::textarea('company_profile[address]', null, ['class' => 'form-control form-control-sm', 'placeholder' => trans('fi.address'), 'rows' => 4]) !!}
                                    </div>
                                </div>

								<div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {!! Form::text('company_profile[city]', null, ['id' => 'city', 'class' => 'form-control form-control-sm', 'placeholder' => trans('fi.city')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {!! Form::text('company_profile[state]', null, ['id' => 'state', 'class' => 'form-control form-control-sm', 'placeholder' => trans('fi.state')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {!! Form::text('company_profile[zip]', null, ['id' => 'zip', 'class' => 'form-control form-control-sm', 'placeholder' => trans('fi.postal_code')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            {!! Form::select('company_profile[country]', $countries, null, ['id' => 'country', 'class' => 'form-control form-control-sm', 'placeholder' => trans('fi.country')]) !!}
                                        </div>
                                    </div>
                                </div>

								<div class="row">

                                    <div class="col-md-3 form-group">
                                        {!! Form::text('company_profile[phone]', null, ['class' => 'form-control form-control-sm', 'placeholder' => trans('fi.phone')]) !!}
                                    </div>

                                    <div class="col-md-3 form-group">
                                        {!! Form::text('company_profile[mobile]', null, ['class' => 'form-control form-control-sm', 'placeholder' => trans('fi.mobile')]) !!}
                                    </div>

                                    <div class="col-md-3 form-group">
                                        {!! Form::text('company_profile[fax]', null, ['class' => 'form-control form-control-sm', 'placeholder' => trans('fi.fax')]) !!}
                                    </div>

                                    <div class="col-md-3 form-group">
                                        {!! Form::text('company_profile[web]', null, ['class' => 'form-control form-control-sm', 'placeholder' => trans('fi.web')]) !!}
                                    </div>

                                </div>
							@else
								<div class="row">
                                    <div class="col-md-12 pb-3">
                                        <span>{{ trans('fi.select_default_company_profile') }}</span>
                                    </div>
                                    <div class="col-md-12 form-group">
										{!! Form::select('company_profile[company]', $companyProfiles, null, ['class'=>'form-control form-control-sm']) !!}
                                    </div>
                                </div>
							@endif
							<button class="btn btn-sm btn-outline-primary" type="submit" @style('box-shadow: 0px 0px 6px lightblue;')>{{ trans('fi.continue') }}</button>

							{!! Form::close() !!}

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>
@stop