<script type="text/javascript">
    $(function () {

        $('input[type="radio"]').each(function (e) {
            if ($(this).prop("checked") == true)
            {
                radioBtnSelected($(this).data('radio-btn'), $(this).data('type'));
            }
        });

        $('#mailPassword').val('');

        $('#lbl-save-first').hide();

        $('#mailDriver').change(function () {
            updateEmailOptions();
        });

        function updateEmailOptions()
        {

            $('.email-option').hide();

            mailDriver = $('#mailDriver').val();

            if (mailDriver == 'smtp')
            {
                $('.smtp-option').show();
            }
            else if (mailDriver == 'sendmail')
            {
                $('.sendmail-option').show();
            }
            else if (mailDriver == 'mail')
            {
                $('.phpmail-option').show();
            }
            else if (mailDriver == 'sendgrid')
            {
                $('.sendgrid-option').show();
            }
            else if (mailDriver == 'microsoft365')
            {
                $('.office365-option').show();
            }
        }

        updateEmailOptions();

        $('#mailPassword').val("{{ $mailPassword }}");

        $('#testEmailAddress, #mailDriver, #mailHost, #mailPort, #mailUsername, #mailPassword, #mailEncryption, #mailAllowSelfSignedCertificate, #mailSendmail').change(function () {
            $('#btn-test-email').attr('disabled', true);
            $('#lbl-save-first').show();
        });

        $('#btn-test-email').click(function () {
            if ($('#mailDriver').val() == '')
            {
                alertify.error('{{ trans('fi.mail_config_error') }}');
            }
            else
            {
                var testMail = $('#testEmailAddress').val();
                $('#modal-placeholder').load('{{ route('testMail.create') }}', {testMail: testMail}, function (response, status, xhr) {
                    if (status == 'error')
                    {
                        alertify.error('{{ trans('fi.problem_with_email_template') }}');
                    }
                });
            }
        });

        $(".btn-custom-toggle").on('click', function () {
            var appendId = $(this).data('card-name');

            function runCode()
            {
                var content = document.getElementById(appendId + '-sourceCode').value;
                var iframe = document.getElementById(appendId + '-targetCode');
                iframe = (iframe.contentWindow) ? iframe.contentWindow : (iframe.contentDocument.document) ? iframe.contentDocument.document : iframe.contentDocument;
                iframe.document.open();
                iframe.document.write(content);
                iframe.document.close();
                return false;
            }

            runCode();

            if (($('.custom-' + appendId + '-sourceCode-display').hasClass('d-block')) === true)
            {
                $(this).children().removeClass().addClass('fa fa-code');
                $('.toggle-' + appendId + '-header').html('{{trans('fi.preview')}}');
                $('.custom-' + appendId + '-sourceCode-display').removeClass('d-block').addClass('d-none');
                $('.custom-' + appendId + '-iframe-display').removeClass('d-none').addClass('d-block');
            }
            else
            {

                $(this).children().removeClass().addClass('fa fa-eye');
                $('.toggle-' + appendId + '-header').html("{{trans('fi.code')}}");
                $('.custom-' + appendId + '-sourceCode-display').removeClass('d-none').addClass('d-block');
                $('.custom-' + appendId + '-iframe-display').removeClass('d-block').addClass('d-none');
            }

        });
        $('.radio-btn-check').click(function () {
            radioBtnSelected($(this).data('radio-btn'), $(this).data('type'));
        });

        function radioBtnSelected(radioBTN, btnType)
        {
            if (btnType == 'custom')
            {

                $('#tab-custom-' + radioBTN + '-template').addClass('active');
                $('#tab-' + radioBTN + '-template').removeClass('active');
                $('.custom-' + radioBTN + '-active').addClass('active');
                $('.' + radioBTN + '-active').removeClass('active');
                $('.custom-check-' + radioBTN + '-template').show();
                $('.default-check-' + radioBTN + '-template').hide();
            }
            else
            {
                $('#tab-custom-' + radioBTN + '-template').removeClass('active');
                $('#tab-' + radioBTN + '-template').addClass('active');
                $('.' + radioBTN + '-active').addClass('active');
                $('.custom-' + radioBTN + '-active').removeClass('active');
                $('.custom-check-' + radioBTN + '-template').hide();
                $('.default-check-' + radioBTN + '-template').show();
            }
        }

        $('.reset-default-mail-template-value').click(function () {

            $('#modal-placeholder').load('{{ route('settings.reset.mail.template.model') }}',
                {actionType: $(this).data('action-type'), modelTemplateName: $(this).data('model-template-name'),},
                function (response, status, xhr) {
                    if (status == 'error')
                    {
                        alertify.error('{{ trans('fi.problem_with_email_template') }}');
                    }
                });
        });
    });
</script>
<style type="text/css">
    iframe {
        height: 500px !important;
        width: 100% !important;
    }
</style>
<div class="row">
    <div class="col-md-3">
        <div class="form-group">
            <label>{{ trans('fi.email_send_method') }}: </label>
            {!! Form::select('setting[mailDriver]', $emailSendMethods, config('fi.mailDriver'), ['id' => 'mailDriver', 'class' => 'form-control form-control-sm']) !!}
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group smtp-option email-option">
            <label>{{ trans('fi.smtp_host_address') }}: </label>
            {!! Form::text('setting[mailHost]', config('fi.mailHost'), ['id' => 'mailHost', 'class' => 'form-control form-control-sm']) !!}
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group smtp-option email-option">
            <label>{{ trans('fi.smtp_host_port') }}: </label>
            {!! Form::text('setting[mailPort]', config('fi.mailPort'), ['id' => 'mailPort', 'class' => 'form-control form-control-sm']) !!}
        </div>
    </div>
</div>

<div class="form-group sendgrid-option email-option">
    <div class="form-group">
        <label>{{ trans('fi.sendgrid_key') }}: </label>
        {!! Form::text('setting[mailSendgridKey]', config('fi.mailSendgridKey'), ['id'=>'mailSendgridKey', 'class' => 'form-control form-control-sm']) !!}
    </div>
</div>

<div class="row smtp-option email-option sendgrid-option">
    <div class="col-md-3">
        <div class="form-group smtp-option email-option">
            <label>{{ trans('fi.smtp_username') }}: </label>
            {!! Form::text('setting[mailUsername]', config('fi.mailUsername'), ['id' => 'mailUsername', 'class' => 'form-control form-control-sm']) !!}
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group smtp-option email-option">
            <label>{{ trans('fi.smtp_password') }}: </label>
            {!! Form::password('setting[mailPassword]' ,['id' => 'mailPassword', 'class' => 'form-control form-control-sm', 'autocomplete' => 'off']) !!}
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group smtp-option email-option">
            <label>{{ trans('fi.smtp_encryption') }}: </label>
            {!! Form::select('setting[mailEncryption]', $emailEncryptions, config('fi.mailEncryption'), ['id' => 'mailEncryption', 'class' => 'form-control form-control-sm']) !!}
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group smtp-option email-option sendgrid-option">
            <label>{{ trans('fi.allow_self_signed_cert') }}: </label>
            {!! Form::select('setting[mailAllowSelfSignedCertificate]', $yesNoArray, config('fi.mailAllowSelfSignedCertificate'), ['id'=>'mailAllowSelfSignedCertificate', 'class' => 'form-control form-control-sm']) !!}
        </div>
    </div>
</div>

<div class="row office365-option email-option">
    <div class="col-md-3">
        <div class="form-group office365-option email-option">
            <label>{{ trans('fi.office365_username') }}: </label>
            {!! Form::text('setting[office365Username]', config('fi.office365Username'), ['id' => 'office365Username', 'class' => 'form-control form-control-sm']) !!}
        </div>
    </div>
</div>


<div class="form-group sendmail-option email-option">
    <div class="form-group">
        <label>{{ trans('fi.sendmail_path') }}: </label>
        {!! Form::text('setting[mailSendmail]', config('fi.mailSendmail'), ['id'=>'mailSendmail', 'class' => 'form-control form-control-sm']) !!}
    </div>
</div>

<div class="row smtp-option sendmail-option phpmail-option email-option sendgrid-option office365-option">
    <div class="col-md-4">
        <div class="form-group smtp-option sendmail-option phpmail-option email-option sendgrid-option office365-option">
            <label>{{ trans('fi.reply_to_address') }}: </label>
            {!! Form::text('setting[mailReplyToAddress]', config('fi.mailReplyToAddress'), ['class' => 'form-control form-control-sm', 'autocomplete' => 'off']) !!}
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group smtp-option sendmail-option phpmail-option email-option sendgrid-option office365-option">
            <label>{{ trans('fi.always_cc') }}: </label>
            {!! Form::text('setting[mailDefaultCc]', config('fi.mailDefaultCc'), ['class' => 'form-control form-control-sm', 'autocomplete' => 'off']) !!}
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group smtp-option sendmail-option phpmail-option email-option sendgrid-option office365-option">
            <label>{{ trans('fi.always_bcc') }}: </label>
            {!! Form::text('setting[mailDefaultBcc]', config('fi.mailDefaultBcc'), ['class' => 'form-control form-control-sm', 'autocomplete' => 'off']) !!}
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        <div class="form-group">
            <label>{{ trans('fi.test_email_address') }}: </label>

            <div class="input-group">
                {!! Form::text('setting[testEmailAddress]', config('fi.testEmailAddress'), ['id'=>'testEmailAddress', 'class' => 'form-control form-control-sm', 'autocomplete' => 'off']) !!}
                <span class="input-group-append">
                    <a href="javascript:void(0)" class="btn btn-sm btn-info" id="btn-test-email">
                        <i class="fa fa-envelope"></i> {{ trans('fi.send_test_email') }}
                    </a>
                </span>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            <label>{{ trans('fi.mail_from_address') }}: </label>
            {!! Form::text('setting[mailFromAddress]', config('fi.mailFromAddress'), ['id'=>'mailFromAddress', 'class' => 'form-control form-control-sm', 'autocomplete' => 'off']) !!}
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            <label>{{ trans('fi.mail_from_name') }}: </label>
            {!! Form::text('setting[mailFromName]', config('fi.mailFromName'), ['id'=>'mailFromName', 'class' => 'form-control form-control-sm', 'autocomplete' => 'off']) !!}
        </div>
    </div>
</div>

<div class="content-header p-0 pb-2">
    <div class="container-fluid p-0">
        <label>{{ trans('fi.email_templates') }} :</label>
    </div>
</div>

<div class="row">
    <section class="col-lg-12">
        <div class="card card-primary card-outline card-outline-tabs">
            <div class="card-header p-0 border-bottom-0">
                <ul class="nav nav-tabs" id="email-templates">
                    <li class="nav-item">
                        <a data-toggle="tab" class="active nav-link"
                           href="#tab-quote_setting_email_template">{{ trans('fi.quotes') }}
                        </a>
                    </li>
                    @if(config('proforma_invoice_enabled')== true)
                        <li class="nav-item">
                            <a data-toggle="tab" class="nav-link"
                               href="#tab-proforma_invoice_setting_email_template">{{ trans('ProformaInvoice::lang.proforma_invoice') }}
                            </a>
                        </li>
                    @endif
                    <li class="nav-item">
                        <a data-toggle="tab" class="nav-link "
                           href="#tab-invoice_setting_email_template">{{ trans('fi.invoices') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a data-toggle="tab" class="nav-link "
                           href="#tab-credit_memo_setting_email_template">{{ trans('fi.credit_memos') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a data-toggle="tab" class="nav-link "
                           href="#tab-overdue_invoice_setting_email_template">{{ trans('fi.overdue_invoices') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a data-toggle="tab" class="nav-link "
                           href="#tab-payment_receipt_setting_email_template">{{ trans('fi.payment_receipts') }}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a data-toggle="tab" class="nav-link "
                           href="#tab-upcoming_payment_notice_setting_email_template">{{ trans('fi.upcoming_payment_notices') }}
                        </a>
                    </li>
                </ul>
            </div>
            <div class="card-body">
                <div class="tab-content mt-2">

                    <div id="tab-quote_setting_email_template" class="tab-pane active">

                        <a class="btn btn-info btn-xs col-md-1 offset-md-11"
                           href="https://www.fusioninvoice.com/docs/2023/Customization/Email-Templates#quote-email-template"
                           target="_blank">
                            <i class="fa fa-bullhorn"
                               aria-hidden="true"></i> {{ trans('fi.available_fields') }}
                        </a>


                        <div class="form-group">

                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.quote_email') }}: </label>
                                        @if(isset($isChangeQuoteEmail['isChange']) && $isChangeQuoteEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="quote"
                                                    data-model-template-name="{{trans('fi.quote')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs" id="quote-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="active nav-link  quote-active"
                                               href="#tab-quote-template"><i
                                                        class="fa"> </i> {{ trans('fi.default') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link  custom-quote-active"
                                               href="#tab-custom-quote-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link  custom-quote-active"
                                               href="#tab-custom2-quote-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link  custom-quote-active"
                                               href="#tab-custom3-quote-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>

                                <div class="card-body p-0">
                                    <div class="tab-content mt-2">
                                        <div id="tab-quote-template" class="tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[quoteSubjectDefault]', config('fi.quoteSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }}: </label>
                                                {!! Form::textarea('setting[quoteMailTemplateDefault]', config('fi.quoteMailTemplateDefault'), ['class' => 'form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                            </div>
                                        </div>

                                        <div id="tab-custom-quote-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">

                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteSubjectCustom1]', config('fi.quoteSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quote"
                                                                       id="btn-quote-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <label>{{ trans('fi.body') }}: </label>

                                                <div class="p-0 col-12 custom-quote-sourceCode-display d-block">
                                                    {!! Form::textarea('setting[quoteMailTemplateCustom1]', config('fi.quoteMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quote-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quote-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quote-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom2-quote-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">

                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteSubjectCustom2]', config('fi.quoteSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quote2"
                                                                       id="btn-quote-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="card-body p-2 custom-template-scroller">
                                                <label>{{ trans('fi.body') }}: </label>

                                                <div class="p-0 col-12 custom-quote2-sourceCode-display d-block">
                                                    {!! Form::textarea('setting[quoteMailTemplateCustom2]', config('fi.quoteMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quote2-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quote2-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quote2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-quote-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteSubjectCustom3]', config('fi.quoteSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quote3"
                                                                       id="btn-quote-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="card-body p-2 custom-template-scroller">
                                                <label>{{ trans('fi.body') }}: </label>

                                                <div class="p-0 col-12 custom-quote3-sourceCode-display d-block">
                                                    {!! Form::textarea('setting[quoteMailTemplateCustom3]', config('fi.quoteMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quote3-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quote3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quote3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <br>

                        <div class="form-group">
                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.quote_approved_email_body') }}: </label>
                                        @if(isset($isChangeQuoteApprovedEmail['isChange']) && $isChangeQuoteApprovedEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="quoteApproved"
                                                    data-model-template-name="{{trans('fi.quote_approved')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs" id="quoteApproved-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="active nav-link  quoteApproved-active"
                                               href="#tab-quoteApproved-template">
                                                <i class="fa"> </i> {{ trans('fi.default') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-quoteApproved-active"
                                               href="#tab-custom-quoteApproved-template">
                                                <i class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-quoteApproved-active"
                                               href="#tab-custom2-quoteApproved-template">
                                                <i class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-quoteApproved-active"
                                               href="#tab-custom3-quoteApproved-template">
                                                <i class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-body p-0">
                                    <div class="tab-content mt-2">
                                        <div id="tab-quoteApproved-template" class="tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[quoteApprovedSubjectDefault]', config('fi.quoteApprovedSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }}: </label>
                                                {!! Form::textarea('setting[quoteApprovedMailTemplateDefault]', config('fi.quoteApprovedMailTemplateDefault'), ['class' => 'form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                            </div>
                                        </div>
                                        <div id="tab-custom-quoteApproved-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteApprovedSubjectCustom1]', config('fi.quoteApprovedSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quoteApproved"
                                                                       id="btn-quoteApproved-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-quoteApproved-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[quoteApprovedMailTemplateCustom1]', config('fi.quoteApprovedMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quoteApproved-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quoteApproved-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quoteApproved-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom2-quoteApproved-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteApprovedSubjectCustom2]', config('fi.quoteApprovedSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quoteApproved2"
                                                                       id="btn-quoteApproved-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-quoteApproved2-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[quoteApprovedMailTemplateCustom2]', config('fi.quoteApprovedMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quoteApproved2-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quoteApproved2-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quoteApproved2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-quoteApproved-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteApprovedSubjectCustom3]', config('fi.quoteApprovedSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quoteApproved3"
                                                                       id="btn-quoteApproved-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-quoteApproved3-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[quoteApprovedMailTemplateCustom3]', config('fi.quoteApprovedMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quoteApproved3-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quoteApproved3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quoteApproved3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <br>

                        <div class="form-group">
                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.quote_rejected_email_body') }}: </label>
                                        @if(isset($isChangeQuoteRejectedEmail['isChange']) && $isChangeQuoteRejectedEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="quoteRejected"
                                                    data-model-template-name="{{trans('fi.quote_rejected')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs" id="quoteRejected-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="active nav-link quoteRejected-active"
                                               href="#tab-quoteRejected-template"><i
                                                        class="fa"> </i> {{ trans('fi.default') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-quoteRejected-active"
                                               href="#tab-custom-quoteRejected-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-quoteRejected-active"
                                               href="#tab-custom2-quoteRejected-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-quoteRejected-active"
                                               href="#tab-custom3-quoteRejected-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-body p-0">
                                    <div class="tab-content mt-2">
                                        <div id="tab-quoteRejected-template" class="tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteRejectedSubjectDefault]', config('fi.quoteRejectedSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }}: </label>
                                                {!! Form::textarea('setting[quoteRejectedMailTemplateDefault]', config('fi.quoteRejectedMailTemplateDefault'), ['class' => 'form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                            </div>
                                        </div>

                                        <div id="tab-custom-quoteRejected-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteRejectedSubjectCustom1]', config('fi.quoteRejectedSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quoteRejected"
                                                                       id="btn-quoteRejected-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-quoteRejected-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[quoteRejectedMailTemplateCustom1]', config('fi.quoteRejectedMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quoteRejected-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quoteRejected-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quoteRejected-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom2-quoteRejected-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteRejectedSubjectCustom2]', config('fi.quoteRejectedSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quoteRejected2"
                                                                       id="btn-quoteRejected-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-quoteRejected2-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[quoteRejectedMailTemplateCustom2]', config('fi.quoteRejectedMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quoteRejected2-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quoteRejected2-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quoteRejected2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-quoteRejected-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[quoteRejectedSubjectCustom3]', config('fi.quoteRejectedSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="quoteRejected3"
                                                                       id="btn-quoteRejected-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-quoteRejected3-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[quoteRejectedMailTemplateCustom3]', config('fi.quoteRejectedMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"quoteRejected3-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-quoteRejected3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="quoteRejected3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <br>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                {!! Form::checkbox('setting[quoteAttachPDF]', 1, config('fi.quoteAttachPDF'), ['id' => 'quote_attach_pdf', 'class' => 'custom-control-input']) !!}
                                <label for="quote_attach_pdf"
                                       class="custom-control-label"> {{ trans('fi.attach_quote_pdf') }} </label>
                            </div>
                        </div>
                    </div>

                    @if(config('proforma_invoice_enabled')== true)

                        <div id="tab-proforma_invoice_setting_email_template" class="tab-pane">

                            <a class="btn btn-info btn-xs col-md-1 offset-md-11"
                               href="https://www.fusioninvoice.com/docs/2023/Customization/Email-Templates#quote-email-template"
                               target="_blank">
                                <i class="fa fa-bullhorn"
                                   aria-hidden="true"></i> {{ trans('fi.available_fields') }}
                            </a>


                            <div class="form-group">
                                <div class="container-fluid p-0 mt-1">
                                    <div class="row">
                                        <div class="col-12">
                                            <label>{{ trans('ProformaInvoice::lang.proforma_invoice_email') }}: </label>
                                            @if(isset($isChangeProformaInvoiceEmail['isChange']) && $isChangeProformaInvoiceEmail['isChange'])
                                                <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                        data-action-type="proformaInvoice"
                                                        data-model-template-name="{{trans('ProformaInvoice::lang.proforma_invoice')}}"
                                                        type="button">
                                                    <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="card card-primary card-outline card-outline-tabs">
                                    <div class="card-header p-0 border-bottom-0">
                                        <ul class="nav nav-tabs" id="proformaInvoice-mail-template">
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="active nav-link"
                                                   href="#tab-proformaInvoice-template">
                                                    <i class="fa"> </i> {{ trans('fi.default') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link  custom-proformaInvoice-active"
                                                   href="#tab-custom-proformaInvoice-template"><i
                                                            class="fa"> </i> {{ trans('fi.custom1') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link  custom-proformaInvoice-active"
                                                   href="#tab-custom2-proformaInvoice-template"><i
                                                            class="fa"> </i> {{ trans('fi.custom2') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link  custom-proformaInvoice-active"
                                                   href="#tab-custom3-proformaInvoice-template"><i
                                                            class="fa"> </i> {{ trans('fi.custom3') }}
                                                </a>
                                            </li>
                                        </ul>
                                    </div>

                                    <div class="card-body p-0">
                                        <div class="tab-content mt-2">
                                            <div id="tab-proformaInvoice-template" class="tab-pane active">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[proformaInvoiceSubjectDefault]', config('fi.proformaInvoiceSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-body p-2">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[proformaInvoiceMailTemplateDefault]', config('fi.proformaInvoiceMailTemplateDefault'), ['class' => 'form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                                </div>
                                            </div>

                                            <div id="tab-custom-proformaInvoice-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">

                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceSubjectCustom1]', config('fi.proformaInvoiceSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoice"
                                                                           id="btn-proformaInvoice-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-body p-2 custom-template-scroller">
                                                    <label>{{ trans('fi.body') }}: </label>

                                                    <div class="p-0 col-12 custom-proformaInvoice-sourceCode-display d-block">
                                                        {!! Form::textarea('setting[proformaInvoiceMailTemplateCustom1]', config('fi.proformaInvoiceMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoice-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoice-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoice-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="tab-custom2-proformaInvoice-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">

                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceSubjectCustom2]', config('fi.proformaInvoiceSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoice2"
                                                                           id="btn-proformaInvoice-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="card-body p-2 custom-template-scroller">
                                                    <label>{{ trans('fi.body') }}: </label>

                                                    <div class="p-0 col-12 custom-proformaInvoice2-sourceCode-display d-block">
                                                        {!! Form::textarea('setting[proformaInvoiceMailTemplateCustom2]', config('fi.proformaInvoiceMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoice2-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoice2-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoice2-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="tab-custom3-proformaInvoice-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceSubjectCustom3]', config('fi.proformaInvoiceSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoice3"
                                                                           id="btn-proformaInvoice-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="card-body p-2 custom-template-scroller">
                                                    <label>{{ trans('fi.body') }}: </label>

                                                    <div class="p-0 col-12 custom-proformaInvoice3-sourceCode-display d-block">
                                                        {!! Form::textarea('setting[proformaInvoiceMailTemplateCustom3]', config('fi.proformaInvoiceMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoice3-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoice3-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoice3-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <br>
                            <div class="form-group">
                                <div class="container-fluid p-0 mt-1">
                                    <div class="row">
                                        <div class="col-12">
                                            <label>{{ trans('ProformaInvoice::lang.proforma_invoice_approved_email_body') }}
                                                : </label>
                                            @if(isset($isChangeProformaInvoiceApprovedEmail['isChange']) && $isChangeProformaInvoiceApprovedEmail['isChange'])
                                                <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                        data-action-type="proformaInvoiceApproved"
                                                        data-model-template-name="{{trans('ProformaInvoice::lang.proforma_invoice_approved')}}"
                                                        type="button">
                                                    <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="card card-primary card-outline card-outline-tabs">
                                    <div class="card-header p-0 border-bottom-0">
                                        <ul class="nav nav-tabs" id="proformaInvoiceApproved-mail-template">
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="active nav-link  proformaInvoiceApproved-active"
                                                   href="#tab-proformaInvoiceApproved-template">
                                                    <i class="fa"> </i> {{ trans('fi.default') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link custom-proformaInvoiceApproved-active"
                                                   href="#tab-custom-proformaInvoiceApproved-template">
                                                    <i class="fa"> </i> {{ trans('fi.custom1') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link custom-proformaInvoiceApproved-active"
                                                   href="#tab-custom2-proformaInvoiceApproved-template">
                                                    <i class="fa"> </i> {{ trans('fi.custom2') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link custom-proformaInvoiceApproved-active"
                                                   href="#tab-custom3-proformaInvoiceApproved-template">
                                                    <i class="fa"> </i> {{ trans('fi.custom3') }}
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="card-body p-0">
                                        <div class="tab-content mt-2">
                                            <div id="tab-proformaInvoiceApproved-template" class="tab-pane active">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}: </label>
                                                                    {!! Form::text('setting[proformaInvoiceApprovedSubjectDefault]', config('fi.proformaInvoiceApprovedSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-body p-2">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[proformaInvoiceApprovedMailTemplateDefault]', config('fi.proformaInvoiceApprovedMailTemplateDefault'), ['class' => 'form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                                </div>
                                            </div>
                                            <div id="tab-custom-proformaInvoiceApproved-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceApprovedSubjectCustom1]', config('fi.proformaInvoiceApprovedSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoiceApproved"
                                                                           id="btn-proformaInvoiceApproved-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-body p-2 custom-template-scroller">
                                                    <div class="p-0 col-12 custom-proformaInvoiceApproved-sourceCode-display d-block">
                                                        <label>{{ trans('fi.body') }}: </label>
                                                        {!! Form::textarea('setting[proformaInvoiceApprovedMailTemplateCustom1]', config('fi.proformaInvoiceApprovedMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoiceApproved-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoiceApproved-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoiceApproved-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="tab-custom2-proformaInvoiceApproved-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceApprovedSubjectCustom2]', config('fi.proformaInvoiceApprovedSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoiceApproved2"
                                                                           id="btn-proformaInvoiceApproved-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-body p-2 custom-template-scroller">
                                                    <div class="p-0 col-12 custom-proformaInvoiceApproved2-sourceCode-display d-block">
                                                        <label>{{ trans('fi.body') }}: </label>
                                                        {!! Form::textarea('setting[proformaInvoiceApprovedMailTemplateCustom2]', config('fi.proformaInvoiceApprovedMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoiceApproved2-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoiceApproved2-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoiceApproved2-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="tab-custom3-proformaInvoiceApproved-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceApprovedSubjectCustom3]', config('fi.proformaInvoiceApprovedSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoiceApproved3"
                                                                           id="btn-proformaInvoiceApproved-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-body p-2 custom-template-scroller">
                                                    <div class="p-0 col-12 custom-proformaInvoiceApproved3-sourceCode-display d-block">
                                                        <label>{{ trans('fi.body') }}: </label>
                                                        {!! Form::textarea('setting[proformaInvoiceApprovedMailTemplateCustom3]', config('fi.proformaInvoiceApprovedMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoiceApproved3-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoiceApproved3-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoiceApproved3-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <br>

                            <div class="form-group">
                                <div class="container-fluid p-0 mt-1">
                                    <div class="row">
                                        <div class="col-12">
                                            <label>{{ trans('ProformaInvoice::lang.proforma_invoice_rejected_email_body') }}
                                                : </label>
                                            @if(isset($isChangeProformaInvoiceRejectedEmail['isChange']) && $isChangeProformaInvoiceRejectedEmail['isChange'])
                                                <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                        data-action-type="proformaInvoiceRejected"
                                                        data-model-template-name="{{trans('ProformaInvoice::lang.proforma_invoice_rejected')}}"
                                                        type="button">
                                                    <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="card card-primary card-outline card-outline-tabs">
                                    <div class="card-header p-0 border-bottom-0">
                                        <ul class="nav nav-tabs" id="proformaInvoiceRejected-mail-template">
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="active nav-link proformaInvoiceRejected-active"
                                                   href="#tab-proformaInvoiceRejected-template"><i
                                                            class="fa"> </i> {{ trans('fi.default') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link custom-proformaInvoiceRejected-active"
                                                   href="#tab-custom-proformaInvoiceRejected-template"><i
                                                            class="fa"> </i> {{ trans('fi.custom1') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link custom-proformaInvoiceRejected-active"
                                                   href="#tab-custom2-proformaInvoiceRejected-template"><i
                                                            class="fa"> </i> {{ trans('fi.custom2') }}
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a data-toggle="tab"
                                                   class="nav-link custom-proformaInvoiceRejected-active"
                                                   href="#tab-custom3-proformaInvoiceRejected-template"><i
                                                            class="fa"> </i> {{ trans('fi.custom3') }}
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="card-body p-0">
                                        <div class="tab-content mt-2">
                                            <div id="tab-proformaInvoiceRejected-template" class="tab-pane active">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceRejectedSubjectDefault]', config('fi.proformaInvoiceRejectedSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card-body p-2">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[proformaInvoiceRejectedMailTemplateDefault]', config('fi.proformaInvoiceRejectedMailTemplateDefault'), ['class' => 'form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                                </div>
                                            </div>

                                            <div id="tab-custom-proformaInvoiceRejected-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceRejectedSubjectCustom1]', config('fi.proformaInvoiceRejectedSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoiceRejected"
                                                                           id="btn-proformaInvoiceRejected-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="card-body p-2 custom-template-scroller">
                                                    <div class="p-0 col-12 custom-proformaInvoiceRejected-sourceCode-display d-block">
                                                        <label>{{ trans('fi.body') }}: </label>
                                                        {!! Form::textarea('setting[proformaInvoiceRejectedMailTemplateCustom1]', config('fi.proformaInvoiceRejectedMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoiceRejected-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoiceRejected-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoiceRejected-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="tab-custom2-proformaInvoiceRejected-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceRejectedSubjectCustom2]', config('fi.proformaInvoiceRejectedSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoiceRejected2"
                                                                           id="btn-proformaInvoiceRejected-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="card-body p-2 custom-template-scroller">
                                                    <div class="p-0 col-12 custom-proformaInvoiceRejected2-sourceCode-display d-block">
                                                        <label>{{ trans('fi.body') }}: </label>
                                                        {!! Form::textarea('setting[proformaInvoiceRejectedMailTemplateCustom2]', config('fi.proformaInvoiceRejectedMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoiceRejected2-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoiceRejected2-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoiceRejected2-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="tab-custom3-proformaInvoiceRejected-template" class="tab-pane">
                                                <div class="content-header pb-0">
                                                    <div class="container-fluid p-0">
                                                        <div class="row">
                                                            <div class="col-sm-6">
                                                                <div class="form-group mb-0">
                                                                    <div class="form-group">
                                                                        <label>{{ trans('fi.subject') }}: </label>
                                                                        {!! Form::text('setting[proformaInvoiceRejectedSubjectCustom3]', config('fi.proformaInvoiceRejectedSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6">
                                                                <ol class="breadcrumb float-right">
                                                                    <li class="breadcrumb-item">
                                                                        <a href="javascript:void(0);"
                                                                           class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                           data-card-name="proformaInvoiceRejected3"
                                                                           id="btn-proformaInvoiceRejected-custom-toggle">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ol>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="card-body p-2 custom-template-scroller">
                                                    <div class="p-0 col-12 custom-proformaInvoiceRejected3-sourceCode-display d-block">
                                                        <label>{{ trans('fi.body') }}: </label>
                                                        {!! Form::textarea('setting[proformaInvoiceRejectedMailTemplateCustom3]', config('fi.proformaInvoiceRejectedMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"proformaInvoiceRejected3-sourceCode", 'placeholder' =>trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                    </div>

                                                    <div class="p-0 d-none custom-proformaInvoiceRejected3-iframe-display col-12">
                                                        <iframe class="border-1" name="targetCode"
                                                                id="proformaInvoiceRejected3-targetCode"></iframe>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>

                            <br>

                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    {!! Form::checkbox('setting[proformaInvoiceAttachPDF]', 1, config('fi.proformaInvoiceAttachPDF'), ['id' => 'proformaInvoice_attach_pdf', 'class' => 'custom-control-input']) !!}
                                    <label for="proformaInvoice_attach_pdf"
                                           class="custom-control-label"> {{ trans('ProformaInvoice::lang.attach_proformaInvoice_pdf') }} </label>
                                </div>
                            </div>

                        </div>
                    @endif
                    <div id="tab-invoice_setting_email_template" class="tab-pane ">
                        <a class="btn btn-info btn-xs col-md-1 offset-md-11"
                           href="https://www.fusioninvoice.com/docs/2023/Customization/Email-Templates#invoice-email-template"
                           target="_blank">
                            <i class="fa fa-bullhorn"
                               aria-hidden="true"></i> {{ trans('fi.available_fields') }}
                        </a>


                        <div class="form-group">

                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.invoice_email_body') }} : </label>
                                        @if(isset($isChangeInvoiceEmail['isChange']) && $isChangeInvoiceEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="invoice"
                                                    data-model-template-name="{{trans('fi.invoice')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs" id="invoice-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="active nav-link invoice-active"
                                               href="#tab-invoice-template"><i
                                                        class="fa"> </i> {{ trans('fi.default') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-invoice-active"
                                               href="#tab-custom-invoice-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-invoice-active"
                                               href="#tab-custom2-invoice-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-invoice-active"
                                               href="#tab-custom3-invoice-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>

                                <div class="card-body p-0">
                                    <div class="tab-content">

                                        <div id="tab-invoice-template" class="tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}
                                                                        : </label>
                                                                    {!! Form::text('setting[invoiceSubjectDefault]', config('fi.invoiceSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }}:</label>
                                                {!! Form::textarea('setting[invoiceMailTemplateDefault]', config('fi.invoiceMailTemplateDefault'), ['class' => 'mt-2 form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                            </div>
                                        </div>
                                        <div id="tab-custom-invoice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}
                                                                        : </label>
                                                                    {!! Form::text('setting[invoiceSubjectCustom1]', config('fi.invoiceSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="invoice"
                                                                       id="btn-invoice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body  p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-invoice-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }} : </label>
                                                    {!! Form::textarea('setting[invoiceMailTemplateCustom1]', config('fi.invoiceMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"invoice-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template'), 'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-invoice-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="invoice-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom2-invoice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}
                                                                        : </label>
                                                                    {!! Form::text('setting[invoiceSubjectCustom2]', config('fi.invoiceSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="invoice2"
                                                                       id="btn-invoice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body  p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-invoice2-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }} : </label>
                                                    {!! Form::textarea('setting[invoiceMailTemplateCustom2]', config('fi.invoiceMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"invoice2-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template'), 'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-invoice2-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="invoice2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-invoice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">
                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}
                                                                        : </label>
                                                                    {!! Form::text('setting[invoiceSubjectCustom3]', config('fi.invoiceSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="invoice3"
                                                                       id="btn-invoice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body  p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-invoice3-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }} : </label>
                                                    {!! Form::textarea('setting[invoiceMailTemplateCustom3]', config('fi.invoiceMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"invoice3-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template'), 'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-invoice3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="invoice3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                {!! Form::checkbox('setting[invoiceAttachPDF]', 1, config('fi.invoiceAttachPDF'), ['id' => 'invoice_attach_pdf', 'class' => 'custom-control-input']) !!}
                                <label for="invoice_attach_pdf"
                                       class="custom-control-label"> {{ trans('fi.attach_invoice_pdf') }} </label>
                            </div>
                        </div>

                    </div>

                    <div id="tab-credit_memo_setting_email_template" class="tab-pane ">


                        <div class="form-group">

                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.credit_memo_email_body') }} : </label>
                                        @if(isset($isChangeCreditMemosEmail['isChange']) && $isChangeCreditMemosEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="creditMemos"
                                                    data-model-template-name="{{trans('fi.credit_memo')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs" id="creditMemo-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="active nav-link creditMemo-active"
                                               href="#tab-creditMemo-template"><i
                                                        class="fa"> </i> {{ trans('fi.default') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-creditMemo-active"
                                               href="#tab-custom-creditMemo-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-creditMemo-active"
                                               href="#tab-custom2-creditMemo-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab"
                                               class="nav-link custom-creditMemo-active"
                                               href="#tab-custom3-creditMemo-template"><i
                                                        class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-body p-0">
                                    <div class="tab-content">
                                        <div id="tab-creditMemo-template" class="tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}
                                                                    : </label>
                                                                {!! Form::text('setting[creditMemosSubjectDefault]', config('fi.creditMemosSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }} : </label>
                                                {!! Form::textarea('setting[creditMemosMailTemplateDefault]', config('fi.creditMemosMailTemplateDefault'), ['class' => 'mt-2 form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                            </div>
                                        </div>
                                        <div id="tab-custom-creditMemo-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">

                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}
                                                                        : </label>
                                                                    {!! Form::text('setting[creditMemosSubjectCustom1]', config('fi.creditMemosSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="creditMemo"
                                                                       id="btn-creditMemo-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-creditMemo-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }} : </label>
                                                    {!! Form::textarea('setting[creditMemosMailTemplateCustom1]', config('fi.creditMemosMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>'creditMemo-sourceCode', 'placeholder' => trans('fi.placeholder_type_email_template') ,'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-creditMemo-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="creditMemo-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom2-creditMemo-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">

                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}
                                                                        : </label>
                                                                    {!! Form::text('setting[creditMemosSubjectCustom2]', config('fi.creditMemosSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="creditMemo2"
                                                                       id="btn-creditMemo-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-creditMemo2-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }} : </label>
                                                    {!! Form::textarea('setting[creditMemosMailTemplateCustom2]', config('fi.creditMemosMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>'creditMemo2-sourceCode', 'placeholder' => trans('fi.placeholder_type_email_template') ,'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-creditMemo2-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="creditMemo2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-creditMemo-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group mb-0">

                                                                <div class="form-group">
                                                                    <label>{{ trans('fi.subject') }}
                                                                        : </label>
                                                                    {!! Form::text('setting[creditMemosSubjectCustom3]', config('fi.creditMemosSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="creditMemo3"
                                                                       id="btn-creditMemo-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-creditMemo3-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }} : </label>
                                                    {!! Form::textarea('setting[creditMemosMailTemplateCustom3]', config('fi.creditMemosMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>'creditMemo3-sourceCode', 'placeholder' => trans('fi.placeholder_type_email_template') ,'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-creditMemo3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="creditMemo3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id="tab-overdue_invoice_setting_email_template" class="tab-pane">
                        <a class="btn btn-info btn-xs col-md-1 offset-md-11"
                           href="https://www.fusioninvoice.com/docs/2023/Customization/Email-Templates#invoice-email-template"
                           target="_blank">
                            <i class="fa fa-bullhorn" aria-hidden="true"></i> {{ trans('fi.available_fields') }}
                        </a>


                        <div class="form-group">
                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.overdue_invoice_email_body') }} : </label>
                                        @if(isset($isChangeOverdueInvoiceEmail['isChange']) && $isChangeOverdueInvoiceEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="overdueInvoice"
                                                    data-model-template-name="{{trans('fi.overdue_invoice')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs" id="overdueInvoice-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="active nav-link overdueInvoice-active"
                                               href="#tab-overdueInvoice-template">
                                                <i class="fa"> </i> {{ trans('fi.default') }}

                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-overdueInvoice-active"
                                               href="#tab-custom-overdueInvoice-template">
                                                <i class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-overdueInvoice-active"
                                               href="#tab-custom2-overdueInvoice-template">
                                                <i class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-overdueInvoice-active"
                                               href="#tab-custom3-overdueInvoice-template">
                                                <i class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>

                                <div class="card-body p-0">
                                    <div class="tab-content">
                                        <div id="tab-overdueInvoice-template" class="mt-2 tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">

                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[overdueInvoiceSubjectDefault]', config('fi.overdueInvoiceSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }}: </label>
                                                {!! Form::textarea('setting[overdueInvoiceMailTemplateDefault]', config('fi.overdueInvoiceMailTemplateDefault'), ['class' => 'form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                            </div>
                                        </div>

                                        <div id="tab-custom-overdueInvoice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[overdueInvoiceSubjectCustom1]', config('fi.overdueInvoiceSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="overdueInvoice"
                                                                       id="btn-overdueInvoice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-overdueInvoice-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[overdueInvoiceMailTemplateCustom1]', config('fi.overdueInvoiceMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"overdueInvoice-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-overdueInvoice-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="overdueInvoice-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom2-overdueInvoice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[overdueInvoiceSubjectCustom2]', config('fi.overdueInvoiceSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="overdueInvoice2"
                                                                       id="btn-overdueInvoice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-overdueInvoice2-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[overdueInvoiceMailTemplateCustom2]', config('fi.overdueInvoiceMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"overdueInvoice2-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-overdueInvoice2-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="overdueInvoice2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-overdueInvoice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[overdueInvoiceSubjectCustom3]', config('fi.overdueInvoiceSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="overdueInvoice3"
                                                                       id="btn-overdueInvoice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-overdueInvoice3-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[overdueInvoiceMailTemplateCustom3]', config('fi.overdueInvoiceMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light', 'id'=>"overdueInvoice3-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template'),'rows' => 23]) !!}
                                                </div>

                                                <div class="p-0 d-none custom-overdueInvoice3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="overdueInvoice3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>{{ trans('fi.overdue_invoice_reminder_frequency') }}: </label>
                            {!! Form::text('setting[overdueInvoiceReminderFrequency]', config('fi.overdueInvoiceReminderFrequency'), ['class' => 'form-control form-control-sm']) !!}
                            <span class="help-block">{{ trans('fi.overdue_invoice_reminder_frequency_help') }}</span>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                {!! Form::checkbox('setting[overdueAttachInvoice]', 1, config('fi.overdueAttachInvoice'), ['id' => 'overdue_attach_invoice', 'class' => 'custom-control-input']) !!}
                                <label for="overdue_attach_invoice"
                                       class="custom-control-label"> {{ trans('fi.attach_invoice_pdf') }} </label>
                            </div>
                        </div>
                    </div>

                    <div id="tab-payment_receipt_setting_email_template" class="tab-pane">

                        <div class="form-group">
                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.payment_receipts') }} : </label>
                                        @if(isset($isChangePaymentReceiptEmail['isChange']) && $isChangePaymentReceiptEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="paymentReceipt"
                                                    data-model-template-name="{{trans('fi.payment_receipts')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs" id="paymentReceipt-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="active nav-link paymentReceipt-active"
                                               href="#tab-paymentReceipt-template">
                                                <i class="fa"> </i> {{ trans('fi.default') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-paymentReceipt-active"
                                               href="#tab-custom-paymentReceipt-template">
                                                <i class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-paymentReceipt-active"
                                               href="#tab-custom2-paymentReceipt-template">
                                                <i class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-paymentReceipt-active"
                                               href="#tab-custom3-paymentReceipt-template">
                                                <i class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>

                                <div class="card-body p-0">
                                    <div class="tab-content">
                                        <div id="tab-paymentReceipt-template" class="tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}
                                                                    : </label>
                                                                {!! Form::text('setting[paymentReceiptSubjectDefault]', config('fi.paymentReceiptSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }}: </label>
                                                {!! Form::textarea('setting[paymentReceiptMailTemplateDefault]', config('fi.paymentReceiptMailTemplateDefault'), ['class' => 'mt-2 form-control form-control-sm']) !!}
                                            </div>
                                        </div>

                                        <div id="tab-custom-paymentReceipt-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[paymentReceiptSubjectCustom1]', config('fi.paymentReceiptSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="paymentReceipt"
                                                                       id="btn-paymentReceipt-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-paymentReceipt-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[paymentReceiptMailTemplateCustom1]', config('fi.paymentReceiptMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>"paymentReceipt-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template') ,'rows' => 23]) !!}
                                                </div>
                                                <div class="p-0 d-none custom-paymentReceipt-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="paymentReceipt-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>

                                        <div id="tab-custom2-paymentReceipt-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[paymentReceiptSubjectCustom2]', config('fi.paymentReceiptSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="paymentReceipt2"
                                                                       id="btn-paymentReceipt-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-paymentReceipt2-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[paymentReceiptMailTemplateCustom2]', config('fi.paymentReceiptMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>"paymentReceipt2-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template') ,'rows' => 23]) !!}
                                                </div>
                                                <div class="p-0 d-none custom-paymentReceipt2-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="paymentReceipt2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-paymentReceipt-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}: </label>
                                                                {!! Form::text('setting[paymentReceiptSubjectCustom3]', config('fi.paymentReceiptSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="paymentReceipt3"
                                                                       id="btn-paymentReceipt-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-paymentReceipt3-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[paymentReceiptMailTemplateCustom3]', config('fi.paymentReceiptMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>"paymentReceipt3-sourceCode", 'placeholder' => trans('fi.placeholder_type_email_template') ,'rows' => 23]) !!}
                                                </div>
                                                <div class="p-0 d-none custom-paymentReceipt3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="paymentReceipt3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                {!! Form::checkbox('setting[paymentAttachInvoice]', 1, config('fi.paymentAttachInvoice'), ['id' => 'payment_attach_invoice', 'class' => 'custom-control-input']) !!}
                                <label for="payment_attach_invoice"
                                       class="custom-control-label"> {{ trans('fi.attach_invoice_pdf') }} </label>
                            </div>
                        </div>

                    </div>

                    <div id="tab-upcoming_payment_notice_setting_email_template" class="tab-pane ">
                        <a class="btn btn-info btn-xs col-md-1 offset-md-11"
                           href="https://www.fusioninvoice.com/docs/2023/Customization/Email-Templates#invoice-email-template"
                           target="_blank">
                            <i class="fa fa-bullhorn"
                               aria-hidden="true"></i> {{ trans('fi.available_fields') }}
                        </a>


                        <div class="form-group">
                            <div class="container-fluid p-0 mt-1">
                                <div class="row">
                                    <div class="col-12">
                                        <label>{{ trans('fi.upcoming_payment_notices') }} : </label>
                                        @if(isset($isChangeUpcomingPaymentEmail['isChange']) && $isChangeUpcomingPaymentEmail['isChange'])
                                            <button class="btn btn-xs btn-warning float-right reset-default-mail-template-value"
                                                    data-action-type="upcomingPayment"
                                                    data-model-template-name="{{trans('fi.upcoming_payment_notices')}}"
                                                    type="button">
                                                <i class='fa fa-recycle'></i> {{trans('fi.reset_to_default')}}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="card card-primary card-outline card-outline-tabs">
                                <div class="card-header p-0 border-bottom-0">
                                    <ul class="nav nav-tabs"
                                        id="upcomingPaymentNotice-mail-template">
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="active nav-link upcomingPaymentNotice-active"
                                               href="#tab-upcomingPaymentNotice-template">
                                                <i class="fa"> </i> {{ trans('fi.default') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-upcomingPaymentNotice-active"
                                               href="#tab-custom-upcomingPaymentNotice-template">
                                                <i class="fa"> </i> {{ trans('fi.custom1') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-upcomingPaymentNotice-active"
                                               href="#tab-custom2-upcomingPaymentNotice-template">
                                                <i class="fa"> </i> {{ trans('fi.custom2') }}
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a data-toggle="tab" class="nav-link custom-upcomingPaymentNotice-active"
                                               href="#tab-custom3-upcomingPaymentNotice-template">
                                                <i class="fa"> </i> {{ trans('fi.custom3') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-body p-0">
                                    <div class="tab-content">
                                        <div id="tab-upcomingPaymentNotice-template" class="tab-pane active">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}
                                                                    : </label>
                                                                {!! Form::text('setting[upcomingPaymentSubjectDefault]', config('fi.upcomingPaymentSubjectDefault'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2">
                                                <label>{{ trans('fi.body') }}: </label>
                                                {!! Form::textarea('setting[upcomingPaymentMailTemplateDefault]', config('fi.upcomingPaymentMailTemplateDefault'), ['class' => ' mt-2 form-control form-control-sm bg-light', 'rows' => 5]) !!}
                                            </div>
                                        </div>

                                        <div id="tab-custom-upcomingPaymentNotice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}
                                                                    : </label>
                                                                {!! Form::text('setting[upcomingPaymentSubjectCustom1]', config('fi.upcomingPaymentSubjectCustom1'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="upcomingPaymentNotice"
                                                                       id="btn-upcomingPaymentNotice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-upcomingPaymentNotice-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[upcomingPaymentMailTemplateCustom1]', config('fi.upcomingPaymentMailTemplateCustom1'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>"upcomingPaymentNotice-sourceCode", 'placeholder' =>  trans('fi.placeholder_type_email_template')  ,'rows' => 23]) !!}
                                                </div>
                                                <div class="p-0 d-none custom-upcomingPaymentNotice-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="upcomingPaymentNotice-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom2-upcomingPaymentNotice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}
                                                                    : </label>
                                                                {!! Form::text('setting[upcomingPaymentSubjectCustom2]', config('fi.upcomingPaymentSubjectCustom2'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="upcomingPaymentNotice2"
                                                                       id="btn-upcomingPaymentNotice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-upcomingPaymentNotice2-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[upcomingPaymentMailTemplateCustom2]', config('fi.upcomingPaymentMailTemplateCustom2'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>"upcomingPaymentNotice2-sourceCode", 'placeholder' =>  trans('fi.placeholder_type_email_template')  ,'rows' => 23]) !!}
                                                </div>
                                                <div class="p-0 d-none custom-upcomingPaymentNotice-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="upcomingPaymentNotice2-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tab-custom3-upcomingPaymentNotice-template" class="tab-pane">
                                            <div class="content-header pb-0">
                                                <div class="container-fluid p-0">
                                                    <div class="row">
                                                        <div class="col-sm-6">
                                                            <div class="form-group">
                                                                <label>{{ trans('fi.subject') }}
                                                                    : </label>
                                                                {!! Form::text('setting[upcomingPaymentSubjectCustom3]', config('fi.upcomingPaymentSubjectCustom3'), ['class' => 'form-control form-control-sm']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-6">
                                                            <ol class="breadcrumb float-right">
                                                                <li class="breadcrumb-item">
                                                                    <a href="javascript:void(0);"
                                                                       class="btn btn-xs btn-default float-right custom-toggle-class btn-custom-toggle"
                                                                       data-card-name="upcomingPaymentNotice3"
                                                                       id="btn-upcomingPaymentNotice-custom-toggle">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ol>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-body p-2 custom-template-scroller">
                                                <div class="p-0 col-12 custom-upcomingPaymentNotice3-sourceCode-display d-block">
                                                    <label>{{ trans('fi.body') }}: </label>
                                                    {!! Form::textarea('setting[upcomingPaymentMailTemplateCustom3]', config('fi.upcomingPaymentMailTemplateCustom3'), ['class' => 'sourceCode form-control form-control-sm bg-light',  'id'=>"upcomingPaymentNotice3-sourceCode", 'placeholder' =>  trans('fi.placeholder_type_email_template')  ,'rows' => 23]) !!}
                                                </div>
                                                <div class="p-0 d-none custom-upcomingPaymentNotice3-iframe-display col-12">
                                                    <iframe class="border-1" name="targetCode"
                                                            id="upcomingPaymentNotice3-targetCode"></iframe>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>{{ trans('fi.upcoming_payment_notice_frequency') }}: </label>
                            {!! Form::text('setting[upcomingPaymentNoticeFrequency]', config('fi.upcomingPaymentNoticeFrequency'), ['class' => 'form-control form-control-sm']) !!}
                            <span class="help-block">{{ trans('fi.upcoming_payment_notice_frequency_help') }}</span>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                {!! Form::checkbox('setting[upcomingPaymentNoticeAttachInvoice]', 1, config('fi.upcomingPaymentNoticeAttachInvoice'), ['id' => 'upcoming_payment_notice_attach_invoice', 'class' => 'custom-control-input']) !!}
                                <label for="upcoming_payment_notice_attach_invoice"
                                       class="custom-control-label"> {{ trans('fi.attach_invoice_pdf') }} </label>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </section>
</div>