<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

Route::group(['namespace' => 'FI\Modules\Sessions\Controllers', 'middleware' => 'web'], function ()
{
    Route::get('login', ['uses' => 'SessionController@login', 'as' => 'session.login']);
    Route::post('login', ['uses' => 'SessionController@attempt', 'as' => 'session.attempt']);
    Route::get('logout', ['uses' => 'SessionController@logout', 'as' => 'session.logout']);
    Route::post('refresh-captcha', ['uses' => 'SessionController@refreshCaptcha', 'as' => 'session.refresh_captcha']);
    Route::get('check-mail-service-enabled', ['uses' => 'SessionController@checkMailServiceEnabled', 'as' => 'session.ajax.checkMailServiceEnabled']);
    Route::get('otp-verification', ['uses' => 'SessionController@otpVerification', 'as' => 'session.otp-verification']);
    Route::post('login-with-otp', ['uses' => 'SessionController@loginWithOtp', 'as' => 'session.login.with-otp']);
    Route::get('resend-otp', ['uses' => 'SessionController@resendOtp', 'as' => 'session.resend-otp']);
});