<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ trans('fi.two_factor_auth') }}</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <meta name="csrf-token" content="{{ csrf_token() }}"/>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
          href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/fontawesome-free/css/all.min.css') }}">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('assets/dist/css/adminlte.min.css') }}">
    @if (file_exists(base_path('custom/custom.css')))
        <link href="{{ asset('custom/custom.css') }}" rel="stylesheet" type="text/css"/>
    @endif
</head>
<body class="hold-transition login-page">
<div class="login-box">
    @if($logo != '')
        <div class="login-logo">
            <img src="{{$logo}}" alt="{{ config('fi.headerTitleText') }}" class="brand-image card-img-top elevation-5">
        </div>
    @else
        <div class="login-logo">
            <img src="{{ asset('assets/dist/img/logo.png') }}" alt="{{ config('fi.headerTitleText') }}"
                 class="brand-image img-circle elevation-3" style="opacity: .8">
        </div>
        @endif

                <!-- /.login-logo -->
        <div class="card">
            <div class="card-body login-card-body">
                @include('layouts._alertifyjs')
                @include('layouts._alerts')

                {!! Form::open(['route' => 'session.login.with-otp']) !!}

                <div class="mb-3">
                    <input type="password" name="otp" class="form-control form-control-sm otp" autocomplete="off"
                           placeholder="{{ trans('fi.verification_code') }}">
                </div>

                <div class="row">
                    <!-- /.col -->
                    <div class="col-5">
                        <button type="button" id="resend-otp" class="btn btn-sm btn-success btn-block"
                                disabled>{{ trans('fi.resend_otp_btn') }}</button>
                    </div>
                    <div class="col-7 text-right">
                        <button type="submit" id="verify-otp-btn"
                                class="btn btn-sm btn-primary ">{{ trans('fi.verify') }}</button>
                    </div>

                    <!-- /.col -->
                </div>
                {!! Form::close() !!}
            </div>
            <!-- /.login-card-body -->
        </div>
        <div class="login-logo">
            <span class=" btn float-right p-0 mt-2">
                Powered by
                <a href="https://fusioninvoice.com"><b>Fusion</b>Invoice
                </a>
            </span>
        </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="{{ asset('assets/plugins/jquery/jquery.min.js') }}"></script>
<!-- Bootstrap 4 -->
<script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- AdminLTE App -->
<script src="{{ asset('assets/dist/js/adminlte.js') }}"></script>
<script type="text/javascript">
    $(function () {
        $('.otp').focus();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        let timer;
        let countdown = 60; // Set the initial countdown time in seconds

        function startTimer() {
            timer = setInterval(function () {
                if (countdown <= 0) {
                    clearInterval(timer);
                    document.getElementById('resend-otp').removeAttribute('disabled');
                } else {
                    countdown--;
                    localStorage.setItem('countdown', countdown);
                    if (countdown == 0) {
                        document.getElementById('resend-otp').textContent = '{{ trans('fi.resend_otp_btn') }}';
                    } else {
                        document.getElementById('resend-otp').textContent = '{{ trans('fi.resend_otp_btn') }} (' + countdown + 's)';
                    }

                }
            }, 1000);

        }

        var storedCountdown = localStorage.getItem('countdown');

        if (storedCountdown !== null && !isNaN(storedCountdown) && storedCountdown > 0) {
            countdown = parseInt(storedCountdown);

        }
        startTimer();

    });


    $(document).on('click', '#resend-otp', function () {

        $('#resend-otp').prop('disabled', true);
        $('#verify-otp-btn').prop('disabled', true);

        $.ajax({
            url: "{{ route('session.resend-otp') }}",
            method: 'get',

            success: function (response) {
                if (response.success == true) {
                    alertify.success(response.message, 5);
                } else {
                    alertify.error(response.message, 5);
                }
                setTimeout(function () {
                    window.location = '{{ url('otp-verification') }}';
                }, 1500);
            }
        });

    });

</script>
</body>
</html>
