<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Sessions\Requests;

use Carbon\Carbon;
use FI\Modules\Users\Models\User;
use Illuminate\Contracts\Validation\Rule;

class OtpVerificationRequest implements Rule
{
    public function passes($attribute, $value)
    {
        $admin_credentials = session('user_credentials');

        $user_detail = User::with('loginOtp')->where('email', $admin_credentials['email'])->where('user_type', '<>', 'system')->first();

        if ($user_detail->loginOtp->otp === $value)
        {
            if (Carbon::now()->diffInMinutes($user_detail->loginOtp->created_at) <= 15)
            {
                return true;
            }
            else
            {
                $this->message = trans('fi.expired_otp');

                return false;
            }
        }
        else
        {
            $this->message = trans('fi.invalid_otp');

            return false;
        }
    }

    public function message()
    {
        return $this->message;
    }
}