<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Sessions\Models;

use Illuminate\Database\Eloquent\Model;

class LoginOtp extends Model
{

    protected $guarded = ['id'];

    protected $table   = 'users_two_factor_otp';

    public function user()
    {
        return $this->belongsTo('FI\Modules\Users\Models\User');
    }

    public function mailQueue()
    {
        return $this->morphMany('FI\Modules\MailQueue\Models\MailQueue', 'mailable');
    }

    public static function generateOtp()
    {
        return substr(number_format(time() * rand(), 0, '', ''), 0, 6);
    }
}