@extends('reports.layouts.master')
@section('title')
    {{ config('fi.headerTitleText') }} | {{ trans('fi.tax_summary') }}
@stop
@section('content')

    <table>
        <tr>
            <td style="width: 25%;" valign="top">
                @if(isset($logo['image']) && $logo['image'] != null)
                    <span style="width: 100%">
                        {!! $logo['image'] !!}
                    </span>
                    <p style="margin: 2px !important;">
                        <strong style=" color: #5D6975;">{!! $logo['name'] !!}</strong>
                    </p>
                @endif
            </td>

            <td style="width: 50%;margin: 0px;padding: 0px !important;" valign="top" align="center">
                <h1 class="theme-color"
                    style="font-size: 34px;margin-bottom: 0;width: 100%;float: left;margin-top: 0px !important;">{{ trans('fi.tax_summary') }}</h1>
                <h3 class="theme-color" style="margin-top: 0; font-size: 15px;">{{ $results['from_date'] }}
                    - {{ $results['to_date'] }}</h3>
            </td>
            <td style="width: 25%; text-align: right;" valign="top">
            </td>
        </tr>
    </table>

    @if(count($results['records']) == 0)
        <h5 style="padding-top: 50px; padding-bottom: 50px;">{{ trans('fi.no_records_found') }}</h5>
    @else
        <table class="alternate" style=" font-size: 12px;">

            <thead>
            <tr>
                <th class="theme-color" style="width: 50%;">{{ trans('fi.tax_rate') }}</th>
                <th class="amount theme-color" style="width: 25%;">{{ trans('fi.taxable_amount') }}</th>
                <th class="amount theme-color" style="width: 25%;">{{ trans('fi.taxes') }}</th>
            </tr>
            </thead>

            <tbody>
            @foreach ($results['records'] as $currency => $records)
                <tr>
                    <td colspan="3" text-align="center">
                        <h2 class="theme-color">{{ trans('fi.currency') }}: {{ $currency }}</h2>
                    </td>
                </tr>
                @foreach ($records as $taxRate => $result)
                    <tr>
                        <td class="theme-color">{{ $taxRate }}</td>
                        <td class="amount theme-color">{{ $result['taxable_amount'] }}</td>
                        <td class="amount theme-color">{{ $result['taxes'] }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td class="amount theme-color" colspan="2">{{ trans('fi.total') }}</td>
                    <td class="amount theme-color">{{ $results['total'][$currency] }}</td>
                </tr>
                <tr>
                    <td class="amount theme-color" colspan="2">{{ trans('fi.paid') }}</td>
                    <td class="amount theme-color">{{ $results['paid'][$currency] }}</td>
                </tr>
                <tr>
                    <td class="amount theme-color" colspan="2">{{ trans('fi.remaining') }}</td>
                    <td class="amount theme-color">{{ $results['remaining'][$currency] }}</td>
                </tr>
            @endforeach
            </tbody>

        </table>
    @endif

@stop

<style>
    {{ config('fi.skin') == 'dark-mode' ? iframeThemeColor() : ''  }}
</style>