<script type="text/javascript">
    $(function () {

        $('body #create-live-invoice').modal();

        $('.create-live-invoice-cancel').click(function () {
            $('.create-live-invoice-active').removeClass('create-live-invoice-active');
        });

        $('#create-live-invoice-save').click(function () {
            $('#create-live-invoice').modal('hide');
            showHideLoaderModal();
            $.post('{{route('recurringInvoices.create.live.invoice')}}', {
                id: '{{$id}}'
            }).done(function (response) {
                showHideLoaderModal();
                alertify.success(response.message, 5);
                @if($editMode)
                $('#div-recurring-invoice-edit').load('{{ route('recurringInvoiceEdit.refreshEdit', [$id]) }}', function () {
                    var settings = {
                        placeholder: '{{ trans('fi.select-item') }}',
                        allowClear: true,
                        tags: true,
                    };
                    $('.item-lookup').select2(settings);
                    itemLookupTabFunctionality(settings);
                });
                @endif
            }).fail(function (response) {
                showHideLoaderModal();
                alertify.error($.parseJSON(response.responseText).message, 10);
            });
        });
    });
</script>

<div class="modal fade" id="create-live-invoice" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog text-break">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <h5 class="modal-title"> {{trans('fi.create_live_invoice_now')}} </h5>
                <button type="button" class="close create-live-invoice-cancel" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <div class="row">
                        <div class="col-md-12">
                            {!! trans('fi.create_live_invoice_warn_message') !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer pb-1 pt-1">
                <div class="col-sm-12">
                    <button type="button" id="create-live-invoice-save"
                            class="btn btn-sm btn-outline-danger float-right ml-2"
                    >
                        {{ trans('fi.confirm') }}
                    </button>

                    <button type="button"
                            class="btn btn-sm btn-outline-secondary float-right create-live-invoice-cancel"
                            data-dismiss="modal" id="create-live-invoice-cancel">
                        {{ trans('fi.cancel') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>