<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Quotes\Support;

use FI\Support\CurrencyFormatter;

class QuotePaymentTerm
{
    public function processTypeOne($paymentTerm, $quote)
    {
        $mess     = $paymentTerm->quote_description_template;
        $net_days = $paymentTerm->net_due_days ?? 0;
        return self::modifyContent('#NETDAYS', $net_days, $mess);
    }

    public function processTypeTwo($paymentTerm, $quote)
    {
        $mess                 = $paymentTerm->quote_description_template;
        $net_days             = $paymentTerm->net_due_days ?? 0;
        $discount_days_simple = $paymentTerm->discount_days_simple ?? 0;
        $discount_amount   = ($quote->amount->total * ($paymentTerm->discount_percent / 100));
        $discounted_total  = $quote->amount->total - $discount_amount;
        $no_discount_total = $quote->amount->total;

//        $discount_date = Carbon::parse($quote->quote_date)->addDays($paymentTerm->discount_days_simple ?? 0)->format(config('fi.dateFormat'));
//        $last_date     = Carbon::parse($quote->quote_date)->addDays($paymentTerm->net_due_days ?? 0)->format(config('fi.dateFormat'));
        $mess = self::modifyContent('#DISCOUNTPERCENT', ($paymentTerm->numeric_formatted_discount_percent ?? 0), $mess);
        $mess = self::modifyContent('#DISCOUNTAMOUNT', CurrencyFormatter::format($discount_amount), $mess);
        $mess = self::modifyContent('#DISCOUNTEDTOTAL', CurrencyFormatter::format($discounted_total), $mess);
        $mess = self::modifyContent('#NODISCOUNTTOTAL', CurrencyFormatter::format($no_discount_total), $mess);
        $mess = self::modifyContent('#DISCOUNTDAYS', $discount_days_simple, $mess);
        $mess = self::modifyContent('#NETDAYS', $net_days, $mess);
        return $mess;
        // return self::modifyContent('#NETDAYS', $net_days, $mess);
    }

    public function processTypeThree($paymentTerm, $quote)
    {
        $mess                 = $paymentTerm->quote_description_template;
        $nth_day              = self::ordinalNumber($paymentTerm->discount_days_nth ?? 0);
        $discount_days_simple = self::ordinalNumber($paymentTerm->discount_days_nth ?? 0);
        $net_days = $paymentTerm->net_due_days ?? 0;
        $discount_amount   = ($quote->amount->total * ($paymentTerm->discount_percent / 100));
        $discounted_total  = $quote->amount->total - $discount_amount;
        $no_discount_total = $quote->amount->total;

//        $discount_date = Carbon::parse($quote->quote_date)->endOfMonth()->addDays($paymentTerm->discount_days_nth ?? 0)->format(config('fi.dateFormat'));
//        $last_date     = Carbon::parse($quote->quote_date)->addDays($paymentTerm->net_due_days ?? 0)->format(config('fi.dateFormat'));
        $mess = self::modifyContent('#DISCOUNTPERCENT', ($paymentTerm->numeric_formatted_discount_percent ?? 0), $mess);
        $mess = self::modifyContent('#NTHDAY', $nth_day, $mess);
        $mess = self::modifyContent('#NETDAYS', $net_days, $mess);
        $mess = self::modifyContent('#DISCOUNTAMOUNT', CurrencyFormatter::format($discount_amount), $mess);
        $mess = self::modifyContent('#DISCOUNTEDTOTAL', CurrencyFormatter::format($discounted_total), $mess);
        $mess = self::modifyContent('#NODISCOUNTTOTAL', CurrencyFormatter::format($no_discount_total), $mess);
        return self::modifyContent('#DISCOUNTDAYS', $discount_days_simple, $mess);

    }

    public function processTypeFour($paymentTerm, $quote)
    {
        $mess                = $paymentTerm->quote_description_template;
        $numeric_formatted   = number_format($paymentTerm->down_payment, 2, '.', '');
        $down_payment_amount = CurrencyFormatter::format($paymentTerm->down_payment ?? 0, $quote->currency);
        $net_days            = $paymentTerm->balance_due_days ?? 0;
        if ($paymentTerm->down_payment_type == 'flat_amount')
        {
            $mess = self::modifyContent('#DOWNPAYMENT', $down_payment_amount, $mess);
        }
        else
        {
            $mess = self::modifyContent('#DOWNPAYMENTPERCENT', $numeric_formatted . '% ', $mess);
        }

        return self::modifyContent('#NETDAYS', $net_days, $mess);
    }

    public function processTypeFive($paymentTerm, $quote)
    {
        $full_message = $paymentTerm->quote_description_template;

        foreach ($paymentTerm->installments as $key => $installment)
        {
            $number  = $key;
            $amount  = ($quote->amount->total * $installment->installment_percent / 100);
            $installmentDay = $installment->installment_due_days ?? 0;
            $installmentNumber = $installment->installment_number ?? 0;
            
            $message = str_replace('#NUMBEROFINSTALLMENTS', '<span class="text-info">' . ($paymentTerm->number_of_installments ?? 0) . '</span>', $full_message);

            $message = preg_replace('/#PERCENT/', '<span class="text-info">' . $installment->numeric_formatted_installment_percent . '</span>', $message, 1);

            $message = preg_replace('/#INSTALLMENTNUMBER/', '<span class="text-info">' . $installmentNumber . '</span>', $message, 1);

            $message = str_replace('#INSTALLMENTAMOUNT' . ($number + 1), '<span class="text-info">' . CurrencyFormatter::format(number_format(floor($amount * 100) / 100, 2, '.', ''), $quote->currency) . '</span>', $message);

            $message = preg_replace('/#INSTALLMENTDUEDAYS/', '<span class="text-info">' . $installmentDay . '</span>', $message, 1);

            $full_message = $message;
        }

        return nl2br($full_message);
    }


    public function modifyContent($search, $replace, $string)
    {
        return str_replace($search, '<span class="text-info">' . $replace . '</span>', $string);
    }

    public static function ordinalNumber($number)
    {
        $suffix = ['th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th'];
        if (($number % 100) >= 11 && ($number % 100) <= 13)
        {
            $abbreviation = $number . 'th';
        }
        else
        {
            $abbreviation = $number . $suffix[$number % 10];
        }
        return $abbreviation;
    }
}