<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Quotes\Models;

use FI\Modules\CustomFields\Models\QuoteItemCustom;
use FI\Modules\Quotes\Events\QuoteModified;

class QuoteItemObserver
{
    public function created(QuoteItem $quoteItem)
    {
        $quoteItem->custom()->save(new QuoteItemCustom());
    }

    public function deleted(QuoteItem $quoteItem)
    {
        if ($quoteItem->quote)
        {
            event(new QuoteModified($quoteItem->quote));
        }

        $quoteItem->custom()->delete();
    }

    public function deleting(QuoteItem $quoteItem)
    {
        $quoteItem->amount()->delete();
    }

    public function saved(QuoteItem $quoteItem)
    {
        event(new QuoteModified($quoteItem->quote));
    }

    public function saving(QuoteItem $quoteItem)
    {
        $applyExchangeRate = $quoteItem->apply_exchange_rate;
        unset($quoteItem->apply_exchange_rate);

        if ($applyExchangeRate == true)
        {
            $quoteItem->price = $quoteItem->price * $quoteItem->quote->exchange_rate;
        }

        if (!$quoteItem->display_order)
        {
            $displayOrder = QuoteItem::where('quote_id', $quoteItem->quote_id)->max('display_order');

            $displayOrder++;

            $quoteItem->display_order = $displayOrder;
        }
    }
}