<?php

/**
 * This file is part of FusionInvoice.
 *
 * (c) SquarePig LLC <hello@squarepiginteractive.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FI\Modules\Quotes\Events;

use FI\Events\Event;
use FI\Modules\Quotes\Models\Quote;
use Illuminate\Queue\SerializesModels;

class QuoteApproved extends Event
{
    use SerializesModels;

    public $quote;
    public $actionType;

    public function __construct(Quote $quote, $actionType = 'approved')
    {
        $this->quote       = $quote;
        $this->action_type = $actionType;
    }
}