@include('payments._js_create')

@if(isset($layoutFormDataInclude) && $layoutFormDataInclude == true)
    @include('layouts._formdata')
@endif
<div class="modal fade" id="modal-enter-payment" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog modal-xl">
        <div class="modal-enter-payment modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ trans('fi.enter_payment_for_invoice') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body">

                <div id="modal-status-placeholder"></div>

                <form class="form-horizontal">
                    <div class="row">
                        <div class="col-lg-6">
                            <input type="hidden" name="invoice_id" id="invoice_id" value="{{ $invoice->id }}">

                            <div class="form-group">
                                <label>{{ trans('fi.client') }}</label>

                                {!! Form::select('client_id', [$client->id=>$client->name], $client->id, ['id' => 'client_id', 'class' => 'form-control form-control-sm disabled', 'disabled' => true]) !!}
                            </div>

                            <div class="form-group">
                                <label>{{ trans('fi.invoice') }}</label>

                                {!! Form::select('invoice_id', [$invoice->id => $invoice->number], $invoice->id, ['id' => 'invoice_id', 'class' => 'form-control form-control-sm disabled', 'disabled' => true]) !!}
                            </div>

                            <div class="form-group">
                                <label>{{ trans('fi.invoice_balance') }}</label>

                                {!! Form::text('invoice_balance', $invoice->amount->formatted_balance, ['id' => 'invoice_balance', 'class' => 'form-control form-control-sm disabled', 'disabled' => true, 'data-amount' => $invoice->amount->balance]) !!}
                            </div>

                            <div class="form-group">
                                <label>{{ trans('fi.payment_terms') }}</label>
                                {!! Form::select('payment_terms', $paymentTerms, $invoice->payment_terms_id,['disabled' => true,'id' =>'payment_terms', 'class' => 'form-control form-control-sm']) !!}
                            </div>

                            @if($paymentDetails['type'] == 5)
                                <div class="form-group">
                                    <div class="card card-body table-responsive p-1">
                                        <table class="table table-hover table-striped table-sm text-nowrap">
                                            <thead>

                                            <tr>

                                                <th>{{trans('fi.status')}}</th>
                                                <th class="text-center">{{trans('fi.percentage')}}</th>
                                                <th class="text-center">{{trans('fi.amount')}}</th>
                                            </tr>

                                            </thead>
                                            <tbody>
                                            @foreach( $arrayInstallments as $key => $arrayInstallment)
                                                <tr class="{{$arrayInstallment['is_paid'] ? 'disabled':''}}">
                                                    <td>
                                                        <span class="badge {{$arrayInstallment['is_paid'] ? 'badge-paid' : 'badge-unpaid'}}">{{$arrayInstallment['is_paid'] ? trans('fi.paid') : trans('fi.unpaid')}}</span>
                                                    </td>
                                                    <td class="text-center">{!! $arrayInstallment['percentage'] !!}%
                                                    </td>
                                                    <td class="text-center">{!! $arrayInstallment['formatted_amount'] !!}</td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            @endif

                            <div class="form-group">
                                <label>{{ trans('fi.currency') }}</label>

                                {!! Form::select('currency_code', $currencies, $invoice->currency_code, ['disabled' => true,'id' =>'currency_code', 'class' => 'form-control form-control-sm']) !!}
                            </div>
                            <div class="form-group">
                                <label>{{ trans('fi.note') }}</label>

                                {!! Form::textarea('payment_note', null, ['id' => 'payment_note', 'class' => 'form-control form-control-sm', 'rows' => 4]) !!}
                            </div>
                        </div>
                        <div class="col-lg-6">

                            @if($paymentTermIsApply &&  ($paymentDetails['type'] != 5 && $paymentDetails['type'] != 4))
                                <div class="form-group">
                                    <div class="form-check pl-0 mb-2">
                                        {!! Form::checkbox('payment_discount_check', 1, $paymentTermIsApply, ['id' => 'payment-term-checkbox']) !!}
                                        <label class="form-check-label" for="payment-term-checkbox">
                                            {{ trans('fi.apply_payment_terms') }}
                                        </label>
                                    </div>
                                    {!! Form::text('payment_term_discount', ($paymentTermIsApply) ? $paymentDetails['formattedPaymentTermsDiscount'] : $paymentDetails['formattedZero'], ['id' => 'payment_term_discount', 'class' => 'form-control form-control-sm payment_term_discount', 'data-value' => (($paymentTermIsApply) ? $paymentDetails['paymentTermsDiscount'] : 0)]) !!}
                                </div>
                            @endif

                            <div class="form-group">

                                <div class="row">
                                    <div class="col">
                                        <label>{{ trans('fi.amount') }}</label>
                                        @if(($paymentTermIsApply && ($paymentDetails['type'] == 4 || $paymentDetails['type'] == 5)))
                                            {!! Form::text('payment_amount',  $paymentDetails['formattedAmountValue'] , ['id' => 'payment_amount', 'class' => "form-control form-control-sm  currency-input-validator ",'data-value' =>$paymentDetails['amountValue'],'disabled'=>($paymentDetails['type'] == 5) ]) !!}
                                        @else
                                            {!! Form::text('payment_amount',  $invoice->amount->formatted_balance, ['id' => 'payment_amount', 'class' => "form-control form-control-sm  currency-input-validator ",'data-value' => $invoice->amount->formatted_decimal_number_balance]) !!}
                                        @endif
                                    </div>
                                    @if($paymentTermIsApply &&  $paymentDetails['type'] != 5)
                                        @if($paymentDetails['type'] != 4)
                                            <div class="col">
                                                <label class="text-info">{{ trans('fi.payable_amount') }}</label>
                                                {!! Form::text('final_payable_amount', ($paymentTermIsApply) ? $paymentDetails['formattedAmountValue'] : $invoice->amount->formatted_balance, ['id' => 'final_payable_amount', 'class' => "bg-info-disabled form-control form-control-sm currency-input-validator disabled" ,'disabled'=>true,'data-value'=>(($paymentTermIsApply) ? $paymentDetails['amountValue'] : $invoice->amount->balance) ]) !!}
                                            </div>
                                        @endif
                                    @endif
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="input-group date ">
                                    <label>{{ trans('fi.payment_date') }}</label>
                                    <div class="input-group date" id="payment_date" data-target-input="nearest">

                                        {!! Form::text('payment_date', $date, ['class' => 'custom-form-field form-control form-control-sm datetimepicker-input', 'data-toggle' => 'datetimepicker','autocomplete' => 'off' ,'data-target' => "#payment_date"]) !!}
                                        <div class="input-group-append"
                                             data-target="#payment_date" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label>{{ trans('fi.payment_method') }}</label>
                                {!! Form::select('payment_method_id', $paymentMethods, null, ['id' => 'payment_method_id', 'class' => 'form-control form-control-sm']) !!}
                            </div>

                            <div id="payment-custom-fields">
                                @if ($customFields)
                                    @include('custom_fields._custom_fields_modal')
                                @endif
                            </div>

                            <div class="form-group">
                                <label>{{ trans('fi.remaining_balance') }}</label>
                                {!! Form::text('remaining_balance', $paymentDetails['formattedZero'] , ['class' => 'form-control form-control-sm disabled', 'id' => 'remaining_balance','readonly'=>true, 'data-value'=>0.00]) !!}
                            </div>

                            @if (config('fi.mailConfigured') && $clientEmail)

                                <div class="form-check">
                                    {!! Form::checkbox('email_payment_receipt', 1, $client->should_email_payment_receipt, ['id' => 'email_payment_receipt','class'=>'form-check-input']) !!}
                                    <label class="form-check-label"
                                           for="email_payment_receipt">{{ trans('fi.email_payment_receipt') }}</label>
                                </div>

                            @else

                                <div class="form-check p-0">
                                    {!! Form::checkbox('dummy', '', '', ['id'=>'email_payment_receipt_dummy', 'disabled' => 'true', 'title' => trans('fi.email_payment_receipt_notice')]) !!}
                                    <label class="form-check-label"
                                           for="email_payment_receipt_dummy">{{ trans('fi.email_payment_receipt') }}</label>
                                </div>

                            @endif

                        </div>
                    </div>
                </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-sm btn-default"
                        data-dismiss="modal">{{ trans('fi.cancel') }}</button>
                @can('payments.create')
                    <button type="button" id="enter-payment-confirm" class="btn btn-sm btn-primary"
                            data-loading-text="{{ trans('fi.please_wait') }}..."
                            data-original-text="{{ trans('fi.submit') }}">{{ trans('fi.submit') }}</button>
                @endcan
            </div>
        </div>
    </div>
</div>
