@include('layouts._select2')
@include('layouts._daterangepicker')
<script type="text/javascript">

    $(function () {
        initDateRangePicker('payment');

        initDateRangePreSelected('payment');

        var settings = {
            placeholder: '{{ trans('fi.select_client') }}',
            allowClear: true,
            width: '100%',
        };

        $('.client-lookup').select2(settings);

        @can('payments.delete')
        $('#btn-bulk-delete').click(function () {

            var ids = [];

            $('.bulk-record:checked').each(function () {
                ids.push($(this).data('id'));
            });

            if (ids.length > 0)
            {

                $('#modal-placeholder').load('{!! route('bulk.delete.payments.modal') !!}', {
                        action: '{{ route('payments.bulk.delete') }}',
                        modalName: 'payments',
                        data: ids,
                        returnURL: '{{route('payments.index')}}'
                    },
                    function (response, status, xhr) {
                        if (status == "error")
                        {
                            var response = JSON.parse(response);
                            alertify.error(response.message);
                        }
                    }
                );
            }
        });

        $('.delete-payment').click(function () {

            $(this).addClass('delete-payments-active');

            $('#modal-placeholder').load('{!! route('payments.delete.modal') !!}', {
                    action: $(this).data('action'),
                    modalName: 'payments',
                    isReload: false,
                    returnURL: '{{route('payments.index')}}'
                },
                function (response, status, xhr) {
                    if (status == "error")
                    {
                        var response = JSON.parse(response);
                        alertify.error(response.message);
                    }
                }
            );
        });
        @endcan
        $('#tags-filter-open').click(function () {
            $('#modal-placeholder').load('{!! route('payments.filterTags', ['tags' => json_encode($tags), 'tagsMustMatchAll' => $tagsMustMatchAll, 'firstLoad' => true]) !!}')
            $(this).prop('disabled', true);
        });


        $('#payment_date_range,#client,#payment_method').change(function () {
            $('form#filter').submit();
        });

        $('#btn-clear-filters').click(function () {
            $('#search, #payment_date_range,#tags-filter,#client,#payment_from_date,#payment_to_date,#payment_method').val('');
            $('#tags-must-match-all').val(0);
            $('#filter').submit();
        });

    });

</script>